/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Note data to be saved
 */
@JsonPropertyOrder({
  NoteData.JSON_PROPERTY_TEXT,
  NoteData.JSON_PROPERTY_CONTACT_IDS,
  NoteData.JSON_PROPERTY_DEAL_IDS,
  NoteData.JSON_PROPERTY_COMPANY_IDS
})
public class NoteData {
  public static final String JSON_PROPERTY_TEXT = "text";
  @jakarta.annotation.Nonnull
  private String text;

  public static final String JSON_PROPERTY_CONTACT_IDS = "contactIds";
  @jakarta.annotation.Nullable
  private List<Integer> contactIds = new ArrayList<>();

  public static final String JSON_PROPERTY_DEAL_IDS = "dealIds";
  @jakarta.annotation.Nullable
  private List<String> dealIds = new ArrayList<>();

  public static final String JSON_PROPERTY_COMPANY_IDS = "companyIds";
  @jakarta.annotation.Nullable
  private List<String> companyIds = new ArrayList<>();

  public NoteData() {
  }

  public NoteData text(@jakarta.annotation.Nonnull String text) {
    
    this.text = text;
    return this;
  }

  /**
   * Text content of a note
   * @return text
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setText(@jakarta.annotation.Nonnull String text) {
    this.text = text;
  }

  public NoteData contactIds(@jakarta.annotation.Nullable List<Integer> contactIds) {
    
    this.contactIds = contactIds;
    return this;
  }

  public NoteData addContactIdsItem(Integer contactIdsItem) {
    if (this.contactIds == null) {
      this.contactIds = new ArrayList<>();
    }
    this.contactIds.add(contactIdsItem);
    return this;
  }

  /**
   * Contact Ids linked to a note
   * @return contactIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getContactIds() {
    return contactIds;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactIds(@jakarta.annotation.Nullable List<Integer> contactIds) {
    this.contactIds = contactIds;
  }

  public NoteData dealIds(@jakarta.annotation.Nullable List<String> dealIds) {
    
    this.dealIds = dealIds;
    return this;
  }

  public NoteData addDealIdsItem(String dealIdsItem) {
    if (this.dealIds == null) {
      this.dealIds = new ArrayList<>();
    }
    this.dealIds.add(dealIdsItem);
    return this;
  }

  /**
   * Deal Ids linked to a note
   * @return dealIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEAL_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDealIds() {
    return dealIds;
  }


  @JsonProperty(JSON_PROPERTY_DEAL_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDealIds(@jakarta.annotation.Nullable List<String> dealIds) {
    this.dealIds = dealIds;
  }

  public NoteData companyIds(@jakarta.annotation.Nullable List<String> companyIds) {
    
    this.companyIds = companyIds;
    return this;
  }

  public NoteData addCompanyIdsItem(String companyIdsItem) {
    if (this.companyIds == null) {
      this.companyIds = new ArrayList<>();
    }
    this.companyIds.add(companyIdsItem);
    return this;
  }

  /**
   * Company Ids linked to a note
   * @return companyIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCompanyIds() {
    return companyIds;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyIds(@jakarta.annotation.Nullable List<String> companyIds) {
    this.companyIds = companyIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NoteData noteData = (NoteData) o;
    return Objects.equals(this.text, noteData.text) &&
        Objects.equals(this.contactIds, noteData.contactIds) &&
        Objects.equals(this.dealIds, noteData.dealIds) &&
        Objects.equals(this.companyIds, noteData.companyIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, contactIds, dealIds, companyIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NoteData {\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    contactIds: ").append(toIndentedString(contactIds)).append("\n");
    sb.append("    dealIds: ").append(toIndentedString(dealIds)).append("\n");
    sb.append("    companyIds: ").append(toIndentedString(companyIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `text` to the URL query string
    if (getText() != null) {
      try {
        joiner.add(String.format("%stext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactIds` to the URL query string
    if (getContactIds() != null) {
      for (int i = 0; i < getContactIds().size(); i++) {
        try {
          joiner.add(String.format("%scontactIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getContactIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `dealIds` to the URL query string
    if (getDealIds() != null) {
      for (int i = 0; i < getDealIds().size(); i++) {
        try {
          joiner.add(String.format("%sdealIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getDealIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `companyIds` to the URL query string
    if (getCompanyIds() != null) {
      for (int i = 0; i < getCompanyIds().size(); i++) {
        try {
          joiner.add(String.format("%scompanyIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCompanyIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

