/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.MasterDetailsResponsePlanInfoFeaturesInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Plan details
 */
@JsonPropertyOrder({
  MasterDetailsResponsePlanInfo.JSON_PROPERTY_CURRENCY_CODE,
  MasterDetailsResponsePlanInfo.JSON_PROPERTY_NEXT_BILLING_AT,
  MasterDetailsResponsePlanInfo.JSON_PROPERTY_PRICE,
  MasterDetailsResponsePlanInfo.JSON_PROPERTY_PLAN_PERIOD,
  MasterDetailsResponsePlanInfo.JSON_PROPERTY_SUB_ACCOUNTS,
  MasterDetailsResponsePlanInfo.JSON_PROPERTY_FEATURES
})
@JsonTypeName("masterDetailsResponse_planInfo")
public class MasterDetailsResponsePlanInfo {
  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nullable
  private String currencyCode;

  public static final String JSON_PROPERTY_NEXT_BILLING_AT = "nextBillingAt";
  @jakarta.annotation.Nullable
  private Long nextBillingAt;

  public static final String JSON_PROPERTY_PRICE = "price";
  @jakarta.annotation.Nullable
  private BigDecimal price;

  /**
   * Plan period type
   */
  public enum PlanPeriodEnum {
    MONTH(String.valueOf("month")),
    
    YEAR(String.valueOf("year"));

    private String value;

    PlanPeriodEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PlanPeriodEnum fromValue(String value) {
      for (PlanPeriodEnum b : PlanPeriodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PLAN_PERIOD = "planPeriod";
  @jakarta.annotation.Nullable
  private PlanPeriodEnum planPeriod;

  public static final String JSON_PROPERTY_SUB_ACCOUNTS = "subAccounts";
  @jakarta.annotation.Nullable
  private Integer subAccounts;

  public static final String JSON_PROPERTY_FEATURES = "features";
  @jakarta.annotation.Nullable
  private List<MasterDetailsResponsePlanInfoFeaturesInner> features = new ArrayList<>();

  public MasterDetailsResponsePlanInfo() {
  }

  public MasterDetailsResponsePlanInfo currencyCode(@jakarta.annotation.Nullable String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Plan currency
   * @return currencyCode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(@jakarta.annotation.Nullable String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public MasterDetailsResponsePlanInfo nextBillingAt(@jakarta.annotation.Nullable Long nextBillingAt) {
    
    this.nextBillingAt = nextBillingAt;
    return this;
  }

  /**
   * Timestamp of next billing date
   * @return nextBillingAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NEXT_BILLING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNextBillingAt() {
    return nextBillingAt;
  }


  @JsonProperty(JSON_PROPERTY_NEXT_BILLING_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNextBillingAt(@jakarta.annotation.Nullable Long nextBillingAt) {
    this.nextBillingAt = nextBillingAt;
  }

  public MasterDetailsResponsePlanInfo price(@jakarta.annotation.Nullable BigDecimal price) {
    
    this.price = price;
    return this;
  }

  /**
   * Plan amount
   * @return price
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(@jakarta.annotation.Nullable BigDecimal price) {
    this.price = price;
  }

  public MasterDetailsResponsePlanInfo planPeriod(@jakarta.annotation.Nullable PlanPeriodEnum planPeriod) {
    
    this.planPeriod = planPeriod;
    return this;
  }

  /**
   * Plan period type
   * @return planPeriod
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PLAN_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlanPeriodEnum getPlanPeriod() {
    return planPeriod;
  }


  @JsonProperty(JSON_PROPERTY_PLAN_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlanPeriod(@jakarta.annotation.Nullable PlanPeriodEnum planPeriod) {
    this.planPeriod = planPeriod;
  }

  public MasterDetailsResponsePlanInfo subAccounts(@jakarta.annotation.Nullable Integer subAccounts) {
    
    this.subAccounts = subAccounts;
    return this;
  }

  /**
   * Number of sub-accounts
   * @return subAccounts
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUB_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSubAccounts() {
    return subAccounts;
  }


  @JsonProperty(JSON_PROPERTY_SUB_ACCOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubAccounts(@jakarta.annotation.Nullable Integer subAccounts) {
    this.subAccounts = subAccounts;
  }

  public MasterDetailsResponsePlanInfo features(@jakarta.annotation.Nullable List<MasterDetailsResponsePlanInfoFeaturesInner> features) {
    
    this.features = features;
    return this;
  }

  public MasterDetailsResponsePlanInfo addFeaturesItem(MasterDetailsResponsePlanInfoFeaturesInner featuresItem) {
    if (this.features == null) {
      this.features = new ArrayList<>();
    }
    this.features.add(featuresItem);
    return this;
  }

  /**
   * List of provided features in the plan
   * @return features
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MasterDetailsResponsePlanInfoFeaturesInner> getFeatures() {
    return features;
  }


  @JsonProperty(JSON_PROPERTY_FEATURES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeatures(@jakarta.annotation.Nullable List<MasterDetailsResponsePlanInfoFeaturesInner> features) {
    this.features = features;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MasterDetailsResponsePlanInfo masterDetailsResponsePlanInfo = (MasterDetailsResponsePlanInfo) o;
    return Objects.equals(this.currencyCode, masterDetailsResponsePlanInfo.currencyCode) &&
        Objects.equals(this.nextBillingAt, masterDetailsResponsePlanInfo.nextBillingAt) &&
        Objects.equals(this.price, masterDetailsResponsePlanInfo.price) &&
        Objects.equals(this.planPeriod, masterDetailsResponsePlanInfo.planPeriod) &&
        Objects.equals(this.subAccounts, masterDetailsResponsePlanInfo.subAccounts) &&
        Objects.equals(this.features, masterDetailsResponsePlanInfo.features);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currencyCode, nextBillingAt, price, planPeriod, subAccounts, features);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MasterDetailsResponsePlanInfo {\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    nextBillingAt: ").append(toIndentedString(nextBillingAt)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    planPeriod: ").append(toIndentedString(planPeriod)).append("\n");
    sb.append("    subAccounts: ").append(toIndentedString(subAccounts)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `currencyCode` to the URL query string
    if (getCurrencyCode() != null) {
      try {
        joiner.add(String.format("%scurrencyCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCurrencyCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `nextBillingAt` to the URL query string
    if (getNextBillingAt() != null) {
      try {
        joiner.add(String.format("%snextBillingAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNextBillingAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `price` to the URL query string
    if (getPrice() != null) {
      try {
        joiner.add(String.format("%sprice%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPrice()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `planPeriod` to the URL query string
    if (getPlanPeriod() != null) {
      try {
        joiner.add(String.format("%splanPeriod%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPlanPeriod()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subAccounts` to the URL query string
    if (getSubAccounts() != null) {
      try {
        joiner.add(String.format("%ssubAccounts%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubAccounts()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `features` to the URL query string
    if (getFeatures() != null) {
      for (int i = 0; i < getFeatures().size(); i++) {
        if (getFeatures().get(i) != null) {
          joiner.add(getFeatures().get(i).toUrlQueryString(String.format("%sfeatures%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

