/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import software.xdev.brevo.model.MasterDetailsResponseBillingInfo;
import software.xdev.brevo.model.MasterDetailsResponsePlanInfo;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MasterDetailsResponse
 */
@JsonPropertyOrder({
  MasterDetailsResponse.JSON_PROPERTY_EMAIL,
  MasterDetailsResponse.JSON_PROPERTY_COMPANY_NAME,
  MasterDetailsResponse.JSON_PROPERTY_ID,
  MasterDetailsResponse.JSON_PROPERTY_CURRENCY_CODE,
  MasterDetailsResponse.JSON_PROPERTY_TIMEZONE,
  MasterDetailsResponse.JSON_PROPERTY_BILLING_INFO,
  MasterDetailsResponse.JSON_PROPERTY_PLAN_INFO
})
@JsonTypeName("masterDetailsResponse")
public class MasterDetailsResponse {
  public static final String JSON_PROPERTY_EMAIL = "email";
  @jakarta.annotation.Nullable
  private String email;

  public static final String JSON_PROPERTY_COMPANY_NAME = "companyName";
  @jakarta.annotation.Nullable
  private String companyName;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private Long id;

  public static final String JSON_PROPERTY_CURRENCY_CODE = "currencyCode";
  @jakarta.annotation.Nullable
  private String currencyCode;

  public static final String JSON_PROPERTY_TIMEZONE = "timezone";
  @jakarta.annotation.Nullable
  private String timezone;

  public static final String JSON_PROPERTY_BILLING_INFO = "billingInfo";
  @jakarta.annotation.Nullable
  private MasterDetailsResponseBillingInfo billingInfo;

  public static final String JSON_PROPERTY_PLAN_INFO = "planInfo";
  @jakarta.annotation.Nullable
  private MasterDetailsResponsePlanInfo planInfo;

  public MasterDetailsResponse() {
  }

  public MasterDetailsResponse email(@jakarta.annotation.Nullable String email) {
    
    this.email = email;
    return this;
  }

  /**
   * Email id of master account
   * @return email
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(@jakarta.annotation.Nullable String email) {
    this.email = email;
  }

  public MasterDetailsResponse companyName(@jakarta.annotation.Nullable String companyName) {
    
    this.companyName = companyName;
    return this;
  }

  /**
   * Company name of master account organization
   * @return companyName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCompanyName() {
    return companyName;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompanyName(@jakarta.annotation.Nullable String companyName) {
    this.companyName = companyName;
  }

  public MasterDetailsResponse id(@jakarta.annotation.Nullable Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier of the master account organization
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable Long id) {
    this.id = id;
  }

  public MasterDetailsResponse currencyCode(@jakarta.annotation.Nullable String currencyCode) {
    
    this.currencyCode = currencyCode;
    return this;
  }

  /**
   * Currency code of the master account organization
   * @return currencyCode
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrencyCode() {
    return currencyCode;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrencyCode(@jakarta.annotation.Nullable String currencyCode) {
    this.currencyCode = currencyCode;
  }

  public MasterDetailsResponse timezone(@jakarta.annotation.Nullable String timezone) {
    
    this.timezone = timezone;
    return this;
  }

  /**
   * Timezone of the master account organization
   * @return timezone
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTimezone() {
    return timezone;
  }


  @JsonProperty(JSON_PROPERTY_TIMEZONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimezone(@jakarta.annotation.Nullable String timezone) {
    this.timezone = timezone;
  }

  public MasterDetailsResponse billingInfo(@jakarta.annotation.Nullable MasterDetailsResponseBillingInfo billingInfo) {
    
    this.billingInfo = billingInfo;
    return this;
  }

  /**
   * Get billingInfo
   * @return billingInfo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BILLING_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MasterDetailsResponseBillingInfo getBillingInfo() {
    return billingInfo;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingInfo(@jakarta.annotation.Nullable MasterDetailsResponseBillingInfo billingInfo) {
    this.billingInfo = billingInfo;
  }

  public MasterDetailsResponse planInfo(@jakarta.annotation.Nullable MasterDetailsResponsePlanInfo planInfo) {
    
    this.planInfo = planInfo;
    return this;
  }

  /**
   * Get planInfo
   * @return planInfo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PLAN_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MasterDetailsResponsePlanInfo getPlanInfo() {
    return planInfo;
  }


  @JsonProperty(JSON_PROPERTY_PLAN_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlanInfo(@jakarta.annotation.Nullable MasterDetailsResponsePlanInfo planInfo) {
    this.planInfo = planInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MasterDetailsResponse masterDetailsResponse = (MasterDetailsResponse) o;
    return Objects.equals(this.email, masterDetailsResponse.email) &&
        Objects.equals(this.companyName, masterDetailsResponse.companyName) &&
        Objects.equals(this.id, masterDetailsResponse.id) &&
        Objects.equals(this.currencyCode, masterDetailsResponse.currencyCode) &&
        Objects.equals(this.timezone, masterDetailsResponse.timezone) &&
        Objects.equals(this.billingInfo, masterDetailsResponse.billingInfo) &&
        Objects.equals(this.planInfo, masterDetailsResponse.planInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, companyName, id, currencyCode, timezone, billingInfo, planInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MasterDetailsResponse {\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    currencyCode: ").append(toIndentedString(currencyCode)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    billingInfo: ").append(toIndentedString(billingInfo)).append("\n");
    sb.append("    planInfo: ").append(toIndentedString(planInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `email` to the URL query string
    if (getEmail() != null) {
      try {
        joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmail()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `companyName` to the URL query string
    if (getCompanyName() != null) {
      try {
        joiner.add(String.format("%scompanyName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompanyName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `currencyCode` to the URL query string
    if (getCurrencyCode() != null) {
      try {
        joiner.add(String.format("%scurrencyCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCurrencyCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `timezone` to the URL query string
    if (getTimezone() != null) {
      try {
        joiner.add(String.format("%stimezone%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTimezone()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `billingInfo` to the URL query string
    if (getBillingInfo() != null) {
      joiner.add(getBillingInfo().toUrlQueryString(prefix + "billingInfo" + suffix));
    }

    // add `planInfo` to the URL query string
    if (getPlanInfo() != null) {
      joiner.add(getPlanInfo().toUrlQueryString(prefix + "planInfo" + suffix));
    }

    return joiner.toString();
  }

}

