/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.xdev.brevo.model.MainRuleConditionResponse;
import software.xdev.brevo.model.MainRuleEventResponse;
import software.xdev.brevo.model.MainRuleResultResponse;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MainRule
 */
@JsonPropertyOrder({
  MainRule.JSON_PROPERTY_CONDITION,
  MainRule.JSON_PROPERTY_CREATED_AT,
  MainRule.JSON_PROPERTY_DESCRIPTION,
  MainRule.JSON_PROPERTY_EVENT,
  MainRule.JSON_PROPERTY_IS_INTERNAL,
  MainRule.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  MainRule.JSON_PROPERTY_LOYALTY_VERSION_ID,
  MainRule.JSON_PROPERTY_META,
  MainRule.JSON_PROPERTY_NAME,
  MainRule.JSON_PROPERTY_RESULTS,
  MainRule.JSON_PROPERTY_RULE_ID,
  MainRule.JSON_PROPERTY_RULE_TYPE,
  MainRule.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("main.rule")
public class MainRule {
  public static final String JSON_PROPERTY_CONDITION = "condition";
  @jakarta.annotation.Nullable
  private MainRuleConditionResponse condition;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private String createdAt;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_EVENT = "event";
  @jakarta.annotation.Nullable
  private MainRuleEventResponse event;

  public static final String JSON_PROPERTY_IS_INTERNAL = "isInternal";
  @jakarta.annotation.Nullable
  private Boolean isInternal;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private String loyaltyProgramId;

  public static final String JSON_PROPERTY_LOYALTY_VERSION_ID = "loyaltyVersionId";
  @jakarta.annotation.Nullable
  private Integer loyaltyVersionId;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_RESULTS = "results";
  @jakarta.annotation.Nullable
  private List<MainRuleResultResponse> results = new ArrayList<>();

  public static final String JSON_PROPERTY_RULE_ID = "ruleId";
  @jakarta.annotation.Nullable
  private String ruleId;

  public static final String JSON_PROPERTY_RULE_TYPE = "ruleType";
  @jakarta.annotation.Nullable
  private String ruleType;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nullable
  private String updatedAt;

  public MainRule() {
  }

  public MainRule condition(@jakarta.annotation.Nullable MainRuleConditionResponse condition) {
    
    this.condition = condition;
    return this;
  }

  /**
   * Selected rule condition
   * @return condition
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONDITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainRuleConditionResponse getCondition() {
    return condition;
  }


  @JsonProperty(JSON_PROPERTY_CONDITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCondition(@jakarta.annotation.Nullable MainRuleConditionResponse condition) {
    this.condition = condition;
  }

  public MainRule createdAt(@jakarta.annotation.Nullable String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the rule was created
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable String createdAt) {
    this.createdAt = createdAt;
  }

  public MainRule description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Description of the rule
   * @return description
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public MainRule event(@jakarta.annotation.Nullable MainRuleEventResponse event) {
    
    this.event = event;
    return this;
  }

  /**
   * Selected event in the rule
   * @return event
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainRuleEventResponse getEvent() {
    return event;
  }


  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEvent(@jakarta.annotation.Nullable MainRuleEventResponse event) {
    this.event = event;
  }

  public MainRule isInternal(@jakarta.annotation.Nullable Boolean isInternal) {
    
    this.isInternal = isInternal;
    return this;
  }

  /**
   * Metric to identify if it&#39;s an internal rule or not
   * @return isInternal
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_INTERNAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsInternal() {
    return isInternal;
  }


  @JsonProperty(JSON_PROPERTY_IS_INTERNAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsInternal(@jakarta.annotation.Nullable Boolean isInternal) {
    this.isInternal = isInternal;
  }

  public MainRule loyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Loyalty Program id to which current rule is associated
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public MainRule loyaltyVersionId(@jakarta.annotation.Nullable Integer loyaltyVersionId) {
    
    this.loyaltyVersionId = loyaltyVersionId;
    return this;
  }

  /**
   * Loyalty Version id to which current rule is associated
   * @return loyaltyVersionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLoyaltyVersionId() {
    return loyaltyVersionId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_VERSION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyVersionId(@jakarta.annotation.Nullable Integer loyaltyVersionId) {
    this.loyaltyVersionId = loyaltyVersionId;
  }

  public MainRule meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public MainRule putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Additional data to define the rule
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public MainRule name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Rule name
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public MainRule results(@jakarta.annotation.Nullable List<MainRuleResultResponse> results) {
    
    this.results = results;
    return this;
  }

  public MainRule addResultsItem(MainRuleResultResponse resultsItem) {
    if (this.results == null) {
      this.results = new ArrayList<>();
    }
    this.results.add(resultsItem);
    return this;
  }

  /**
   * Results of the rule definition
   * @return results
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MainRuleResultResponse> getResults() {
    return results;
  }


  @JsonProperty(JSON_PROPERTY_RESULTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setResults(@jakarta.annotation.Nullable List<MainRuleResultResponse> results) {
    this.results = results;
  }

  public MainRule ruleId(@jakarta.annotation.Nullable String ruleId) {
    
    this.ruleId = ruleId;
    return this;
  }

  /**
   * Unique identifier for the rule
   * @return ruleId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RULE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleId() {
    return ruleId;
  }


  @JsonProperty(JSON_PROPERTY_RULE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuleId(@jakarta.annotation.Nullable String ruleId) {
    this.ruleId = ruleId;
  }

  public MainRule ruleType(@jakarta.annotation.Nullable String ruleType) {
    
    this.ruleType = ruleType;
    return this;
  }

  /**
   * Type of the rule
   * @return ruleType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RULE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRuleType() {
    return ruleType;
  }


  @JsonProperty(JSON_PROPERTY_RULE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuleType(@jakarta.annotation.Nullable String ruleType) {
    this.ruleType = ruleType;
  }

  public MainRule updatedAt(@jakarta.annotation.Nullable String updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Timestamp when the rule was updated
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(@jakarta.annotation.Nullable String updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainRule mainRule = (MainRule) o;
    return Objects.equals(this.condition, mainRule.condition) &&
        Objects.equals(this.createdAt, mainRule.createdAt) &&
        Objects.equals(this.description, mainRule.description) &&
        Objects.equals(this.event, mainRule.event) &&
        Objects.equals(this.isInternal, mainRule.isInternal) &&
        Objects.equals(this.loyaltyProgramId, mainRule.loyaltyProgramId) &&
        Objects.equals(this.loyaltyVersionId, mainRule.loyaltyVersionId) &&
        Objects.equals(this.meta, mainRule.meta) &&
        Objects.equals(this.name, mainRule.name) &&
        Objects.equals(this.results, mainRule.results) &&
        Objects.equals(this.ruleId, mainRule.ruleId) &&
        Objects.equals(this.ruleType, mainRule.ruleType) &&
        Objects.equals(this.updatedAt, mainRule.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(condition, createdAt, description, event, isInternal, loyaltyProgramId, loyaltyVersionId, meta, name, results, ruleId, ruleType, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainRule {\n");
    sb.append("    condition: ").append(toIndentedString(condition)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    isInternal: ").append(toIndentedString(isInternal)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    loyaltyVersionId: ").append(toIndentedString(loyaltyVersionId)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("    ruleId: ").append(toIndentedString(ruleId)).append("\n");
    sb.append("    ruleType: ").append(toIndentedString(ruleType)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `condition` to the URL query string
    if (getCondition() != null) {
      joiner.add(getCondition().toUrlQueryString(prefix + "condition" + suffix));
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `event` to the URL query string
    if (getEvent() != null) {
      joiner.add(getEvent().toUrlQueryString(prefix + "event" + suffix));
    }

    // add `isInternal` to the URL query string
    if (getIsInternal() != null) {
      try {
        joiner.add(String.format("%sisInternal%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsInternal()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyVersionId` to the URL query string
    if (getLoyaltyVersionId() != null) {
      try {
        joiner.add(String.format("%sloyaltyVersionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyVersionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `results` to the URL query string
    if (getResults() != null) {
      for (int i = 0; i < getResults().size(); i++) {
        if (getResults().get(i) != null) {
          joiner.add(getResults().get(i).toUrlQueryString(String.format("%sresults%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `ruleId` to the URL query string
    if (getRuleId() != null) {
      try {
        joiner.add(String.format("%sruleId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRuleId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ruleType` to the URL query string
    if (getRuleType() != null) {
      try {
        joiner.add(String.format("%sruleType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRuleType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

