/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import software.xdev.brevo.model.MainGenerator;
import software.xdev.brevo.model.MainLimit;
import software.xdev.brevo.model.MainProduct;
import software.xdev.brevo.model.MainRewardConfigurations;
import software.xdev.brevo.model.MainRule;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MainReward
 */
@JsonPropertyOrder({
  MainReward.JSON_PROPERTY_ATTRIBUTION_PER_CONSUMER,
  MainReward.JSON_PROPERTY_BALANCE_DEFINITION_ID,
  MainReward.JSON_PROPERTY_CODE,
  MainReward.JSON_PROPERTY_CODE_COUNT,
  MainReward.JSON_PROPERTY_CODE_GENERATOR_ID,
  MainReward.JSON_PROPERTY_CODE_POOL_ID,
  MainReward.JSON_PROPERTY_CONFIG,
  MainReward.JSON_PROPERTY_CREATED_AT,
  MainReward.JSON_PROPERTY_DISABLED_AT,
  MainReward.JSON_PROPERTY_END_DATE,
  MainReward.JSON_PROPERTY_EXPIRATION_DATE,
  MainReward.JSON_PROPERTY_EXPIRATION_MODIFIER,
  MainReward.JSON_PROPERTY_EXPIRATION_UNIT,
  MainReward.JSON_PROPERTY_EXPIRATION_VALUE,
  MainReward.JSON_PROPERTY_GENERATOR,
  MainReward.JSON_PROPERTY_ID,
  MainReward.JSON_PROPERTY_LIMITS,
  MainReward.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  MainReward.JSON_PROPERTY_META,
  MainReward.JSON_PROPERTY_NAME,
  MainReward.JSON_PROPERTY_PRODUCTS,
  MainReward.JSON_PROPERTY_PUBLIC_DESCRIPTION,
  MainReward.JSON_PROPERTY_PUBLIC_IMAGE,
  MainReward.JSON_PROPERTY_PUBLIC_NAME,
  MainReward.JSON_PROPERTY_REDEEM_PER_CONSUMER,
  MainReward.JSON_PROPERTY_REDEEM_RULES,
  MainReward.JSON_PROPERTY_REWARD_CONFIGS,
  MainReward.JSON_PROPERTY_RULE,
  MainReward.JSON_PROPERTY_START_DATE,
  MainReward.JSON_PROPERTY_SUBTRACT_BALANCE_DEFINITION_ID,
  MainReward.JSON_PROPERTY_SUBTRACT_BALANCE_STRATEGY,
  MainReward.JSON_PROPERTY_SUBTRACT_BALANCE_VALUE,
  MainReward.JSON_PROPERTY_SUBTRACT_TOTAL_BALANCE,
  MainReward.JSON_PROPERTY_TOTAL_ATTRIBUTION,
  MainReward.JSON_PROPERTY_TOTAL_REDEEM,
  MainReward.JSON_PROPERTY_TRIGGER_ID,
  MainReward.JSON_PROPERTY_UNIT,
  MainReward.JSON_PROPERTY_UPDATED_AT,
  MainReward.JSON_PROPERTY_VALUE,
  MainReward.JSON_PROPERTY_VALUE_TYPE
})
@JsonTypeName("main.reward")
public class MainReward {
  public static final String JSON_PROPERTY_ATTRIBUTION_PER_CONSUMER = "attributionPerConsumer";
  @jakarta.annotation.Nullable
  private Integer attributionPerConsumer;

  public static final String JSON_PROPERTY_BALANCE_DEFINITION_ID = "balanceDefinitionId";
  @jakarta.annotation.Nullable
  private UUID balanceDefinitionId;

  public static final String JSON_PROPERTY_CODE = "code";
  @jakarta.annotation.Nullable
  private String code;

  public static final String JSON_PROPERTY_CODE_COUNT = "codeCount";
  @jakarta.annotation.Nullable
  private Long codeCount;

  public static final String JSON_PROPERTY_CODE_GENERATOR_ID = "codeGeneratorId";
  @jakarta.annotation.Nullable
  private UUID codeGeneratorId;

  public static final String JSON_PROPERTY_CODE_POOL_ID = "codePoolId";
  @jakarta.annotation.Nullable
  private UUID codePoolId;

  public static final String JSON_PROPERTY_CONFIG = "config";
  @jakarta.annotation.Nullable
  private String config;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DISABLED_AT = "disabledAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime disabledAt;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nullable
  private OffsetDateTime endDate;

  public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
  @jakarta.annotation.Nullable
  private OffsetDateTime expirationDate;

  /**
   * Select startOfPeriod to configure rewards expiry on start of day/week/month/year. Select endOfPeriod to configure reward expiry on end of day/week/month/year, else select noModification
   */
  public enum ExpirationModifierEnum {
    START_OF_PERIOD(String.valueOf("startOfPeriod")),
    
    END_OF_PERIOD(String.valueOf("endOfPeriod")),
    
    NO_MODIFICATION(String.valueOf("noModification"));

    private String value;

    ExpirationModifierEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ExpirationModifierEnum fromValue(String value) {
      for (ExpirationModifierEnum b : ExpirationModifierEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EXPIRATION_MODIFIER = "expirationModifier";
  @jakarta.annotation.Nullable
  private ExpirationModifierEnum expirationModifier = ExpirationModifierEnum.NO_MODIFICATION;

  public static final String JSON_PROPERTY_EXPIRATION_UNIT = "expirationUnit";
  @jakarta.annotation.Nullable
  private String expirationUnit;

  public static final String JSON_PROPERTY_EXPIRATION_VALUE = "expirationValue";
  @jakarta.annotation.Nullable
  private Integer expirationValue;

  public static final String JSON_PROPERTY_GENERATOR = "generator";
  @jakarta.annotation.Nullable
  private MainGenerator generator;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private UUID id;

  public static final String JSON_PROPERTY_LIMITS = "limits";
  @jakarta.annotation.Nullable
  private List<MainLimit> limits = new ArrayList<>();

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private UUID loyaltyProgramId;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_PRODUCTS = "products";
  @jakarta.annotation.Nullable
  private List<MainProduct> products = new ArrayList<>();

  public static final String JSON_PROPERTY_PUBLIC_DESCRIPTION = "publicDescription";
  @jakarta.annotation.Nullable
  private String publicDescription;

  public static final String JSON_PROPERTY_PUBLIC_IMAGE = "publicImage";
  @jakarta.annotation.Nullable
  private String publicImage;

  public static final String JSON_PROPERTY_PUBLIC_NAME = "publicName";
  @jakarta.annotation.Nullable
  private String publicName;

  public static final String JSON_PROPERTY_REDEEM_PER_CONSUMER = "redeemPerConsumer";
  @jakarta.annotation.Nullable
  private Integer redeemPerConsumer;

  public static final String JSON_PROPERTY_REDEEM_RULES = "redeemRules";
  @jakarta.annotation.Nullable
  private List<String> redeemRules = new ArrayList<>();

  public static final String JSON_PROPERTY_REWARD_CONFIGS = "rewardConfigs";
  @jakarta.annotation.Nullable
  private MainRewardConfigurations rewardConfigs;

  public static final String JSON_PROPERTY_RULE = "rule";
  @jakarta.annotation.Nullable
  private MainRule rule;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nullable
  private OffsetDateTime startDate;

  public static final String JSON_PROPERTY_SUBTRACT_BALANCE_DEFINITION_ID = "subtractBalanceDefinitionId";
  @jakarta.annotation.Nullable
  private String subtractBalanceDefinitionId;

  public static final String JSON_PROPERTY_SUBTRACT_BALANCE_STRATEGY = "subtractBalanceStrategy";
  @jakarta.annotation.Nullable
  private String subtractBalanceStrategy;

  public static final String JSON_PROPERTY_SUBTRACT_BALANCE_VALUE = "subtractBalanceValue";
  @jakarta.annotation.Nullable
  private Integer subtractBalanceValue;

  public static final String JSON_PROPERTY_SUBTRACT_TOTAL_BALANCE = "subtractTotalBalance";
  @jakarta.annotation.Nullable
  private Boolean subtractTotalBalance;

  public static final String JSON_PROPERTY_TOTAL_ATTRIBUTION = "totalAttribution";
  @jakarta.annotation.Nullable
  private Integer totalAttribution;

  public static final String JSON_PROPERTY_TOTAL_REDEEM = "totalRedeem";
  @jakarta.annotation.Nullable
  private Integer totalRedeem;

  public static final String JSON_PROPERTY_TRIGGER_ID = "triggerId";
  @jakarta.annotation.Nullable
  private String triggerId;

  public static final String JSON_PROPERTY_UNIT = "unit";
  @jakarta.annotation.Nullable
  private String unit;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nullable
  private String updatedAt;

  public static final String JSON_PROPERTY_VALUE = "value";
  @jakarta.annotation.Nullable
  private BigDecimal value;

  public static final String JSON_PROPERTY_VALUE_TYPE = "valueType";
  @jakarta.annotation.Nullable
  private String valueType;

  public MainReward() {
  }

  public MainReward attributionPerConsumer(@jakarta.annotation.Nullable Integer attributionPerConsumer) {
    
    this.attributionPerConsumer = attributionPerConsumer;
    return this;
  }

  /**
   * Maximum number of times a consumer can be attributed this reward
   * @return attributionPerConsumer
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTION_PER_CONSUMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAttributionPerConsumer() {
    return attributionPerConsumer;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTION_PER_CONSUMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributionPerConsumer(@jakarta.annotation.Nullable Integer attributionPerConsumer) {
    this.attributionPerConsumer = attributionPerConsumer;
  }

  public MainReward balanceDefinitionId(@jakarta.annotation.Nullable UUID balanceDefinitionId) {
    
    this.balanceDefinitionId = balanceDefinitionId;
    return this;
  }

  /**
   * Unique identifier for the balance definition
   * @return balanceDefinitionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBalanceDefinitionId() {
    return balanceDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceDefinitionId(@jakarta.annotation.Nullable UUID balanceDefinitionId) {
    this.balanceDefinitionId = balanceDefinitionId;
  }

  public MainReward code(@jakarta.annotation.Nullable String code) {
    
    this.code = code;
    return this;
  }

  /**
   * Unique code for the reward
   * @return code
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(@jakarta.annotation.Nullable String code) {
    this.code = code;
  }

  public MainReward codeCount(@jakarta.annotation.Nullable Long codeCount) {
    
    this.codeCount = codeCount;
    return this;
  }

  /**
   * Total number of codes generated
   * @return codeCount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCodeCount() {
    return codeCount;
  }


  @JsonProperty(JSON_PROPERTY_CODE_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCodeCount(@jakarta.annotation.Nullable Long codeCount) {
    this.codeCount = codeCount;
  }

  public MainReward codeGeneratorId(@jakarta.annotation.Nullable UUID codeGeneratorId) {
    
    this.codeGeneratorId = codeGeneratorId;
    return this;
  }

  /**
   * Unique identifier for the code generator
   * @return codeGeneratorId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE_GENERATOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getCodeGeneratorId() {
    return codeGeneratorId;
  }


  @JsonProperty(JSON_PROPERTY_CODE_GENERATOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCodeGeneratorId(@jakarta.annotation.Nullable UUID codeGeneratorId) {
    this.codeGeneratorId = codeGeneratorId;
  }

  public MainReward codePoolId(@jakarta.annotation.Nullable UUID codePoolId) {
    
    this.codePoolId = codePoolId;
    return this;
  }

  /**
   * Unique identifier for the code pool
   * @return codePoolId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE_POOL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getCodePoolId() {
    return codePoolId;
  }


  @JsonProperty(JSON_PROPERTY_CODE_POOL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCodePoolId(@jakarta.annotation.Nullable UUID codePoolId) {
    this.codePoolId = codePoolId;
  }

  public MainReward config(@jakarta.annotation.Nullable String config) {
    
    this.config = config;
    return this;
  }

  /**
   * Configuration settings for the reward
   * @return config
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConfig() {
    return config;
  }


  @JsonProperty(JSON_PROPERTY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfig(@jakarta.annotation.Nullable String config) {
    this.config = config;
  }

  public MainReward createdAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the reward was created
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public MainReward disabledAt(@jakarta.annotation.Nullable OffsetDateTime disabledAt) {
    
    this.disabledAt = disabledAt;
    return this;
  }

  /**
   * Disabled date of the reward
   * @return disabledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DISABLED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getDisabledAt() {
    return disabledAt;
  }


  @JsonProperty(JSON_PROPERTY_DISABLED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabledAt(@jakarta.annotation.Nullable OffsetDateTime disabledAt) {
    this.disabledAt = disabledAt;
  }

  public MainReward endDate(@jakarta.annotation.Nullable OffsetDateTime endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * End date of the reward validity
   * @return endDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@jakarta.annotation.Nullable OffsetDateTime endDate) {
    this.endDate = endDate;
  }

  public MainReward expirationDate(@jakarta.annotation.Nullable OffsetDateTime expirationDate) {
    
    this.expirationDate = expirationDate;
    return this;
  }

  /**
   * Expiration date of the reward
   * @return expirationDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpirationDate() {
    return expirationDate;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpirationDate(@jakarta.annotation.Nullable OffsetDateTime expirationDate) {
    this.expirationDate = expirationDate;
  }

  public MainReward expirationModifier(@jakarta.annotation.Nullable ExpirationModifierEnum expirationModifier) {
    
    this.expirationModifier = expirationModifier;
    return this;
  }

  /**
   * Select startOfPeriod to configure rewards expiry on start of day/week/month/year. Select endOfPeriod to configure reward expiry on end of day/week/month/year, else select noModification
   * @return expirationModifier
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRATION_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ExpirationModifierEnum getExpirationModifier() {
    return expirationModifier;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpirationModifier(@jakarta.annotation.Nullable ExpirationModifierEnum expirationModifier) {
    this.expirationModifier = expirationModifier;
  }

  public MainReward expirationUnit(@jakarta.annotation.Nullable String expirationUnit) {
    
    this.expirationUnit = expirationUnit;
    return this;
  }

  /**
   * Unit of time for the rewards&#39;s availability (e.g., day/week/month/year).
   * @return expirationUnit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpirationUnit() {
    return expirationUnit;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpirationUnit(@jakarta.annotation.Nullable String expirationUnit) {
    this.expirationUnit = expirationUnit;
  }

  public MainReward expirationValue(@jakarta.annotation.Nullable Integer expirationValue) {
    
    this.expirationValue = expirationValue;
    return this;
  }

  /**
   * Number of days/weeks/month/year for reward expiry
   * @return expirationValue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getExpirationValue() {
    return expirationValue;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpirationValue(@jakarta.annotation.Nullable Integer expirationValue) {
    this.expirationValue = expirationValue;
  }

  public MainReward generator(@jakarta.annotation.Nullable MainGenerator generator) {
    
    this.generator = generator;
    return this;
  }

  /**
   * object
   * @return generator
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GENERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainGenerator getGenerator() {
    return generator;
  }


  @JsonProperty(JSON_PROPERTY_GENERATOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGenerator(@jakarta.annotation.Nullable MainGenerator generator) {
    this.generator = generator;
  }

  public MainReward id(@jakarta.annotation.Nullable UUID id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for the reward
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable UUID id) {
    this.id = id;
  }

  public MainReward limits(@jakarta.annotation.Nullable List<MainLimit> limits) {
    
    this.limits = limits;
    return this;
  }

  public MainReward addLimitsItem(MainLimit limitsItem) {
    if (this.limits == null) {
      this.limits = new ArrayList<>();
    }
    this.limits.add(limitsItem);
    return this;
  }

  /**
   * Attribution / Redeem Limits for the reward
   * @return limits
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MainLimit> getLimits() {
    return limits;
  }


  @JsonProperty(JSON_PROPERTY_LIMITS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimits(@jakarta.annotation.Nullable List<MainLimit> limits) {
    this.limits = limits;
  }

  public MainReward loyaltyProgramId(@jakarta.annotation.Nullable UUID loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Id of the loyalty program to which the current reward belongs to
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable UUID loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public MainReward meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public MainReward putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Additional data for reward definition
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public MainReward name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the reward
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public MainReward products(@jakarta.annotation.Nullable List<MainProduct> products) {
    
    this.products = products;
    return this;
  }

  public MainReward addProductsItem(MainProduct productsItem) {
    if (this.products == null) {
      this.products = new ArrayList<>();
    }
    this.products.add(productsItem);
    return this;
  }

  /**
   * Selected products for reward definition
   * @return products
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MainProduct> getProducts() {
    return products;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProducts(@jakarta.annotation.Nullable List<MainProduct> products) {
    this.products = products;
  }

  public MainReward publicDescription(@jakarta.annotation.Nullable String publicDescription) {
    
    this.publicDescription = publicDescription;
    return this;
  }

  /**
   * Public description for the reward
   * @return publicDescription
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PUBLIC_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPublicDescription() {
    return publicDescription;
  }


  @JsonProperty(JSON_PROPERTY_PUBLIC_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublicDescription(@jakarta.annotation.Nullable String publicDescription) {
    this.publicDescription = publicDescription;
  }

  public MainReward publicImage(@jakarta.annotation.Nullable String publicImage) {
    
    this.publicImage = publicImage;
    return this;
  }

  /**
   * Public Image for the reward
   * @return publicImage
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PUBLIC_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPublicImage() {
    return publicImage;
  }


  @JsonProperty(JSON_PROPERTY_PUBLIC_IMAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublicImage(@jakarta.annotation.Nullable String publicImage) {
    this.publicImage = publicImage;
  }

  public MainReward publicName(@jakarta.annotation.Nullable String publicName) {
    
    this.publicName = publicName;
    return this;
  }

  /**
   * Public name for the reward
   * @return publicName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PUBLIC_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPublicName() {
    return publicName;
  }


  @JsonProperty(JSON_PROPERTY_PUBLIC_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPublicName(@jakarta.annotation.Nullable String publicName) {
    this.publicName = publicName;
  }

  public MainReward redeemPerConsumer(@jakarta.annotation.Nullable Integer redeemPerConsumer) {
    
    this.redeemPerConsumer = redeemPerConsumer;
    return this;
  }

  /**
   * Defines the redeem limit for the consumer
   * @return redeemPerConsumer
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REDEEM_PER_CONSUMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRedeemPerConsumer() {
    return redeemPerConsumer;
  }


  @JsonProperty(JSON_PROPERTY_REDEEM_PER_CONSUMER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedeemPerConsumer(@jakarta.annotation.Nullable Integer redeemPerConsumer) {
    this.redeemPerConsumer = redeemPerConsumer;
  }

  public MainReward redeemRules(@jakarta.annotation.Nullable List<String> redeemRules) {
    
    this.redeemRules = redeemRules;
    return this;
  }

  public MainReward addRedeemRulesItem(String redeemRulesItem) {
    if (this.redeemRules == null) {
      this.redeemRules = new ArrayList<>();
    }
    this.redeemRules.add(redeemRulesItem);
    return this;
  }

  /**
   * Rules defined to redeem a reward
   * @return redeemRules
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REDEEM_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getRedeemRules() {
    return redeemRules;
  }


  @JsonProperty(JSON_PROPERTY_REDEEM_RULES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedeemRules(@jakarta.annotation.Nullable List<String> redeemRules) {
    this.redeemRules = redeemRules;
  }

  public MainReward rewardConfigs(@jakarta.annotation.Nullable MainRewardConfigurations rewardConfigs) {
    
    this.rewardConfigs = rewardConfigs;
    return this;
  }

  /**
   * object
   * @return rewardConfigs
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REWARD_CONFIGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainRewardConfigurations getRewardConfigs() {
    return rewardConfigs;
  }


  @JsonProperty(JSON_PROPERTY_REWARD_CONFIGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRewardConfigs(@jakarta.annotation.Nullable MainRewardConfigurations rewardConfigs) {
    this.rewardConfigs = rewardConfigs;
  }

  public MainReward rule(@jakarta.annotation.Nullable MainRule rule) {
    
    this.rule = rule;
    return this;
  }

  /**
   * Rule to define the reward
   * @return rule
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainRule getRule() {
    return rule;
  }


  @JsonProperty(JSON_PROPERTY_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRule(@jakarta.annotation.Nullable MainRule rule) {
    this.rule = rule;
  }

  public MainReward startDate(@jakarta.annotation.Nullable OffsetDateTime startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Start date of attribution of the reward
   * @return startDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@jakarta.annotation.Nullable OffsetDateTime startDate) {
    this.startDate = startDate;
  }

  public MainReward subtractBalanceDefinitionId(@jakarta.annotation.Nullable String subtractBalanceDefinitionId) {
    
    this.subtractBalanceDefinitionId = subtractBalanceDefinitionId;
    return this;
  }

  /**
   * Id of the selected balance while redeeming / attributing a reward
   * @return subtractBalanceDefinitionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBTRACT_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubtractBalanceDefinitionId() {
    return subtractBalanceDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_SUBTRACT_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubtractBalanceDefinitionId(@jakarta.annotation.Nullable String subtractBalanceDefinitionId) {
    this.subtractBalanceDefinitionId = subtractBalanceDefinitionId;
  }

  public MainReward subtractBalanceStrategy(@jakarta.annotation.Nullable String subtractBalanceStrategy) {
    
    this.subtractBalanceStrategy = subtractBalanceStrategy;
    return this;
  }

  /**
   * Strategy of the Balance while redeeming / attributing a reward
   * @return subtractBalanceStrategy
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBTRACT_BALANCE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubtractBalanceStrategy() {
    return subtractBalanceStrategy;
  }


  @JsonProperty(JSON_PROPERTY_SUBTRACT_BALANCE_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubtractBalanceStrategy(@jakarta.annotation.Nullable String subtractBalanceStrategy) {
    this.subtractBalanceStrategy = subtractBalanceStrategy;
  }

  public MainReward subtractBalanceValue(@jakarta.annotation.Nullable Integer subtractBalanceValue) {
    
    this.subtractBalanceValue = subtractBalanceValue;
    return this;
  }

  /**
   * Amount of balance to be selected while redeeming / attributing a reward
   * @return subtractBalanceValue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBTRACT_BALANCE_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSubtractBalanceValue() {
    return subtractBalanceValue;
  }


  @JsonProperty(JSON_PROPERTY_SUBTRACT_BALANCE_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubtractBalanceValue(@jakarta.annotation.Nullable Integer subtractBalanceValue) {
    this.subtractBalanceValue = subtractBalanceValue;
  }

  public MainReward subtractTotalBalance(@jakarta.annotation.Nullable Boolean subtractTotalBalance) {
    
    this.subtractTotalBalance = subtractTotalBalance;
    return this;
  }

  /**
   * Value to indicate to subtract full balance or not
   * @return subtractTotalBalance
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBTRACT_TOTAL_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSubtractTotalBalance() {
    return subtractTotalBalance;
  }


  @JsonProperty(JSON_PROPERTY_SUBTRACT_TOTAL_BALANCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubtractTotalBalance(@jakarta.annotation.Nullable Boolean subtractTotalBalance) {
    this.subtractTotalBalance = subtractTotalBalance;
  }

  public MainReward totalAttribution(@jakarta.annotation.Nullable Integer totalAttribution) {
    
    this.totalAttribution = totalAttribution;
    return this;
  }

  /**
   * Defines the limit to which a consumer can attribute a reward
   * @return totalAttribution
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_ATTRIBUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalAttribution() {
    return totalAttribution;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_ATTRIBUTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalAttribution(@jakarta.annotation.Nullable Integer totalAttribution) {
    this.totalAttribution = totalAttribution;
  }

  public MainReward totalRedeem(@jakarta.annotation.Nullable Integer totalRedeem) {
    
    this.totalRedeem = totalRedeem;
    return this;
  }

  /**
   * Defines the limit to which a consumer can redeem a reward
   * @return totalRedeem
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOTAL_REDEEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTotalRedeem() {
    return totalRedeem;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_REDEEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalRedeem(@jakarta.annotation.Nullable Integer totalRedeem) {
    this.totalRedeem = totalRedeem;
  }

  public MainReward triggerId(@jakarta.annotation.Nullable String triggerId) {
    
    this.triggerId = triggerId;
    return this;
  }

  /**
   * Id of the Rule to be updated for that reward
   * @return triggerId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRIGGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTriggerId() {
    return triggerId;
  }


  @JsonProperty(JSON_PROPERTY_TRIGGER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTriggerId(@jakarta.annotation.Nullable String triggerId) {
    this.triggerId = triggerId;
  }

  public MainReward unit(@jakarta.annotation.Nullable String unit) {
    
    this.unit = unit;
    return this;
  }

  /**
   * Selected unit of the balance
   * @return unit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUnit() {
    return unit;
  }


  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnit(@jakarta.annotation.Nullable String unit) {
    this.unit = unit;
  }

  public MainReward updatedAt(@jakarta.annotation.Nullable String updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Timestamp for when this reward was last updated.
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(@jakarta.annotation.Nullable String updatedAt) {
    this.updatedAt = updatedAt;
  }

  public MainReward value(@jakarta.annotation.Nullable BigDecimal value) {
    
    this.value = value;
    return this;
  }

  /**
   * Value of metric in selected config for reward definition
   * @return value
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(@jakarta.annotation.Nullable BigDecimal value) {
    this.value = value;
  }

  public MainReward valueType(@jakarta.annotation.Nullable String valueType) {
    
    this.valueType = valueType;
    return this;
  }

  /**
   * Type of config selected for reward definition
   * @return valueType
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getValueType() {
    return valueType;
  }


  @JsonProperty(JSON_PROPERTY_VALUE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValueType(@jakarta.annotation.Nullable String valueType) {
    this.valueType = valueType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainReward mainReward = (MainReward) o;
    return Objects.equals(this.attributionPerConsumer, mainReward.attributionPerConsumer) &&
        Objects.equals(this.balanceDefinitionId, mainReward.balanceDefinitionId) &&
        Objects.equals(this.code, mainReward.code) &&
        Objects.equals(this.codeCount, mainReward.codeCount) &&
        Objects.equals(this.codeGeneratorId, mainReward.codeGeneratorId) &&
        Objects.equals(this.codePoolId, mainReward.codePoolId) &&
        Objects.equals(this.config, mainReward.config) &&
        Objects.equals(this.createdAt, mainReward.createdAt) &&
        Objects.equals(this.disabledAt, mainReward.disabledAt) &&
        Objects.equals(this.endDate, mainReward.endDate) &&
        Objects.equals(this.expirationDate, mainReward.expirationDate) &&
        Objects.equals(this.expirationModifier, mainReward.expirationModifier) &&
        Objects.equals(this.expirationUnit, mainReward.expirationUnit) &&
        Objects.equals(this.expirationValue, mainReward.expirationValue) &&
        Objects.equals(this.generator, mainReward.generator) &&
        Objects.equals(this.id, mainReward.id) &&
        Objects.equals(this.limits, mainReward.limits) &&
        Objects.equals(this.loyaltyProgramId, mainReward.loyaltyProgramId) &&
        Objects.equals(this.meta, mainReward.meta) &&
        Objects.equals(this.name, mainReward.name) &&
        Objects.equals(this.products, mainReward.products) &&
        Objects.equals(this.publicDescription, mainReward.publicDescription) &&
        Objects.equals(this.publicImage, mainReward.publicImage) &&
        Objects.equals(this.publicName, mainReward.publicName) &&
        Objects.equals(this.redeemPerConsumer, mainReward.redeemPerConsumer) &&
        Objects.equals(this.redeemRules, mainReward.redeemRules) &&
        Objects.equals(this.rewardConfigs, mainReward.rewardConfigs) &&
        Objects.equals(this.rule, mainReward.rule) &&
        Objects.equals(this.startDate, mainReward.startDate) &&
        Objects.equals(this.subtractBalanceDefinitionId, mainReward.subtractBalanceDefinitionId) &&
        Objects.equals(this.subtractBalanceStrategy, mainReward.subtractBalanceStrategy) &&
        Objects.equals(this.subtractBalanceValue, mainReward.subtractBalanceValue) &&
        Objects.equals(this.subtractTotalBalance, mainReward.subtractTotalBalance) &&
        Objects.equals(this.totalAttribution, mainReward.totalAttribution) &&
        Objects.equals(this.totalRedeem, mainReward.totalRedeem) &&
        Objects.equals(this.triggerId, mainReward.triggerId) &&
        Objects.equals(this.unit, mainReward.unit) &&
        Objects.equals(this.updatedAt, mainReward.updatedAt) &&
        Objects.equals(this.value, mainReward.value) &&
        Objects.equals(this.valueType, mainReward.valueType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributionPerConsumer, balanceDefinitionId, code, codeCount, codeGeneratorId, codePoolId, config, createdAt, disabledAt, endDate, expirationDate, expirationModifier, expirationUnit, expirationValue, generator, id, limits, loyaltyProgramId, meta, name, products, publicDescription, publicImage, publicName, redeemPerConsumer, redeemRules, rewardConfigs, rule, startDate, subtractBalanceDefinitionId, subtractBalanceStrategy, subtractBalanceValue, subtractTotalBalance, totalAttribution, totalRedeem, triggerId, unit, updatedAt, value, valueType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainReward {\n");
    sb.append("    attributionPerConsumer: ").append(toIndentedString(attributionPerConsumer)).append("\n");
    sb.append("    balanceDefinitionId: ").append(toIndentedString(balanceDefinitionId)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    codeCount: ").append(toIndentedString(codeCount)).append("\n");
    sb.append("    codeGeneratorId: ").append(toIndentedString(codeGeneratorId)).append("\n");
    sb.append("    codePoolId: ").append(toIndentedString(codePoolId)).append("\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    disabledAt: ").append(toIndentedString(disabledAt)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    expirationModifier: ").append(toIndentedString(expirationModifier)).append("\n");
    sb.append("    expirationUnit: ").append(toIndentedString(expirationUnit)).append("\n");
    sb.append("    expirationValue: ").append(toIndentedString(expirationValue)).append("\n");
    sb.append("    generator: ").append(toIndentedString(generator)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    limits: ").append(toIndentedString(limits)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    products: ").append(toIndentedString(products)).append("\n");
    sb.append("    publicDescription: ").append(toIndentedString(publicDescription)).append("\n");
    sb.append("    publicImage: ").append(toIndentedString(publicImage)).append("\n");
    sb.append("    publicName: ").append(toIndentedString(publicName)).append("\n");
    sb.append("    redeemPerConsumer: ").append(toIndentedString(redeemPerConsumer)).append("\n");
    sb.append("    redeemRules: ").append(toIndentedString(redeemRules)).append("\n");
    sb.append("    rewardConfigs: ").append(toIndentedString(rewardConfigs)).append("\n");
    sb.append("    rule: ").append(toIndentedString(rule)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    subtractBalanceDefinitionId: ").append(toIndentedString(subtractBalanceDefinitionId)).append("\n");
    sb.append("    subtractBalanceStrategy: ").append(toIndentedString(subtractBalanceStrategy)).append("\n");
    sb.append("    subtractBalanceValue: ").append(toIndentedString(subtractBalanceValue)).append("\n");
    sb.append("    subtractTotalBalance: ").append(toIndentedString(subtractTotalBalance)).append("\n");
    sb.append("    totalAttribution: ").append(toIndentedString(totalAttribution)).append("\n");
    sb.append("    totalRedeem: ").append(toIndentedString(totalRedeem)).append("\n");
    sb.append("    triggerId: ").append(toIndentedString(triggerId)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    valueType: ").append(toIndentedString(valueType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `attributionPerConsumer` to the URL query string
    if (getAttributionPerConsumer() != null) {
      try {
        joiner.add(String.format("%sattributionPerConsumer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttributionPerConsumer()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceDefinitionId` to the URL query string
    if (getBalanceDefinitionId() != null) {
      try {
        joiner.add(String.format("%sbalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `code` to the URL query string
    if (getCode() != null) {
      try {
        joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `codeCount` to the URL query string
    if (getCodeCount() != null) {
      try {
        joiner.add(String.format("%scodeCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCodeCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `codeGeneratorId` to the URL query string
    if (getCodeGeneratorId() != null) {
      try {
        joiner.add(String.format("%scodeGeneratorId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCodeGeneratorId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `codePoolId` to the URL query string
    if (getCodePoolId() != null) {
      try {
        joiner.add(String.format("%scodePoolId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCodePoolId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `config` to the URL query string
    if (getConfig() != null) {
      try {
        joiner.add(String.format("%sconfig%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getConfig()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `disabledAt` to the URL query string
    if (getDisabledAt() != null) {
      try {
        joiner.add(String.format("%sdisabledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDisabledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expirationDate` to the URL query string
    if (getExpirationDate() != null) {
      try {
        joiner.add(String.format("%sexpirationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpirationDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expirationModifier` to the URL query string
    if (getExpirationModifier() != null) {
      try {
        joiner.add(String.format("%sexpirationModifier%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpirationModifier()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expirationUnit` to the URL query string
    if (getExpirationUnit() != null) {
      try {
        joiner.add(String.format("%sexpirationUnit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpirationUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expirationValue` to the URL query string
    if (getExpirationValue() != null) {
      try {
        joiner.add(String.format("%sexpirationValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpirationValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `generator` to the URL query string
    if (getGenerator() != null) {
      joiner.add(getGenerator().toUrlQueryString(prefix + "generator" + suffix));
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `limits` to the URL query string
    if (getLimits() != null) {
      for (int i = 0; i < getLimits().size(); i++) {
        if (getLimits().get(i) != null) {
          joiner.add(getLimits().get(i).toUrlQueryString(String.format("%slimits%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `products` to the URL query string
    if (getProducts() != null) {
      for (int i = 0; i < getProducts().size(); i++) {
        if (getProducts().get(i) != null) {
          joiner.add(getProducts().get(i).toUrlQueryString(String.format("%sproducts%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `publicDescription` to the URL query string
    if (getPublicDescription() != null) {
      try {
        joiner.add(String.format("%spublicDescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPublicDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `publicImage` to the URL query string
    if (getPublicImage() != null) {
      try {
        joiner.add(String.format("%spublicImage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPublicImage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `publicName` to the URL query string
    if (getPublicName() != null) {
      try {
        joiner.add(String.format("%spublicName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPublicName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `redeemPerConsumer` to the URL query string
    if (getRedeemPerConsumer() != null) {
      try {
        joiner.add(String.format("%sredeemPerConsumer%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRedeemPerConsumer()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `redeemRules` to the URL query string
    if (getRedeemRules() != null) {
      for (int i = 0; i < getRedeemRules().size(); i++) {
        try {
          joiner.add(String.format("%sredeemRules%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getRedeemRules().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `rewardConfigs` to the URL query string
    if (getRewardConfigs() != null) {
      joiner.add(getRewardConfigs().toUrlQueryString(prefix + "rewardConfigs" + suffix));
    }

    // add `rule` to the URL query string
    if (getRule() != null) {
      joiner.add(getRule().toUrlQueryString(prefix + "rule" + suffix));
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subtractBalanceDefinitionId` to the URL query string
    if (getSubtractBalanceDefinitionId() != null) {
      try {
        joiner.add(String.format("%ssubtractBalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubtractBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subtractBalanceStrategy` to the URL query string
    if (getSubtractBalanceStrategy() != null) {
      try {
        joiner.add(String.format("%ssubtractBalanceStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubtractBalanceStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subtractBalanceValue` to the URL query string
    if (getSubtractBalanceValue() != null) {
      try {
        joiner.add(String.format("%ssubtractBalanceValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubtractBalanceValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subtractTotalBalance` to the URL query string
    if (getSubtractTotalBalance() != null) {
      try {
        joiner.add(String.format("%ssubtractTotalBalance%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubtractTotalBalance()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `totalAttribution` to the URL query string
    if (getTotalAttribution() != null) {
      try {
        joiner.add(String.format("%stotalAttribution%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTotalAttribution()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `totalRedeem` to the URL query string
    if (getTotalRedeem() != null) {
      try {
        joiner.add(String.format("%stotalRedeem%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTotalRedeem()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `triggerId` to the URL query string
    if (getTriggerId() != null) {
      try {
        joiner.add(String.format("%striggerId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTriggerId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unit` to the URL query string
    if (getUnit() != null) {
      try {
        joiner.add(String.format("%sunit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `value` to the URL query string
    if (getValue() != null) {
      try {
        joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `valueType` to the URL query string
    if (getValueType() != null) {
      try {
        joiner.add(String.format("%svalueType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValueType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

