/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MainRedeem
 */
@JsonPropertyOrder({
  MainRedeem.JSON_PROPERTY_CANCELLED_AT,
  MainRedeem.JSON_PROPERTY_COMPLETED_AT,
  MainRedeem.JSON_PROPERTY_CONTACT_ID,
  MainRedeem.JSON_PROPERTY_CREATED_AT,
  MainRedeem.JSON_PROPERTY_DEBIT_TRANSACTION_ID,
  MainRedeem.JSON_PROPERTY_EXPIRES_AT,
  MainRedeem.JSON_PROPERTY_ID,
  MainRedeem.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  MainRedeem.JSON_PROPERTY_META,
  MainRedeem.JSON_PROPERTY_REJECT_REASON,
  MainRedeem.JSON_PROPERTY_REJECTED_AT,
  MainRedeem.JSON_PROPERTY_REWARD_ATTRIBUTION_ID,
  MainRedeem.JSON_PROPERTY_STATUS,
  MainRedeem.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("main.redeem")
public class MainRedeem {
  public static final String JSON_PROPERTY_CANCELLED_AT = "cancelledAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime cancelledAt;

  public static final String JSON_PROPERTY_COMPLETED_AT = "completedAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime completedAt;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nullable
  private Long contactId;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DEBIT_TRANSACTION_ID = "debitTransactionId";
  @jakarta.annotation.Nullable
  private UUID debitTransactionId;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private UUID id;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private UUID loyaltyProgramId;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_REJECT_REASON = "rejectReason";
  @jakarta.annotation.Nullable
  private String rejectReason;

  public static final String JSON_PROPERTY_REJECTED_AT = "rejectedAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime rejectedAt;

  public static final String JSON_PROPERTY_REWARD_ATTRIBUTION_ID = "rewardAttributionId";
  @jakarta.annotation.Nullable
  private UUID rewardAttributionId;

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nullable
  private String status;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime updatedAt;

  public MainRedeem() {
  }

  public MainRedeem cancelledAt(@jakarta.annotation.Nullable OffsetDateTime cancelledAt) {
    
    this.cancelledAt = cancelledAt;
    return this;
  }

  /**
   * Timestamp when the redemption was cancelled
   * @return cancelledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANCELLED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCancelledAt() {
    return cancelledAt;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledAt(@jakarta.annotation.Nullable OffsetDateTime cancelledAt) {
    this.cancelledAt = cancelledAt;
  }

  public MainRedeem completedAt(@jakarta.annotation.Nullable OffsetDateTime completedAt) {
    
    this.completedAt = completedAt;
    return this;
  }

  /**
   * Timestamp when the redemption was completed
   * @return completedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPLETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCompletedAt() {
    return completedAt;
  }


  @JsonProperty(JSON_PROPERTY_COMPLETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompletedAt(@jakarta.annotation.Nullable OffsetDateTime completedAt) {
    this.completedAt = completedAt;
  }

  public MainRedeem contactId(@jakarta.annotation.Nullable Long contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Unique identifier for the contact
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Long contactId) {
    this.contactId = contactId;
  }

  public MainRedeem createdAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the redemption was created
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public MainRedeem debitTransactionId(@jakarta.annotation.Nullable UUID debitTransactionId) {
    
    this.debitTransactionId = debitTransactionId;
    return this;
  }

  /**
   * Unique identifier for the debit transaction
   * @return debitTransactionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEBIT_TRANSACTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getDebitTransactionId() {
    return debitTransactionId;
  }


  @JsonProperty(JSON_PROPERTY_DEBIT_TRANSACTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDebitTransactionId(@jakarta.annotation.Nullable UUID debitTransactionId) {
    this.debitTransactionId = debitTransactionId;
  }

  public MainRedeem expiresAt(@jakarta.annotation.Nullable OffsetDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * Timestamp when the redemption expires
   * @return expiresAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(@jakarta.annotation.Nullable OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }

  public MainRedeem id(@jakarta.annotation.Nullable UUID id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for the redemption
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable UUID id) {
    this.id = id;
  }

  public MainRedeem loyaltyProgramId(@jakarta.annotation.Nullable UUID loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Unique identifier for the loyalty program
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable UUID loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public MainRedeem meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public MainRedeem putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Additional metadata associated with the redemption
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public MainRedeem rejectReason(@jakarta.annotation.Nullable String rejectReason) {
    
    this.rejectReason = rejectReason;
    return this;
  }

  /**
   * Reason for rejection if the redemption was rejected
   * @return rejectReason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REJECT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRejectReason() {
    return rejectReason;
  }


  @JsonProperty(JSON_PROPERTY_REJECT_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRejectReason(@jakarta.annotation.Nullable String rejectReason) {
    this.rejectReason = rejectReason;
  }

  public MainRedeem rejectedAt(@jakarta.annotation.Nullable OffsetDateTime rejectedAt) {
    
    this.rejectedAt = rejectedAt;
    return this;
  }

  /**
   * Timestamp when the redemption was rejected
   * @return rejectedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REJECTED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getRejectedAt() {
    return rejectedAt;
  }


  @JsonProperty(JSON_PROPERTY_REJECTED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRejectedAt(@jakarta.annotation.Nullable OffsetDateTime rejectedAt) {
    this.rejectedAt = rejectedAt;
  }

  public MainRedeem rewardAttributionId(@jakarta.annotation.Nullable UUID rewardAttributionId) {
    
    this.rewardAttributionId = rewardAttributionId;
    return this;
  }

  /**
   * Unique identifier for the reward attribution
   * @return rewardAttributionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REWARD_ATTRIBUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getRewardAttributionId() {
    return rewardAttributionId;
  }


  @JsonProperty(JSON_PROPERTY_REWARD_ATTRIBUTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRewardAttributionId(@jakarta.annotation.Nullable UUID rewardAttributionId) {
    this.rewardAttributionId = rewardAttributionId;
  }

  public MainRedeem status(@jakarta.annotation.Nullable String status) {
    
    this.status = status;
    return this;
  }

  /**
   * Current status of the redemption
   * @return status
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(@jakarta.annotation.Nullable String status) {
    this.status = status;
  }

  public MainRedeem updatedAt(@jakarta.annotation.Nullable OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Timestamp when the redemption was last updated
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(@jakarta.annotation.Nullable OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainRedeem mainRedeem = (MainRedeem) o;
    return Objects.equals(this.cancelledAt, mainRedeem.cancelledAt) &&
        Objects.equals(this.completedAt, mainRedeem.completedAt) &&
        Objects.equals(this.contactId, mainRedeem.contactId) &&
        Objects.equals(this.createdAt, mainRedeem.createdAt) &&
        Objects.equals(this.debitTransactionId, mainRedeem.debitTransactionId) &&
        Objects.equals(this.expiresAt, mainRedeem.expiresAt) &&
        Objects.equals(this.id, mainRedeem.id) &&
        Objects.equals(this.loyaltyProgramId, mainRedeem.loyaltyProgramId) &&
        Objects.equals(this.meta, mainRedeem.meta) &&
        Objects.equals(this.rejectReason, mainRedeem.rejectReason) &&
        Objects.equals(this.rejectedAt, mainRedeem.rejectedAt) &&
        Objects.equals(this.rewardAttributionId, mainRedeem.rewardAttributionId) &&
        Objects.equals(this.status, mainRedeem.status) &&
        Objects.equals(this.updatedAt, mainRedeem.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cancelledAt, completedAt, contactId, createdAt, debitTransactionId, expiresAt, id, loyaltyProgramId, meta, rejectReason, rejectedAt, rewardAttributionId, status, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainRedeem {\n");
    sb.append("    cancelledAt: ").append(toIndentedString(cancelledAt)).append("\n");
    sb.append("    completedAt: ").append(toIndentedString(completedAt)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    debitTransactionId: ").append(toIndentedString(debitTransactionId)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    rejectReason: ").append(toIndentedString(rejectReason)).append("\n");
    sb.append("    rejectedAt: ").append(toIndentedString(rejectedAt)).append("\n");
    sb.append("    rewardAttributionId: ").append(toIndentedString(rewardAttributionId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `cancelledAt` to the URL query string
    if (getCancelledAt() != null) {
      try {
        joiner.add(String.format("%scancelledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCancelledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `completedAt` to the URL query string
    if (getCompletedAt() != null) {
      try {
        joiner.add(String.format("%scompletedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCompletedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `debitTransactionId` to the URL query string
    if (getDebitTransactionId() != null) {
      try {
        joiner.add(String.format("%sdebitTransactionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDebitTransactionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expiresAt` to the URL query string
    if (getExpiresAt() != null) {
      try {
        joiner.add(String.format("%sexpiresAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpiresAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `rejectReason` to the URL query string
    if (getRejectReason() != null) {
      try {
        joiner.add(String.format("%srejectReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRejectReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rejectedAt` to the URL query string
    if (getRejectedAt() != null) {
      try {
        joiner.add(String.format("%srejectedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRejectedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rewardAttributionId` to the URL query string
    if (getRewardAttributionId() != null) {
      try {
        joiner.add(String.format("%srewardAttributionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRewardAttributionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      try {
        joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

