/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.MainBillingPayload;
import software.xdev.brevo.model.MainIdentifiersPayload;
import software.xdev.brevo.model.MainProductPayload;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MainOrderPayload
 */
@JsonPropertyOrder({
  MainOrderPayload.JSON_PROPERTY_AMOUNT,
  MainOrderPayload.JSON_PROPERTY_BILLING,
  MainOrderPayload.JSON_PROPERTY_CONTACT_ID,
  MainOrderPayload.JSON_PROPERTY_COUPONS,
  MainOrderPayload.JSON_PROPERTY_CREATED_AT,
  MainOrderPayload.JSON_PROPERTY_EMAIL,
  MainOrderPayload.JSON_PROPERTY_ID,
  MainOrderPayload.JSON_PROPERTY_IDENTIFIERS,
  MainOrderPayload.JSON_PROPERTY_PRODUCTS,
  MainOrderPayload.JSON_PROPERTY_STATUS,
  MainOrderPayload.JSON_PROPERTY_STORE_ID,
  MainOrderPayload.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("main.orderPayload")
public class MainOrderPayload {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nullable
  private BigDecimal amount;

  public static final String JSON_PROPERTY_BILLING = "billing";
  @jakarta.annotation.Nullable
  private MainBillingPayload billing;

  public static final String JSON_PROPERTY_CONTACT_ID = "contact_id";
  @jakarta.annotation.Nullable
  private Long contactId;

  public static final String JSON_PROPERTY_COUPONS = "coupons";
  @jakarta.annotation.Nullable
  private List<String> coupons = new ArrayList<>();

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_EMAIL = "email";
  @jakarta.annotation.Nullable
  private String email;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
  @jakarta.annotation.Nullable
  private MainIdentifiersPayload identifiers;

  public static final String JSON_PROPERTY_PRODUCTS = "products";
  @jakarta.annotation.Nullable
  private List<MainProductPayload> products = new ArrayList<>();

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nullable
  private String status;

  public static final String JSON_PROPERTY_STORE_ID = "storeId";
  @jakarta.annotation.Nullable
  private String storeId;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime updatedAt;

  public MainOrderPayload() {
  }

  public MainOrderPayload amount(@jakarta.annotation.Nullable BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Total amount of the order
   * @return amount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(@jakarta.annotation.Nullable BigDecimal amount) {
    this.amount = amount;
  }

  public MainOrderPayload billing(@jakarta.annotation.Nullable MainBillingPayload billing) {
    
    this.billing = billing;
    return this;
  }

  /**
   * Billing information for the order
   * @return billing
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainBillingPayload getBilling() {
    return billing;
  }


  @JsonProperty(JSON_PROPERTY_BILLING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBilling(@jakarta.annotation.Nullable MainBillingPayload billing) {
    this.billing = billing;
  }

  public MainOrderPayload contactId(@jakarta.annotation.Nullable Long contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Unique identifier for the contact
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Long contactId) {
    this.contactId = contactId;
  }

  public MainOrderPayload coupons(@jakarta.annotation.Nullable List<String> coupons) {
    
    this.coupons = coupons;
    return this;
  }

  public MainOrderPayload addCouponsItem(String couponsItem) {
    if (this.coupons == null) {
      this.coupons = new ArrayList<>();
    }
    this.coupons.add(couponsItem);
    return this;
  }

  /**
   * List of coupon codes applied to the order
   * @return coupons
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUPONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCoupons() {
    return coupons;
  }


  @JsonProperty(JSON_PROPERTY_COUPONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCoupons(@jakarta.annotation.Nullable List<String> coupons) {
    this.coupons = coupons;
  }

  public MainOrderPayload createdAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp when the order was created
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public MainOrderPayload email(@jakarta.annotation.Nullable String email) {
    
    this.email = email;
    return this;
  }

  /**
   * Email address associated with the order
   * @return email
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(@jakarta.annotation.Nullable String email) {
    this.email = email;
  }

  public MainOrderPayload id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for the order
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public MainOrderPayload identifiers(@jakarta.annotation.Nullable MainIdentifiersPayload identifiers) {
    
    this.identifiers = identifiers;
    return this;
  }

  /**
   * Additional identifiers for the order
   * @return identifiers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainIdentifiersPayload getIdentifiers() {
    return identifiers;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifiers(@jakarta.annotation.Nullable MainIdentifiersPayload identifiers) {
    this.identifiers = identifiers;
  }

  public MainOrderPayload products(@jakarta.annotation.Nullable List<MainProductPayload> products) {
    
    this.products = products;
    return this;
  }

  public MainOrderPayload addProductsItem(MainProductPayload productsItem) {
    if (this.products == null) {
      this.products = new ArrayList<>();
    }
    this.products.add(productsItem);
    return this;
  }

  /**
   * List of products in the order
   * @return products
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MainProductPayload> getProducts() {
    return products;
  }


  @JsonProperty(JSON_PROPERTY_PRODUCTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProducts(@jakarta.annotation.Nullable List<MainProductPayload> products) {
    this.products = products;
  }

  public MainOrderPayload status(@jakarta.annotation.Nullable String status) {
    
    this.status = status;
    return this;
  }

  /**
   * Current status of the order
   * @return status
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatus(@jakarta.annotation.Nullable String status) {
    this.status = status;
  }

  public MainOrderPayload storeId(@jakarta.annotation.Nullable String storeId) {
    
    this.storeId = storeId;
    return this;
  }

  /**
   * Identifier for the store where the order was placed
   * @return storeId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getStoreId() {
    return storeId;
  }


  @JsonProperty(JSON_PROPERTY_STORE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStoreId(@jakarta.annotation.Nullable String storeId) {
    this.storeId = storeId;
  }

  public MainOrderPayload updatedAt(@jakarta.annotation.Nullable OffsetDateTime updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Timestamp when the order was last updated
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(@jakarta.annotation.Nullable OffsetDateTime updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainOrderPayload mainOrderPayload = (MainOrderPayload) o;
    return Objects.equals(this.amount, mainOrderPayload.amount) &&
        Objects.equals(this.billing, mainOrderPayload.billing) &&
        Objects.equals(this.contactId, mainOrderPayload.contactId) &&
        Objects.equals(this.coupons, mainOrderPayload.coupons) &&
        Objects.equals(this.createdAt, mainOrderPayload.createdAt) &&
        Objects.equals(this.email, mainOrderPayload.email) &&
        Objects.equals(this.id, mainOrderPayload.id) &&
        Objects.equals(this.identifiers, mainOrderPayload.identifiers) &&
        Objects.equals(this.products, mainOrderPayload.products) &&
        Objects.equals(this.status, mainOrderPayload.status) &&
        Objects.equals(this.storeId, mainOrderPayload.storeId) &&
        Objects.equals(this.updatedAt, mainOrderPayload.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, billing, contactId, coupons, createdAt, email, id, identifiers, products, status, storeId, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainOrderPayload {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    billing: ").append(toIndentedString(billing)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    coupons: ").append(toIndentedString(coupons)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    identifiers: ").append(toIndentedString(identifiers)).append("\n");
    sb.append("    products: ").append(toIndentedString(products)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    storeId: ").append(toIndentedString(storeId)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `amount` to the URL query string
    if (getAmount() != null) {
      try {
        joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `billing` to the URL query string
    if (getBilling() != null) {
      joiner.add(getBilling().toUrlQueryString(prefix + "billing" + suffix));
    }

    // add `contact_id` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontact_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `coupons` to the URL query string
    if (getCoupons() != null) {
      for (int i = 0; i < getCoupons().size(); i++) {
        try {
          joiner.add(String.format("%scoupons%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCoupons().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `email` to the URL query string
    if (getEmail() != null) {
      try {
        joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmail()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `identifiers` to the URL query string
    if (getIdentifiers() != null) {
      joiner.add(getIdentifiers().toUrlQueryString(prefix + "identifiers" + suffix));
    }

    // add `products` to the URL query string
    if (getProducts() != null) {
      for (int i = 0; i < getProducts().size(); i++) {
        if (getProducts().get(i) != null) {
          joiner.add(getProducts().get(i).toUrlQueryString(String.format("%sproducts%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      try {
        joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `storeId` to the URL query string
    if (getStoreId() != null) {
      try {
        joiner.add(String.format("%sstoreId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStoreId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

