/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.MainModelContactReward;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MainModelContactRewardsResp
 */
@JsonPropertyOrder({
  MainModelContactRewardsResp.JSON_PROPERTY_CONTACT_ID,
  MainModelContactRewardsResp.JSON_PROPERTY_CONTACT_REWARDS,
  MainModelContactRewardsResp.JSON_PROPERTY_COUNT,
  MainModelContactRewardsResp.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  MainModelContactRewardsResp.JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID
})
@JsonTypeName("main.modelContactRewardsResp")
public class MainModelContactRewardsResp {
  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nullable
  private Long contactId;

  public static final String JSON_PROPERTY_CONTACT_REWARDS = "contactRewards";
  @jakarta.annotation.Nullable
  private List<MainModelContactReward> contactRewards = new ArrayList<>();

  public static final String JSON_PROPERTY_COUNT = "count";
  @jakarta.annotation.Nullable
  private Integer count;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private String loyaltyProgramId;

  public static final String JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID = "loyaltySubscriptionId";
  @jakarta.annotation.Nullable
  private String loyaltySubscriptionId;

  public MainModelContactRewardsResp() {
  }

  public MainModelContactRewardsResp contactId(@jakarta.annotation.Nullable Long contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Contact id associated with the current reward
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Long contactId) {
    this.contactId = contactId;
  }

  public MainModelContactRewardsResp contactRewards(@jakarta.annotation.Nullable List<MainModelContactReward> contactRewards) {
    
    this.contactRewards = contactRewards;
    return this;
  }

  public MainModelContactRewardsResp addContactRewardsItem(MainModelContactReward contactRewardsItem) {
    if (this.contactRewards == null) {
      this.contactRewards = new ArrayList<>();
    }
    this.contactRewards.add(contactRewardsItem);
    return this;
  }

  /**
   * List of all the rewards for current contact
   * @return contactRewards
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_REWARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<MainModelContactReward> getContactRewards() {
    return contactRewards;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_REWARDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactRewards(@jakarta.annotation.Nullable List<MainModelContactReward> contactRewards) {
    this.contactRewards = contactRewards;
  }

  public MainModelContactRewardsResp count(@jakarta.annotation.Nullable Integer count) {
    
    this.count = count;
    return this;
  }

  /**
   * Count of the rewards associated with the current contact
   * @return count
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getCount() {
    return count;
  }


  @JsonProperty(JSON_PROPERTY_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCount(@jakarta.annotation.Nullable Integer count) {
    this.count = count;
  }

  public MainModelContactRewardsResp loyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Loyalty Program Id for the contact
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public MainModelContactRewardsResp loyaltySubscriptionId(@jakarta.annotation.Nullable String loyaltySubscriptionId) {
    
    this.loyaltySubscriptionId = loyaltySubscriptionId;
    return this;
  }

  /**
   * Loyalty Subscription Id for the contact
   * @return loyaltySubscriptionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltySubscriptionId() {
    return loyaltySubscriptionId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltySubscriptionId(@jakarta.annotation.Nullable String loyaltySubscriptionId) {
    this.loyaltySubscriptionId = loyaltySubscriptionId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainModelContactRewardsResp mainModelContactRewardsResp = (MainModelContactRewardsResp) o;
    return Objects.equals(this.contactId, mainModelContactRewardsResp.contactId) &&
        Objects.equals(this.contactRewards, mainModelContactRewardsResp.contactRewards) &&
        Objects.equals(this.count, mainModelContactRewardsResp.count) &&
        Objects.equals(this.loyaltyProgramId, mainModelContactRewardsResp.loyaltyProgramId) &&
        Objects.equals(this.loyaltySubscriptionId, mainModelContactRewardsResp.loyaltySubscriptionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contactId, contactRewards, count, loyaltyProgramId, loyaltySubscriptionId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainModelContactRewardsResp {\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    contactRewards: ").append(toIndentedString(contactRewards)).append("\n");
    sb.append("    count: ").append(toIndentedString(count)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    loyaltySubscriptionId: ").append(toIndentedString(loyaltySubscriptionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactRewards` to the URL query string
    if (getContactRewards() != null) {
      for (int i = 0; i < getContactRewards().size(); i++) {
        if (getContactRewards().get(i) != null) {
          joiner.add(getContactRewards().get(i).toUrlQueryString(String.format("%scontactRewards%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `count` to the URL query string
    if (getCount() != null) {
      try {
        joiner.add(String.format("%scount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltySubscriptionId` to the URL query string
    if (getLoyaltySubscriptionId() != null) {
      try {
        joiner.add(String.format("%sloyaltySubscriptionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltySubscriptionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

