/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import software.xdev.brevo.model.MainOrderPayload;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * MainCreateRedeemPayload
 */
@JsonPropertyOrder({
  MainCreateRedeemPayload.JSON_PROPERTY_ATTRIBUTED_REWARD_ID,
  MainCreateRedeemPayload.JSON_PROPERTY_CODE,
  MainCreateRedeemPayload.JSON_PROPERTY_CONTACT_ID,
  MainCreateRedeemPayload.JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID,
  MainCreateRedeemPayload.JSON_PROPERTY_META,
  MainCreateRedeemPayload.JSON_PROPERTY_ORDER,
  MainCreateRedeemPayload.JSON_PROPERTY_REWARD_ID,
  MainCreateRedeemPayload.JSON_PROPERTY_TTL
})
@JsonTypeName("main.createRedeemPayload")
public class MainCreateRedeemPayload {
  public static final String JSON_PROPERTY_ATTRIBUTED_REWARD_ID = "attributedRewardId";
  @jakarta.annotation.Nullable
  private UUID attributedRewardId;

  public static final String JSON_PROPERTY_CODE = "code";
  @jakarta.annotation.Nullable
  private String code;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nullable
  private Long contactId;

  public static final String JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID = "loyaltySubscriptionId";
  @jakarta.annotation.Nullable
  private String loyaltySubscriptionId;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_ORDER = "order";
  @jakarta.annotation.Nullable
  private MainOrderPayload order;

  public static final String JSON_PROPERTY_REWARD_ID = "rewardId";
  @jakarta.annotation.Nullable
  private UUID rewardId;

  public static final String JSON_PROPERTY_TTL = "ttl";
  @jakarta.annotation.Nullable
  private Integer ttl;

  public MainCreateRedeemPayload() {
  }

  public MainCreateRedeemPayload attributedRewardId(@jakarta.annotation.Nullable UUID attributedRewardId) {
    
    this.attributedRewardId = attributedRewardId;
    return this;
  }

  /**
   * Unique identifier for the attributed reward
   * @return attributedRewardId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTED_REWARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getAttributedRewardId() {
    return attributedRewardId;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTED_REWARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributedRewardId(@jakarta.annotation.Nullable UUID attributedRewardId) {
    this.attributedRewardId = attributedRewardId;
  }

  public MainCreateRedeemPayload code(@jakarta.annotation.Nullable String code) {
    
    this.code = code;
    return this;
  }

  /**
   * Redemption code for the reward
   * @return code
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(@jakarta.annotation.Nullable String code) {
    this.code = code;
  }

  public MainCreateRedeemPayload contactId(@jakarta.annotation.Nullable Long contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Unique identifier for the contact
   * minimum: 1
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Long contactId) {
    this.contactId = contactId;
  }

  public MainCreateRedeemPayload loyaltySubscriptionId(@jakarta.annotation.Nullable String loyaltySubscriptionId) {
    
    this.loyaltySubscriptionId = loyaltySubscriptionId;
    return this;
  }

  /**
   * Identifier for the loyalty subscription
   * @return loyaltySubscriptionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltySubscriptionId() {
    return loyaltySubscriptionId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_SUBSCRIPTION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltySubscriptionId(@jakarta.annotation.Nullable String loyaltySubscriptionId) {
    this.loyaltySubscriptionId = loyaltySubscriptionId;
  }

  public MainCreateRedeemPayload meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public MainCreateRedeemPayload putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Additional metadata associated with the redeem request
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public MainCreateRedeemPayload order(@jakarta.annotation.Nullable MainOrderPayload order) {
    
    this.order = order;
    return this;
  }

  /**
   * Order details for the redemption
   * @return order
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MainOrderPayload getOrder() {
    return order;
  }


  @JsonProperty(JSON_PROPERTY_ORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrder(@jakarta.annotation.Nullable MainOrderPayload order) {
    this.order = order;
  }

  public MainCreateRedeemPayload rewardId(@jakarta.annotation.Nullable UUID rewardId) {
    
    this.rewardId = rewardId;
    return this;
  }

  /**
   * Unique identifier for the reward
   * @return rewardId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REWARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getRewardId() {
    return rewardId;
  }


  @JsonProperty(JSON_PROPERTY_REWARD_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRewardId(@jakarta.annotation.Nullable UUID rewardId) {
    this.rewardId = rewardId;
  }

  public MainCreateRedeemPayload ttl(@jakarta.annotation.Nullable Integer ttl) {
    
    this.ttl = ttl;
    return this;
  }

  /**
   * Time to live in seconds for the redemption request
   * minimum: 0
   * @return ttl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TTL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getTtl() {
    return ttl;
  }


  @JsonProperty(JSON_PROPERTY_TTL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTtl(@jakarta.annotation.Nullable Integer ttl) {
    this.ttl = ttl;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MainCreateRedeemPayload mainCreateRedeemPayload = (MainCreateRedeemPayload) o;
    return Objects.equals(this.attributedRewardId, mainCreateRedeemPayload.attributedRewardId) &&
        Objects.equals(this.code, mainCreateRedeemPayload.code) &&
        Objects.equals(this.contactId, mainCreateRedeemPayload.contactId) &&
        Objects.equals(this.loyaltySubscriptionId, mainCreateRedeemPayload.loyaltySubscriptionId) &&
        Objects.equals(this.meta, mainCreateRedeemPayload.meta) &&
        Objects.equals(this.order, mainCreateRedeemPayload.order) &&
        Objects.equals(this.rewardId, mainCreateRedeemPayload.rewardId) &&
        Objects.equals(this.ttl, mainCreateRedeemPayload.ttl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attributedRewardId, code, contactId, loyaltySubscriptionId, meta, order, rewardId, ttl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MainCreateRedeemPayload {\n");
    sb.append("    attributedRewardId: ").append(toIndentedString(attributedRewardId)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    loyaltySubscriptionId: ").append(toIndentedString(loyaltySubscriptionId)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    rewardId: ").append(toIndentedString(rewardId)).append("\n");
    sb.append("    ttl: ").append(toIndentedString(ttl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `attributedRewardId` to the URL query string
    if (getAttributedRewardId() != null) {
      try {
        joiner.add(String.format("%sattributedRewardId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttributedRewardId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `code` to the URL query string
    if (getCode() != null) {
      try {
        joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltySubscriptionId` to the URL query string
    if (getLoyaltySubscriptionId() != null) {
      try {
        joiner.add(String.format("%sloyaltySubscriptionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltySubscriptionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `order` to the URL query string
    if (getOrder() != null) {
      joiner.add(getOrder().toUrlQueryString(prefix + "order" + suffix));
    }

    // add `rewardId` to the URL query string
    if (getRewardId() != null) {
      try {
        joiner.add(String.format("%srewardId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRewardId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ttl` to the URL query string
    if (getTtl() != null) {
      try {
        joiner.add(String.format("%sttl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTtl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

