/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import software.xdev.brevo.model.WhatsappCampStats;
import software.xdev.brevo.model.WhatsappCampTemplate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetWhatsappCampaignOverview
 */
@JsonPropertyOrder({
  GetWhatsappCampaignOverview.JSON_PROPERTY_ID,
  GetWhatsappCampaignOverview.JSON_PROPERTY_CAMPAIGN_NAME,
  GetWhatsappCampaignOverview.JSON_PROPERTY_CAMPAIGN_STATUS,
  GetWhatsappCampaignOverview.JSON_PROPERTY_SCHEDULED_AT,
  GetWhatsappCampaignOverview.JSON_PROPERTY_SENDER_NUMBER,
  GetWhatsappCampaignOverview.JSON_PROPERTY_STATS,
  GetWhatsappCampaignOverview.JSON_PROPERTY_TEMPLATE,
  GetWhatsappCampaignOverview.JSON_PROPERTY_CREATED_AT,
  GetWhatsappCampaignOverview.JSON_PROPERTY_MODIFIED_AT
})
@JsonTypeName("getWhatsappCampaignOverview")
public class GetWhatsappCampaignOverview {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private Long id;

  public static final String JSON_PROPERTY_CAMPAIGN_NAME = "campaignName";
  @jakarta.annotation.Nonnull
  private String campaignName;

  /**
   * Status of the WhatsApp Campaign
   */
  public enum CampaignStatusEnum {
    DRAFT(String.valueOf("draft")),
    
    SCHEDULED(String.valueOf("scheduled")),
    
    PENDING(String.valueOf("pending")),
    
    APPROVED(String.valueOf("approved")),
    
    RUNNING(String.valueOf("running")),
    
    SUSPENDED(String.valueOf("suspended")),
    
    REJECTED(String.valueOf("rejected")),
    
    SENT(String.valueOf("sent"));

    private String value;

    CampaignStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CampaignStatusEnum fromValue(String value) {
      for (CampaignStatusEnum b : CampaignStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CAMPAIGN_STATUS = "campaignStatus";
  @jakarta.annotation.Nonnull
  private CampaignStatusEnum campaignStatus;

  public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
  @jakarta.annotation.Nullable
  private String scheduledAt;

  public static final String JSON_PROPERTY_SENDER_NUMBER = "senderNumber";
  @jakarta.annotation.Nonnull
  private String senderNumber;

  public static final String JSON_PROPERTY_STATS = "stats";
  @jakarta.annotation.Nullable
  private WhatsappCampStats stats;

  public static final String JSON_PROPERTY_TEMPLATE = "template";
  @jakarta.annotation.Nonnull
  private WhatsappCampTemplate template;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nonnull
  private String createdAt;

  public static final String JSON_PROPERTY_MODIFIED_AT = "modifiedAt";
  @jakarta.annotation.Nonnull
  private String modifiedAt;

  public GetWhatsappCampaignOverview() {
  }

  public GetWhatsappCampaignOverview id(@jakarta.annotation.Nonnull Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * ID of the WhatsApp Campaign
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull Long id) {
    this.id = id;
  }

  public GetWhatsappCampaignOverview campaignName(@jakarta.annotation.Nonnull String campaignName) {
    
    this.campaignName = campaignName;
    return this;
  }

  /**
   * Name of the WhatsApp Campaign
   * @return campaignName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCampaignName() {
    return campaignName;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCampaignName(@jakarta.annotation.Nonnull String campaignName) {
    this.campaignName = campaignName;
  }

  public GetWhatsappCampaignOverview campaignStatus(@jakarta.annotation.Nonnull CampaignStatusEnum campaignStatus) {
    
    this.campaignStatus = campaignStatus;
    return this;
  }

  /**
   * Status of the WhatsApp Campaign
   * @return campaignStatus
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CAMPAIGN_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CampaignStatusEnum getCampaignStatus() {
    return campaignStatus;
  }


  @JsonProperty(JSON_PROPERTY_CAMPAIGN_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCampaignStatus(@jakarta.annotation.Nonnull CampaignStatusEnum campaignStatus) {
    this.campaignStatus = campaignStatus;
  }

  public GetWhatsappCampaignOverview scheduledAt(@jakarta.annotation.Nullable String scheduledAt) {
    
    this.scheduledAt = scheduledAt;
    return this;
  }

  /**
   * UTC date-time on which WhatsApp campaign is scheduled. Should be in YYYY-MM-DDTHH:mm:ss.SSSZ format
   * @return scheduledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScheduledAt() {
    return scheduledAt;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledAt(@jakarta.annotation.Nullable String scheduledAt) {
    this.scheduledAt = scheduledAt;
  }

  public GetWhatsappCampaignOverview senderNumber(@jakarta.annotation.Nonnull String senderNumber) {
    
    this.senderNumber = senderNumber;
    return this;
  }

  /**
   * Sender of the WhatsApp Campaign
   * @return senderNumber
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SENDER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSenderNumber() {
    return senderNumber;
  }


  @JsonProperty(JSON_PROPERTY_SENDER_NUMBER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSenderNumber(@jakarta.annotation.Nonnull String senderNumber) {
    this.senderNumber = senderNumber;
  }

  public GetWhatsappCampaignOverview stats(@jakarta.annotation.Nullable WhatsappCampStats stats) {
    
    this.stats = stats;
    return this;
  }

  /**
   * Get stats
   * @return stats
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WhatsappCampStats getStats() {
    return stats;
  }


  @JsonProperty(JSON_PROPERTY_STATS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStats(@jakarta.annotation.Nullable WhatsappCampStats stats) {
    this.stats = stats;
  }

  public GetWhatsappCampaignOverview template(@jakarta.annotation.Nonnull WhatsappCampTemplate template) {
    
    this.template = template;
    return this;
  }

  /**
   * Get template
   * @return template
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public WhatsappCampTemplate getTemplate() {
    return template;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTemplate(@jakarta.annotation.Nonnull WhatsappCampTemplate template) {
    this.template = template;
  }

  public GetWhatsappCampaignOverview createdAt(@jakarta.annotation.Nonnull String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Creation UTC date-time of the WhatsApp campaign (YYYY-MM-DDTHH:mm:ss.SSSZ)
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(@jakarta.annotation.Nonnull String createdAt) {
    this.createdAt = createdAt;
  }

  public GetWhatsappCampaignOverview modifiedAt(@jakarta.annotation.Nonnull String modifiedAt) {
    
    this.modifiedAt = modifiedAt;
    return this;
  }

  /**
   * UTC date-time of last modification of the WhatsApp campaign (YYYY-MM-DDTHH:mm:ss.SSSZ)
   * @return modifiedAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getModifiedAt() {
    return modifiedAt;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifiedAt(@jakarta.annotation.Nonnull String modifiedAt) {
    this.modifiedAt = modifiedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetWhatsappCampaignOverview getWhatsappCampaignOverview = (GetWhatsappCampaignOverview) o;
    return Objects.equals(this.id, getWhatsappCampaignOverview.id) &&
        Objects.equals(this.campaignName, getWhatsappCampaignOverview.campaignName) &&
        Objects.equals(this.campaignStatus, getWhatsappCampaignOverview.campaignStatus) &&
        Objects.equals(this.scheduledAt, getWhatsappCampaignOverview.scheduledAt) &&
        Objects.equals(this.senderNumber, getWhatsappCampaignOverview.senderNumber) &&
        Objects.equals(this.stats, getWhatsappCampaignOverview.stats) &&
        Objects.equals(this.template, getWhatsappCampaignOverview.template) &&
        Objects.equals(this.createdAt, getWhatsappCampaignOverview.createdAt) &&
        Objects.equals(this.modifiedAt, getWhatsappCampaignOverview.modifiedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, campaignName, campaignStatus, scheduledAt, senderNumber, stats, template, createdAt, modifiedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetWhatsappCampaignOverview {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    campaignName: ").append(toIndentedString(campaignName)).append("\n");
    sb.append("    campaignStatus: ").append(toIndentedString(campaignStatus)).append("\n");
    sb.append("    scheduledAt: ").append(toIndentedString(scheduledAt)).append("\n");
    sb.append("    senderNumber: ").append(toIndentedString(senderNumber)).append("\n");
    sb.append("    stats: ").append(toIndentedString(stats)).append("\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    modifiedAt: ").append(toIndentedString(modifiedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `campaignName` to the URL query string
    if (getCampaignName() != null) {
      try {
        joiner.add(String.format("%scampaignName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCampaignName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `campaignStatus` to the URL query string
    if (getCampaignStatus() != null) {
      try {
        joiner.add(String.format("%scampaignStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCampaignStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `scheduledAt` to the URL query string
    if (getScheduledAt() != null) {
      try {
        joiner.add(String.format("%sscheduledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getScheduledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `senderNumber` to the URL query string
    if (getSenderNumber() != null) {
      try {
        joiner.add(String.format("%ssenderNumber%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSenderNumber()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `stats` to the URL query string
    if (getStats() != null) {
      joiner.add(getStats().toUrlQueryString(prefix + "stats" + suffix));
    }

    // add `template` to the URL query string
    if (getTemplate() != null) {
      joiner.add(getTemplate().toUrlQueryString(prefix + "template" + suffix));
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `modifiedAt` to the URL query string
    if (getModifiedAt() != null) {
      try {
        joiner.add(String.format("%smodifiedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getModifiedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

