/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetWhatsAppConfig
 */
@JsonPropertyOrder({
  GetWhatsAppConfig.JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_ID,
  GetWhatsAppConfig.JSON_PROPERTY_SENDING_LIMIT,
  GetWhatsAppConfig.JSON_PROPERTY_PHONE_NUMBER_QUALITY,
  GetWhatsAppConfig.JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_STATUS,
  GetWhatsAppConfig.JSON_PROPERTY_BUSINESS_STATUS,
  GetWhatsAppConfig.JSON_PROPERTY_PHONE_NUMBER_NAME_STATUS
})
@JsonTypeName("getWhatsAppConfig")
public class GetWhatsAppConfig {
  public static final String JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_ID = "whatsappBusinessAccountId";
  @jakarta.annotation.Nullable
  private String whatsappBusinessAccountId;

  public static final String JSON_PROPERTY_SENDING_LIMIT = "sendingLimit";
  @jakarta.annotation.Nullable
  private String sendingLimit;

  /**
   * Quality status of phone number associated with WhatsApp account. There are three quality ratings. example - **High (GREEN) , Medium (YELLOW) and Low(RED)**
   */
  public enum PhoneNumberQualityEnum {
    GREEN(String.valueOf("GREEN")),
    
    YELLOW(String.valueOf("YELLOW")),
    
    RED(String.valueOf("RED"));

    private String value;

    PhoneNumberQualityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PhoneNumberQualityEnum fromValue(String value) {
      for (PhoneNumberQualityEnum b : PhoneNumberQualityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PHONE_NUMBER_QUALITY = "phoneNumberQuality";
  @jakarta.annotation.Nullable
  private PhoneNumberQualityEnum phoneNumberQuality;

  /**
   * Status information related to WhatsApp API account
   */
  public enum WhatsappBusinessAccountStatusEnum {
    APPROVED(String.valueOf("APPROVED")),
    
    PENDING(String.valueOf("PENDING")),
    
    REJECTED(String.valueOf("REJECTED"));

    private String value;

    WhatsappBusinessAccountStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WhatsappBusinessAccountStatusEnum fromValue(String value) {
      for (WhatsappBusinessAccountStatusEnum b : WhatsappBusinessAccountStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_STATUS = "whatsappBusinessAccountStatus";
  @jakarta.annotation.Nullable
  private WhatsappBusinessAccountStatusEnum whatsappBusinessAccountStatus;

  public static final String JSON_PROPERTY_BUSINESS_STATUS = "businessStatus";
  @jakarta.annotation.Nullable
  private String businessStatus;

  /**
   * Status of the name associated with WhatsApp Phone number
   */
  public enum PhoneNumberNameStatusEnum {
    APPROVED(String.valueOf("APPROVED")),
    
    PENDING(String.valueOf("PENDING")),
    
    REJECTED(String.valueOf("REJECTED"));

    private String value;

    PhoneNumberNameStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PhoneNumberNameStatusEnum fromValue(String value) {
      for (PhoneNumberNameStatusEnum b : PhoneNumberNameStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PHONE_NUMBER_NAME_STATUS = "phoneNumberNameStatus";
  @jakarta.annotation.Nullable
  private PhoneNumberNameStatusEnum phoneNumberNameStatus;

  public GetWhatsAppConfig() {
  }

  public GetWhatsAppConfig whatsappBusinessAccountId(@jakarta.annotation.Nullable String whatsappBusinessAccountId) {
    
    this.whatsappBusinessAccountId = whatsappBusinessAccountId;
    return this;
  }

  /**
   * Id of the WhatsApp business account
   * @return whatsappBusinessAccountId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhatsappBusinessAccountId() {
    return whatsappBusinessAccountId;
  }


  @JsonProperty(JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhatsappBusinessAccountId(@jakarta.annotation.Nullable String whatsappBusinessAccountId) {
    this.whatsappBusinessAccountId = whatsappBusinessAccountId;
  }

  public GetWhatsAppConfig sendingLimit(@jakarta.annotation.Nullable String sendingLimit) {
    
    this.sendingLimit = sendingLimit;
    return this;
  }

  /**
   * Sending limit Information of the WhatsApp API account
   * @return sendingLimit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SENDING_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSendingLimit() {
    return sendingLimit;
  }


  @JsonProperty(JSON_PROPERTY_SENDING_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendingLimit(@jakarta.annotation.Nullable String sendingLimit) {
    this.sendingLimit = sendingLimit;
  }

  public GetWhatsAppConfig phoneNumberQuality(@jakarta.annotation.Nullable PhoneNumberQualityEnum phoneNumberQuality) {
    
    this.phoneNumberQuality = phoneNumberQuality;
    return this;
  }

  /**
   * Quality status of phone number associated with WhatsApp account. There are three quality ratings. example - **High (GREEN) , Medium (YELLOW) and Low(RED)**
   * @return phoneNumberQuality
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PhoneNumberQualityEnum getPhoneNumberQuality() {
    return phoneNumberQuality;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER_QUALITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumberQuality(@jakarta.annotation.Nullable PhoneNumberQualityEnum phoneNumberQuality) {
    this.phoneNumberQuality = phoneNumberQuality;
  }

  public GetWhatsAppConfig whatsappBusinessAccountStatus(@jakarta.annotation.Nullable WhatsappBusinessAccountStatusEnum whatsappBusinessAccountStatus) {
    
    this.whatsappBusinessAccountStatus = whatsappBusinessAccountStatus;
    return this;
  }

  /**
   * Status information related to WhatsApp API account
   * @return whatsappBusinessAccountStatus
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WhatsappBusinessAccountStatusEnum getWhatsappBusinessAccountStatus() {
    return whatsappBusinessAccountStatus;
  }


  @JsonProperty(JSON_PROPERTY_WHATSAPP_BUSINESS_ACCOUNT_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhatsappBusinessAccountStatus(@jakarta.annotation.Nullable WhatsappBusinessAccountStatusEnum whatsappBusinessAccountStatus) {
    this.whatsappBusinessAccountStatus = whatsappBusinessAccountStatus;
  }

  public GetWhatsAppConfig businessStatus(@jakarta.annotation.Nullable String businessStatus) {
    
    this.businessStatus = businessStatus;
    return this;
  }

  /**
   * Verification status information of the Business account
   * @return businessStatus
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BUSINESS_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBusinessStatus() {
    return businessStatus;
  }


  @JsonProperty(JSON_PROPERTY_BUSINESS_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBusinessStatus(@jakarta.annotation.Nullable String businessStatus) {
    this.businessStatus = businessStatus;
  }

  public GetWhatsAppConfig phoneNumberNameStatus(@jakarta.annotation.Nullable PhoneNumberNameStatusEnum phoneNumberNameStatus) {
    
    this.phoneNumberNameStatus = phoneNumberNameStatus;
    return this;
  }

  /**
   * Status of the name associated with WhatsApp Phone number
   * @return phoneNumberNameStatus
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER_NAME_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PhoneNumberNameStatusEnum getPhoneNumberNameStatus() {
    return phoneNumberNameStatus;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_NUMBER_NAME_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneNumberNameStatus(@jakarta.annotation.Nullable PhoneNumberNameStatusEnum phoneNumberNameStatus) {
    this.phoneNumberNameStatus = phoneNumberNameStatus;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetWhatsAppConfig getWhatsAppConfig = (GetWhatsAppConfig) o;
    return Objects.equals(this.whatsappBusinessAccountId, getWhatsAppConfig.whatsappBusinessAccountId) &&
        Objects.equals(this.sendingLimit, getWhatsAppConfig.sendingLimit) &&
        Objects.equals(this.phoneNumberQuality, getWhatsAppConfig.phoneNumberQuality) &&
        Objects.equals(this.whatsappBusinessAccountStatus, getWhatsAppConfig.whatsappBusinessAccountStatus) &&
        Objects.equals(this.businessStatus, getWhatsAppConfig.businessStatus) &&
        Objects.equals(this.phoneNumberNameStatus, getWhatsAppConfig.phoneNumberNameStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(whatsappBusinessAccountId, sendingLimit, phoneNumberQuality, whatsappBusinessAccountStatus, businessStatus, phoneNumberNameStatus);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetWhatsAppConfig {\n");
    sb.append("    whatsappBusinessAccountId: ").append(toIndentedString(whatsappBusinessAccountId)).append("\n");
    sb.append("    sendingLimit: ").append(toIndentedString(sendingLimit)).append("\n");
    sb.append("    phoneNumberQuality: ").append(toIndentedString(phoneNumberQuality)).append("\n");
    sb.append("    whatsappBusinessAccountStatus: ").append(toIndentedString(whatsappBusinessAccountStatus)).append("\n");
    sb.append("    businessStatus: ").append(toIndentedString(businessStatus)).append("\n");
    sb.append("    phoneNumberNameStatus: ").append(toIndentedString(phoneNumberNameStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `whatsappBusinessAccountId` to the URL query string
    if (getWhatsappBusinessAccountId() != null) {
      try {
        joiner.add(String.format("%swhatsappBusinessAccountId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWhatsappBusinessAccountId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sendingLimit` to the URL query string
    if (getSendingLimit() != null) {
      try {
        joiner.add(String.format("%ssendingLimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSendingLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `phoneNumberQuality` to the URL query string
    if (getPhoneNumberQuality() != null) {
      try {
        joiner.add(String.format("%sphoneNumberQuality%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPhoneNumberQuality()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `whatsappBusinessAccountStatus` to the URL query string
    if (getWhatsappBusinessAccountStatus() != null) {
      try {
        joiner.add(String.format("%swhatsappBusinessAccountStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWhatsappBusinessAccountStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `businessStatus` to the URL query string
    if (getBusinessStatus() != null) {
      try {
        joiner.add(String.format("%sbusinessStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBusinessStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `phoneNumberNameStatus` to the URL query string
    if (getPhoneNumberNameStatus() != null) {
      try {
        joiner.add(String.format("%sphoneNumberNameStatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPhoneNumberNameStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

