/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Reason for blocking / unsubscribing
 */
@JsonPropertyOrder({
  GetTransacBlockedContactsContactsInnerReason.JSON_PROPERTY_CODE,
  GetTransacBlockedContactsContactsInnerReason.JSON_PROPERTY_MESSAGE
})
@JsonTypeName("getTransacBlockedContacts_contacts_inner_reason")
public class GetTransacBlockedContactsContactsInnerReason {
  /**
   * Reason code for blocking / unsubscribing (This code is safe for comparison)
   */
  public enum CodeEnum {
    UNSUBSCRIBED_VIA_MA(String.valueOf("unsubscribedViaMA")),
    
    UNSUBSCRIBED_VIA_EMAIL(String.valueOf("unsubscribedViaEmail")),
    
    ADMIN_BLOCKED(String.valueOf("adminBlocked")),
    
    UNSUBSCRIBED_VIA_API(String.valueOf("unsubscribedViaApi")),
    
    HARD_BOUNCE(String.valueOf("hardBounce")),
    
    CONTACT_FLAGGED_AS_SPAM(String.valueOf("contactFlaggedAsSpam"));

    private String value;

    CodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CodeEnum fromValue(String value) {
      for (CodeEnum b : CodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CODE = "code";
  @jakarta.annotation.Nullable
  private CodeEnum code;

  public static final String JSON_PROPERTY_MESSAGE = "message";
  @jakarta.annotation.Nullable
  private String message;

  public GetTransacBlockedContactsContactsInnerReason() {
  }

  public GetTransacBlockedContactsContactsInnerReason code(@jakarta.annotation.Nullable CodeEnum code) {
    
    this.code = code;
    return this;
  }

  /**
   * Reason code for blocking / unsubscribing (This code is safe for comparison)
   * @return code
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CodeEnum getCode() {
    return code;
  }


  @JsonProperty(JSON_PROPERTY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCode(@jakarta.annotation.Nullable CodeEnum code) {
    this.code = code;
  }

  public GetTransacBlockedContactsContactsInnerReason message(@jakarta.annotation.Nullable String message) {
    
    this.message = message;
    return this;
  }

  /**
   * Reason for blocking / unsubscribing (This string is not safe for comparison)
   * @return message
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessage() {
    return message;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessage(@jakarta.annotation.Nullable String message) {
    this.message = message;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetTransacBlockedContactsContactsInnerReason getTransacBlockedContactsContactsInnerReason = (GetTransacBlockedContactsContactsInnerReason) o;
    return Objects.equals(this.code, getTransacBlockedContactsContactsInnerReason.code) &&
        Objects.equals(this.message, getTransacBlockedContactsContactsInnerReason.message);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetTransacBlockedContactsContactsInnerReason {\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `code` to the URL query string
    if (getCode() != null) {
      try {
        joiner.add(String.format("%scode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `message` to the URL query string
    if (getMessage() != null) {
      try {
        joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

