/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import software.xdev.brevo.model.Cart;
import software.xdev.brevo.model.ModelConfiguration;
import software.xdev.brevo.model.Notification;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetPaymentRequest
 */
@JsonPropertyOrder({
  GetPaymentRequest.JSON_PROPERTY_REFERENCE,
  GetPaymentRequest.JSON_PROPERTY_STATUS,
  GetPaymentRequest.JSON_PROPERTY_CONFIGURATION,
  GetPaymentRequest.JSON_PROPERTY_CONTACT_ID,
  GetPaymentRequest.JSON_PROPERTY_NUMBER_OF_REMINDERS_SENT,
  GetPaymentRequest.JSON_PROPERTY_CART,
  GetPaymentRequest.JSON_PROPERTY_NOTIFICATION
})
@JsonTypeName("getPaymentRequest")
public class GetPaymentRequest {
  public static final String JSON_PROPERTY_REFERENCE = "reference";
  @jakarta.annotation.Nonnull
  private String reference;

  /**
   * Status of the payment request.
   */
  public enum StatusEnum {
    CREATED(String.valueOf("created")),
    
    SENT(String.valueOf("sent")),
    
    REMINDER_SENT(String.valueOf("reminderSent")),
    
    PAID(String.valueOf("paid"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nonnull
  private StatusEnum status;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  @jakarta.annotation.Nullable
  private ModelConfiguration _configuration;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nullable
  private Long contactId;

  public static final String JSON_PROPERTY_NUMBER_OF_REMINDERS_SENT = "numberOfRemindersSent";
  @jakarta.annotation.Nullable
  private Long numberOfRemindersSent;

  public static final String JSON_PROPERTY_CART = "cart";
  @jakarta.annotation.Nonnull
  private Cart cart;

  public static final String JSON_PROPERTY_NOTIFICATION = "notification";
  @jakarta.annotation.Nonnull
  private Notification notification;

  public GetPaymentRequest() {
  }

  public GetPaymentRequest reference(@jakarta.annotation.Nonnull String reference) {
    
    this.reference = reference;
    return this;
  }

  /**
   * Reference of the payment request, it will appear on the payment page. 
   * @return reference
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReference(@jakarta.annotation.Nonnull String reference) {
    this.reference = reference;
  }

  public GetPaymentRequest status(@jakarta.annotation.Nonnull StatusEnum status) {
    
    this.status = status;
    return this;
  }

  /**
   * Status of the payment request.
   * @return status
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(@jakarta.annotation.Nonnull StatusEnum status) {
    this.status = status;
  }

  public GetPaymentRequest _configuration(@jakarta.annotation.Nullable ModelConfiguration _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

  /**
   * Get _configuration
   * @return _configuration
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModelConfiguration getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(@jakarta.annotation.Nullable ModelConfiguration _configuration) {
    this._configuration = _configuration;
  }

  public GetPaymentRequest contactId(@jakarta.annotation.Nullable Long contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Brevo ID of the contact requested to pay. 
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Long contactId) {
    this.contactId = contactId;
  }

  public GetPaymentRequest numberOfRemindersSent(@jakarta.annotation.Nullable Long numberOfRemindersSent) {
    
    this.numberOfRemindersSent = numberOfRemindersSent;
    return this;
  }

  /**
   * number of reminders sent. 
   * @return numberOfRemindersSent
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NUMBER_OF_REMINDERS_SENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getNumberOfRemindersSent() {
    return numberOfRemindersSent;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_REMINDERS_SENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfRemindersSent(@jakarta.annotation.Nullable Long numberOfRemindersSent) {
    this.numberOfRemindersSent = numberOfRemindersSent;
  }

  public GetPaymentRequest cart(@jakarta.annotation.Nonnull Cart cart) {
    
    this.cart = cart;
    return this;
  }

  /**
   * Get cart
   * @return cart
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CART)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Cart getCart() {
    return cart;
  }


  @JsonProperty(JSON_PROPERTY_CART)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCart(@jakarta.annotation.Nonnull Cart cart) {
    this.cart = cart;
  }

  public GetPaymentRequest notification(@jakarta.annotation.Nonnull Notification notification) {
    
    this.notification = notification;
    return this;
  }

  /**
   * Get notification
   * @return notification
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Notification getNotification() {
    return notification;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNotification(@jakarta.annotation.Nonnull Notification notification) {
    this.notification = notification;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetPaymentRequest getPaymentRequest = (GetPaymentRequest) o;
    return Objects.equals(this.reference, getPaymentRequest.reference) &&
        Objects.equals(this.status, getPaymentRequest.status) &&
        Objects.equals(this._configuration, getPaymentRequest._configuration) &&
        Objects.equals(this.contactId, getPaymentRequest.contactId) &&
        Objects.equals(this.numberOfRemindersSent, getPaymentRequest.numberOfRemindersSent) &&
        Objects.equals(this.cart, getPaymentRequest.cart) &&
        Objects.equals(this.notification, getPaymentRequest.notification);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reference, status, _configuration, contactId, numberOfRemindersSent, cart, notification);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetPaymentRequest {\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    numberOfRemindersSent: ").append(toIndentedString(numberOfRemindersSent)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    notification: ").append(toIndentedString(notification)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `reference` to the URL query string
    if (getReference() != null) {
      try {
        joiner.add(String.format("%sreference%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReference()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      try {
        joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `configuration` to the URL query string
    if (getConfiguration() != null) {
      joiner.add(getConfiguration().toUrlQueryString(prefix + "configuration" + suffix));
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `numberOfRemindersSent` to the URL query string
    if (getNumberOfRemindersSent() != null) {
      try {
        joiner.add(String.format("%snumberOfRemindersSent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNumberOfRemindersSent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `cart` to the URL query string
    if (getCart() != null) {
      joiner.add(getCart().toUrlQueryString(prefix + "cart" + suffix));
    }

    // add `notification` to the URL query string
    if (getNotification() != null) {
      joiner.add(getNotification().toUrlQueryString(prefix + "notification" + suffix));
    }

    return joiner.toString();
  }

}

