/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;
import software.xdev.brevo.model.GetInboundEmailEventsByUuidAttachmentsInner;
import software.xdev.brevo.model.GetInboundEmailEventsByUuidLogsInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetInboundEmailEventsByUuid
 */
@JsonPropertyOrder({
  GetInboundEmailEventsByUuid.JSON_PROPERTY_RECEIVED_AT,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_DELIVERED_AT,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_RECIPIENT,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_SENDER,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_MESSAGE_ID,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_SUBJECT,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_ATTACHMENTS,
  GetInboundEmailEventsByUuid.JSON_PROPERTY_LOGS
})
@JsonTypeName("getInboundEmailEventsByUuid")
public class GetInboundEmailEventsByUuid {
  public static final String JSON_PROPERTY_RECEIVED_AT = "receivedAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime receivedAt;

  public static final String JSON_PROPERTY_DELIVERED_AT = "deliveredAt";
  @jakarta.annotation.Nullable
  private JsonNullable<OffsetDateTime> deliveredAt = JsonNullable.<OffsetDateTime>undefined();

  public static final String JSON_PROPERTY_RECIPIENT = "recipient";
  @jakarta.annotation.Nullable
  private String recipient;

  public static final String JSON_PROPERTY_SENDER = "sender";
  @jakarta.annotation.Nullable
  private String sender;

  public static final String JSON_PROPERTY_MESSAGE_ID = "messageId";
  @jakarta.annotation.Nullable
  private String messageId;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private String subject;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  @jakarta.annotation.Nullable
  private List<GetInboundEmailEventsByUuidAttachmentsInner> attachments = new ArrayList<>();

  public static final String JSON_PROPERTY_LOGS = "logs";
  @jakarta.annotation.Nullable
  private List<GetInboundEmailEventsByUuidLogsInner> logs = new ArrayList<>();

  public GetInboundEmailEventsByUuid() {
  }

  public GetInboundEmailEventsByUuid receivedAt(@jakarta.annotation.Nullable OffsetDateTime receivedAt) {
    
    this.receivedAt = receivedAt;
    return this;
  }

  /**
   * Date when email was received on SMTP relay
   * @return receivedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECEIVED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getReceivedAt() {
    return receivedAt;
  }


  @JsonProperty(JSON_PROPERTY_RECEIVED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceivedAt(@jakarta.annotation.Nullable OffsetDateTime receivedAt) {
    this.receivedAt = receivedAt;
  }

  public GetInboundEmailEventsByUuid deliveredAt(@jakarta.annotation.Nullable OffsetDateTime deliveredAt) {
    this.deliveredAt = JsonNullable.<OffsetDateTime>of(deliveredAt);
    
    return this;
  }

  /**
   * Date when email was delivered successfully to client’s webhook
   * @return deliveredAt
   */
  @jakarta.annotation.Nullable
  @JsonIgnore

  public OffsetDateTime getDeliveredAt() {
        return deliveredAt.orElse(null);
  }

  @JsonProperty(JSON_PROPERTY_DELIVERED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JsonNullable<OffsetDateTime> getDeliveredAt_JsonNullable() {
    return deliveredAt;
  }
  
  @JsonProperty(JSON_PROPERTY_DELIVERED_AT)
  public void setDeliveredAt_JsonNullable(JsonNullable<OffsetDateTime> deliveredAt) {
    this.deliveredAt = deliveredAt;
  }

  public void setDeliveredAt(@jakarta.annotation.Nullable OffsetDateTime deliveredAt) {
    this.deliveredAt = JsonNullable.<OffsetDateTime>of(deliveredAt);
  }

  public GetInboundEmailEventsByUuid recipient(@jakarta.annotation.Nullable String recipient) {
    
    this.recipient = recipient;
    return this;
  }

  /**
   * Recipient’s email address
   * @return recipient
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRecipient() {
    return recipient;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecipient(@jakarta.annotation.Nullable String recipient) {
    this.recipient = recipient;
  }

  public GetInboundEmailEventsByUuid sender(@jakarta.annotation.Nullable String sender) {
    
    this.sender = sender;
    return this;
  }

  /**
   * Sender’s email address
   * @return sender
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSender() {
    return sender;
  }


  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSender(@jakarta.annotation.Nullable String sender) {
    this.sender = sender;
  }

  public GetInboundEmailEventsByUuid messageId(@jakarta.annotation.Nullable String messageId) {
    
    this.messageId = messageId;
    return this;
  }

  /**
   * Value of the Message-ID header. This will be present only after the processing is done.
   * @return messageId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageId() {
    return messageId;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageId(@jakarta.annotation.Nullable String messageId) {
    this.messageId = messageId;
  }

  public GetInboundEmailEventsByUuid subject(@jakarta.annotation.Nullable String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Value of the Subject header. This will be present only after the processing is done. 
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable String subject) {
    this.subject = subject;
  }

  public GetInboundEmailEventsByUuid attachments(@jakarta.annotation.Nullable List<GetInboundEmailEventsByUuidAttachmentsInner> attachments) {
    
    this.attachments = attachments;
    return this;
  }

  public GetInboundEmailEventsByUuid addAttachmentsItem(GetInboundEmailEventsByUuidAttachmentsInner attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * List of attachments of the email. This will be present only after the processing is done.
   * @return attachments
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GetInboundEmailEventsByUuidAttachmentsInner> getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(@jakarta.annotation.Nullable List<GetInboundEmailEventsByUuidAttachmentsInner> attachments) {
    this.attachments = attachments;
  }

  public GetInboundEmailEventsByUuid logs(@jakarta.annotation.Nullable List<GetInboundEmailEventsByUuidLogsInner> logs) {
    
    this.logs = logs;
    return this;
  }

  public GetInboundEmailEventsByUuid addLogsItem(GetInboundEmailEventsByUuidLogsInner logsItem) {
    if (this.logs == null) {
      this.logs = new ArrayList<>();
    }
    this.logs.add(logsItem);
    return this;
  }

  /**
   * List of events/logs that describe the lifecycle of the email on SIB platform
   * @return logs
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GetInboundEmailEventsByUuidLogsInner> getLogs() {
    return logs;
  }


  @JsonProperty(JSON_PROPERTY_LOGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogs(@jakarta.annotation.Nullable List<GetInboundEmailEventsByUuidLogsInner> logs) {
    this.logs = logs;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetInboundEmailEventsByUuid getInboundEmailEventsByUuid = (GetInboundEmailEventsByUuid) o;
    return Objects.equals(this.receivedAt, getInboundEmailEventsByUuid.receivedAt) &&
        equalsNullable(this.deliveredAt, getInboundEmailEventsByUuid.deliveredAt) &&
        Objects.equals(this.recipient, getInboundEmailEventsByUuid.recipient) &&
        Objects.equals(this.sender, getInboundEmailEventsByUuid.sender) &&
        Objects.equals(this.messageId, getInboundEmailEventsByUuid.messageId) &&
        Objects.equals(this.subject, getInboundEmailEventsByUuid.subject) &&
        Objects.equals(this.attachments, getInboundEmailEventsByUuid.attachments) &&
        Objects.equals(this.logs, getInboundEmailEventsByUuid.logs);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(receivedAt, hashCodeNullable(deliveredAt), recipient, sender, messageId, subject, attachments, logs);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetInboundEmailEventsByUuid {\n");
    sb.append("    receivedAt: ").append(toIndentedString(receivedAt)).append("\n");
    sb.append("    deliveredAt: ").append(toIndentedString(deliveredAt)).append("\n");
    sb.append("    recipient: ").append(toIndentedString(recipient)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("    logs: ").append(toIndentedString(logs)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `receivedAt` to the URL query string
    if (getReceivedAt() != null) {
      try {
        joiner.add(String.format("%sreceivedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReceivedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deliveredAt` to the URL query string
    if (getDeliveredAt() != null) {
      try {
        joiner.add(String.format("%sdeliveredAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeliveredAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `recipient` to the URL query string
    if (getRecipient() != null) {
      try {
        joiner.add(String.format("%srecipient%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRecipient()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sender` to the URL query string
    if (getSender() != null) {
      try {
        joiner.add(String.format("%ssender%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSender()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `messageId` to the URL query string
    if (getMessageId() != null) {
      try {
        joiner.add(String.format("%smessageId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessageId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      try {
        joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attachments` to the URL query string
    if (getAttachments() != null) {
      for (int i = 0; i < getAttachments().size(); i++) {
        if (getAttachments().get(i) != null) {
          joiner.add(getAttachments().get(i).toUrlQueryString(String.format("%sattachments%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `logs` to the URL query string
    if (getLogs() != null) {
      for (int i = 0; i < getLogs().size(); i++) {
        if (getLogs().get(i) != null) {
          joiner.add(getLogs().get(i).toUrlQueryString(String.format("%slogs%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

