/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Address informations
 */
@JsonPropertyOrder({
  GetExtendedClientAllOfAddress.JSON_PROPERTY_STREET,
  GetExtendedClientAllOfAddress.JSON_PROPERTY_CITY,
  GetExtendedClientAllOfAddress.JSON_PROPERTY_ZIP_CODE,
  GetExtendedClientAllOfAddress.JSON_PROPERTY_COUNTRY
})
@JsonTypeName("getExtendedClient_allOf_address")
public class GetExtendedClientAllOfAddress {
  public static final String JSON_PROPERTY_STREET = "street";
  @jakarta.annotation.Nonnull
  private String street;

  public static final String JSON_PROPERTY_CITY = "city";
  @jakarta.annotation.Nonnull
  private String city;

  public static final String JSON_PROPERTY_ZIP_CODE = "zipCode";
  @jakarta.annotation.Nonnull
  private String zipCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  @jakarta.annotation.Nonnull
  private String country;

  public GetExtendedClientAllOfAddress() {
  }

  public GetExtendedClientAllOfAddress street(@jakarta.annotation.Nonnull String street) {
    
    this.street = street;
    return this;
  }

  /**
   * Street information
   * @return street
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STREET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getStreet() {
    return street;
  }


  @JsonProperty(JSON_PROPERTY_STREET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStreet(@jakarta.annotation.Nonnull String street) {
    this.street = street;
  }

  public GetExtendedClientAllOfAddress city(@jakarta.annotation.Nonnull String city) {
    
    this.city = city;
    return this;
  }

  /**
   * City information
   * @return city
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCity(@jakarta.annotation.Nonnull String city) {
    this.city = city;
  }

  public GetExtendedClientAllOfAddress zipCode(@jakarta.annotation.Nonnull String zipCode) {
    
    this.zipCode = zipCode;
    return this;
  }

  /**
   * Zip Code information
   * @return zipCode
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getZipCode() {
    return zipCode;
  }


  @JsonProperty(JSON_PROPERTY_ZIP_CODE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setZipCode(@jakarta.annotation.Nonnull String zipCode) {
    this.zipCode = zipCode;
  }

  public GetExtendedClientAllOfAddress country(@jakarta.annotation.Nonnull String country) {
    
    this.country = country;
    return this;
  }

  /**
   * Country information
   * @return country
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCountry(@jakarta.annotation.Nonnull String country) {
    this.country = country;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetExtendedClientAllOfAddress getExtendedClientAllOfAddress = (GetExtendedClientAllOfAddress) o;
    return Objects.equals(this.street, getExtendedClientAllOfAddress.street) &&
        Objects.equals(this.city, getExtendedClientAllOfAddress.city) &&
        Objects.equals(this.zipCode, getExtendedClientAllOfAddress.zipCode) &&
        Objects.equals(this.country, getExtendedClientAllOfAddress.country);
  }

  @Override
  public int hashCode() {
    return Objects.hash(street, city, zipCode, country);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetExtendedClientAllOfAddress {\n");
    sb.append("    street: ").append(toIndentedString(street)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    zipCode: ").append(toIndentedString(zipCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `street` to the URL query string
    if (getStreet() != null) {
      try {
        joiner.add(String.format("%sstreet%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStreet()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `city` to the URL query string
    if (getCity() != null) {
      try {
        joiner.add(String.format("%scity%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCity()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `zipCode` to the URL query string
    if (getZipCode() != null) {
      try {
        joiner.add(String.format("%szipCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getZipCode()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `country` to the URL query string
    if (getCountry() != null) {
      try {
        joiner.add(String.format("%scountry%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCountry()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

