/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetEmailEventReportEventsInner
 */
@JsonPropertyOrder({
  GetEmailEventReportEventsInner.JSON_PROPERTY_EMAIL,
  GetEmailEventReportEventsInner.JSON_PROPERTY_DATE,
  GetEmailEventReportEventsInner.JSON_PROPERTY_SUBJECT,
  GetEmailEventReportEventsInner.JSON_PROPERTY_MESSAGE_ID,
  GetEmailEventReportEventsInner.JSON_PROPERTY_EVENT,
  GetEmailEventReportEventsInner.JSON_PROPERTY_REASON,
  GetEmailEventReportEventsInner.JSON_PROPERTY_TAG,
  GetEmailEventReportEventsInner.JSON_PROPERTY_IP,
  GetEmailEventReportEventsInner.JSON_PROPERTY_LINK,
  GetEmailEventReportEventsInner.JSON_PROPERTY_FROM,
  GetEmailEventReportEventsInner.JSON_PROPERTY_TEMPLATE_ID
})
@JsonTypeName("getEmailEventReport_events_inner")
public class GetEmailEventReportEventsInner {
  public static final String JSON_PROPERTY_EMAIL = "email";
  @jakarta.annotation.Nonnull
  private String email;

  public static final String JSON_PROPERTY_DATE = "date";
  @jakarta.annotation.Nonnull
  private String date;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private String subject;

  public static final String JSON_PROPERTY_MESSAGE_ID = "messageId";
  @jakarta.annotation.Nonnull
  private String messageId;

  /**
   * Event which occurred
   */
  public enum EventEnum {
    BOUNCES(String.valueOf("bounces")),
    
    HARD_BOUNCES(String.valueOf("hardBounces")),
    
    SOFT_BOUNCES(String.valueOf("softBounces")),
    
    DELIVERED(String.valueOf("delivered")),
    
    SPAM(String.valueOf("spam")),
    
    REQUESTS(String.valueOf("requests")),
    
    OPENED(String.valueOf("opened")),
    
    CLICKS(String.valueOf("clicks")),
    
    INVALID(String.valueOf("invalid")),
    
    DEFERRED(String.valueOf("deferred")),
    
    BLOCKED(String.valueOf("blocked")),
    
    UNSUBSCRIBED(String.valueOf("unsubscribed")),
    
    ERROR(String.valueOf("error")),
    
    LOADED_BY_PROXY(String.valueOf("loadedByProxy"));

    private String value;

    EventEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static EventEnum fromValue(String value) {
      for (EventEnum b : EventEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_EVENT = "event";
  @jakarta.annotation.Nonnull
  private EventEnum event;

  public static final String JSON_PROPERTY_REASON = "reason";
  @jakarta.annotation.Nullable
  private String reason;

  public static final String JSON_PROPERTY_TAG = "tag";
  @jakarta.annotation.Nullable
  private String tag;

  public static final String JSON_PROPERTY_IP = "ip";
  @jakarta.annotation.Nullable
  private String ip;

  public static final String JSON_PROPERTY_LINK = "link";
  @jakarta.annotation.Nullable
  private String link;

  public static final String JSON_PROPERTY_FROM = "from";
  @jakarta.annotation.Nullable
  private String from;

  public static final String JSON_PROPERTY_TEMPLATE_ID = "templateId";
  @jakarta.annotation.Nullable
  private Long templateId;

  public GetEmailEventReportEventsInner() {
  }

  public GetEmailEventReportEventsInner email(@jakarta.annotation.Nonnull String email) {
    
    this.email = email;
    return this;
  }

  /**
   * Email address which generates the event
   * @return email
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(@jakarta.annotation.Nonnull String email) {
    this.email = email;
  }

  public GetEmailEventReportEventsInner date(@jakarta.annotation.Nonnull String date) {
    
    this.date = date;
    return this;
  }

  /**
   * UTC date-time on which the event has been generated
   * @return date
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(@jakarta.annotation.Nonnull String date) {
    this.date = date;
  }

  public GetEmailEventReportEventsInner subject(@jakarta.annotation.Nullable String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Subject of the event
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable String subject) {
    this.subject = subject;
  }

  public GetEmailEventReportEventsInner messageId(@jakarta.annotation.Nonnull String messageId) {
    
    this.messageId = messageId;
    return this;
  }

  /**
   * Message ID which generated the event
   * @return messageId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getMessageId() {
    return messageId;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMessageId(@jakarta.annotation.Nonnull String messageId) {
    this.messageId = messageId;
  }

  public GetEmailEventReportEventsInner event(@jakarta.annotation.Nonnull EventEnum event) {
    
    this.event = event;
    return this;
  }

  /**
   * Event which occurred
   * @return event
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EventEnum getEvent() {
    return event;
  }


  @JsonProperty(JSON_PROPERTY_EVENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEvent(@jakarta.annotation.Nonnull EventEnum event) {
    this.event = event;
  }

  public GetEmailEventReportEventsInner reason(@jakarta.annotation.Nullable String reason) {
    
    this.reason = reason;
    return this;
  }

  /**
   * Reason of bounce (only available if the event is hardbounce or softbounce)
   * @return reason
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReason() {
    return reason;
  }


  @JsonProperty(JSON_PROPERTY_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReason(@jakarta.annotation.Nullable String reason) {
    this.reason = reason;
  }

  public GetEmailEventReportEventsInner tag(@jakarta.annotation.Nullable String tag) {
    
    this.tag = tag;
    return this;
  }

  /**
   * Tag of the email which generated the event
   * @return tag
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTag() {
    return tag;
  }


  @JsonProperty(JSON_PROPERTY_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTag(@jakarta.annotation.Nullable String tag) {
    this.tag = tag;
  }

  public GetEmailEventReportEventsInner ip(@jakarta.annotation.Nullable String ip) {
    
    this.ip = ip;
    return this;
  }

  /**
   * IP from which the user has opened the email or clicked on the link (only available if the event is opened or clicks)
   * @return ip
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIp() {
    return ip;
  }


  @JsonProperty(JSON_PROPERTY_IP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIp(@jakarta.annotation.Nullable String ip) {
    this.ip = ip;
  }

  public GetEmailEventReportEventsInner link(@jakarta.annotation.Nullable String link) {
    
    this.link = link;
    return this;
  }

  /**
   * The link which is sent to the user (only available if the event is requests or opened or clicks)
   * @return link
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLink() {
    return link;
  }


  @JsonProperty(JSON_PROPERTY_LINK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLink(@jakarta.annotation.Nullable String link) {
    this.link = link;
  }

  public GetEmailEventReportEventsInner from(@jakarta.annotation.Nullable String from) {
    
    this.from = from;
    return this;
  }

  /**
   * Sender email from which the emails are sent
   * @return from
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(@jakarta.annotation.Nullable String from) {
    this.from = from;
  }

  public GetEmailEventReportEventsInner templateId(@jakarta.annotation.Nullable Long templateId) {
    
    this.templateId = templateId;
    return this;
  }

  /**
   * ID of the template (only available if the email is template based)
   * @return templateId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTemplateId() {
    return templateId;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTemplateId(@jakarta.annotation.Nullable Long templateId) {
    this.templateId = templateId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetEmailEventReportEventsInner getEmailEventReportEventsInner = (GetEmailEventReportEventsInner) o;
    return Objects.equals(this.email, getEmailEventReportEventsInner.email) &&
        Objects.equals(this.date, getEmailEventReportEventsInner.date) &&
        Objects.equals(this.subject, getEmailEventReportEventsInner.subject) &&
        Objects.equals(this.messageId, getEmailEventReportEventsInner.messageId) &&
        Objects.equals(this.event, getEmailEventReportEventsInner.event) &&
        Objects.equals(this.reason, getEmailEventReportEventsInner.reason) &&
        Objects.equals(this.tag, getEmailEventReportEventsInner.tag) &&
        Objects.equals(this.ip, getEmailEventReportEventsInner.ip) &&
        Objects.equals(this.link, getEmailEventReportEventsInner.link) &&
        Objects.equals(this.from, getEmailEventReportEventsInner.from) &&
        Objects.equals(this.templateId, getEmailEventReportEventsInner.templateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(email, date, subject, messageId, event, reason, tag, ip, link, from, templateId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetEmailEventReportEventsInner {\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    event: ").append(toIndentedString(event)).append("\n");
    sb.append("    reason: ").append(toIndentedString(reason)).append("\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    ip: ").append(toIndentedString(ip)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `email` to the URL query string
    if (getEmail() != null) {
      try {
        joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmail()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `date` to the URL query string
    if (getDate() != null) {
      try {
        joiner.add(String.format("%sdate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      try {
        joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `messageId` to the URL query string
    if (getMessageId() != null) {
      try {
        joiner.add(String.format("%smessageId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMessageId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `event` to the URL query string
    if (getEvent() != null) {
      try {
        joiner.add(String.format("%sevent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEvent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `reason` to the URL query string
    if (getReason() != null) {
      try {
        joiner.add(String.format("%sreason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReason()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tag` to the URL query string
    if (getTag() != null) {
      try {
        joiner.add(String.format("%stag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ip` to the URL query string
    if (getIp() != null) {
      try {
        joiner.add(String.format("%sip%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIp()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `link` to the URL query string
    if (getLink() != null) {
      try {
        joiner.add(String.format("%slink%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLink()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `from` to the URL query string
    if (getFrom() != null) {
      try {
        joiner.add(String.format("%sfrom%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFrom()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `templateId` to the URL query string
    if (getTemplateId() != null) {
      try {
        joiner.add(String.format("%stemplateId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTemplateId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

