/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetCampaignOverview
 */
@JsonPropertyOrder({
  GetCampaignOverview.JSON_PROPERTY_ID,
  GetCampaignOverview.JSON_PROPERTY_NAME,
  GetCampaignOverview.JSON_PROPERTY_SUBJECT,
  GetCampaignOverview.JSON_PROPERTY_PREVIEW_TEXT,
  GetCampaignOverview.JSON_PROPERTY_TYPE,
  GetCampaignOverview.JSON_PROPERTY_STATUS,
  GetCampaignOverview.JSON_PROPERTY_SCHEDULED_AT,
  GetCampaignOverview.JSON_PROPERTY_AB_TESTING,
  GetCampaignOverview.JSON_PROPERTY_SUBJECT_A,
  GetCampaignOverview.JSON_PROPERTY_SUBJECT_B,
  GetCampaignOverview.JSON_PROPERTY_SPLIT_RULE,
  GetCampaignOverview.JSON_PROPERTY_WINNER_CRITERIA,
  GetCampaignOverview.JSON_PROPERTY_WINNER_DELAY,
  GetCampaignOverview.JSON_PROPERTY_SEND_AT_BEST_TIME
})
@JsonTypeName("getCampaignOverview")
public class GetCampaignOverview {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private Long id;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private String subject;

  public static final String JSON_PROPERTY_PREVIEW_TEXT = "previewText";
  @jakarta.annotation.Nullable
  private String previewText;

  /**
   * Type of campaign
   */
  public enum TypeEnum {
    CLASSIC(String.valueOf("classic")),
    
    TRIGGER(String.valueOf("trigger"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  /**
   * Status of the campaign
   */
  public enum StatusEnum {
    DRAFT(String.valueOf("draft")),
    
    SENT(String.valueOf("sent")),
    
    ARCHIVE(String.valueOf("archive")),
    
    QUEUED(String.valueOf("queued")),
    
    SUSPENDED(String.valueOf("suspended")),
    
    IN_PROCESS(String.valueOf("in_process"));

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  @jakarta.annotation.Nonnull
  private StatusEnum status;

  public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
  @jakarta.annotation.Nullable
  private String scheduledAt;

  public static final String JSON_PROPERTY_AB_TESTING = "abTesting";
  @jakarta.annotation.Nullable
  private Boolean abTesting;

  public static final String JSON_PROPERTY_SUBJECT_A = "subjectA";
  @jakarta.annotation.Nullable
  private String subjectA;

  public static final String JSON_PROPERTY_SUBJECT_B = "subjectB";
  @jakarta.annotation.Nullable
  private String subjectB;

  public static final String JSON_PROPERTY_SPLIT_RULE = "splitRule";
  @jakarta.annotation.Nullable
  private Integer splitRule;

  public static final String JSON_PROPERTY_WINNER_CRITERIA = "winnerCriteria";
  @jakarta.annotation.Nullable
  private String winnerCriteria;

  public static final String JSON_PROPERTY_WINNER_DELAY = "winnerDelay";
  @jakarta.annotation.Nullable
  private Integer winnerDelay;

  public static final String JSON_PROPERTY_SEND_AT_BEST_TIME = "sendAtBestTime";
  @jakarta.annotation.Nullable
  private Boolean sendAtBestTime;

  public GetCampaignOverview() {
  }

  public GetCampaignOverview id(@jakarta.annotation.Nonnull Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * ID of the campaign
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull Long id) {
    this.id = id;
  }

  public GetCampaignOverview name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the campaign
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public GetCampaignOverview subject(@jakarta.annotation.Nullable String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Subject of the campaign. Only available if &#x60;abTesting&#x60; flag of the campaign is &#x60;false&#x60;
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable String subject) {
    this.subject = subject;
  }

  public GetCampaignOverview previewText(@jakarta.annotation.Nullable String previewText) {
    
    this.previewText = previewText;
    return this;
  }

  /**
   * Preview text or preheader of the email campaign
   * @return previewText
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PREVIEW_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreviewText() {
    return previewText;
  }


  @JsonProperty(JSON_PROPERTY_PREVIEW_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreviewText(@jakarta.annotation.Nullable String previewText) {
    this.previewText = previewText;
  }

  public GetCampaignOverview type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of campaign
   * @return type
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public GetCampaignOverview status(@jakarta.annotation.Nonnull StatusEnum status) {
    
    this.status = status;
    return this;
  }

  /**
   * Status of the campaign
   * @return status
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(@jakarta.annotation.Nonnull StatusEnum status) {
    this.status = status;
  }

  public GetCampaignOverview scheduledAt(@jakarta.annotation.Nullable String scheduledAt) {
    
    this.scheduledAt = scheduledAt;
    return this;
  }

  /**
   * UTC date-time on which campaign is scheduled (YYYY-MM-DDTHH:mm:ss.SSSZ)
   * @return scheduledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScheduledAt() {
    return scheduledAt;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledAt(@jakarta.annotation.Nullable String scheduledAt) {
    this.scheduledAt = scheduledAt;
  }

  public GetCampaignOverview abTesting(@jakarta.annotation.Nullable Boolean abTesting) {
    
    this.abTesting = abTesting;
    return this;
  }

  /**
   * Status of A/B Test for the campaign. abTesting &#x3D; false means it is disabled, &amp; abTesting &#x3D; true means it is enabled.
   * @return abTesting
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AB_TESTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAbTesting() {
    return abTesting;
  }


  @JsonProperty(JSON_PROPERTY_AB_TESTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAbTesting(@jakarta.annotation.Nullable Boolean abTesting) {
    this.abTesting = abTesting;
  }

  public GetCampaignOverview subjectA(@jakarta.annotation.Nullable String subjectA) {
    
    this.subjectA = subjectA;
    return this;
  }

  /**
   * Subject A of the ab-test campaign. Only available if &#x60;abTesting&#x60; flag of the campaign is &#x60;true&#x60;
   * @return subjectA
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubjectA() {
    return subjectA;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjectA(@jakarta.annotation.Nullable String subjectA) {
    this.subjectA = subjectA;
  }

  public GetCampaignOverview subjectB(@jakarta.annotation.Nullable String subjectB) {
    
    this.subjectB = subjectB;
    return this;
  }

  /**
   * Subject B of the ab-test campaign. Only available if &#x60;abTesting&#x60; flag of the campaign is &#x60;true&#x60;
   * @return subjectB
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubjectB() {
    return subjectB;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjectB(@jakarta.annotation.Nullable String subjectB) {
    this.subjectB = subjectB;
  }

  public GetCampaignOverview splitRule(@jakarta.annotation.Nullable Integer splitRule) {
    
    this.splitRule = splitRule;
    return this;
  }

  /**
   * The size of your ab-test groups. Only available if &#x60;abTesting&#x60; flag of the campaign is &#x60;true&#x60;
   * @return splitRule
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SPLIT_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSplitRule() {
    return splitRule;
  }


  @JsonProperty(JSON_PROPERTY_SPLIT_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitRule(@jakarta.annotation.Nullable Integer splitRule) {
    this.splitRule = splitRule;
  }

  public GetCampaignOverview winnerCriteria(@jakarta.annotation.Nullable String winnerCriteria) {
    
    this.winnerCriteria = winnerCriteria;
    return this;
  }

  /**
   * Criteria for the winning version. Only available if &#x60;abTesting&#x60; flag of the campaign is &#x60;true&#x60;
   * @return winnerCriteria
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNER_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWinnerCriteria() {
    return winnerCriteria;
  }


  @JsonProperty(JSON_PROPERTY_WINNER_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinnerCriteria(@jakarta.annotation.Nullable String winnerCriteria) {
    this.winnerCriteria = winnerCriteria;
  }

  public GetCampaignOverview winnerDelay(@jakarta.annotation.Nullable Integer winnerDelay) {
    
    this.winnerDelay = winnerDelay;
    return this;
  }

  /**
   * The duration of the test in hours at the end of which the winning version will be sent. Only available if &#x60;abTesting&#x60; flag of the campaign is &#x60;true&#x60;
   * @return winnerDelay
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNER_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getWinnerDelay() {
    return winnerDelay;
  }


  @JsonProperty(JSON_PROPERTY_WINNER_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinnerDelay(@jakarta.annotation.Nullable Integer winnerDelay) {
    this.winnerDelay = winnerDelay;
  }

  public GetCampaignOverview sendAtBestTime(@jakarta.annotation.Nullable Boolean sendAtBestTime) {
    
    this.sendAtBestTime = sendAtBestTime;
    return this;
  }

  /**
   * It is true if you have chosen to send your campaign at best time, otherwise it is false
   * @return sendAtBestTime
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEND_AT_BEST_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendAtBestTime() {
    return sendAtBestTime;
  }


  @JsonProperty(JSON_PROPERTY_SEND_AT_BEST_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendAtBestTime(@jakarta.annotation.Nullable Boolean sendAtBestTime) {
    this.sendAtBestTime = sendAtBestTime;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetCampaignOverview getCampaignOverview = (GetCampaignOverview) o;
    return Objects.equals(this.id, getCampaignOverview.id) &&
        Objects.equals(this.name, getCampaignOverview.name) &&
        Objects.equals(this.subject, getCampaignOverview.subject) &&
        Objects.equals(this.previewText, getCampaignOverview.previewText) &&
        Objects.equals(this.type, getCampaignOverview.type) &&
        Objects.equals(this.status, getCampaignOverview.status) &&
        Objects.equals(this.scheduledAt, getCampaignOverview.scheduledAt) &&
        Objects.equals(this.abTesting, getCampaignOverview.abTesting) &&
        Objects.equals(this.subjectA, getCampaignOverview.subjectA) &&
        Objects.equals(this.subjectB, getCampaignOverview.subjectB) &&
        Objects.equals(this.splitRule, getCampaignOverview.splitRule) &&
        Objects.equals(this.winnerCriteria, getCampaignOverview.winnerCriteria) &&
        Objects.equals(this.winnerDelay, getCampaignOverview.winnerDelay) &&
        Objects.equals(this.sendAtBestTime, getCampaignOverview.sendAtBestTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, subject, previewText, type, status, scheduledAt, abTesting, subjectA, subjectB, splitRule, winnerCriteria, winnerDelay, sendAtBestTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetCampaignOverview {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    previewText: ").append(toIndentedString(previewText)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    scheduledAt: ").append(toIndentedString(scheduledAt)).append("\n");
    sb.append("    abTesting: ").append(toIndentedString(abTesting)).append("\n");
    sb.append("    subjectA: ").append(toIndentedString(subjectA)).append("\n");
    sb.append("    subjectB: ").append(toIndentedString(subjectB)).append("\n");
    sb.append("    splitRule: ").append(toIndentedString(splitRule)).append("\n");
    sb.append("    winnerCriteria: ").append(toIndentedString(winnerCriteria)).append("\n");
    sb.append("    winnerDelay: ").append(toIndentedString(winnerDelay)).append("\n");
    sb.append("    sendAtBestTime: ").append(toIndentedString(sendAtBestTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      try {
        joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `previewText` to the URL query string
    if (getPreviewText() != null) {
      try {
        joiner.add(String.format("%spreviewText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPreviewText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `status` to the URL query string
    if (getStatus() != null) {
      try {
        joiner.add(String.format("%sstatus%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStatus()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `scheduledAt` to the URL query string
    if (getScheduledAt() != null) {
      try {
        joiner.add(String.format("%sscheduledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getScheduledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `abTesting` to the URL query string
    if (getAbTesting() != null) {
      try {
        joiner.add(String.format("%sabTesting%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAbTesting()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subjectA` to the URL query string
    if (getSubjectA() != null) {
      try {
        joiner.add(String.format("%ssubjectA%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubjectA()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subjectB` to the URL query string
    if (getSubjectB() != null) {
      try {
        joiner.add(String.format("%ssubjectB%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubjectB()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `splitRule` to the URL query string
    if (getSplitRule() != null) {
      try {
        joiner.add(String.format("%ssplitRule%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSplitRule()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winnerCriteria` to the URL query string
    if (getWinnerCriteria() != null) {
      try {
        joiner.add(String.format("%swinnerCriteria%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinnerCriteria()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winnerDelay` to the URL query string
    if (getWinnerDelay() != null) {
      try {
        joiner.add(String.format("%swinnerDelay%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinnerDelay()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sendAtBestTime` to the URL query string
    if (getSendAtBestTime() != null) {
      try {
        joiner.add(String.format("%ssendAtBestTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSendAtBestTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

