/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.GetExternalFeedByUUIDHeadersInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetAllExternalFeedsFeedsInner
 */
@JsonPropertyOrder({
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_ID,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_NAME,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_URL,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_AUTH_TYPE,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_USERNAME,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_PASSWORD,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_TOKEN,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_HEADERS,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_MAX_RETRIES,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_CACHE,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_CREATED_AT,
  GetAllExternalFeedsFeedsInner.JSON_PROPERTY_MODIFIED_AT
})
@JsonTypeName("getAllExternalFeeds_feeds_inner")
public class GetAllExternalFeedsFeedsInner {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_URL = "url";
  @jakarta.annotation.Nonnull
  private String url;

  /**
   * Auth type of the feed: * &#x60;basic&#x60; * &#x60;token&#x60; * &#x60;noAuth&#x60; 
   */
  public enum AuthTypeEnum {
    BASIC(String.valueOf("basic")),
    
    TOKEN(String.valueOf("token")),
    
    NO_AUTH(String.valueOf("noAuth"));

    private String value;

    AuthTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AuthTypeEnum fromValue(String value) {
      for (AuthTypeEnum b : AuthTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_AUTH_TYPE = "authType";
  @jakarta.annotation.Nonnull
  private AuthTypeEnum authType;

  public static final String JSON_PROPERTY_USERNAME = "username";
  @jakarta.annotation.Nullable
  private String username;

  public static final String JSON_PROPERTY_PASSWORD = "password";
  @jakarta.annotation.Nullable
  private String password;

  public static final String JSON_PROPERTY_TOKEN = "token";
  @jakarta.annotation.Nullable
  private String token;

  public static final String JSON_PROPERTY_HEADERS = "headers";
  @jakarta.annotation.Nonnull
  private List<GetExternalFeedByUUIDHeadersInner> headers = new ArrayList<>();

  public static final String JSON_PROPERTY_MAX_RETRIES = "maxRetries";
  @jakarta.annotation.Nonnull
  private Integer maxRetries = 5;

  public static final String JSON_PROPERTY_CACHE = "cache";
  @jakarta.annotation.Nonnull
  private Boolean cache;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nonnull
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_MODIFIED_AT = "modifiedAt";
  @jakarta.annotation.Nonnull
  private OffsetDateTime modifiedAt;

  public GetAllExternalFeedsFeedsInner() {
  }

  public GetAllExternalFeedsFeedsInner id(@jakarta.annotation.Nonnull String id) {
    
    this.id = id;
    return this;
  }

  /**
   * ID of the feed
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull String id) {
    this.id = id;
  }

  public GetAllExternalFeedsFeedsInner name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the feed
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public GetAllExternalFeedsFeedsInner url(@jakarta.annotation.Nonnull String url) {
    
    this.url = url;
    return this;
  }

  /**
   * URL of the feed
   * @return url
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(@jakarta.annotation.Nonnull String url) {
    this.url = url;
  }

  public GetAllExternalFeedsFeedsInner authType(@jakarta.annotation.Nonnull AuthTypeEnum authType) {
    
    this.authType = authType;
    return this;
  }

  /**
   * Auth type of the feed: * &#x60;basic&#x60; * &#x60;token&#x60; * &#x60;noAuth&#x60; 
   * @return authType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AUTH_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AuthTypeEnum getAuthType() {
    return authType;
  }


  @JsonProperty(JSON_PROPERTY_AUTH_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAuthType(@jakarta.annotation.Nonnull AuthTypeEnum authType) {
    this.authType = authType;
  }

  public GetAllExternalFeedsFeedsInner username(@jakarta.annotation.Nullable String username) {
    
    this.username = username;
    return this;
  }

  /**
   * Username for authType &#x60;basic&#x60;
   * @return username
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUsername() {
    return username;
  }


  @JsonProperty(JSON_PROPERTY_USERNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsername(@jakarta.annotation.Nullable String username) {
    this.username = username;
  }

  public GetAllExternalFeedsFeedsInner password(@jakarta.annotation.Nullable String password) {
    
    this.password = password;
    return this;
  }

  /**
   * Password for authType &#x60;basic&#x60;
   * @return password
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPassword() {
    return password;
  }


  @JsonProperty(JSON_PROPERTY_PASSWORD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPassword(@jakarta.annotation.Nullable String password) {
    this.password = password;
  }

  public GetAllExternalFeedsFeedsInner token(@jakarta.annotation.Nullable String token) {
    
    this.token = token;
    return this;
  }

  /**
   * Token for authType &#x60;token&#x60;
   * @return token
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getToken() {
    return token;
  }


  @JsonProperty(JSON_PROPERTY_TOKEN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToken(@jakarta.annotation.Nullable String token) {
    this.token = token;
  }

  public GetAllExternalFeedsFeedsInner headers(@jakarta.annotation.Nonnull List<GetExternalFeedByUUIDHeadersInner> headers) {
    
    this.headers = headers;
    return this;
  }

  public GetAllExternalFeedsFeedsInner addHeadersItem(GetExternalFeedByUUIDHeadersInner headersItem) {
    if (this.headers == null) {
      this.headers = new ArrayList<>();
    }
    this.headers.add(headersItem);
    return this;
  }

  /**
   * Custom headers for the feed
   * @return headers
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<GetExternalFeedByUUIDHeadersInner> getHeaders() {
    return headers;
  }


  @JsonProperty(JSON_PROPERTY_HEADERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHeaders(@jakarta.annotation.Nonnull List<GetExternalFeedByUUIDHeadersInner> headers) {
    this.headers = headers;
  }

  public GetAllExternalFeedsFeedsInner maxRetries(@jakarta.annotation.Nonnull Integer maxRetries) {
    
    this.maxRetries = maxRetries;
    return this;
  }

  /**
   * Maximum number of retries on the feed url
   * minimum: 0
   * maximum: 5
   * @return maxRetries
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MAX_RETRIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMaxRetries() {
    return maxRetries;
  }


  @JsonProperty(JSON_PROPERTY_MAX_RETRIES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMaxRetries(@jakarta.annotation.Nonnull Integer maxRetries) {
    this.maxRetries = maxRetries;
  }

  public GetAllExternalFeedsFeedsInner cache(@jakarta.annotation.Nonnull Boolean cache) {
    
    this.cache = cache;
    return this;
  }

  /**
   * Toggle caching of feed url response
   * @return cache
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CACHE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getCache() {
    return cache;
  }


  @JsonProperty(JSON_PROPERTY_CACHE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCache(@jakarta.annotation.Nonnull Boolean cache) {
    this.cache = cache;
  }

  public GetAllExternalFeedsFeedsInner createdAt(@jakarta.annotation.Nonnull OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Datetime on which the feed was created
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(@jakarta.annotation.Nonnull OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public GetAllExternalFeedsFeedsInner modifiedAt(@jakarta.annotation.Nonnull OffsetDateTime modifiedAt) {
    
    this.modifiedAt = modifiedAt;
    return this;
  }

  /**
   * Datetime on which the feed was modified
   * @return modifiedAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getModifiedAt() {
    return modifiedAt;
  }


  @JsonProperty(JSON_PROPERTY_MODIFIED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setModifiedAt(@jakarta.annotation.Nonnull OffsetDateTime modifiedAt) {
    this.modifiedAt = modifiedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAllExternalFeedsFeedsInner getAllExternalFeedsFeedsInner = (GetAllExternalFeedsFeedsInner) o;
    return Objects.equals(this.id, getAllExternalFeedsFeedsInner.id) &&
        Objects.equals(this.name, getAllExternalFeedsFeedsInner.name) &&
        Objects.equals(this.url, getAllExternalFeedsFeedsInner.url) &&
        Objects.equals(this.authType, getAllExternalFeedsFeedsInner.authType) &&
        Objects.equals(this.username, getAllExternalFeedsFeedsInner.username) &&
        Objects.equals(this.password, getAllExternalFeedsFeedsInner.password) &&
        Objects.equals(this.token, getAllExternalFeedsFeedsInner.token) &&
        Objects.equals(this.headers, getAllExternalFeedsFeedsInner.headers) &&
        Objects.equals(this.maxRetries, getAllExternalFeedsFeedsInner.maxRetries) &&
        Objects.equals(this.cache, getAllExternalFeedsFeedsInner.cache) &&
        Objects.equals(this.createdAt, getAllExternalFeedsFeedsInner.createdAt) &&
        Objects.equals(this.modifiedAt, getAllExternalFeedsFeedsInner.modifiedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, url, authType, username, password, token, headers, maxRetries, cache, createdAt, modifiedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAllExternalFeedsFeedsInner {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    authType: ").append(toIndentedString(authType)).append("\n");
    sb.append("    username: ").append(toIndentedString(username)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    token: ").append(toIndentedString(token)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    maxRetries: ").append(toIndentedString(maxRetries)).append("\n");
    sb.append("    cache: ").append(toIndentedString(cache)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    modifiedAt: ").append(toIndentedString(modifiedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `url` to the URL query string
    if (getUrl() != null) {
      try {
        joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `authType` to the URL query string
    if (getAuthType() != null) {
      try {
        joiner.add(String.format("%sauthType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAuthType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `username` to the URL query string
    if (getUsername() != null) {
      try {
        joiner.add(String.format("%susername%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUsername()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `password` to the URL query string
    if (getPassword() != null) {
      try {
        joiner.add(String.format("%spassword%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPassword()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `token` to the URL query string
    if (getToken() != null) {
      try {
        joiner.add(String.format("%stoken%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getToken()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `headers` to the URL query string
    if (getHeaders() != null) {
      for (int i = 0; i < getHeaders().size(); i++) {
        if (getHeaders().get(i) != null) {
          joiner.add(getHeaders().get(i).toUrlQueryString(String.format("%sheaders%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `maxRetries` to the URL query string
    if (getMaxRetries() != null) {
      try {
        joiner.add(String.format("%smaxRetries%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxRetries()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `cache` to the URL query string
    if (getCache() != null) {
      try {
        joiner.add(String.format("%scache%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCache()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `modifiedAt` to the URL query string
    if (getModifiedAt() != null) {
      try {
        joiner.add(String.format("%smodifiedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getModifiedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

