/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Data regarding the transactional email account
 */
@JsonPropertyOrder({
  GetAccountAllOfRelayData.JSON_PROPERTY_USER_NAME,
  GetAccountAllOfRelayData.JSON_PROPERTY_RELAY,
  GetAccountAllOfRelayData.JSON_PROPERTY_PORT
})
@JsonTypeName("getAccount_allOf_relay_data")
public class GetAccountAllOfRelayData {
  public static final String JSON_PROPERTY_USER_NAME = "userName";
  @jakarta.annotation.Nonnull
  private String userName;

  public static final String JSON_PROPERTY_RELAY = "relay";
  @jakarta.annotation.Nonnull
  private String relay;

  public static final String JSON_PROPERTY_PORT = "port";
  @jakarta.annotation.Nonnull
  private Integer port;

  public GetAccountAllOfRelayData() {
  }

  public GetAccountAllOfRelayData userName(@jakarta.annotation.Nonnull String userName) {
    
    this.userName = userName;
    return this;
  }

  /**
   * Email to use as login on transactional platform
   * @return userName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUserName() {
    return userName;
  }


  @JsonProperty(JSON_PROPERTY_USER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserName(@jakarta.annotation.Nonnull String userName) {
    this.userName = userName;
  }

  public GetAccountAllOfRelayData relay(@jakarta.annotation.Nonnull String relay) {
    
    this.relay = relay;
    return this;
  }

  /**
   * URL of the SMTP Relay
   * @return relay
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_RELAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getRelay() {
    return relay;
  }


  @JsonProperty(JSON_PROPERTY_RELAY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRelay(@jakarta.annotation.Nonnull String relay) {
    this.relay = relay;
  }

  public GetAccountAllOfRelayData port(@jakarta.annotation.Nonnull Integer port) {
    
    this.port = port;
    return this;
  }

  /**
   * Port used for SMTP Relay
   * @return port
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPort() {
    return port;
  }


  @JsonProperty(JSON_PROPERTY_PORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPort(@jakarta.annotation.Nonnull Integer port) {
    this.port = port;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAccountAllOfRelayData getAccountAllOfRelayData = (GetAccountAllOfRelayData) o;
    return Objects.equals(this.userName, getAccountAllOfRelayData.userName) &&
        Objects.equals(this.relay, getAccountAllOfRelayData.relay) &&
        Objects.equals(this.port, getAccountAllOfRelayData.port);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userName, relay, port);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAccountAllOfRelayData {\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    relay: ").append(toIndentedString(relay)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `userName` to the URL query string
    if (getUserName() != null) {
      try {
        joiner.add(String.format("%suserName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUserName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `relay` to the URL query string
    if (getRelay() != null) {
      try {
        joiner.add(String.format("%srelay%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRelay()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `port` to the URL query string
    if (getPort() != null) {
      try {
        joiner.add(String.format("%sport%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPort()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

