/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * GetAccountAllOfPlan
 */
@JsonPropertyOrder({
  GetAccountAllOfPlan.JSON_PROPERTY_TYPE,
  GetAccountAllOfPlan.JSON_PROPERTY_CREDITS_TYPE,
  GetAccountAllOfPlan.JSON_PROPERTY_CREDITS,
  GetAccountAllOfPlan.JSON_PROPERTY_START_DATE,
  GetAccountAllOfPlan.JSON_PROPERTY_END_DATE
})
@JsonTypeName("getAccount_allOf_plan")
public class GetAccountAllOfPlan {
  /**
   * Displays the plan type of the user
   */
  public enum TypeEnum {
    PAY_AS_YOU_GO(String.valueOf("payAsYouGo")),
    
    FREE(String.valueOf("free")),
    
    SUBSCRIPTION(String.valueOf("subscription")),
    
    SMS(String.valueOf("sms"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nonnull
  private TypeEnum type;

  /**
   * This is the type of the credit, \&quot;Send Limit\&quot; is one of the possible types of credit of a user. \&quot;Send Limit\&quot; implies the total number of emails you can send to the subscribers in your account.
   */
  public enum CreditsTypeEnum {
    SEND_LIMIT(String.valueOf("sendLimit"));

    private String value;

    CreditsTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CreditsTypeEnum fromValue(String value) {
      for (CreditsTypeEnum b : CreditsTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CREDITS_TYPE = "creditsType";
  @jakarta.annotation.Nonnull
  private CreditsTypeEnum creditsType;

  public static final String JSON_PROPERTY_CREDITS = "credits";
  @jakarta.annotation.Nonnull
  private Float credits;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  @jakarta.annotation.Nullable
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  @jakarta.annotation.Nullable
  private LocalDate endDate;

  public GetAccountAllOfPlan() {
  }

  public GetAccountAllOfPlan type(@jakarta.annotation.Nonnull TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Displays the plan type of the user
   * @return type
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(@jakarta.annotation.Nonnull TypeEnum type) {
    this.type = type;
  }

  public GetAccountAllOfPlan creditsType(@jakarta.annotation.Nonnull CreditsTypeEnum creditsType) {
    
    this.creditsType = creditsType;
    return this;
  }

  /**
   * This is the type of the credit, \&quot;Send Limit\&quot; is one of the possible types of credit of a user. \&quot;Send Limit\&quot; implies the total number of emails you can send to the subscribers in your account.
   * @return creditsType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREDITS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CreditsTypeEnum getCreditsType() {
    return creditsType;
  }


  @JsonProperty(JSON_PROPERTY_CREDITS_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreditsType(@jakarta.annotation.Nonnull CreditsTypeEnum creditsType) {
    this.creditsType = creditsType;
  }

  public GetAccountAllOfPlan credits(@jakarta.annotation.Nonnull Float credits) {
    
    this.credits = credits;
    return this;
  }

  /**
   * Remaining credits of the user
   * @return credits
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREDITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Float getCredits() {
    return credits;
  }


  @JsonProperty(JSON_PROPERTY_CREDITS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCredits(@jakarta.annotation.Nonnull Float credits) {
    this.credits = credits;
  }

  public GetAccountAllOfPlan startDate(@jakarta.annotation.Nullable LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

  /**
   * Date of the period from which the plan will start (only available for \&quot;subscription\&quot; plan type)
   * @return startDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(@jakarta.annotation.Nullable LocalDate startDate) {
    this.startDate = startDate;
  }

  public GetAccountAllOfPlan endDate(@jakarta.annotation.Nullable LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

  /**
   * Date of the period from which the plan will end (only available for \&quot;subscription\&quot; plan type)
   * @return endDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(@jakarta.annotation.Nullable LocalDate endDate) {
    this.endDate = endDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetAccountAllOfPlan getAccountAllOfPlan = (GetAccountAllOfPlan) o;
    return Objects.equals(this.type, getAccountAllOfPlan.type) &&
        Objects.equals(this.creditsType, getAccountAllOfPlan.creditsType) &&
        Objects.equals(this.credits, getAccountAllOfPlan.credits) &&
        Objects.equals(this.startDate, getAccountAllOfPlan.startDate) &&
        Objects.equals(this.endDate, getAccountAllOfPlan.endDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, creditsType, credits, startDate, endDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetAccountAllOfPlan {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    creditsType: ").append(toIndentedString(creditsType)).append("\n");
    sb.append("    credits: ").append(toIndentedString(credits)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `creditsType` to the URL query string
    if (getCreditsType() != null) {
      try {
        joiner.add(String.format("%screditsType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreditsType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `credits` to the URL query string
    if (getCredits() != null) {
      try {
        joiner.add(String.format("%scredits%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCredits()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startDate` to the URL query string
    if (getStartDate() != null) {
      try {
        joiner.add(String.format("%sstartDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStartDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `endDate` to the URL query string
    if (getEndDate() != null) {
      try {
        joiner.add(String.format("%sendDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEndDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

