/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Identifies the contact associated with the event. At least one identifier is required.
 */
@JsonPropertyOrder({
  EventIdentifiers.JSON_PROPERTY_EMAIL_ID,
  EventIdentifiers.JSON_PROPERTY_PHONE_ID,
  EventIdentifiers.JSON_PROPERTY_WHATSAPP_ID,
  EventIdentifiers.JSON_PROPERTY_LANDLINE_NUMBER_ID,
  EventIdentifiers.JSON_PROPERTY_EXT_ID
})
@JsonTypeName("event_identifiers")
public class EventIdentifiers {
  public static final String JSON_PROPERTY_EMAIL_ID = "email_id";
  @jakarta.annotation.Nullable
  private String emailId;

  public static final String JSON_PROPERTY_PHONE_ID = "phone_id";
  @jakarta.annotation.Nullable
  private String phoneId;

  public static final String JSON_PROPERTY_WHATSAPP_ID = "whatsapp_id";
  @jakarta.annotation.Nullable
  private String whatsappId;

  public static final String JSON_PROPERTY_LANDLINE_NUMBER_ID = "landline_number_id";
  @jakarta.annotation.Nullable
  private String landlineNumberId;

  public static final String JSON_PROPERTY_EXT_ID = "ext_id";
  @jakarta.annotation.Nullable
  private String extId;

  public EventIdentifiers() {
  }

  public EventIdentifiers emailId(@jakarta.annotation.Nullable String emailId) {
    
    this.emailId = emailId;
    return this;
  }

  /**
   * Email Id associated with the event
   * @return emailId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmailId() {
    return emailId;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailId(@jakarta.annotation.Nullable String emailId) {
    this.emailId = emailId;
  }

  public EventIdentifiers phoneId(@jakarta.annotation.Nullable String phoneId) {
    
    this.phoneId = phoneId;
    return this;
  }

  /**
   * SMS associated with the event
   * @return phoneId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PHONE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhoneId() {
    return phoneId;
  }


  @JsonProperty(JSON_PROPERTY_PHONE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhoneId(@jakarta.annotation.Nullable String phoneId) {
    this.phoneId = phoneId;
  }

  public EventIdentifiers whatsappId(@jakarta.annotation.Nullable String whatsappId) {
    
    this.whatsappId = whatsappId;
    return this;
  }

  /**
   * whatsapp associated with the event
   * @return whatsappId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WHATSAPP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWhatsappId() {
    return whatsappId;
  }


  @JsonProperty(JSON_PROPERTY_WHATSAPP_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWhatsappId(@jakarta.annotation.Nullable String whatsappId) {
    this.whatsappId = whatsappId;
  }

  public EventIdentifiers landlineNumberId(@jakarta.annotation.Nullable String landlineNumberId) {
    
    this.landlineNumberId = landlineNumberId;
    return this;
  }

  /**
   * landline_number associated with the event
   * @return landlineNumberId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LANDLINE_NUMBER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLandlineNumberId() {
    return landlineNumberId;
  }


  @JsonProperty(JSON_PROPERTY_LANDLINE_NUMBER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLandlineNumberId(@jakarta.annotation.Nullable String landlineNumberId) {
    this.landlineNumberId = landlineNumberId;
  }

  public EventIdentifiers extId(@jakarta.annotation.Nullable String extId) {
    
    this.extId = extId;
    return this;
  }

  /**
   * ext_id associated with the event
   * @return extId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExtId() {
    return extId;
  }


  @JsonProperty(JSON_PROPERTY_EXT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExtId(@jakarta.annotation.Nullable String extId) {
    this.extId = extId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EventIdentifiers eventIdentifiers = (EventIdentifiers) o;
    return Objects.equals(this.emailId, eventIdentifiers.emailId) &&
        Objects.equals(this.phoneId, eventIdentifiers.phoneId) &&
        Objects.equals(this.whatsappId, eventIdentifiers.whatsappId) &&
        Objects.equals(this.landlineNumberId, eventIdentifiers.landlineNumberId) &&
        Objects.equals(this.extId, eventIdentifiers.extId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(emailId, phoneId, whatsappId, landlineNumberId, extId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EventIdentifiers {\n");
    sb.append("    emailId: ").append(toIndentedString(emailId)).append("\n");
    sb.append("    phoneId: ").append(toIndentedString(phoneId)).append("\n");
    sb.append("    whatsappId: ").append(toIndentedString(whatsappId)).append("\n");
    sb.append("    landlineNumberId: ").append(toIndentedString(landlineNumberId)).append("\n");
    sb.append("    extId: ").append(toIndentedString(extId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `email_id` to the URL query string
    if (getEmailId() != null) {
      try {
        joiner.add(String.format("%semail_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmailId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `phone_id` to the URL query string
    if (getPhoneId() != null) {
      try {
        joiner.add(String.format("%sphone_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPhoneId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `whatsapp_id` to the URL query string
    if (getWhatsappId() != null) {
      try {
        joiner.add(String.format("%swhatsapp_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWhatsappId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `landline_number_id` to the URL query string
    if (getLandlineNumberId() != null) {
      try {
        joiner.add(String.format("%slandline_number_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLandlineNumberId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ext_id` to the URL query string
    if (getExtId() != null) {
      try {
        joiner.add(String.format("%sext_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExtId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

