/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import software.xdev.brevo.model.EventContactPropertiesValue;
import software.xdev.brevo.model.EventEventPropertiesValue;
import software.xdev.brevo.model.EventIdentifiers;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Event
 */
@JsonPropertyOrder({
  Event.JSON_PROPERTY_EVENT_NAME,
  Event.JSON_PROPERTY_EVENT_DATE,
  Event.JSON_PROPERTY_IDENTIFIERS,
  Event.JSON_PROPERTY_CONTACT_PROPERTIES,
  Event.JSON_PROPERTY_EVENT_PROPERTIES
})
@JsonTypeName("event")
public class Event {
  public static final String JSON_PROPERTY_EVENT_NAME = "event_name";
  @jakarta.annotation.Nonnull
  private String eventName;

  public static final String JSON_PROPERTY_EVENT_DATE = "event_date";
  @jakarta.annotation.Nullable
  private String eventDate;

  public static final String JSON_PROPERTY_IDENTIFIERS = "identifiers";
  @jakarta.annotation.Nonnull
  private EventIdentifiers identifiers;

  public static final String JSON_PROPERTY_CONTACT_PROPERTIES = "contact_properties";
  @jakarta.annotation.Nullable
  private Map<String, EventContactPropertiesValue> contactProperties = new HashMap<>();

  public static final String JSON_PROPERTY_EVENT_PROPERTIES = "event_properties";
  @jakarta.annotation.Nullable
  private Map<String, EventEventPropertiesValue> eventProperties = new HashMap<>();

  public Event() {
  }

  public Event eventName(@jakarta.annotation.Nonnull String eventName) {
    
    this.eventName = eventName;
    return this;
  }

  /**
   * The name of the event that occurred. This is how you will find your event in Brevo. Limited to 255 characters, alphanumerical characters and - _ only.
   * @return eventName
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_EVENT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEventName() {
    return eventName;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEventName(@jakarta.annotation.Nonnull String eventName) {
    this.eventName = eventName;
  }

  public Event eventDate(@jakarta.annotation.Nullable String eventDate) {
    
    this.eventDate = eventDate;
    return this;
  }

  /**
   * Timestamp of when the event occurred (e.g. \&quot;2024-01-24T17:39:57+01:00\&quot;). If no value is passed, the timestamp of the event creation is used.
   * @return eventDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVENT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEventDate() {
    return eventDate;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventDate(@jakarta.annotation.Nullable String eventDate) {
    this.eventDate = eventDate;
  }

  public Event identifiers(@jakarta.annotation.Nonnull EventIdentifiers identifiers) {
    
    this.identifiers = identifiers;
    return this;
  }

  /**
   * Get identifiers
   * @return identifiers
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public EventIdentifiers getIdentifiers() {
    return identifiers;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifiers(@jakarta.annotation.Nonnull EventIdentifiers identifiers) {
    this.identifiers = identifiers;
  }

  public Event contactProperties(@jakarta.annotation.Nullable Map<String, EventContactPropertiesValue> contactProperties) {
    
    this.contactProperties = contactProperties;
    return this;
  }

  public Event putContactPropertiesItem(String key, EventContactPropertiesValue contactPropertiesItem) {
    if (this.contactProperties == null) {
      this.contactProperties = new HashMap<>();
    }
    this.contactProperties.put(key, contactPropertiesItem);
    return this;
  }

  /**
   * Properties defining the state of the contact associated to this event. Useful to update contact attributes defined in your contacts database while passing the event. For example: **\&quot;FIRSTNAME\&quot;: \&quot;Jane\&quot; , \&quot;AGE\&quot;: 37**
   * @return contactProperties
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, EventContactPropertiesValue> getContactProperties() {
    return contactProperties;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactProperties(@jakarta.annotation.Nullable Map<String, EventContactPropertiesValue> contactProperties) {
    this.contactProperties = contactProperties;
  }

  public Event eventProperties(@jakarta.annotation.Nullable Map<String, EventEventPropertiesValue> eventProperties) {
    
    this.eventProperties = eventProperties;
    return this;
  }

  public Event putEventPropertiesItem(String key, EventEventPropertiesValue eventPropertiesItem) {
    if (this.eventProperties == null) {
      this.eventProperties = new HashMap<>();
    }
    this.eventProperties.put(key, eventPropertiesItem);
    return this;
  }

  /**
   * Properties of the event. Top level properties and nested properties can be used to better segment contacts and personalise workflow conditions. The following field type are supported: string, number, boolean (true/false), date (Timestamp e.g. \&quot;2024-01-24T17:39:57+01:00\&quot;). Keys are limited to 255 characters, alphanumerical characters and - _ only. Size is limited to 50Kb.
   * @return eventProperties
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EVENT_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, EventEventPropertiesValue> getEventProperties() {
    return eventProperties;
  }


  @JsonProperty(JSON_PROPERTY_EVENT_PROPERTIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEventProperties(@jakarta.annotation.Nullable Map<String, EventEventPropertiesValue> eventProperties) {
    this.eventProperties = eventProperties;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Event event = (Event) o;
    return Objects.equals(this.eventName, event.eventName) &&
        Objects.equals(this.eventDate, event.eventDate) &&
        Objects.equals(this.identifiers, event.identifiers) &&
        Objects.equals(this.contactProperties, event.contactProperties) &&
        Objects.equals(this.eventProperties, event.eventProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(eventName, eventDate, identifiers, contactProperties, eventProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Event {\n");
    sb.append("    eventName: ").append(toIndentedString(eventName)).append("\n");
    sb.append("    eventDate: ").append(toIndentedString(eventDate)).append("\n");
    sb.append("    identifiers: ").append(toIndentedString(identifiers)).append("\n");
    sb.append("    contactProperties: ").append(toIndentedString(contactProperties)).append("\n");
    sb.append("    eventProperties: ").append(toIndentedString(eventProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `event_name` to the URL query string
    if (getEventName() != null) {
      try {
        joiner.add(String.format("%sevent_name%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEventName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `event_date` to the URL query string
    if (getEventDate() != null) {
      try {
        joiner.add(String.format("%sevent_date%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEventDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `identifiers` to the URL query string
    if (getIdentifiers() != null) {
      joiner.add(getIdentifiers().toUrlQueryString(prefix + "identifiers" + suffix));
    }

    // add `contact_properties` to the URL query string
    if (getContactProperties() != null) {
      for (String _key : getContactProperties().keySet()) {
        if (getContactProperties().get(_key) != null) {
          joiner.add(getContactProperties().get(_key).toUrlQueryString(String.format("%scontact_properties%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    // add `event_properties` to the URL query string
    if (getEventProperties() != null) {
      for (String _key : getEventProperties().keySet()) {
        if (getEventProperties().get(_key) != null) {
          joiner.add(getEventProperties().get(_key).toUrlQueryString(String.format("%sevent_properties%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

