/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Deal Details
 */
@JsonPropertyOrder({
  Deal.JSON_PROPERTY_ID,
  Deal.JSON_PROPERTY_ATTRIBUTES,
  Deal.JSON_PROPERTY_LINKED_CONTACTS_IDS,
  Deal.JSON_PROPERTY_LINKED_COMPANIES_IDS
})
public class Deal {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  @jakarta.annotation.Nullable
  private Object attributes;

  public static final String JSON_PROPERTY_LINKED_CONTACTS_IDS = "linkedContactsIds";
  @jakarta.annotation.Nullable
  private List<Integer> linkedContactsIds = new ArrayList<>();

  public static final String JSON_PROPERTY_LINKED_COMPANIES_IDS = "linkedCompaniesIds";
  @jakarta.annotation.Nullable
  private List<String> linkedCompaniesIds = new ArrayList<>();

  public Deal() {
  }

  public Deal id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique deal id
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public Deal attributes(@jakarta.annotation.Nullable Object attributes) {
    
    this.attributes = attributes;
    return this;
  }

  /**
   * Deal attributes with values
   * @return attributes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(@jakarta.annotation.Nullable Object attributes) {
    this.attributes = attributes;
  }

  public Deal linkedContactsIds(@jakarta.annotation.Nullable List<Integer> linkedContactsIds) {
    
    this.linkedContactsIds = linkedContactsIds;
    return this;
  }

  public Deal addLinkedContactsIdsItem(Integer linkedContactsIdsItem) {
    if (this.linkedContactsIds == null) {
      this.linkedContactsIds = new ArrayList<>();
    }
    this.linkedContactsIds.add(linkedContactsIdsItem);
    return this;
  }

  /**
   * Contact ids for contacts linked to this deal
   * @return linkedContactsIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKED_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getLinkedContactsIds() {
    return linkedContactsIds;
  }


  @JsonProperty(JSON_PROPERTY_LINKED_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinkedContactsIds(@jakarta.annotation.Nullable List<Integer> linkedContactsIds) {
    this.linkedContactsIds = linkedContactsIds;
  }

  public Deal linkedCompaniesIds(@jakarta.annotation.Nullable List<String> linkedCompaniesIds) {
    
    this.linkedCompaniesIds = linkedCompaniesIds;
    return this;
  }

  public Deal addLinkedCompaniesIdsItem(String linkedCompaniesIdsItem) {
    if (this.linkedCompaniesIds == null) {
      this.linkedCompaniesIds = new ArrayList<>();
    }
    this.linkedCompaniesIds.add(linkedCompaniesIdsItem);
    return this;
  }

  /**
   * Companies ids for companies linked to this deal
   * @return linkedCompaniesIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKED_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLinkedCompaniesIds() {
    return linkedCompaniesIds;
  }


  @JsonProperty(JSON_PROPERTY_LINKED_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinkedCompaniesIds(@jakarta.annotation.Nullable List<String> linkedCompaniesIds) {
    this.linkedCompaniesIds = linkedCompaniesIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Deal deal = (Deal) o;
    return Objects.equals(this.id, deal.id) &&
        Objects.equals(this.attributes, deal.attributes) &&
        Objects.equals(this.linkedContactsIds, deal.linkedContactsIds) &&
        Objects.equals(this.linkedCompaniesIds, deal.linkedCompaniesIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, attributes, linkedContactsIds, linkedCompaniesIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Deal {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    linkedContactsIds: ").append(toIndentedString(linkedContactsIds)).append("\n");
    sb.append("    linkedCompaniesIds: ").append(toIndentedString(linkedCompaniesIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      try {
        joiner.add(String.format("%sattributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttributes()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `linkedContactsIds` to the URL query string
    if (getLinkedContactsIds() != null) {
      for (int i = 0; i < getLinkedContactsIds().size(); i++) {
        try {
          joiner.add(String.format("%slinkedContactsIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getLinkedContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `linkedCompaniesIds` to the URL query string
    if (getLinkedCompaniesIds() != null) {
      for (int i = 0; i < getLinkedCompaniesIds().size(); i++) {
        try {
          joiner.add(String.format("%slinkedCompaniesIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getLinkedCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

