/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.TaskReminder;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CrmTasksPostRequest
 */
@JsonPropertyOrder({
  CrmTasksPostRequest.JSON_PROPERTY_NAME,
  CrmTasksPostRequest.JSON_PROPERTY_DURATION,
  CrmTasksPostRequest.JSON_PROPERTY_TASK_TYPE_ID,
  CrmTasksPostRequest.JSON_PROPERTY_DATE,
  CrmTasksPostRequest.JSON_PROPERTY_NOTES,
  CrmTasksPostRequest.JSON_PROPERTY_DONE,
  CrmTasksPostRequest.JSON_PROPERTY_ASSIGN_TO_ID,
  CrmTasksPostRequest.JSON_PROPERTY_CONTACTS_IDS,
  CrmTasksPostRequest.JSON_PROPERTY_DEALS_IDS,
  CrmTasksPostRequest.JSON_PROPERTY_COMPANIES_IDS,
  CrmTasksPostRequest.JSON_PROPERTY_REMINDER
})
@JsonTypeName("_crm_tasks_post_request")
public class CrmTasksPostRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_DURATION = "duration";
  @jakarta.annotation.Nullable
  private Long duration;

  public static final String JSON_PROPERTY_TASK_TYPE_ID = "taskTypeId";
  @jakarta.annotation.Nonnull
  private String taskTypeId;

  public static final String JSON_PROPERTY_DATE = "date";
  @jakarta.annotation.Nonnull
  private OffsetDateTime date;

  public static final String JSON_PROPERTY_NOTES = "notes";
  @jakarta.annotation.Nullable
  private String notes;

  public static final String JSON_PROPERTY_DONE = "done";
  @jakarta.annotation.Nullable
  private Boolean done;

  public static final String JSON_PROPERTY_ASSIGN_TO_ID = "assignToId";
  @jakarta.annotation.Nullable
  private String assignToId;

  public static final String JSON_PROPERTY_CONTACTS_IDS = "contactsIds";
  @jakarta.annotation.Nullable
  private List<Integer> contactsIds = new ArrayList<>();

  public static final String JSON_PROPERTY_DEALS_IDS = "dealsIds";
  @jakarta.annotation.Nullable
  private List<String> dealsIds = new ArrayList<>();

  public static final String JSON_PROPERTY_COMPANIES_IDS = "companiesIds";
  @jakarta.annotation.Nullable
  private List<String> companiesIds = new ArrayList<>();

  public static final String JSON_PROPERTY_REMINDER = "reminder";
  @jakarta.annotation.Nullable
  private TaskReminder reminder;

  public CrmTasksPostRequest() {
  }

  public CrmTasksPostRequest name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of task
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CrmTasksPostRequest duration(@jakarta.annotation.Nullable Long duration) {
    
    this.duration = duration;
    return this;
  }

  /**
   * Duration of task in milliseconds [1 minute &#x3D; 60000 ms]
   * minimum: 0
   * @return duration
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(@jakarta.annotation.Nullable Long duration) {
    this.duration = duration;
  }

  public CrmTasksPostRequest taskTypeId(@jakarta.annotation.Nonnull String taskTypeId) {
    
    this.taskTypeId = taskTypeId;
    return this;
  }

  /**
   * Id for type of task e.g Call / Email / Meeting etc.
   * @return taskTypeId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_TASK_TYPE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTaskTypeId() {
    return taskTypeId;
  }


  @JsonProperty(JSON_PROPERTY_TASK_TYPE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTaskTypeId(@jakarta.annotation.Nonnull String taskTypeId) {
    this.taskTypeId = taskTypeId;
  }

  public CrmTasksPostRequest date(@jakarta.annotation.Nonnull OffsetDateTime date) {
    
    this.date = date;
    return this;
  }

  /**
   * Task due date and time
   * @return date
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetDateTime getDate() {
    return date;
  }


  @JsonProperty(JSON_PROPERTY_DATE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDate(@jakarta.annotation.Nonnull OffsetDateTime date) {
    this.date = date;
  }

  public CrmTasksPostRequest notes(@jakarta.annotation.Nullable String notes) {
    
    this.notes = notes;
    return this;
  }

  /**
   * Notes added to a task
   * @return notes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNotes() {
    return notes;
  }


  @JsonProperty(JSON_PROPERTY_NOTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotes(@jakarta.annotation.Nullable String notes) {
    this.notes = notes;
  }

  public CrmTasksPostRequest done(@jakarta.annotation.Nullable Boolean done) {
    
    this.done = done;
    return this;
  }

  /**
   * Task marked as done
   * @return done
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDone() {
    return done;
  }


  @JsonProperty(JSON_PROPERTY_DONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDone(@jakarta.annotation.Nullable Boolean done) {
    this.done = done;
  }

  public CrmTasksPostRequest assignToId(@jakarta.annotation.Nullable String assignToId) {
    
    this.assignToId = assignToId;
    return this;
  }

  /**
   * To assign a task to a user you can use either the account email or ID.
   * @return assignToId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGN_TO_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAssignToId() {
    return assignToId;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGN_TO_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignToId(@jakarta.annotation.Nullable String assignToId) {
    this.assignToId = assignToId;
  }

  public CrmTasksPostRequest contactsIds(@jakarta.annotation.Nullable List<Integer> contactsIds) {
    
    this.contactsIds = contactsIds;
    return this;
  }

  public CrmTasksPostRequest addContactsIdsItem(Integer contactsIdsItem) {
    if (this.contactsIds == null) {
      this.contactsIds = new ArrayList<>();
    }
    this.contactsIds.add(contactsIdsItem);
    return this;
  }

  /**
   * Contact ids for contacts linked to this task
   * @return contactsIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Integer> getContactsIds() {
    return contactsIds;
  }


  @JsonProperty(JSON_PROPERTY_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactsIds(@jakarta.annotation.Nullable List<Integer> contactsIds) {
    this.contactsIds = contactsIds;
  }

  public CrmTasksPostRequest dealsIds(@jakarta.annotation.Nullable List<String> dealsIds) {
    
    this.dealsIds = dealsIds;
    return this;
  }

  public CrmTasksPostRequest addDealsIdsItem(String dealsIdsItem) {
    if (this.dealsIds == null) {
      this.dealsIds = new ArrayList<>();
    }
    this.dealsIds.add(dealsIdsItem);
    return this;
  }

  /**
   * Deal ids for deals a task is linked to
   * @return dealsIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEALS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getDealsIds() {
    return dealsIds;
  }


  @JsonProperty(JSON_PROPERTY_DEALS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDealsIds(@jakarta.annotation.Nullable List<String> dealsIds) {
    this.dealsIds = dealsIds;
  }

  public CrmTasksPostRequest companiesIds(@jakarta.annotation.Nullable List<String> companiesIds) {
    
    this.companiesIds = companiesIds;
    return this;
  }

  public CrmTasksPostRequest addCompaniesIdsItem(String companiesIdsItem) {
    if (this.companiesIds == null) {
      this.companiesIds = new ArrayList<>();
    }
    this.companiesIds.add(companiesIdsItem);
    return this;
  }

  /**
   * Companies ids for companies a task is linked to
   * @return companiesIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCompaniesIds() {
    return companiesIds;
  }


  @JsonProperty(JSON_PROPERTY_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCompaniesIds(@jakarta.annotation.Nullable List<String> companiesIds) {
    this.companiesIds = companiesIds;
  }

  public CrmTasksPostRequest reminder(@jakarta.annotation.Nullable TaskReminder reminder) {
    
    this.reminder = reminder;
    return this;
  }

  /**
   * Get reminder
   * @return reminder
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REMINDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TaskReminder getReminder() {
    return reminder;
  }


  @JsonProperty(JSON_PROPERTY_REMINDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReminder(@jakarta.annotation.Nullable TaskReminder reminder) {
    this.reminder = reminder;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrmTasksPostRequest crmTasksPostRequest = (CrmTasksPostRequest) o;
    return Objects.equals(this.name, crmTasksPostRequest.name) &&
        Objects.equals(this.duration, crmTasksPostRequest.duration) &&
        Objects.equals(this.taskTypeId, crmTasksPostRequest.taskTypeId) &&
        Objects.equals(this.date, crmTasksPostRequest.date) &&
        Objects.equals(this.notes, crmTasksPostRequest.notes) &&
        Objects.equals(this.done, crmTasksPostRequest.done) &&
        Objects.equals(this.assignToId, crmTasksPostRequest.assignToId) &&
        Objects.equals(this.contactsIds, crmTasksPostRequest.contactsIds) &&
        Objects.equals(this.dealsIds, crmTasksPostRequest.dealsIds) &&
        Objects.equals(this.companiesIds, crmTasksPostRequest.companiesIds) &&
        Objects.equals(this.reminder, crmTasksPostRequest.reminder);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, duration, taskTypeId, date, notes, done, assignToId, contactsIds, dealsIds, companiesIds, reminder);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrmTasksPostRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    taskTypeId: ").append(toIndentedString(taskTypeId)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    notes: ").append(toIndentedString(notes)).append("\n");
    sb.append("    done: ").append(toIndentedString(done)).append("\n");
    sb.append("    assignToId: ").append(toIndentedString(assignToId)).append("\n");
    sb.append("    contactsIds: ").append(toIndentedString(contactsIds)).append("\n");
    sb.append("    dealsIds: ").append(toIndentedString(dealsIds)).append("\n");
    sb.append("    companiesIds: ").append(toIndentedString(companiesIds)).append("\n");
    sb.append("    reminder: ").append(toIndentedString(reminder)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `duration` to the URL query string
    if (getDuration() != null) {
      try {
        joiner.add(String.format("%sduration%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDuration()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `taskTypeId` to the URL query string
    if (getTaskTypeId() != null) {
      try {
        joiner.add(String.format("%staskTypeId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskTypeId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `date` to the URL query string
    if (getDate() != null) {
      try {
        joiner.add(String.format("%sdate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `notes` to the URL query string
    if (getNotes() != null) {
      try {
        joiner.add(String.format("%snotes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getNotes()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `done` to the URL query string
    if (getDone() != null) {
      try {
        joiner.add(String.format("%sdone%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDone()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignToId` to the URL query string
    if (getAssignToId() != null) {
      try {
        joiner.add(String.format("%sassignToId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignToId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactsIds` to the URL query string
    if (getContactsIds() != null) {
      for (int i = 0; i < getContactsIds().size(); i++) {
        try {
          joiner.add(String.format("%scontactsIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `dealsIds` to the URL query string
    if (getDealsIds() != null) {
      for (int i = 0; i < getDealsIds().size(); i++) {
        try {
          joiner.add(String.format("%sdealsIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getDealsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `companiesIds` to the URL query string
    if (getCompaniesIds() != null) {
      for (int i = 0; i < getCompaniesIds().size(); i++) {
        try {
          joiner.add(String.format("%scompaniesIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `reminder` to the URL query string
    if (getReminder() != null) {
      joiner.add(getReminder().toUrlQueryString(prefix + "reminder" + suffix));
    }

    return joiner.toString();
  }

}

