/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CrmDealsPostRequest
 */
@JsonPropertyOrder({
  CrmDealsPostRequest.JSON_PROPERTY_NAME,
  CrmDealsPostRequest.JSON_PROPERTY_ATTRIBUTES,
  CrmDealsPostRequest.JSON_PROPERTY_LINKED_CONTACTS_IDS,
  CrmDealsPostRequest.JSON_PROPERTY_LINKED_COMPANIES_IDS
})
@JsonTypeName("_crm_deals_post_request")
public class CrmDealsPostRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  @jakarta.annotation.Nullable
  private Object attributes;

  public static final String JSON_PROPERTY_LINKED_CONTACTS_IDS = "linkedContactsIds";
  @jakarta.annotation.Nullable
  private List<Long> linkedContactsIds = new ArrayList<>();

  public static final String JSON_PROPERTY_LINKED_COMPANIES_IDS = "linkedCompaniesIds";
  @jakarta.annotation.Nullable
  private List<String> linkedCompaniesIds = new ArrayList<>();

  public CrmDealsPostRequest() {
  }

  public CrmDealsPostRequest name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of deal
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CrmDealsPostRequest attributes(@jakarta.annotation.Nullable Object attributes) {
    
    this.attributes = attributes;
    return this;
  }

  /**
   * Attributes for deal creation  To assign owner of a Deal you can send attributes.deal_owner and utilize the account email or ID.  If you want to create a deal on a specific pipeline and stage you can use the following attributes &#x60;pipeline&#x60; and &#x60;deal_stage&#x60;.  Pipeline and deal_stage are ids you can fetch using this endpoint &#x60;/crm/pipeline/details/{pipelineID}&#x60; 
   * @return attributes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(@jakarta.annotation.Nullable Object attributes) {
    this.attributes = attributes;
  }

  public CrmDealsPostRequest linkedContactsIds(@jakarta.annotation.Nullable List<Long> linkedContactsIds) {
    
    this.linkedContactsIds = linkedContactsIds;
    return this;
  }

  public CrmDealsPostRequest addLinkedContactsIdsItem(Long linkedContactsIdsItem) {
    if (this.linkedContactsIds == null) {
      this.linkedContactsIds = new ArrayList<>();
    }
    this.linkedContactsIds.add(linkedContactsIdsItem);
    return this;
  }

  /**
   * Contact ids to be linked with deal
   * @return linkedContactsIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKED_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Long> getLinkedContactsIds() {
    return linkedContactsIds;
  }


  @JsonProperty(JSON_PROPERTY_LINKED_CONTACTS_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinkedContactsIds(@jakarta.annotation.Nullable List<Long> linkedContactsIds) {
    this.linkedContactsIds = linkedContactsIds;
  }

  public CrmDealsPostRequest linkedCompaniesIds(@jakarta.annotation.Nullable List<String> linkedCompaniesIds) {
    
    this.linkedCompaniesIds = linkedCompaniesIds;
    return this;
  }

  public CrmDealsPostRequest addLinkedCompaniesIdsItem(String linkedCompaniesIdsItem) {
    if (this.linkedCompaniesIds == null) {
      this.linkedCompaniesIds = new ArrayList<>();
    }
    this.linkedCompaniesIds.add(linkedCompaniesIdsItem);
    return this;
  }

  /**
   * Company ids to be linked with deal
   * @return linkedCompaniesIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKED_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLinkedCompaniesIds() {
    return linkedCompaniesIds;
  }


  @JsonProperty(JSON_PROPERTY_LINKED_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinkedCompaniesIds(@jakarta.annotation.Nullable List<String> linkedCompaniesIds) {
    this.linkedCompaniesIds = linkedCompaniesIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrmDealsPostRequest crmDealsPostRequest = (CrmDealsPostRequest) o;
    return Objects.equals(this.name, crmDealsPostRequest.name) &&
        Objects.equals(this.attributes, crmDealsPostRequest.attributes) &&
        Objects.equals(this.linkedContactsIds, crmDealsPostRequest.linkedContactsIds) &&
        Objects.equals(this.linkedCompaniesIds, crmDealsPostRequest.linkedCompaniesIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, attributes, linkedContactsIds, linkedCompaniesIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrmDealsPostRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    linkedContactsIds: ").append(toIndentedString(linkedContactsIds)).append("\n");
    sb.append("    linkedCompaniesIds: ").append(toIndentedString(linkedCompaniesIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      try {
        joiner.add(String.format("%sattributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttributes()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `linkedContactsIds` to the URL query string
    if (getLinkedContactsIds() != null) {
      for (int i = 0; i < getLinkedContactsIds().size(); i++) {
        try {
          joiner.add(String.format("%slinkedContactsIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getLinkedContactsIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `linkedCompaniesIds` to the URL query string
    if (getLinkedCompaniesIds() != null) {
      for (int i = 0; i < getLinkedCompaniesIds().size(); i++) {
        try {
          joiner.add(String.format("%slinkedCompaniesIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getLinkedCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

