/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CrmDealsIdPatchRequest
 */
@JsonPropertyOrder({
  CrmDealsIdPatchRequest.JSON_PROPERTY_NAME,
  CrmDealsIdPatchRequest.JSON_PROPERTY_ATTRIBUTES,
  CrmDealsIdPatchRequest.JSON_PROPERTY_LINKED_CONTACT_IDS,
  CrmDealsIdPatchRequest.JSON_PROPERTY_LINKED_COMPANIES_IDS
})
@JsonTypeName("_crm_deals__id__patch_request")
public class CrmDealsIdPatchRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
  @jakarta.annotation.Nullable
  private Object attributes;

  public static final String JSON_PROPERTY_LINKED_CONTACT_IDS = "linkedContactIds";
  @jakarta.annotation.Nullable
  private List<Long> linkedContactIds = new ArrayList<>();

  public static final String JSON_PROPERTY_LINKED_COMPANIES_IDS = "linkedCompaniesIds";
  @jakarta.annotation.Nullable
  private List<String> linkedCompaniesIds = new ArrayList<>();

  public CrmDealsIdPatchRequest() {
  }

  public CrmDealsIdPatchRequest name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of deal
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public CrmDealsIdPatchRequest attributes(@jakarta.annotation.Nullable Object attributes) {
    
    this.attributes = attributes;
    return this;
  }

  /**
   * Attributes for deal update  To assign owner of a Deal you can send attributes.deal_owner and utilize the account email or ID.  If you wish to update the pipeline of a deal you need to provide the &#x60;pipeline&#x60; and the &#x60;deal_stage&#x60;  Pipeline and deal_stage are ids you can fetch using this endpoint &#x60;/crm/pipeline/details/{pipelineID}&#x60; 
   * @return attributes
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getAttributes() {
    return attributes;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttributes(@jakarta.annotation.Nullable Object attributes) {
    this.attributes = attributes;
  }

  public CrmDealsIdPatchRequest linkedContactIds(@jakarta.annotation.Nullable List<Long> linkedContactIds) {
    
    this.linkedContactIds = linkedContactIds;
    return this;
  }

  public CrmDealsIdPatchRequest addLinkedContactIdsItem(Long linkedContactIdsItem) {
    if (this.linkedContactIds == null) {
      this.linkedContactIds = new ArrayList<>();
    }
    this.linkedContactIds.add(linkedContactIdsItem);
    return this;
  }

  /**
   * Warning - Using PATCH on linkedContactIds replaces the list of linked contacts. Omitted IDs will be removed.
   * @return linkedContactIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKED_CONTACT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<Long> getLinkedContactIds() {
    return linkedContactIds;
  }


  @JsonProperty(JSON_PROPERTY_LINKED_CONTACT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinkedContactIds(@jakarta.annotation.Nullable List<Long> linkedContactIds) {
    this.linkedContactIds = linkedContactIds;
  }

  public CrmDealsIdPatchRequest linkedCompaniesIds(@jakarta.annotation.Nullable List<String> linkedCompaniesIds) {
    
    this.linkedCompaniesIds = linkedCompaniesIds;
    return this;
  }

  public CrmDealsIdPatchRequest addLinkedCompaniesIdsItem(String linkedCompaniesIdsItem) {
    if (this.linkedCompaniesIds == null) {
      this.linkedCompaniesIds = new ArrayList<>();
    }
    this.linkedCompaniesIds.add(linkedCompaniesIdsItem);
    return this;
  }

  /**
   * Warning - Using PATCH on linkedCompaniesIds replaces the list of linked contacts. Omitted IDs will be removed.
   * @return linkedCompaniesIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LINKED_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getLinkedCompaniesIds() {
    return linkedCompaniesIds;
  }


  @JsonProperty(JSON_PROPERTY_LINKED_COMPANIES_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLinkedCompaniesIds(@jakarta.annotation.Nullable List<String> linkedCompaniesIds) {
    this.linkedCompaniesIds = linkedCompaniesIds;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrmDealsIdPatchRequest crmDealsIdPatchRequest = (CrmDealsIdPatchRequest) o;
    return Objects.equals(this.name, crmDealsIdPatchRequest.name) &&
        Objects.equals(this.attributes, crmDealsIdPatchRequest.attributes) &&
        Objects.equals(this.linkedContactIds, crmDealsIdPatchRequest.linkedContactIds) &&
        Objects.equals(this.linkedCompaniesIds, crmDealsIdPatchRequest.linkedCompaniesIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, attributes, linkedContactIds, linkedCompaniesIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrmDealsIdPatchRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    linkedContactIds: ").append(toIndentedString(linkedContactIds)).append("\n");
    sb.append("    linkedCompaniesIds: ").append(toIndentedString(linkedCompaniesIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attributes` to the URL query string
    if (getAttributes() != null) {
      try {
        joiner.add(String.format("%sattributes%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttributes()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `linkedContactIds` to the URL query string
    if (getLinkedContactIds() != null) {
      for (int i = 0; i < getLinkedContactIds().size(); i++) {
        try {
          joiner.add(String.format("%slinkedContactIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getLinkedContactIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `linkedCompaniesIds` to the URL query string
    if (getLinkedCompaniesIds() != null) {
      for (int i = 0; i < getLinkedCompaniesIds().size(); i++) {
        try {
          joiner.add(String.format("%slinkedCompaniesIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getLinkedCompaniesIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

