/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CrmAttributesPostRequest
 */
@JsonPropertyOrder({
  CrmAttributesPostRequest.JSON_PROPERTY_LABEL,
  CrmAttributesPostRequest.JSON_PROPERTY_ATTRIBUTE_TYPE,
  CrmAttributesPostRequest.JSON_PROPERTY_DESCRIPTION,
  CrmAttributesPostRequest.JSON_PROPERTY_OPTIONS_LABELS,
  CrmAttributesPostRequest.JSON_PROPERTY_OBJECT_TYPE
})
@JsonTypeName("_crm_attributes_post_request")
public class CrmAttributesPostRequest {
  public static final String JSON_PROPERTY_LABEL = "label";
  @jakarta.annotation.Nonnull
  private String label;

  /**
   * The type of attribute (must be one of the defined enums)
   */
  public enum AttributeTypeEnum {
    TEXT(String.valueOf("text")),
    
    USER(String.valueOf("user")),
    
    NUMBER(String.valueOf("number")),
    
    SINGLE_SELECT(String.valueOf("single-select")),
    
    DATE(String.valueOf("date")),
    
    BOOLEAN(String.valueOf("boolean")),
    
    MULTI_CHOICE(String.valueOf("multi-choice"));

    private String value;

    AttributeTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static AttributeTypeEnum fromValue(String value) {
      for (AttributeTypeEnum b : AttributeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_ATTRIBUTE_TYPE = "attributeType";
  @jakarta.annotation.Nonnull
  private AttributeTypeEnum attributeType;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_OPTIONS_LABELS = "optionsLabels";
  @jakarta.annotation.Nullable
  private List<String> optionsLabels = new ArrayList<>();

  /**
   * The type of object the attribute belongs to (prefilled with &#x60;companies&#x60; or &#x60;deal&#x60;, mandatory)
   */
  public enum ObjectTypeEnum {
    COMPANIES(String.valueOf("companies")),
    
    DEALS(String.valueOf("deals"));

    private String value;

    ObjectTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ObjectTypeEnum fromValue(String value) {
      for (ObjectTypeEnum b : ObjectTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OBJECT_TYPE = "objectType";
  @jakarta.annotation.Nonnull
  private ObjectTypeEnum objectType;

  public CrmAttributesPostRequest() {
  }

  public CrmAttributesPostRequest label(@jakarta.annotation.Nonnull String label) {
    
    this.label = label;
    return this;
  }

  /**
   * The label for the attribute (max 50 characters, cannot be empty)
   * @return label
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLabel() {
    return label;
  }


  @JsonProperty(JSON_PROPERTY_LABEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLabel(@jakarta.annotation.Nonnull String label) {
    this.label = label;
  }

  public CrmAttributesPostRequest attributeType(@jakarta.annotation.Nonnull AttributeTypeEnum attributeType) {
    
    this.attributeType = attributeType;
    return this;
  }

  /**
   * The type of attribute (must be one of the defined enums)
   * @return attributeType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ATTRIBUTE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public AttributeTypeEnum getAttributeType() {
    return attributeType;
  }


  @JsonProperty(JSON_PROPERTY_ATTRIBUTE_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAttributeType(@jakarta.annotation.Nonnull AttributeTypeEnum attributeType) {
    this.attributeType = attributeType;
  }

  public CrmAttributesPostRequest description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * A description of the attribute
   * @return description
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public CrmAttributesPostRequest optionsLabels(@jakarta.annotation.Nullable List<String> optionsLabels) {
    
    this.optionsLabels = optionsLabels;
    return this;
  }

  public CrmAttributesPostRequest addOptionsLabelsItem(String optionsLabelsItem) {
    if (this.optionsLabels == null) {
      this.optionsLabels = new ArrayList<>();
    }
    this.optionsLabels.add(optionsLabelsItem);
    return this;
  }

  /**
   * Options for multi-choice or single-select attributes
   * @return optionsLabels
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPTIONS_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getOptionsLabels() {
    return optionsLabels;
  }


  @JsonProperty(JSON_PROPERTY_OPTIONS_LABELS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOptionsLabels(@jakarta.annotation.Nullable List<String> optionsLabels) {
    this.optionsLabels = optionsLabels;
  }

  public CrmAttributesPostRequest objectType(@jakarta.annotation.Nonnull ObjectTypeEnum objectType) {
    
    this.objectType = objectType;
    return this;
  }

  /**
   * The type of object the attribute belongs to (prefilled with &#x60;companies&#x60; or &#x60;deal&#x60;, mandatory)
   * @return objectType
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_OBJECT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ObjectTypeEnum getObjectType() {
    return objectType;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setObjectType(@jakarta.annotation.Nonnull ObjectTypeEnum objectType) {
    this.objectType = objectType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CrmAttributesPostRequest crmAttributesPostRequest = (CrmAttributesPostRequest) o;
    return Objects.equals(this.label, crmAttributesPostRequest.label) &&
        Objects.equals(this.attributeType, crmAttributesPostRequest.attributeType) &&
        Objects.equals(this.description, crmAttributesPostRequest.description) &&
        Objects.equals(this.optionsLabels, crmAttributesPostRequest.optionsLabels) &&
        Objects.equals(this.objectType, crmAttributesPostRequest.objectType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(label, attributeType, description, optionsLabels, objectType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CrmAttributesPostRequest {\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    attributeType: ").append(toIndentedString(attributeType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    optionsLabels: ").append(toIndentedString(optionsLabels)).append("\n");
    sb.append("    objectType: ").append(toIndentedString(objectType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `label` to the URL query string
    if (getLabel() != null) {
      try {
        joiner.add(String.format("%slabel%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLabel()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attributeType` to the URL query string
    if (getAttributeType() != null) {
      try {
        joiner.add(String.format("%sattributeType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttributeType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `optionsLabels` to the URL query string
    if (getOptionsLabels() != null) {
      for (int i = 0; i < getOptionsLabels().size(); i++) {
        try {
          joiner.add(String.format("%soptionsLabels%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getOptionsLabels().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `objectType` to the URL query string
    if (getObjectType() != null) {
      try {
        joiner.add(String.format("%sobjectType%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getObjectType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

