/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateWhatsAppTemplate
 */
@JsonPropertyOrder({
  CreateWhatsAppTemplate.JSON_PROPERTY_NAME,
  CreateWhatsAppTemplate.JSON_PROPERTY_LANGUAGE,
  CreateWhatsAppTemplate.JSON_PROPERTY_CATEGORY,
  CreateWhatsAppTemplate.JSON_PROPERTY_MEDIA_URL,
  CreateWhatsAppTemplate.JSON_PROPERTY_BODY_TEXT,
  CreateWhatsAppTemplate.JSON_PROPERTY_HEADER_TEXT,
  CreateWhatsAppTemplate.JSON_PROPERTY_SOURCE
})
@JsonTypeName("createWhatsAppTemplate")
public class CreateWhatsAppTemplate {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  @jakarta.annotation.Nonnull
  private String language;

  /**
   * Category of the template
   */
  public enum CategoryEnum {
    MARKETING(String.valueOf("MARKETING")),
    
    UTILITY(String.valueOf("UTILITY"));

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CATEGORY = "category";
  @jakarta.annotation.Nonnull
  private CategoryEnum category;

  public static final String JSON_PROPERTY_MEDIA_URL = "mediaUrl";
  @jakarta.annotation.Nullable
  private String mediaUrl;

  public static final String JSON_PROPERTY_BODY_TEXT = "bodyText";
  @jakarta.annotation.Nonnull
  private String bodyText;

  public static final String JSON_PROPERTY_HEADER_TEXT = "headerText";
  @jakarta.annotation.Nullable
  private String headerText;

  /**
   * source of the template
   */
  public enum SourceEnum {
    AUTOMATION(String.valueOf("Automation")),
    
    CONVERSATIONS(String.valueOf("Conversations"));

    private String value;

    SourceEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SourceEnum fromValue(String value) {
      for (SourceEnum b : SourceEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SOURCE = "source";
  @jakarta.annotation.Nullable
  private SourceEnum source;

  public CreateWhatsAppTemplate() {
  }

  public CreateWhatsAppTemplate name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the template
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CreateWhatsAppTemplate language(@jakarta.annotation.Nonnull String language) {
    
    this.language = language;
    return this;
  }

  /**
   * Language of the template. For Example : **en** for English 
   * @return language
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLanguage(@jakarta.annotation.Nonnull String language) {
    this.language = language;
  }

  public CreateWhatsAppTemplate category(@jakarta.annotation.Nonnull CategoryEnum category) {
    
    this.category = category;
    return this;
  }

  /**
   * Category of the template
   * @return category
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CategoryEnum getCategory() {
    return category;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCategory(@jakarta.annotation.Nonnull CategoryEnum category) {
    this.category = category;
  }

  public CreateWhatsAppTemplate mediaUrl(@jakarta.annotation.Nullable String mediaUrl) {
    
    this.mediaUrl = mediaUrl;
    return this;
  }

  /**
   * Absolute url of the media file **(no local file)** for the header. **Use this field in you want to add media in Template header and headerText is empty**. Allowed extensions for media files are: #### jpeg | png | mp4 | pdf 
   * @return mediaUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MEDIA_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMediaUrl() {
    return mediaUrl;
  }


  @JsonProperty(JSON_PROPERTY_MEDIA_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMediaUrl(@jakarta.annotation.Nullable String mediaUrl) {
    this.mediaUrl = mediaUrl;
  }

  public CreateWhatsAppTemplate bodyText(@jakarta.annotation.Nonnull String bodyText) {
    
    this.bodyText = bodyText;
    return this;
  }

  /**
   * Body of the template. **Maximum allowed characters are 1024**
   * @return bodyText
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BODY_TEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBodyText() {
    return bodyText;
  }


  @JsonProperty(JSON_PROPERTY_BODY_TEXT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBodyText(@jakarta.annotation.Nonnull String bodyText) {
    this.bodyText = bodyText;
  }

  public CreateWhatsAppTemplate headerText(@jakarta.annotation.Nullable String headerText) {
    
    this.headerText = headerText;
    return this;
  }

  /**
   * Text content of the header in the template. **Maximum allowed characters are 45** **Use this field to add text content in template header and if mediaUrl is empty** 
   * @return headerText
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEADER_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHeaderText() {
    return headerText;
  }


  @JsonProperty(JSON_PROPERTY_HEADER_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeaderText(@jakarta.annotation.Nullable String headerText) {
    this.headerText = headerText;
  }

  public CreateWhatsAppTemplate source(@jakarta.annotation.Nullable SourceEnum source) {
    
    this.source = source;
    return this;
  }

  /**
   * source of the template
   * @return source
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SourceEnum getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSource(@jakarta.annotation.Nullable SourceEnum source) {
    this.source = source;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateWhatsAppTemplate createWhatsAppTemplate = (CreateWhatsAppTemplate) o;
    return Objects.equals(this.name, createWhatsAppTemplate.name) &&
        Objects.equals(this.language, createWhatsAppTemplate.language) &&
        Objects.equals(this.category, createWhatsAppTemplate.category) &&
        Objects.equals(this.mediaUrl, createWhatsAppTemplate.mediaUrl) &&
        Objects.equals(this.bodyText, createWhatsAppTemplate.bodyText) &&
        Objects.equals(this.headerText, createWhatsAppTemplate.headerText) &&
        Objects.equals(this.source, createWhatsAppTemplate.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, language, category, mediaUrl, bodyText, headerText, source);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateWhatsAppTemplate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    mediaUrl: ").append(toIndentedString(mediaUrl)).append("\n");
    sb.append("    bodyText: ").append(toIndentedString(bodyText)).append("\n");
    sb.append("    headerText: ").append(toIndentedString(headerText)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `language` to the URL query string
    if (getLanguage() != null) {
      try {
        joiner.add(String.format("%slanguage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLanguage()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `category` to the URL query string
    if (getCategory() != null) {
      try {
        joiner.add(String.format("%scategory%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCategory()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `mediaUrl` to the URL query string
    if (getMediaUrl() != null) {
      try {
        joiner.add(String.format("%smediaUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMediaUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `bodyText` to the URL query string
    if (getBodyText() != null) {
      try {
        joiner.add(String.format("%sbodyText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBodyText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `headerText` to the URL query string
    if (getHeaderText() != null) {
      try {
        joiner.add(String.format("%sheaderText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHeaderText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `source` to the URL query string
    if (getSource() != null) {
      try {
        joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSource()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

