/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateUpdateProducts
 */
@JsonPropertyOrder({
  CreateUpdateProducts.JSON_PROPERTY_ID,
  CreateUpdateProducts.JSON_PROPERTY_NAME,
  CreateUpdateProducts.JSON_PROPERTY_URL,
  CreateUpdateProducts.JSON_PROPERTY_IMAGE_URL,
  CreateUpdateProducts.JSON_PROPERTY_SKU,
  CreateUpdateProducts.JSON_PROPERTY_PRICE,
  CreateUpdateProducts.JSON_PROPERTY_CATEGORIES,
  CreateUpdateProducts.JSON_PROPERTY_PARENT_ID,
  CreateUpdateProducts.JSON_PROPERTY_META_INFO,
  CreateUpdateProducts.JSON_PROPERTY_DELETED_AT,
  CreateUpdateProducts.JSON_PROPERTY_IS_DELETED,
  CreateUpdateProducts.JSON_PROPERTY_STOCK
})
@JsonTypeName("createUpdateProducts")
public class CreateUpdateProducts {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_URL = "url";
  @jakarta.annotation.Nullable
  private String url;

  public static final String JSON_PROPERTY_IMAGE_URL = "imageUrl";
  @jakarta.annotation.Nullable
  private String imageUrl;

  public static final String JSON_PROPERTY_SKU = "sku";
  @jakarta.annotation.Nullable
  private String sku;

  public static final String JSON_PROPERTY_PRICE = "price";
  @jakarta.annotation.Nullable
  private Float price;

  public static final String JSON_PROPERTY_CATEGORIES = "categories";
  @jakarta.annotation.Nullable
  private List<String> categories = new ArrayList<>();

  public static final String JSON_PROPERTY_PARENT_ID = "parentId";
  @jakarta.annotation.Nullable
  private String parentId;

  public static final String JSON_PROPERTY_META_INFO = "metaInfo";
  @jakarta.annotation.Nullable
  private Map<String, Object> metaInfo = new HashMap<>();

  public static final String JSON_PROPERTY_DELETED_AT = "deletedAt";
  @jakarta.annotation.Nullable
  private String deletedAt;

  public static final String JSON_PROPERTY_IS_DELETED = "isDeleted";
  @jakarta.annotation.Nullable
  private Boolean isDeleted;

  public static final String JSON_PROPERTY_STOCK = "stock";
  @jakarta.annotation.Nullable
  private BigDecimal stock;

  public CreateUpdateProducts() {
  }

  public CreateUpdateProducts id(@jakarta.annotation.Nonnull String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Product ID for which you requested the details
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull String id) {
    this.id = id;
  }

  public CreateUpdateProducts name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Mandatory in case of creation**. Name of the product for which you requested the details
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CreateUpdateProducts url(@jakarta.annotation.Nullable String url) {
    
    this.url = url;
    return this;
  }

  /**
   * URL to the product
   * @return url
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(@jakarta.annotation.Nullable String url) {
    this.url = url;
  }

  public CreateUpdateProducts imageUrl(@jakarta.annotation.Nullable String imageUrl) {
    
    this.imageUrl = imageUrl;
    return this;
  }

  /**
   * Absolute URL to the cover image of the product
   * @return imageUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageUrl() {
    return imageUrl;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageUrl(@jakarta.annotation.Nullable String imageUrl) {
    this.imageUrl = imageUrl;
  }

  public CreateUpdateProducts sku(@jakarta.annotation.Nullable String sku) {
    
    this.sku = sku;
    return this;
  }

  /**
   * Product identifier from the shop
   * @return sku
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SKU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSku() {
    return sku;
  }


  @JsonProperty(JSON_PROPERTY_SKU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSku(@jakarta.annotation.Nullable String sku) {
    this.sku = sku;
  }

  public CreateUpdateProducts price(@jakarta.annotation.Nullable Float price) {
    
    this.price = price;
    return this;
  }

  /**
   * Price of the product
   * @return price
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(@jakarta.annotation.Nullable Float price) {
    this.price = price;
  }

  public CreateUpdateProducts categories(@jakarta.annotation.Nullable List<String> categories) {
    
    this.categories = categories;
    return this;
  }

  public CreateUpdateProducts addCategoriesItem(String categoriesItem) {
    if (this.categories == null) {
      this.categories = new ArrayList<>();
    }
    this.categories.add(categoriesItem);
    return this;
  }

  /**
   * Category ID-s of the product
   * @return categories
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCategories() {
    return categories;
  }


  @JsonProperty(JSON_PROPERTY_CATEGORIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCategories(@jakarta.annotation.Nullable List<String> categories) {
    this.categories = categories;
  }

  public CreateUpdateProducts parentId(@jakarta.annotation.Nullable String parentId) {
    
    this.parentId = parentId;
    return this;
  }

  /**
   * Parent product id of the product
   * @return parentId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getParentId() {
    return parentId;
  }


  @JsonProperty(JSON_PROPERTY_PARENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setParentId(@jakarta.annotation.Nullable String parentId) {
    this.parentId = parentId;
  }

  public CreateUpdateProducts metaInfo(@jakarta.annotation.Nullable Map<String, Object> metaInfo) {
    
    this.metaInfo = metaInfo;
    return this;
  }

  public CreateUpdateProducts putMetaInfoItem(String key, Object metaInfoItem) {
    if (this.metaInfo == null) {
      this.metaInfo = new HashMap<>();
    }
    this.metaInfo.put(key, metaInfoItem);
    return this;
  }

  /**
   * Meta data of product such as description, vendor, producer, stock level. The size of cumulative metaInfo shall not exceed **1000 KB**. Maximum length of metaInfo object can be 20.
   * @return metaInfo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META_INFO)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMetaInfo() {
    return metaInfo;
  }


  @JsonProperty(JSON_PROPERTY_META_INFO)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetaInfo(@jakarta.annotation.Nullable Map<String, Object> metaInfo) {
    this.metaInfo = metaInfo;
  }

  public CreateUpdateProducts deletedAt(@jakarta.annotation.Nullable String deletedAt) {
    
    this.deletedAt = deletedAt;
    return this;
  }

  /**
   * UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) of the product deleted from the shop&#39;s database
   * @return deletedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DELETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeletedAt() {
    return deletedAt;
  }


  @JsonProperty(JSON_PROPERTY_DELETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeletedAt(@jakarta.annotation.Nullable String deletedAt) {
    this.deletedAt = deletedAt;
  }

  public CreateUpdateProducts isDeleted(@jakarta.annotation.Nullable Boolean isDeleted) {
    
    this.isDeleted = isDeleted;
    return this;
  }

  /**
   * product deleted from the shop&#39;s database
   * @return isDeleted
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsDeleted() {
    return isDeleted;
  }


  @JsonProperty(JSON_PROPERTY_IS_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsDeleted(@jakarta.annotation.Nullable Boolean isDeleted) {
    this.isDeleted = isDeleted;
  }

  public CreateUpdateProducts stock(@jakarta.annotation.Nullable BigDecimal stock) {
    
    this.stock = stock;
    return this;
  }

  /**
   * Current stock value of the product from the shop&#39;s database
   * @return stock
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STOCK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getStock() {
    return stock;
  }


  @JsonProperty(JSON_PROPERTY_STOCK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStock(@jakarta.annotation.Nullable BigDecimal stock) {
    this.stock = stock;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateUpdateProducts createUpdateProducts = (CreateUpdateProducts) o;
    return Objects.equals(this.id, createUpdateProducts.id) &&
        Objects.equals(this.name, createUpdateProducts.name) &&
        Objects.equals(this.url, createUpdateProducts.url) &&
        Objects.equals(this.imageUrl, createUpdateProducts.imageUrl) &&
        Objects.equals(this.sku, createUpdateProducts.sku) &&
        Objects.equals(this.price, createUpdateProducts.price) &&
        Objects.equals(this.categories, createUpdateProducts.categories) &&
        Objects.equals(this.parentId, createUpdateProducts.parentId) &&
        Objects.equals(this.metaInfo, createUpdateProducts.metaInfo) &&
        Objects.equals(this.deletedAt, createUpdateProducts.deletedAt) &&
        Objects.equals(this.isDeleted, createUpdateProducts.isDeleted) &&
        Objects.equals(this.stock, createUpdateProducts.stock);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, url, imageUrl, sku, price, categories, parentId, metaInfo, deletedAt, isDeleted, stock);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateUpdateProducts {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    imageUrl: ").append(toIndentedString(imageUrl)).append("\n");
    sb.append("    sku: ").append(toIndentedString(sku)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    categories: ").append(toIndentedString(categories)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    metaInfo: ").append(toIndentedString(metaInfo)).append("\n");
    sb.append("    deletedAt: ").append(toIndentedString(deletedAt)).append("\n");
    sb.append("    isDeleted: ").append(toIndentedString(isDeleted)).append("\n");
    sb.append("    stock: ").append(toIndentedString(stock)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `url` to the URL query string
    if (getUrl() != null) {
      try {
        joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `imageUrl` to the URL query string
    if (getImageUrl() != null) {
      try {
        joiner.add(String.format("%simageUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getImageUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sku` to the URL query string
    if (getSku() != null) {
      try {
        joiner.add(String.format("%ssku%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSku()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `price` to the URL query string
    if (getPrice() != null) {
      try {
        joiner.add(String.format("%sprice%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPrice()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `categories` to the URL query string
    if (getCategories() != null) {
      for (int i = 0; i < getCategories().size(); i++) {
        try {
          joiner.add(String.format("%scategories%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCategories().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `parentId` to the URL query string
    if (getParentId() != null) {
      try {
        joiner.add(String.format("%sparentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getParentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `metaInfo` to the URL query string
    if (getMetaInfo() != null) {
      for (String _key : getMetaInfo().keySet()) {
        try {
          joiner.add(String.format("%smetaInfo%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMetaInfo().get(_key), URLEncoder.encode(String.valueOf(getMetaInfo().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `deletedAt` to the URL query string
    if (getDeletedAt() != null) {
      try {
        joiner.add(String.format("%sdeletedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isDeleted` to the URL query string
    if (getIsDeleted() != null) {
      try {
        joiner.add(String.format("%sisDeleted%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsDeleted()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `stock` to the URL query string
    if (getStock() != null) {
      try {
        joiner.add(String.format("%sstock%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getStock()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

