/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateUpdateCategory
 */
@JsonPropertyOrder({
  CreateUpdateCategory.JSON_PROPERTY_ID,
  CreateUpdateCategory.JSON_PROPERTY_NAME,
  CreateUpdateCategory.JSON_PROPERTY_URL,
  CreateUpdateCategory.JSON_PROPERTY_UPDATE_ENABLED,
  CreateUpdateCategory.JSON_PROPERTY_DELETED_AT,
  CreateUpdateCategory.JSON_PROPERTY_IS_DELETED
})
@JsonTypeName("createUpdateCategory")
public class CreateUpdateCategory {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private String id;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_URL = "url";
  @jakarta.annotation.Nullable
  private String url;

  public static final String JSON_PROPERTY_UPDATE_ENABLED = "updateEnabled";
  @jakarta.annotation.Nullable
  private Boolean updateEnabled = false;

  public static final String JSON_PROPERTY_DELETED_AT = "deletedAt";
  @jakarta.annotation.Nullable
  private String deletedAt;

  public static final String JSON_PROPERTY_IS_DELETED = "isDeleted";
  @jakarta.annotation.Nullable
  private Boolean isDeleted;

  public CreateUpdateCategory() {
  }

  public CreateUpdateCategory id(@jakarta.annotation.Nonnull String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique Category ID as saved in the shop 
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull String id) {
    this.id = id;
  }

  public CreateUpdateCategory name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * **Mandatory in case of creation**. Name of the Category, as displayed in the shop 
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public CreateUpdateCategory url(@jakarta.annotation.Nullable String url) {
    
    this.url = url;
    return this;
  }

  /**
   * URL to the category
   * @return url
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(@jakarta.annotation.Nullable String url) {
    this.url = url;
  }

  public CreateUpdateCategory updateEnabled(@jakarta.annotation.Nullable Boolean updateEnabled) {
    
    this.updateEnabled = updateEnabled;
    return this;
  }

  /**
   * Facilitate to update the existing category in the same request (updateEnabled &#x3D; true)
   * @return updateEnabled
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATE_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUpdateEnabled() {
    return updateEnabled;
  }


  @JsonProperty(JSON_PROPERTY_UPDATE_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdateEnabled(@jakarta.annotation.Nullable Boolean updateEnabled) {
    this.updateEnabled = updateEnabled;
  }

  public CreateUpdateCategory deletedAt(@jakarta.annotation.Nullable String deletedAt) {
    
    this.deletedAt = deletedAt;
    return this;
  }

  /**
   * UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) of the category deleted from the shop&#39;s database
   * @return deletedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DELETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeletedAt() {
    return deletedAt;
  }


  @JsonProperty(JSON_PROPERTY_DELETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeletedAt(@jakarta.annotation.Nullable String deletedAt) {
    this.deletedAt = deletedAt;
  }

  public CreateUpdateCategory isDeleted(@jakarta.annotation.Nullable Boolean isDeleted) {
    
    this.isDeleted = isDeleted;
    return this;
  }

  /**
   * category deleted from the shop&#39;s database
   * @return isDeleted
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsDeleted() {
    return isDeleted;
  }


  @JsonProperty(JSON_PROPERTY_IS_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsDeleted(@jakarta.annotation.Nullable Boolean isDeleted) {
    this.isDeleted = isDeleted;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateUpdateCategory createUpdateCategory = (CreateUpdateCategory) o;
    return Objects.equals(this.id, createUpdateCategory.id) &&
        Objects.equals(this.name, createUpdateCategory.name) &&
        Objects.equals(this.url, createUpdateCategory.url) &&
        Objects.equals(this.updateEnabled, createUpdateCategory.updateEnabled) &&
        Objects.equals(this.deletedAt, createUpdateCategory.deletedAt) &&
        Objects.equals(this.isDeleted, createUpdateCategory.isDeleted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, url, updateEnabled, deletedAt, isDeleted);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateUpdateCategory {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    updateEnabled: ").append(toIndentedString(updateEnabled)).append("\n");
    sb.append("    deletedAt: ").append(toIndentedString(deletedAt)).append("\n");
    sb.append("    isDeleted: ").append(toIndentedString(isDeleted)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `url` to the URL query string
    if (getUrl() != null) {
      try {
        joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updateEnabled` to the URL query string
    if (getUpdateEnabled() != null) {
      try {
        joiner.add(String.format("%supdateEnabled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateEnabled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletedAt` to the URL query string
    if (getDeletedAt() != null) {
      try {
        joiner.add(String.format("%sdeletedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isDeleted` to the URL query string
    if (getIsDeleted() != null) {
      try {
        joiner.add(String.format("%sisDeleted%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsDeleted()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

