/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import software.xdev.brevo.model.Cart;
import software.xdev.brevo.model.ModelConfiguration;
import software.xdev.brevo.model.Notification;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreatePaymentRequest
 */
@JsonPropertyOrder({
  CreatePaymentRequest.JSON_PROPERTY_REFERENCE,
  CreatePaymentRequest.JSON_PROPERTY_CART,
  CreatePaymentRequest.JSON_PROPERTY_CONTACT_ID,
  CreatePaymentRequest.JSON_PROPERTY_DESCRIPTION,
  CreatePaymentRequest.JSON_PROPERTY_NOTIFICATION,
  CreatePaymentRequest.JSON_PROPERTY_CONFIGURATION
})
@JsonTypeName("createPaymentRequest")
public class CreatePaymentRequest {
  public static final String JSON_PROPERTY_REFERENCE = "reference";
  @jakarta.annotation.Nonnull
  private String reference;

  public static final String JSON_PROPERTY_CART = "cart";
  @jakarta.annotation.Nonnull
  private Cart cart;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nonnull
  private Long contactId;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_NOTIFICATION = "notification";
  @jakarta.annotation.Nullable
  private Notification notification;

  public static final String JSON_PROPERTY_CONFIGURATION = "configuration";
  @jakarta.annotation.Nullable
  private ModelConfiguration _configuration;

  public CreatePaymentRequest() {
  }

  public CreatePaymentRequest reference(@jakarta.annotation.Nonnull String reference) {
    
    this.reference = reference;
    return this;
  }

  /**
   * Reference of the payment request, it will appear on the payment page. 
   * @return reference
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getReference() {
    return reference;
  }


  @JsonProperty(JSON_PROPERTY_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setReference(@jakarta.annotation.Nonnull String reference) {
    this.reference = reference;
  }

  public CreatePaymentRequest cart(@jakarta.annotation.Nonnull Cart cart) {
    
    this.cart = cart;
    return this;
  }

  /**
   * Get cart
   * @return cart
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CART)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Cart getCart() {
    return cart;
  }


  @JsonProperty(JSON_PROPERTY_CART)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCart(@jakarta.annotation.Nonnull Cart cart) {
    this.cart = cart;
  }

  public CreatePaymentRequest contactId(@jakarta.annotation.Nonnull Long contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Brevo ID of the contact requested to pay. 
   * @return contactId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactId(@jakarta.annotation.Nonnull Long contactId) {
    this.contactId = contactId;
  }

  public CreatePaymentRequest description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * description of payment request 
   * @return description
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public CreatePaymentRequest notification(@jakarta.annotation.Nullable Notification notification) {
    
    this.notification = notification;
    return this;
  }

  /**
   * Get notification
   * @return notification
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Notification getNotification() {
    return notification;
  }


  @JsonProperty(JSON_PROPERTY_NOTIFICATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNotification(@jakarta.annotation.Nullable Notification notification) {
    this.notification = notification;
  }

  public CreatePaymentRequest _configuration(@jakarta.annotation.Nullable ModelConfiguration _configuration) {
    
    this._configuration = _configuration;
    return this;
  }

  /**
   * Get _configuration
   * @return _configuration
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ModelConfiguration getConfiguration() {
    return _configuration;
  }


  @JsonProperty(JSON_PROPERTY_CONFIGURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfiguration(@jakarta.annotation.Nullable ModelConfiguration _configuration) {
    this._configuration = _configuration;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreatePaymentRequest createPaymentRequest = (CreatePaymentRequest) o;
    return Objects.equals(this.reference, createPaymentRequest.reference) &&
        Objects.equals(this.cart, createPaymentRequest.cart) &&
        Objects.equals(this.contactId, createPaymentRequest.contactId) &&
        Objects.equals(this.description, createPaymentRequest.description) &&
        Objects.equals(this.notification, createPaymentRequest.notification) &&
        Objects.equals(this._configuration, createPaymentRequest._configuration);
  }

  @Override
  public int hashCode() {
    return Objects.hash(reference, cart, contactId, description, notification, _configuration);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreatePaymentRequest {\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    cart: ").append(toIndentedString(cart)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    notification: ").append(toIndentedString(notification)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `reference` to the URL query string
    if (getReference() != null) {
      try {
        joiner.add(String.format("%sreference%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReference()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `cart` to the URL query string
    if (getCart() != null) {
      joiner.add(getCart().toUrlQueryString(prefix + "cart" + suffix));
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `notification` to the URL query string
    if (getNotification() != null) {
      joiner.add(getNotification().toUrlQueryString(prefix + "notification" + suffix));
    }

    // add `configuration` to the URL query string
    if (getConfiguration() != null) {
      joiner.add(getConfiguration().toUrlQueryString(prefix + "configuration" + suffix));
    }

    return joiner.toString();
  }

}

