/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Payload for creating an order linked to a balance definition.
 */
@JsonPropertyOrder({
  CreateOrderPayload.JSON_PROPERTY_AMOUNT,
  CreateOrderPayload.JSON_PROPERTY_BALANCE_DEFINITION_ID,
  CreateOrderPayload.JSON_PROPERTY_CONTACT_ID,
  CreateOrderPayload.JSON_PROPERTY_DUE_AT,
  CreateOrderPayload.JSON_PROPERTY_EXPIRES_AT,
  CreateOrderPayload.JSON_PROPERTY_META,
  CreateOrderPayload.JSON_PROPERTY_SOURCE
})
@JsonTypeName("createOrderPayload")
public class CreateOrderPayload {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nonnull
  private BigDecimal amount;

  public static final String JSON_PROPERTY_BALANCE_DEFINITION_ID = "balanceDefinitionId";
  @jakarta.annotation.Nonnull
  private String balanceDefinitionId;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nonnull
  private Integer contactId;

  public static final String JSON_PROPERTY_DUE_AT = "dueAt";
  @jakarta.annotation.Nonnull
  private String dueAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  @jakarta.annotation.Nullable
  private String expiresAt;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_SOURCE = "source";
  @jakarta.annotation.Nonnull
  private String source;

  public CreateOrderPayload() {
  }

  public CreateOrderPayload amount(@jakarta.annotation.Nonnull BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Order amount (must be non-zero).
   * @return amount
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(@jakarta.annotation.Nonnull BigDecimal amount) {
    this.amount = amount;
  }

  public CreateOrderPayload balanceDefinitionId(@jakarta.annotation.Nonnull String balanceDefinitionId) {
    
    this.balanceDefinitionId = balanceDefinitionId;
    return this;
  }

  /**
   * Unique identifier (UUID) of the associated balance definition.
   * @return balanceDefinitionId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getBalanceDefinitionId() {
    return balanceDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBalanceDefinitionId(@jakarta.annotation.Nonnull String balanceDefinitionId) {
    this.balanceDefinitionId = balanceDefinitionId;
  }

  public CreateOrderPayload contactId(@jakarta.annotation.Nonnull Integer contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Unique identifier of the contact placing the order (must be ≥ 1).
   * minimum: 1
   * @return contactId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactId(@jakarta.annotation.Nonnull Integer contactId) {
    this.contactId = contactId;
  }

  public CreateOrderPayload dueAt(@jakarta.annotation.Nonnull String dueAt) {
    
    this.dueAt = dueAt;
    return this;
  }

  /**
   * RFC3339 timestamp specifying when the order is due.
   * @return dueAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DUE_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDueAt() {
    return dueAt;
  }


  @JsonProperty(JSON_PROPERTY_DUE_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDueAt(@jakarta.annotation.Nonnull String dueAt) {
    this.dueAt = dueAt;
  }

  public CreateOrderPayload expiresAt(@jakarta.annotation.Nullable String expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * Optional RFC3339 timestamp defining order expiration.
   * @return expiresAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(@jakarta.annotation.Nullable String expiresAt) {
    this.expiresAt = expiresAt;
  }

  public CreateOrderPayload meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public CreateOrderPayload putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Optional metadata associated with the order.
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public CreateOrderPayload source(@jakarta.annotation.Nonnull String source) {
    
    this.source = source;
    return this;
  }

  /**
   * Specifies the origin of the order (&#x60;engine&#x60; or &#x60;user&#x60;).
   * @return source
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSource() {
    return source;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSource(@jakarta.annotation.Nonnull String source) {
    this.source = source;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateOrderPayload createOrderPayload = (CreateOrderPayload) o;
    return Objects.equals(this.amount, createOrderPayload.amount) &&
        Objects.equals(this.balanceDefinitionId, createOrderPayload.balanceDefinitionId) &&
        Objects.equals(this.contactId, createOrderPayload.contactId) &&
        Objects.equals(this.dueAt, createOrderPayload.dueAt) &&
        Objects.equals(this.expiresAt, createOrderPayload.expiresAt) &&
        Objects.equals(this.meta, createOrderPayload.meta) &&
        Objects.equals(this.source, createOrderPayload.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, balanceDefinitionId, contactId, dueAt, expiresAt, meta, source);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderPayload {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balanceDefinitionId: ").append(toIndentedString(balanceDefinitionId)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    dueAt: ").append(toIndentedString(dueAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `amount` to the URL query string
    if (getAmount() != null) {
      try {
        joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceDefinitionId` to the URL query string
    if (getBalanceDefinitionId() != null) {
      try {
        joiner.add(String.format("%sbalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueAt` to the URL query string
    if (getDueAt() != null) {
      try {
        joiner.add(String.format("%sdueAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expiresAt` to the URL query string
    if (getExpiresAt() != null) {
      try {
        joiner.add(String.format("%sexpiresAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpiresAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `source` to the URL query string
    if (getSource() != null) {
      try {
        joiner.add(String.format("%ssource%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSource()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

