/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import software.xdev.brevo.model.CreateEmailCampaignEmailExpirationDate;
import software.xdev.brevo.model.CreateEmailCampaignRecipients;
import software.xdev.brevo.model.CreateEmailCampaignSender;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateEmailCampaign
 */
@JsonPropertyOrder({
  CreateEmailCampaign.JSON_PROPERTY_TAG,
  CreateEmailCampaign.JSON_PROPERTY_SENDER,
  CreateEmailCampaign.JSON_PROPERTY_NAME,
  CreateEmailCampaign.JSON_PROPERTY_HTML_CONTENT,
  CreateEmailCampaign.JSON_PROPERTY_HTML_URL,
  CreateEmailCampaign.JSON_PROPERTY_TEMPLATE_ID,
  CreateEmailCampaign.JSON_PROPERTY_SCHEDULED_AT,
  CreateEmailCampaign.JSON_PROPERTY_SUBJECT,
  CreateEmailCampaign.JSON_PROPERTY_PREVIEW_TEXT,
  CreateEmailCampaign.JSON_PROPERTY_REPLY_TO,
  CreateEmailCampaign.JSON_PROPERTY_TO_FIELD,
  CreateEmailCampaign.JSON_PROPERTY_RECIPIENTS,
  CreateEmailCampaign.JSON_PROPERTY_ATTACHMENT_URL,
  CreateEmailCampaign.JSON_PROPERTY_INLINE_IMAGE_ACTIVATION,
  CreateEmailCampaign.JSON_PROPERTY_MIRROR_ACTIVE,
  CreateEmailCampaign.JSON_PROPERTY_FOOTER,
  CreateEmailCampaign.JSON_PROPERTY_HEADER,
  CreateEmailCampaign.JSON_PROPERTY_UTM_CAMPAIGN,
  CreateEmailCampaign.JSON_PROPERTY_PARAMS,
  CreateEmailCampaign.JSON_PROPERTY_SEND_AT_BEST_TIME,
  CreateEmailCampaign.JSON_PROPERTY_AB_TESTING,
  CreateEmailCampaign.JSON_PROPERTY_SUBJECT_A,
  CreateEmailCampaign.JSON_PROPERTY_SUBJECT_B,
  CreateEmailCampaign.JSON_PROPERTY_SPLIT_RULE,
  CreateEmailCampaign.JSON_PROPERTY_WINNER_CRITERIA,
  CreateEmailCampaign.JSON_PROPERTY_WINNER_DELAY,
  CreateEmailCampaign.JSON_PROPERTY_IP_WARMUP_ENABLE,
  CreateEmailCampaign.JSON_PROPERTY_INITIAL_QUOTA,
  CreateEmailCampaign.JSON_PROPERTY_INCREASE_RATE,
  CreateEmailCampaign.JSON_PROPERTY_UNSUBSCRIPTION_PAGE_ID,
  CreateEmailCampaign.JSON_PROPERTY_UPDATE_FORM_ID,
  CreateEmailCampaign.JSON_PROPERTY_EMAIL_EXPIRATION_DATE
})
@JsonTypeName("createEmailCampaign")
public class CreateEmailCampaign {
  public static final String JSON_PROPERTY_TAG = "tag";
  @jakarta.annotation.Nullable
  private String tag;

  public static final String JSON_PROPERTY_SENDER = "sender";
  @jakarta.annotation.Nonnull
  private CreateEmailCampaignSender sender;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_HTML_CONTENT = "htmlContent";
  @jakarta.annotation.Nullable
  private String htmlContent;

  public static final String JSON_PROPERTY_HTML_URL = "htmlUrl";
  @jakarta.annotation.Nullable
  private String htmlUrl;

  public static final String JSON_PROPERTY_TEMPLATE_ID = "templateId";
  @jakarta.annotation.Nullable
  private Long templateId;

  public static final String JSON_PROPERTY_SCHEDULED_AT = "scheduledAt";
  @jakarta.annotation.Nullable
  private String scheduledAt;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private String subject;

  public static final String JSON_PROPERTY_PREVIEW_TEXT = "previewText";
  @jakarta.annotation.Nullable
  private String previewText;

  public static final String JSON_PROPERTY_REPLY_TO = "replyTo";
  @jakarta.annotation.Nullable
  private String replyTo;

  public static final String JSON_PROPERTY_TO_FIELD = "toField";
  @jakarta.annotation.Nullable
  private String toField;

  public static final String JSON_PROPERTY_RECIPIENTS = "recipients";
  @jakarta.annotation.Nullable
  private CreateEmailCampaignRecipients recipients;

  public static final String JSON_PROPERTY_ATTACHMENT_URL = "attachmentUrl";
  @jakarta.annotation.Nullable
  private String attachmentUrl;

  public static final String JSON_PROPERTY_INLINE_IMAGE_ACTIVATION = "inlineImageActivation";
  @jakarta.annotation.Nullable
  private Boolean inlineImageActivation = false;

  public static final String JSON_PROPERTY_MIRROR_ACTIVE = "mirrorActive";
  @jakarta.annotation.Nullable
  private Boolean mirrorActive;

  public static final String JSON_PROPERTY_FOOTER = "footer";
  @jakarta.annotation.Nullable
  private String footer;

  public static final String JSON_PROPERTY_HEADER = "header";
  @jakarta.annotation.Nullable
  private String header;

  public static final String JSON_PROPERTY_UTM_CAMPAIGN = "utmCampaign";
  @jakarta.annotation.Nullable
  private String utmCampaign;

  public static final String JSON_PROPERTY_PARAMS = "params";
  @jakarta.annotation.Nullable
  private Map<String, Object> params = new HashMap<>();

  public static final String JSON_PROPERTY_SEND_AT_BEST_TIME = "sendAtBestTime";
  @jakarta.annotation.Nullable
  private Boolean sendAtBestTime = false;

  public static final String JSON_PROPERTY_AB_TESTING = "abTesting";
  @jakarta.annotation.Nullable
  private Boolean abTesting = false;

  public static final String JSON_PROPERTY_SUBJECT_A = "subjectA";
  @jakarta.annotation.Nullable
  private String subjectA;

  public static final String JSON_PROPERTY_SUBJECT_B = "subjectB";
  @jakarta.annotation.Nullable
  private String subjectB;

  public static final String JSON_PROPERTY_SPLIT_RULE = "splitRule";
  @jakarta.annotation.Nullable
  private Long splitRule;

  /**
   * Choose the metrics that will determinate the winning version. **Mandatory if _splitRule_ &gt;&#x3D; 1 and &lt; 50**. If splitRule &#x3D; 50, &#x60;winnerCriteria&#x60; is ignored if passed 
   */
  public enum WinnerCriteriaEnum {
    OPEN(String.valueOf("open")),
    
    CLICK(String.valueOf("click"));

    private String value;

    WinnerCriteriaEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WinnerCriteriaEnum fromValue(String value) {
      for (WinnerCriteriaEnum b : WinnerCriteriaEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WINNER_CRITERIA = "winnerCriteria";
  @jakarta.annotation.Nullable
  private WinnerCriteriaEnum winnerCriteria;

  public static final String JSON_PROPERTY_WINNER_DELAY = "winnerDelay";
  @jakarta.annotation.Nullable
  private Long winnerDelay;

  public static final String JSON_PROPERTY_IP_WARMUP_ENABLE = "ipWarmupEnable";
  @jakarta.annotation.Nullable
  private Boolean ipWarmupEnable = false;

  public static final String JSON_PROPERTY_INITIAL_QUOTA = "initialQuota";
  @jakarta.annotation.Nullable
  private Long initialQuota;

  public static final String JSON_PROPERTY_INCREASE_RATE = "increaseRate";
  @jakarta.annotation.Nullable
  private Long increaseRate;

  public static final String JSON_PROPERTY_UNSUBSCRIPTION_PAGE_ID = "unsubscriptionPageId";
  @jakarta.annotation.Nullable
  private String unsubscriptionPageId;

  public static final String JSON_PROPERTY_UPDATE_FORM_ID = "updateFormId";
  @jakarta.annotation.Nullable
  private String updateFormId;

  public static final String JSON_PROPERTY_EMAIL_EXPIRATION_DATE = "emailExpirationDate";
  @jakarta.annotation.Nullable
  private CreateEmailCampaignEmailExpirationDate emailExpirationDate;

  public CreateEmailCampaign() {
  }

  public CreateEmailCampaign tag(@jakarta.annotation.Nullable String tag) {
    
    this.tag = tag;
    return this;
  }

  /**
   * Tag of the campaign
   * @return tag
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTag() {
    return tag;
  }


  @JsonProperty(JSON_PROPERTY_TAG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTag(@jakarta.annotation.Nullable String tag) {
    this.tag = tag;
  }

  public CreateEmailCampaign sender(@jakarta.annotation.Nonnull CreateEmailCampaignSender sender) {
    
    this.sender = sender;
    return this;
  }

  /**
   * Get sender
   * @return sender
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CreateEmailCampaignSender getSender() {
    return sender;
  }


  @JsonProperty(JSON_PROPERTY_SENDER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSender(@jakarta.annotation.Nonnull CreateEmailCampaignSender sender) {
    this.sender = sender;
  }

  public CreateEmailCampaign name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the campaign
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CreateEmailCampaign htmlContent(@jakarta.annotation.Nullable String htmlContent) {
    
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * Mandatory if htmlUrl and templateId are empty. Body of the message (HTML). 
   * @return htmlContent
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HTML_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHtmlContent() {
    return htmlContent;
  }


  @JsonProperty(JSON_PROPERTY_HTML_CONTENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtmlContent(@jakarta.annotation.Nullable String htmlContent) {
    this.htmlContent = htmlContent;
  }

  public CreateEmailCampaign htmlUrl(@jakarta.annotation.Nullable String htmlUrl) {
    
    this.htmlUrl = htmlUrl;
    return this;
  }

  /**
   * **Mandatory if htmlContent and templateId are empty**. Url to the message (HTML). For example: **https://html.domain.com** 
   * @return htmlUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HTML_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHtmlUrl() {
    return htmlUrl;
  }


  @JsonProperty(JSON_PROPERTY_HTML_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtmlUrl(@jakarta.annotation.Nullable String htmlUrl) {
    this.htmlUrl = htmlUrl;
  }

  public CreateEmailCampaign templateId(@jakarta.annotation.Nullable Long templateId) {
    
    this.templateId = templateId;
    return this;
  }

  /**
   * **Mandatory if htmlContent and htmlUrl are empty**. Id of the transactional email template with status _active_. Used to copy only its content fetched from htmlContent/htmlUrl to an email campaign for RSS feature. 
   * @return templateId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTemplateId() {
    return templateId;
  }


  @JsonProperty(JSON_PROPERTY_TEMPLATE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTemplateId(@jakarta.annotation.Nullable Long templateId) {
    this.templateId = templateId;
  }

  public CreateEmailCampaign scheduledAt(@jakarta.annotation.Nullable String scheduledAt) {
    
    this.scheduledAt = scheduledAt;
    return this;
  }

  /**
   * Sending UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result**. If sendAtBestTime is set to true, your campaign will be sent according to the date passed (ignoring the time part). For example: **2017-06-01T12:30:00+02:00** 
   * @return scheduledAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getScheduledAt() {
    return scheduledAt;
  }


  @JsonProperty(JSON_PROPERTY_SCHEDULED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setScheduledAt(@jakarta.annotation.Nullable String scheduledAt) {
    this.scheduledAt = scheduledAt;
  }

  public CreateEmailCampaign subject(@jakarta.annotation.Nullable String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * Subject of the campaign. **Mandatory if abTesting is false**. Ignored if abTesting is true. 
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable String subject) {
    this.subject = subject;
  }

  public CreateEmailCampaign previewText(@jakarta.annotation.Nullable String previewText) {
    
    this.previewText = previewText;
    return this;
  }

  /**
   * Preview text or preheader of the email campaign
   * @return previewText
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PREVIEW_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreviewText() {
    return previewText;
  }


  @JsonProperty(JSON_PROPERTY_PREVIEW_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreviewText(@jakarta.annotation.Nullable String previewText) {
    this.previewText = previewText;
  }

  public CreateEmailCampaign replyTo(@jakarta.annotation.Nullable String replyTo) {
    
    this.replyTo = replyTo;
    return this;
  }

  /**
   * Email on which the campaign recipients will be able to reply to
   * @return replyTo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReplyTo() {
    return replyTo;
  }


  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplyTo(@jakarta.annotation.Nullable String replyTo) {
    this.replyTo = replyTo;
  }

  public CreateEmailCampaign toField(@jakarta.annotation.Nullable String toField) {
    
    this.toField = toField;
    return this;
  }

  /**
   * To personalize the **To** Field. If you want to include the first name and last name of your recipient, add **{FNAME} {LNAME}**. These contact attributes must already exist in your Brevo account. If input parameter **params** used please use **{{contact.FNAME}} {{contact.LNAME}}** for personalization 
   * @return toField
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TO_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getToField() {
    return toField;
  }


  @JsonProperty(JSON_PROPERTY_TO_FIELD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setToField(@jakarta.annotation.Nullable String toField) {
    this.toField = toField;
  }

  public CreateEmailCampaign recipients(@jakarta.annotation.Nullable CreateEmailCampaignRecipients recipients) {
    
    this.recipients = recipients;
    return this;
  }

  /**
   * Get recipients
   * @return recipients
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateEmailCampaignRecipients getRecipients() {
    return recipients;
  }


  @JsonProperty(JSON_PROPERTY_RECIPIENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRecipients(@jakarta.annotation.Nullable CreateEmailCampaignRecipients recipients) {
    this.recipients = recipients;
  }

  public CreateEmailCampaign attachmentUrl(@jakarta.annotation.Nullable String attachmentUrl) {
    
    this.attachmentUrl = attachmentUrl;
    return this;
  }

  /**
   * Absolute url of the attachment (no local file). Extension allowed: #### xlsx, xls, ods, docx, docm, doc, csv, pdf, txt, gif, jpg, jpeg, png, tif, tiff, rtf, bmp, cgm, css, shtml, html, htm, zip, xml, ppt, pptx, tar, ez, ics, mobi, msg, pub and eps 
   * @return attachmentUrl
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAttachmentUrl() {
    return attachmentUrl;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENT_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachmentUrl(@jakarta.annotation.Nullable String attachmentUrl) {
    this.attachmentUrl = attachmentUrl;
  }

  public CreateEmailCampaign inlineImageActivation(@jakarta.annotation.Nullable Boolean inlineImageActivation) {
    
    this.inlineImageActivation = inlineImageActivation;
    return this;
  }

  /**
   * Use true to embedded the images in your email. Final size of the email should be less than **4MB**. Campaigns with embedded images can _not be sent to more than 5000 contacts_ 
   * @return inlineImageActivation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INLINE_IMAGE_ACTIVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getInlineImageActivation() {
    return inlineImageActivation;
  }


  @JsonProperty(JSON_PROPERTY_INLINE_IMAGE_ACTIVATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInlineImageActivation(@jakarta.annotation.Nullable Boolean inlineImageActivation) {
    this.inlineImageActivation = inlineImageActivation;
  }

  public CreateEmailCampaign mirrorActive(@jakarta.annotation.Nullable Boolean mirrorActive) {
    
    this.mirrorActive = mirrorActive;
    return this;
  }

  /**
   * Use true to enable the mirror link
   * @return mirrorActive
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MIRROR_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMirrorActive() {
    return mirrorActive;
  }


  @JsonProperty(JSON_PROPERTY_MIRROR_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMirrorActive(@jakarta.annotation.Nullable Boolean mirrorActive) {
    this.mirrorActive = mirrorActive;
  }

  public CreateEmailCampaign footer(@jakarta.annotation.Nullable String footer) {
    
    this.footer = footer;
    return this;
  }

  /**
   * Footer of the email campaign
   * @return footer
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFooter() {
    return footer;
  }


  @JsonProperty(JSON_PROPERTY_FOOTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFooter(@jakarta.annotation.Nullable String footer) {
    this.footer = footer;
  }

  public CreateEmailCampaign header(@jakarta.annotation.Nullable String header) {
    
    this.header = header;
    return this;
  }

  /**
   * Header of the email campaign
   * @return header
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHeader() {
    return header;
  }


  @JsonProperty(JSON_PROPERTY_HEADER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeader(@jakarta.annotation.Nullable String header) {
    this.header = header;
  }

  public CreateEmailCampaign utmCampaign(@jakarta.annotation.Nullable String utmCampaign) {
    
    this.utmCampaign = utmCampaign;
    return this;
  }

  /**
   * Customize the utm_campaign value. If this field is empty, the campaign name will be used. Only alphanumeric characters and spaces are allowed
   * @return utmCampaign
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UTM_CAMPAIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUtmCampaign() {
    return utmCampaign;
  }


  @JsonProperty(JSON_PROPERTY_UTM_CAMPAIGN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUtmCampaign(@jakarta.annotation.Nullable String utmCampaign) {
    this.utmCampaign = utmCampaign;
  }

  public CreateEmailCampaign params(@jakarta.annotation.Nullable Map<String, Object> params) {
    
    this.params = params;
    return this;
  }

  public CreateEmailCampaign putParamsItem(String key, Object paramsItem) {
    if (this.params == null) {
      this.params = new HashMap<>();
    }
    this.params.put(key, paramsItem);
    return this;
  }

  /**
   * Pass the set of attributes to customize the type classic campaign. For example: **{\&quot;FNAME\&quot;:\&quot;Joe\&quot;, \&quot;LNAME\&quot;:\&quot;Doe\&quot;}**. Only available if **type** is **classic**. It&#39;s considered only if campaign is in _New Template Language format_. The New Template Language is dependent on the values of **subject, htmlContent/htmlUrl, sender.name &amp; toField** 
   * @return params
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getParams() {
    return params;
  }


  @JsonProperty(JSON_PROPERTY_PARAMS)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setParams(@jakarta.annotation.Nullable Map<String, Object> params) {
    this.params = params;
  }

  public CreateEmailCampaign sendAtBestTime(@jakarta.annotation.Nullable Boolean sendAtBestTime) {
    
    this.sendAtBestTime = sendAtBestTime;
    return this;
  }

  /**
   * Set this to true if you want to send your campaign at best time.
   * @return sendAtBestTime
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEND_AT_BEST_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendAtBestTime() {
    return sendAtBestTime;
  }


  @JsonProperty(JSON_PROPERTY_SEND_AT_BEST_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendAtBestTime(@jakarta.annotation.Nullable Boolean sendAtBestTime) {
    this.sendAtBestTime = sendAtBestTime;
  }

  public CreateEmailCampaign abTesting(@jakarta.annotation.Nullable Boolean abTesting) {
    
    this.abTesting = abTesting;
    return this;
  }

  /**
   * Status of A/B Test. abTesting &#x3D; false means it is disabled &amp; abTesting &#x3D; true means it is enabled. **subjectA, subjectB, splitRule, winnerCriteria &amp; winnerDelay** will be considered when abTesting is set to true. subjectA &amp; subjectB are mandatory together &amp; subject if passed is ignored. **Can be set to true only if sendAtBestTime is false**. You will be able to set up two subject lines for your campaign and send them to a random sample of your total recipients. Half of the test group will receive version A, and the other half will receive version B 
   * @return abTesting
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AB_TESTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAbTesting() {
    return abTesting;
  }


  @JsonProperty(JSON_PROPERTY_AB_TESTING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAbTesting(@jakarta.annotation.Nullable Boolean abTesting) {
    this.abTesting = abTesting;
  }

  public CreateEmailCampaign subjectA(@jakarta.annotation.Nullable String subjectA) {
    
    this.subjectA = subjectA;
    return this;
  }

  /**
   * Subject A of the campaign. **Mandatory if abTesting &#x3D; true**. subjectA &amp; subjectB should have unique value 
   * @return subjectA
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubjectA() {
    return subjectA;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_A)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjectA(@jakarta.annotation.Nullable String subjectA) {
    this.subjectA = subjectA;
  }

  public CreateEmailCampaign subjectB(@jakarta.annotation.Nullable String subjectB) {
    
    this.subjectB = subjectB;
    return this;
  }

  /**
   * Subject B of the campaign. **Mandatory if abTesting &#x3D; true**. subjectA &amp; subjectB should have unique value 
   * @return subjectB
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubjectB() {
    return subjectB;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT_B)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubjectB(@jakarta.annotation.Nullable String subjectB) {
    this.subjectB = subjectB;
  }

  public CreateEmailCampaign splitRule(@jakarta.annotation.Nullable Long splitRule) {
    
    this.splitRule = splitRule;
    return this;
  }

  /**
   * Add the size of your test groups. **Mandatory if abTesting &#x3D; true &amp; &#39;recipients&#39; is passed**. We&#39;ll send version A and B to a random sample of recipients, and then the winning version to everyone else 
   * minimum: 1
   * maximum: 50
   * @return splitRule
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SPLIT_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getSplitRule() {
    return splitRule;
  }


  @JsonProperty(JSON_PROPERTY_SPLIT_RULE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSplitRule(@jakarta.annotation.Nullable Long splitRule) {
    this.splitRule = splitRule;
  }

  public CreateEmailCampaign winnerCriteria(@jakarta.annotation.Nullable WinnerCriteriaEnum winnerCriteria) {
    
    this.winnerCriteria = winnerCriteria;
    return this;
  }

  /**
   * Choose the metrics that will determinate the winning version. **Mandatory if _splitRule_ &gt;&#x3D; 1 and &lt; 50**. If splitRule &#x3D; 50, &#x60;winnerCriteria&#x60; is ignored if passed 
   * @return winnerCriteria
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNER_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WinnerCriteriaEnum getWinnerCriteria() {
    return winnerCriteria;
  }


  @JsonProperty(JSON_PROPERTY_WINNER_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinnerCriteria(@jakarta.annotation.Nullable WinnerCriteriaEnum winnerCriteria) {
    this.winnerCriteria = winnerCriteria;
  }

  public CreateEmailCampaign winnerDelay(@jakarta.annotation.Nullable Long winnerDelay) {
    
    this.winnerDelay = winnerDelay;
    return this;
  }

  /**
   * Choose the duration of the test in hours. Maximum is 7 days, pass 24*7 &#x3D; 168 hours. The winning version will be sent at the end of the test. **Mandatory if _splitRule_ &gt;&#x3D; 1 and &lt; 50**. If splitRule &#x3D; 50, &#x60;winnerDelay&#x60; is ignored if passed 
   * minimum: 1
   * maximum: 168
   * @return winnerDelay
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNER_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getWinnerDelay() {
    return winnerDelay;
  }


  @JsonProperty(JSON_PROPERTY_WINNER_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinnerDelay(@jakarta.annotation.Nullable Long winnerDelay) {
    this.winnerDelay = winnerDelay;
  }

  public CreateEmailCampaign ipWarmupEnable(@jakarta.annotation.Nullable Boolean ipWarmupEnable) {
    
    this.ipWarmupEnable = ipWarmupEnable;
    return this;
  }

  /**
   * **Available for dedicated ip clients**. Set this to true if you wish to warm up your ip. 
   * @return ipWarmupEnable
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IP_WARMUP_ENABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIpWarmupEnable() {
    return ipWarmupEnable;
  }


  @JsonProperty(JSON_PROPERTY_IP_WARMUP_ENABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpWarmupEnable(@jakarta.annotation.Nullable Boolean ipWarmupEnable) {
    this.ipWarmupEnable = ipWarmupEnable;
  }

  public CreateEmailCampaign initialQuota(@jakarta.annotation.Nullable Long initialQuota) {
    
    this.initialQuota = initialQuota;
    return this;
  }

  /**
   * **Mandatory if ipWarmupEnable is set to true**. Set an initial quota greater than 1 for warming up your ip. We recommend you set a value of 3000. 
   * @return initialQuota
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INITIAL_QUOTA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getInitialQuota() {
    return initialQuota;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_QUOTA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialQuota(@jakarta.annotation.Nullable Long initialQuota) {
    this.initialQuota = initialQuota;
  }

  public CreateEmailCampaign increaseRate(@jakarta.annotation.Nullable Long increaseRate) {
    
    this.increaseRate = increaseRate;
    return this;
  }

  /**
   * **Mandatory if ipWarmupEnable is set to true**. Set a percentage increase rate for warming up your ip. We recommend you set the increase rate to 30% per day. If you want to send the same number of emails every day, set the daily increase value to 0%. 
   * minimum: 0
   * maximum: 100
   * @return increaseRate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCREASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getIncreaseRate() {
    return increaseRate;
  }


  @JsonProperty(JSON_PROPERTY_INCREASE_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncreaseRate(@jakarta.annotation.Nullable Long increaseRate) {
    this.increaseRate = increaseRate;
  }

  public CreateEmailCampaign unsubscriptionPageId(@jakarta.annotation.Nullable String unsubscriptionPageId) {
    
    this.unsubscriptionPageId = unsubscriptionPageId;
    return this;
  }

  /**
   * Enter an unsubscription page id. The page id is a 24 digit alphanumeric id that can be found in the URL when editing the page. If not entered, then the default unsubscription page will be used. 
   * @return unsubscriptionPageId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNSUBSCRIPTION_PAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUnsubscriptionPageId() {
    return unsubscriptionPageId;
  }


  @JsonProperty(JSON_PROPERTY_UNSUBSCRIPTION_PAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnsubscriptionPageId(@jakarta.annotation.Nullable String unsubscriptionPageId) {
    this.unsubscriptionPageId = unsubscriptionPageId;
  }

  public CreateEmailCampaign updateFormId(@jakarta.annotation.Nullable String updateFormId) {
    
    this.updateFormId = updateFormId;
    return this;
  }

  /**
   * **Mandatory if templateId is used containing the {{ update_profile }} tag**. Enter an update profile form id. The form id is a 24 digit alphanumeric id that can be found in the URL when editing the form. If not entered, then the default update profile form will be used. 
   * @return updateFormId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATE_FORM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdateFormId() {
    return updateFormId;
  }


  @JsonProperty(JSON_PROPERTY_UPDATE_FORM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdateFormId(@jakarta.annotation.Nullable String updateFormId) {
    this.updateFormId = updateFormId;
  }

  public CreateEmailCampaign emailExpirationDate(@jakarta.annotation.Nullable CreateEmailCampaignEmailExpirationDate emailExpirationDate) {
    
    this.emailExpirationDate = emailExpirationDate;
    return this;
  }

  /**
   * Get emailExpirationDate
   * @return emailExpirationDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CreateEmailCampaignEmailExpirationDate getEmailExpirationDate() {
    return emailExpirationDate;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmailExpirationDate(@jakarta.annotation.Nullable CreateEmailCampaignEmailExpirationDate emailExpirationDate) {
    this.emailExpirationDate = emailExpirationDate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateEmailCampaign createEmailCampaign = (CreateEmailCampaign) o;
    return Objects.equals(this.tag, createEmailCampaign.tag) &&
        Objects.equals(this.sender, createEmailCampaign.sender) &&
        Objects.equals(this.name, createEmailCampaign.name) &&
        Objects.equals(this.htmlContent, createEmailCampaign.htmlContent) &&
        Objects.equals(this.htmlUrl, createEmailCampaign.htmlUrl) &&
        Objects.equals(this.templateId, createEmailCampaign.templateId) &&
        Objects.equals(this.scheduledAt, createEmailCampaign.scheduledAt) &&
        Objects.equals(this.subject, createEmailCampaign.subject) &&
        Objects.equals(this.previewText, createEmailCampaign.previewText) &&
        Objects.equals(this.replyTo, createEmailCampaign.replyTo) &&
        Objects.equals(this.toField, createEmailCampaign.toField) &&
        Objects.equals(this.recipients, createEmailCampaign.recipients) &&
        Objects.equals(this.attachmentUrl, createEmailCampaign.attachmentUrl) &&
        Objects.equals(this.inlineImageActivation, createEmailCampaign.inlineImageActivation) &&
        Objects.equals(this.mirrorActive, createEmailCampaign.mirrorActive) &&
        Objects.equals(this.footer, createEmailCampaign.footer) &&
        Objects.equals(this.header, createEmailCampaign.header) &&
        Objects.equals(this.utmCampaign, createEmailCampaign.utmCampaign) &&
        Objects.equals(this.params, createEmailCampaign.params) &&
        Objects.equals(this.sendAtBestTime, createEmailCampaign.sendAtBestTime) &&
        Objects.equals(this.abTesting, createEmailCampaign.abTesting) &&
        Objects.equals(this.subjectA, createEmailCampaign.subjectA) &&
        Objects.equals(this.subjectB, createEmailCampaign.subjectB) &&
        Objects.equals(this.splitRule, createEmailCampaign.splitRule) &&
        Objects.equals(this.winnerCriteria, createEmailCampaign.winnerCriteria) &&
        Objects.equals(this.winnerDelay, createEmailCampaign.winnerDelay) &&
        Objects.equals(this.ipWarmupEnable, createEmailCampaign.ipWarmupEnable) &&
        Objects.equals(this.initialQuota, createEmailCampaign.initialQuota) &&
        Objects.equals(this.increaseRate, createEmailCampaign.increaseRate) &&
        Objects.equals(this.unsubscriptionPageId, createEmailCampaign.unsubscriptionPageId) &&
        Objects.equals(this.updateFormId, createEmailCampaign.updateFormId) &&
        Objects.equals(this.emailExpirationDate, createEmailCampaign.emailExpirationDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tag, sender, name, htmlContent, htmlUrl, templateId, scheduledAt, subject, previewText, replyTo, toField, recipients, attachmentUrl, inlineImageActivation, mirrorActive, footer, header, utmCampaign, params, sendAtBestTime, abTesting, subjectA, subjectB, splitRule, winnerCriteria, winnerDelay, ipWarmupEnable, initialQuota, increaseRate, unsubscriptionPageId, updateFormId, emailExpirationDate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateEmailCampaign {\n");
    sb.append("    tag: ").append(toIndentedString(tag)).append("\n");
    sb.append("    sender: ").append(toIndentedString(sender)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    htmlContent: ").append(toIndentedString(htmlContent)).append("\n");
    sb.append("    htmlUrl: ").append(toIndentedString(htmlUrl)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("    scheduledAt: ").append(toIndentedString(scheduledAt)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    previewText: ").append(toIndentedString(previewText)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    toField: ").append(toIndentedString(toField)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    attachmentUrl: ").append(toIndentedString(attachmentUrl)).append("\n");
    sb.append("    inlineImageActivation: ").append(toIndentedString(inlineImageActivation)).append("\n");
    sb.append("    mirrorActive: ").append(toIndentedString(mirrorActive)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    utmCampaign: ").append(toIndentedString(utmCampaign)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("    sendAtBestTime: ").append(toIndentedString(sendAtBestTime)).append("\n");
    sb.append("    abTesting: ").append(toIndentedString(abTesting)).append("\n");
    sb.append("    subjectA: ").append(toIndentedString(subjectA)).append("\n");
    sb.append("    subjectB: ").append(toIndentedString(subjectB)).append("\n");
    sb.append("    splitRule: ").append(toIndentedString(splitRule)).append("\n");
    sb.append("    winnerCriteria: ").append(toIndentedString(winnerCriteria)).append("\n");
    sb.append("    winnerDelay: ").append(toIndentedString(winnerDelay)).append("\n");
    sb.append("    ipWarmupEnable: ").append(toIndentedString(ipWarmupEnable)).append("\n");
    sb.append("    initialQuota: ").append(toIndentedString(initialQuota)).append("\n");
    sb.append("    increaseRate: ").append(toIndentedString(increaseRate)).append("\n");
    sb.append("    unsubscriptionPageId: ").append(toIndentedString(unsubscriptionPageId)).append("\n");
    sb.append("    updateFormId: ").append(toIndentedString(updateFormId)).append("\n");
    sb.append("    emailExpirationDate: ").append(toIndentedString(emailExpirationDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `tag` to the URL query string
    if (getTag() != null) {
      try {
        joiner.add(String.format("%stag%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTag()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `sender` to the URL query string
    if (getSender() != null) {
      joiner.add(getSender().toUrlQueryString(prefix + "sender" + suffix));
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `htmlContent` to the URL query string
    if (getHtmlContent() != null) {
      try {
        joiner.add(String.format("%shtmlContent%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHtmlContent()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `htmlUrl` to the URL query string
    if (getHtmlUrl() != null) {
      try {
        joiner.add(String.format("%shtmlUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHtmlUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `templateId` to the URL query string
    if (getTemplateId() != null) {
      try {
        joiner.add(String.format("%stemplateId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTemplateId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `scheduledAt` to the URL query string
    if (getScheduledAt() != null) {
      try {
        joiner.add(String.format("%sscheduledAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getScheduledAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      try {
        joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `previewText` to the URL query string
    if (getPreviewText() != null) {
      try {
        joiner.add(String.format("%spreviewText%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPreviewText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `replyTo` to the URL query string
    if (getReplyTo() != null) {
      try {
        joiner.add(String.format("%sreplyTo%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReplyTo()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `toField` to the URL query string
    if (getToField() != null) {
      try {
        joiner.add(String.format("%stoField%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getToField()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `recipients` to the URL query string
    if (getRecipients() != null) {
      joiner.add(getRecipients().toUrlQueryString(prefix + "recipients" + suffix));
    }

    // add `attachmentUrl` to the URL query string
    if (getAttachmentUrl() != null) {
      try {
        joiner.add(String.format("%sattachmentUrl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAttachmentUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `inlineImageActivation` to the URL query string
    if (getInlineImageActivation() != null) {
      try {
        joiner.add(String.format("%sinlineImageActivation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInlineImageActivation()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `mirrorActive` to the URL query string
    if (getMirrorActive() != null) {
      try {
        joiner.add(String.format("%smirrorActive%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMirrorActive()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `footer` to the URL query string
    if (getFooter() != null) {
      try {
        joiner.add(String.format("%sfooter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFooter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `header` to the URL query string
    if (getHeader() != null) {
      try {
        joiner.add(String.format("%sheader%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHeader()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `utmCampaign` to the URL query string
    if (getUtmCampaign() != null) {
      try {
        joiner.add(String.format("%sutmCampaign%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUtmCampaign()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `params` to the URL query string
    if (getParams() != null) {
      for (String _key : getParams().keySet()) {
        try {
          joiner.add(String.format("%sparams%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getParams().get(_key), URLEncoder.encode(String.valueOf(getParams().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `sendAtBestTime` to the URL query string
    if (getSendAtBestTime() != null) {
      try {
        joiner.add(String.format("%ssendAtBestTime%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSendAtBestTime()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `abTesting` to the URL query string
    if (getAbTesting() != null) {
      try {
        joiner.add(String.format("%sabTesting%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAbTesting()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subjectA` to the URL query string
    if (getSubjectA() != null) {
      try {
        joiner.add(String.format("%ssubjectA%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubjectA()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subjectB` to the URL query string
    if (getSubjectB() != null) {
      try {
        joiner.add(String.format("%ssubjectB%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubjectB()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `splitRule` to the URL query string
    if (getSplitRule() != null) {
      try {
        joiner.add(String.format("%ssplitRule%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSplitRule()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winnerCriteria` to the URL query string
    if (getWinnerCriteria() != null) {
      try {
        joiner.add(String.format("%swinnerCriteria%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinnerCriteria()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winnerDelay` to the URL query string
    if (getWinnerDelay() != null) {
      try {
        joiner.add(String.format("%swinnerDelay%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinnerDelay()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `ipWarmupEnable` to the URL query string
    if (getIpWarmupEnable() != null) {
      try {
        joiner.add(String.format("%sipWarmupEnable%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIpWarmupEnable()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `initialQuota` to the URL query string
    if (getInitialQuota() != null) {
      try {
        joiner.add(String.format("%sinitialQuota%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getInitialQuota()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `increaseRate` to the URL query string
    if (getIncreaseRate() != null) {
      try {
        joiner.add(String.format("%sincreaseRate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIncreaseRate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unsubscriptionPageId` to the URL query string
    if (getUnsubscriptionPageId() != null) {
      try {
        joiner.add(String.format("%sunsubscriptionPageId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnsubscriptionPageId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updateFormId` to the URL query string
    if (getUpdateFormId() != null) {
      try {
        joiner.add(String.format("%supdateFormId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdateFormId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `emailExpirationDate` to the URL query string
    if (getEmailExpirationDate() != null) {
      joiner.add(getEmailExpirationDate().toUrlQueryString(prefix + "emailExpirationDate" + suffix));
    }

    return joiner.toString();
  }

}

