/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateCouponCollectionRequest
 */
@JsonPropertyOrder({
  CreateCouponCollectionRequest.JSON_PROPERTY_NAME,
  CreateCouponCollectionRequest.JSON_PROPERTY_DEFAULT_COUPON,
  CreateCouponCollectionRequest.JSON_PROPERTY_EXPIRATION_DATE,
  CreateCouponCollectionRequest.JSON_PROPERTY_REMAINING_DAYS_ALERT,
  CreateCouponCollectionRequest.JSON_PROPERTY_REMAINING_COUPONS_ALERT
})
@JsonTypeName("createCouponCollection_request")
public class CreateCouponCollectionRequest {
  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nonnull
  private String name;

  public static final String JSON_PROPERTY_DEFAULT_COUPON = "defaultCoupon";
  @jakarta.annotation.Nonnull
  private String defaultCoupon;

  public static final String JSON_PROPERTY_EXPIRATION_DATE = "expirationDate";
  @jakarta.annotation.Nullable
  private OffsetDateTime expirationDate;

  public static final String JSON_PROPERTY_REMAINING_DAYS_ALERT = "remainingDaysAlert";
  @jakarta.annotation.Nullable
  private Integer remainingDaysAlert;

  public static final String JSON_PROPERTY_REMAINING_COUPONS_ALERT = "remainingCouponsAlert";
  @jakarta.annotation.Nullable
  private Integer remainingCouponsAlert;

  public CreateCouponCollectionRequest() {
  }

  public CreateCouponCollectionRequest name(@jakarta.annotation.Nonnull String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the coupons collection
   * @return name
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(@jakarta.annotation.Nonnull String name) {
    this.name = name;
  }

  public CreateCouponCollectionRequest defaultCoupon(@jakarta.annotation.Nonnull String defaultCoupon) {
    
    this.defaultCoupon = defaultCoupon;
    return this;
  }

  /**
   * Default coupons collection name
   * @return defaultCoupon
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DEFAULT_COUPON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDefaultCoupon() {
    return defaultCoupon;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_COUPON)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDefaultCoupon(@jakarta.annotation.Nonnull String defaultCoupon) {
    this.defaultCoupon = defaultCoupon;
  }

  public CreateCouponCollectionRequest expirationDate(@jakarta.annotation.Nullable OffsetDateTime expirationDate) {
    
    this.expirationDate = expirationDate;
    return this;
  }

  /**
   * Specify an expiration date for the coupon collection in RFC3339 format. Use null to remove the expiration date.
   * @return expirationDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getExpirationDate() {
    return expirationDate;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpirationDate(@jakarta.annotation.Nullable OffsetDateTime expirationDate) {
    this.expirationDate = expirationDate;
  }

  public CreateCouponCollectionRequest remainingDaysAlert(@jakarta.annotation.Nullable Integer remainingDaysAlert) {
    
    this.remainingDaysAlert = remainingDaysAlert;
    return this;
  }

  /**
   * Send a notification alert (email) when the remaining days until the expiration date are equal or fall bellow this number. Use null to disable alerts.
   * @return remainingDaysAlert
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REMAINING_DAYS_ALERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRemainingDaysAlert() {
    return remainingDaysAlert;
  }


  @JsonProperty(JSON_PROPERTY_REMAINING_DAYS_ALERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemainingDaysAlert(@jakarta.annotation.Nullable Integer remainingDaysAlert) {
    this.remainingDaysAlert = remainingDaysAlert;
  }

  public CreateCouponCollectionRequest remainingCouponsAlert(@jakarta.annotation.Nullable Integer remainingCouponsAlert) {
    
    this.remainingCouponsAlert = remainingCouponsAlert;
    return this;
  }

  /**
   * Send a notification alert (email) when the remaining coupons count is equal or fall bellow this number. Use null to disable alerts.
   * @return remainingCouponsAlert
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REMAINING_COUPONS_ALERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getRemainingCouponsAlert() {
    return remainingCouponsAlert;
  }


  @JsonProperty(JSON_PROPERTY_REMAINING_COUPONS_ALERT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRemainingCouponsAlert(@jakarta.annotation.Nullable Integer remainingCouponsAlert) {
    this.remainingCouponsAlert = remainingCouponsAlert;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCouponCollectionRequest createCouponCollectionRequest = (CreateCouponCollectionRequest) o;
    return Objects.equals(this.name, createCouponCollectionRequest.name) &&
        Objects.equals(this.defaultCoupon, createCouponCollectionRequest.defaultCoupon) &&
        Objects.equals(this.expirationDate, createCouponCollectionRequest.expirationDate) &&
        Objects.equals(this.remainingDaysAlert, createCouponCollectionRequest.remainingDaysAlert) &&
        Objects.equals(this.remainingCouponsAlert, createCouponCollectionRequest.remainingCouponsAlert);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, defaultCoupon, expirationDate, remainingDaysAlert, remainingCouponsAlert);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCouponCollectionRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    defaultCoupon: ").append(toIndentedString(defaultCoupon)).append("\n");
    sb.append("    expirationDate: ").append(toIndentedString(expirationDate)).append("\n");
    sb.append("    remainingDaysAlert: ").append(toIndentedString(remainingDaysAlert)).append("\n");
    sb.append("    remainingCouponsAlert: ").append(toIndentedString(remainingCouponsAlert)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `defaultCoupon` to the URL query string
    if (getDefaultCoupon() != null) {
      try {
        joiner.add(String.format("%sdefaultCoupon%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDefaultCoupon()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expirationDate` to the URL query string
    if (getExpirationDate() != null) {
      try {
        joiner.add(String.format("%sexpirationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpirationDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `remainingDaysAlert` to the URL query string
    if (getRemainingDaysAlert() != null) {
      try {
        joiner.add(String.format("%sremainingDaysAlert%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemainingDaysAlert()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `remainingCouponsAlert` to the URL query string
    if (getRemainingCouponsAlert() != null) {
      try {
        joiner.add(String.format("%sremainingCouponsAlert%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRemainingCouponsAlert()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

