/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.CreateAttributeEnumerationInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateAttribute
 */
@JsonPropertyOrder({
  CreateAttribute.JSON_PROPERTY_VALUE,
  CreateAttribute.JSON_PROPERTY_IS_RECURRING,
  CreateAttribute.JSON_PROPERTY_ENUMERATION,
  CreateAttribute.JSON_PROPERTY_MULTI_CATEGORY_OPTIONS,
  CreateAttribute.JSON_PROPERTY_TYPE
})
@JsonTypeName("createAttribute")
public class CreateAttribute {
  public static final String JSON_PROPERTY_VALUE = "value";
  @jakarta.annotation.Nullable
  private String value;

  public static final String JSON_PROPERTY_IS_RECURRING = "isRecurring";
  @jakarta.annotation.Nullable
  private Boolean isRecurring;

  public static final String JSON_PROPERTY_ENUMERATION = "enumeration";
  @jakarta.annotation.Nullable
  private List<CreateAttributeEnumerationInner> enumeration = new ArrayList<>();

  public static final String JSON_PROPERTY_MULTI_CATEGORY_OPTIONS = "multiCategoryOptions";
  @jakarta.annotation.Nullable
  private List<String> multiCategoryOptions = new ArrayList<>();

  /**
   * Type of the attribute. **Use only if the attribute&#39;s category is &#39;normal&#39;, &#39;category&#39; or &#39;transactional&#39;** Type **user and multiple-choice** is only available if the category is **normal** attribute Type **id** is only available if the category is **transactional** attribute Type **category** is only available if the category is **category** attribute 
   */
  public enum TypeEnum {
    TEXT(String.valueOf("text")),
    
    DATE(String.valueOf("date")),
    
    FLOAT(String.valueOf("float")),
    
    BOOLEAN(String.valueOf("boolean")),
    
    ID(String.valueOf("id")),
    
    CATEGORY(String.valueOf("category")),
    
    MULTIPLE_CHOICE(String.valueOf("multiple-choice")),
    
    USER(String.valueOf("user"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nullable
  private TypeEnum type;

  public CreateAttribute() {
  }

  public CreateAttribute value(@jakarta.annotation.Nullable String value) {
    
    this.value = value;
    return this;
  }

  /**
   * Value of the attribute. **Use only if the attribute&#39;s category is &#39;calculated&#39; or &#39;global&#39;** 
   * @return value
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(@jakarta.annotation.Nullable String value) {
    this.value = value;
  }

  public CreateAttribute isRecurring(@jakarta.annotation.Nullable Boolean isRecurring) {
    
    this.isRecurring = isRecurring;
    return this;
  }

  /**
   * Type of the attribute. **Use only if the attribute&#39;s category is &#39;calculated&#39; or &#39;global&#39;** 
   * @return isRecurring
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsRecurring() {
    return isRecurring;
  }


  @JsonProperty(JSON_PROPERTY_IS_RECURRING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsRecurring(@jakarta.annotation.Nullable Boolean isRecurring) {
    this.isRecurring = isRecurring;
  }

  public CreateAttribute enumeration(@jakarta.annotation.Nullable List<CreateAttributeEnumerationInner> enumeration) {
    
    this.enumeration = enumeration;
    return this;
  }

  public CreateAttribute addEnumerationItem(CreateAttributeEnumerationInner enumerationItem) {
    if (this.enumeration == null) {
      this.enumeration = new ArrayList<>();
    }
    this.enumeration.add(enumerationItem);
    return this;
  }

  /**
   * List of values and labels that the attribute can take. **Use only if the attribute&#39;s category is \&quot;category\&quot;**. None of the category options can exceed max 200 characters. For example: **[{\&quot;value\&quot;:1, \&quot;label\&quot;:\&quot;male\&quot;}, {\&quot;value\&quot;:2, \&quot;label\&quot;:\&quot;female\&quot;}]** 
   * @return enumeration
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ENUMERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<CreateAttributeEnumerationInner> getEnumeration() {
    return enumeration;
  }


  @JsonProperty(JSON_PROPERTY_ENUMERATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnumeration(@jakarta.annotation.Nullable List<CreateAttributeEnumerationInner> enumeration) {
    this.enumeration = enumeration;
  }

  public CreateAttribute multiCategoryOptions(@jakarta.annotation.Nullable List<String> multiCategoryOptions) {
    
    this.multiCategoryOptions = multiCategoryOptions;
    return this;
  }

  public CreateAttribute addMultiCategoryOptionsItem(String multiCategoryOptionsItem) {
    if (this.multiCategoryOptions == null) {
      this.multiCategoryOptions = new ArrayList<>();
    }
    this.multiCategoryOptions.add(multiCategoryOptionsItem);
    return this;
  }

  /**
   * List of options you want to add for multiple-choice attribute. **Use only if the attribute&#39;s category is \&quot;normal\&quot; and attribute&#39;s type is \&quot;multiple-choice\&quot;. None of the multicategory options can exceed max 200 characters.** For example: **[\&quot;USA\&quot;,\&quot;INDIA\&quot;]** 
   * @return multiCategoryOptions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MULTI_CATEGORY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getMultiCategoryOptions() {
    return multiCategoryOptions;
  }


  @JsonProperty(JSON_PROPERTY_MULTI_CATEGORY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMultiCategoryOptions(@jakarta.annotation.Nullable List<String> multiCategoryOptions) {
    this.multiCategoryOptions = multiCategoryOptions;
  }

  public CreateAttribute type(@jakarta.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * Type of the attribute. **Use only if the attribute&#39;s category is &#39;normal&#39;, &#39;category&#39; or &#39;transactional&#39;** Type **user and multiple-choice** is only available if the category is **normal** attribute Type **id** is only available if the category is **transactional** attribute Type **category** is only available if the category is **category** attribute 
   * @return type
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@jakarta.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateAttribute createAttribute = (CreateAttribute) o;
    return Objects.equals(this.value, createAttribute.value) &&
        Objects.equals(this.isRecurring, createAttribute.isRecurring) &&
        Objects.equals(this.enumeration, createAttribute.enumeration) &&
        Objects.equals(this.multiCategoryOptions, createAttribute.multiCategoryOptions) &&
        Objects.equals(this.type, createAttribute.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, isRecurring, enumeration, multiCategoryOptions, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateAttribute {\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    isRecurring: ").append(toIndentedString(isRecurring)).append("\n");
    sb.append("    enumeration: ").append(toIndentedString(enumeration)).append("\n");
    sb.append("    multiCategoryOptions: ").append(toIndentedString(multiCategoryOptions)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `value` to the URL query string
    if (getValue() != null) {
      try {
        joiner.add(String.format("%svalue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isRecurring` to the URL query string
    if (getIsRecurring() != null) {
      try {
        joiner.add(String.format("%sisRecurring%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsRecurring()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `enumeration` to the URL query string
    if (getEnumeration() != null) {
      for (int i = 0; i < getEnumeration().size(); i++) {
        if (getEnumeration().get(i) != null) {
          joiner.add(getEnumeration().get(i).toUrlQueryString(String.format("%senumeration%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `multiCategoryOptions` to the URL query string
    if (getMultiCategoryOptions() != null) {
      for (int i = 0; i < getMultiCategoryOptions().size(); i++) {
        try {
          joiner.add(String.format("%smultiCategoryOptions%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getMultiCategoryOptions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

