/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Permission on features
 */
@JsonPropertyOrder({
  CorporateUserEmailPermissionsPutRequestPrivilegesInner.JSON_PROPERTY_FEATURE,
  CorporateUserEmailPermissionsPutRequestPrivilegesInner.JSON_PROPERTY_PERMISSIONS
})
@JsonTypeName("_corporate_user__email__permissions_put_request_privileges_inner")
public class CorporateUserEmailPermissionsPutRequestPrivilegesInner {
  /**
   * feature name
   */
  public enum FeatureEnum {
    USER_MANAGEMENT(String.valueOf("user_management")),
    
    API(String.valueOf("api")),
    
    MY_PLAN(String.valueOf("my_plan")),
    
    APPS_MANAGEMENT(String.valueOf("apps_management")),
    
    ANALYTICS(String.valueOf("analytics")),
    
    SUB_ORGANIZATION_GROUPS(String.valueOf("sub_organization_groups")),
    
    CREATE_SUB_ORGANIZATIONS(String.valueOf("create_sub_organizations")),
    
    MANAGE_SUB_ORGANIZATIONS(String.valueOf("manage_sub_organizations")),
    
    SECURITY(String.valueOf("security"));

    private String value;

    FeatureEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FeatureEnum fromValue(String value) {
      for (FeatureEnum b : FeatureEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_FEATURE = "feature";
  @jakarta.annotation.Nullable
  private FeatureEnum feature;

  /**
   * Gets or Sets permissions
   */
  public enum PermissionsEnum {
    ALL(String.valueOf("all")),
    
    NONE(String.valueOf("none")),
    
    CREATE(String.valueOf("create")),
    
    EDIT_DELETE(String.valueOf("edit_delete")),
    
    CREATE_ALERTS(String.valueOf("create_alerts")),
    
    DOWNLOAD_DATA(String.valueOf("download_data")),
    
    MY_LOOKS(String.valueOf("my_looks")),
    
    EXPLORE_CREATE(String.valueOf("explore_create"));

    private String value;

    PermissionsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PermissionsEnum fromValue(String value) {
      for (PermissionsEnum b : PermissionsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
  @jakarta.annotation.Nullable
  private List<PermissionsEnum> permissions = new ArrayList<>();

  public CorporateUserEmailPermissionsPutRequestPrivilegesInner() {
  }

  public CorporateUserEmailPermissionsPutRequestPrivilegesInner feature(@jakarta.annotation.Nullable FeatureEnum feature) {
    
    this.feature = feature;
    return this;
  }

  /**
   * feature name
   * @return feature
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FEATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public FeatureEnum getFeature() {
    return feature;
  }


  @JsonProperty(JSON_PROPERTY_FEATURE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFeature(@jakarta.annotation.Nullable FeatureEnum feature) {
    this.feature = feature;
  }

  public CorporateUserEmailPermissionsPutRequestPrivilegesInner permissions(@jakarta.annotation.Nullable List<PermissionsEnum> permissions) {
    
    this.permissions = permissions;
    return this;
  }

  public CorporateUserEmailPermissionsPutRequestPrivilegesInner addPermissionsItem(PermissionsEnum permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

  /**
   * Permission for the feature
   * @return permissions
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PermissionsEnum> getPermissions() {
    return permissions;
  }


  @JsonProperty(JSON_PROPERTY_PERMISSIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPermissions(@jakarta.annotation.Nullable List<PermissionsEnum> permissions) {
    this.permissions = permissions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CorporateUserEmailPermissionsPutRequestPrivilegesInner corporateUserEmailPermissionsPutRequestPrivilegesInner = (CorporateUserEmailPermissionsPutRequestPrivilegesInner) o;
    return Objects.equals(this.feature, corporateUserEmailPermissionsPutRequestPrivilegesInner.feature) &&
        Objects.equals(this.permissions, corporateUserEmailPermissionsPutRequestPrivilegesInner.permissions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(feature, permissions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CorporateUserEmailPermissionsPutRequestPrivilegesInner {\n");
    sb.append("    feature: ").append(toIndentedString(feature)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `feature` to the URL query string
    if (getFeature() != null) {
      try {
        joiner.add(String.format("%sfeature%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFeature()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `permissions` to the URL query string
    if (getPermissions() != null) {
      for (int i = 0; i < getPermissions().size(); i++) {
        try {
          joiner.add(String.format("%spermissions%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getPermissions().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    return joiner.toString();
  }

}

