/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CorporateSubAccountSsoTokenPostRequest
 */
@JsonPropertyOrder({
  CorporateSubAccountSsoTokenPostRequest.JSON_PROPERTY_ID,
  CorporateSubAccountSsoTokenPostRequest.JSON_PROPERTY_EMAIL,
  CorporateSubAccountSsoTokenPostRequest.JSON_PROPERTY_TARGET,
  CorporateSubAccountSsoTokenPostRequest.JSON_PROPERTY_URL
})
@JsonTypeName("_corporate_subAccount_ssoToken_post_request")
public class CorporateSubAccountSsoTokenPostRequest {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nonnull
  private Long id;

  public static final String JSON_PROPERTY_EMAIL = "email";
  @jakarta.annotation.Nullable
  private String email;

  /**
   * **Set target after login success** * **automation** - Redirect to Automation after login * **email_campaign** - Redirect to Email Campaign after login * **contacts** - Redirect to Contacts after login * **landing_pages** - Redirect to Landing Pages after login * **email_transactional** - Redirect to Email Transactional after login * **senders** - Redirect to Senders after login * **sms_campaign** - Redirect to Sms Campaign after login * **sms_transactional** - Redirect to Sms Transactional after login 
   */
  public enum TargetEnum {
    AUTOMATION(String.valueOf("automation")),
    
    EMAIL_CAMPAIGN(String.valueOf("email_campaign")),
    
    CONTACTS(String.valueOf("contacts")),
    
    LANDING_PAGES(String.valueOf("landing_pages")),
    
    EMAIL_TRANSACTIONAL(String.valueOf("email_transactional")),
    
    SENDERS(String.valueOf("senders")),
    
    SMS_CAMPAIGN(String.valueOf("sms_campaign")),
    
    SMS_TRANSACTIONAL(String.valueOf("sms_transactional"));

    private String value;

    TargetEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TargetEnum fromValue(String value) {
      for (TargetEnum b : TargetEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TARGET = "target";
  @jakarta.annotation.Nullable
  private TargetEnum target;

  public static final String JSON_PROPERTY_URL = "url";
  @jakarta.annotation.Nullable
  private String url;

  public CorporateSubAccountSsoTokenPostRequest() {
  }

  public CorporateSubAccountSsoTokenPostRequest id(@jakarta.annotation.Nonnull Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Id of the sub-account organization
   * @return id
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setId(@jakarta.annotation.Nonnull Long id) {
    this.id = id;
  }

  public CorporateSubAccountSsoTokenPostRequest email(@jakarta.annotation.Nullable String email) {
    
    this.email = email;
    return this;
  }

  /**
   * User email of sub-account organization
   * @return email
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEmail(@jakarta.annotation.Nullable String email) {
    this.email = email;
  }

  public CorporateSubAccountSsoTokenPostRequest target(@jakarta.annotation.Nullable TargetEnum target) {
    
    this.target = target;
    return this;
  }

  /**
   * **Set target after login success** * **automation** - Redirect to Automation after login * **email_campaign** - Redirect to Email Campaign after login * **contacts** - Redirect to Contacts after login * **landing_pages** - Redirect to Landing Pages after login * **email_transactional** - Redirect to Email Transactional after login * **senders** - Redirect to Senders after login * **sms_campaign** - Redirect to Sms Campaign after login * **sms_transactional** - Redirect to Sms Transactional after login 
   * @return target
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TargetEnum getTarget() {
    return target;
  }


  @JsonProperty(JSON_PROPERTY_TARGET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTarget(@jakarta.annotation.Nullable TargetEnum target) {
    this.target = target;
  }

  public CorporateSubAccountSsoTokenPostRequest url(@jakarta.annotation.Nullable String url) {
    
    this.url = url;
    return this;
  }

  /**
   * Set the full target URL after login success. The user will land directly on this target URL after login
   * @return url
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrl(@jakarta.annotation.Nullable String url) {
    this.url = url;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CorporateSubAccountSsoTokenPostRequest corporateSubAccountSsoTokenPostRequest = (CorporateSubAccountSsoTokenPostRequest) o;
    return Objects.equals(this.id, corporateSubAccountSsoTokenPostRequest.id) &&
        Objects.equals(this.email, corporateSubAccountSsoTokenPostRequest.email) &&
        Objects.equals(this.target, corporateSubAccountSsoTokenPostRequest.target) &&
        Objects.equals(this.url, corporateSubAccountSsoTokenPostRequest.url);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, email, target, url);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CorporateSubAccountSsoTokenPostRequest {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `email` to the URL query string
    if (getEmail() != null) {
      try {
        joiner.add(String.format("%semail%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getEmail()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `target` to the URL query string
    if (getTarget() != null) {
      try {
        joiner.add(String.format("%starget%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTarget()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `url` to the URL query string
    if (getUrl() != null) {
      try {
        joiner.add(String.format("%surl%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUrl()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

