/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import software.xdev.brevo.model.ConversationsMessageAttachmentsInner;
import software.xdev.brevo.model.ConversationsMessageFile;
import software.xdev.brevo.model.ConversationsMessageForwardedToSourceStatus;
import software.xdev.brevo.model.ConversationsMessageFrom;
import software.xdev.brevo.model.ConversationsMessageReplyTo;
import software.xdev.brevo.model.ConversationsMessageToInner;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * a Conversations message
 */
@JsonPropertyOrder({
  ConversationsMessage.JSON_PROPERTY_ID,
  ConversationsMessage.JSON_PROPERTY_TYPE,
  ConversationsMessage.JSON_PROPERTY_TEXT,
  ConversationsMessage.JSON_PROPERTY_SUBJECT,
  ConversationsMessage.JSON_PROPERTY_HTML,
  ConversationsMessage.JSON_PROPERTY_RAW_UNSAFE_HTML,
  ConversationsMessage.JSON_PROPERTY_VISITOR_ID,
  ConversationsMessage.JSON_PROPERTY_AGENT_ID,
  ConversationsMessage.JSON_PROPERTY_AGENT_NAME,
  ConversationsMessage.JSON_PROPERTY_CREATED_AT,
  ConversationsMessage.JSON_PROPERTY_IS_PUSHED,
  ConversationsMessage.JSON_PROPERTY_IS_TRIGGER,
  ConversationsMessage.JSON_PROPERTY_IS_MISSED,
  ConversationsMessage.JSON_PROPERTY_IS_MISSED_BY_VISITOR,
  ConversationsMessage.JSON_PROPERTY_AGENT_USERPIC,
  ConversationsMessage.JSON_PROPERTY_RECEIVED_FROM,
  ConversationsMessage.JSON_PROPERTY_FILE,
  ConversationsMessage.JSON_PROPERTY_FROM,
  ConversationsMessage.JSON_PROPERTY_TO,
  ConversationsMessage.JSON_PROPERTY_REPLY_TO,
  ConversationsMessage.JSON_PROPERTY_CC,
  ConversationsMessage.JSON_PROPERTY_BCC,
  ConversationsMessage.JSON_PROPERTY_SOURCE_MESSAGE_ID,
  ConversationsMessage.JSON_PROPERTY_FORWARDED_TO_SOURCE_STATUS,
  ConversationsMessage.JSON_PROPERTY_INTEGRATIONS,
  ConversationsMessage.JSON_PROPERTY_IS_BOT,
  ConversationsMessage.JSON_PROPERTY_ATTACHMENTS
})
public class ConversationsMessage {
  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  /**
   * &#x60;\&quot;agent\&quot;&#x60; for agents’ messages, &#x60;\&quot;visitor\&quot;&#x60; for visitors’ messages.
   */
  public enum TypeEnum {
    AGENT(String.valueOf("agent")),
    
    VISITOR(String.valueOf("visitor"));

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  @jakarta.annotation.Nullable
  private TypeEnum type;

  public static final String JSON_PROPERTY_TEXT = "text";
  @jakarta.annotation.Nullable
  private String text;

  public static final String JSON_PROPERTY_SUBJECT = "subject";
  @jakarta.annotation.Nullable
  private String subject;

  public static final String JSON_PROPERTY_HTML = "html";
  @jakarta.annotation.Nullable
  private String html;

  public static final String JSON_PROPERTY_RAW_UNSAFE_HTML = "rawUnsafeHtml";
  @jakarta.annotation.Nullable
  private String rawUnsafeHtml;

  public static final String JSON_PROPERTY_VISITOR_ID = "visitorId";
  @jakarta.annotation.Nullable
  private String visitorId;

  public static final String JSON_PROPERTY_AGENT_ID = "agentId";
  @jakarta.annotation.Nullable
  private String agentId;

  public static final String JSON_PROPERTY_AGENT_NAME = "agentName";
  @jakarta.annotation.Nullable
  private String agentName;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private Long createdAt;

  public static final String JSON_PROPERTY_IS_PUSHED = "isPushed";
  @jakarta.annotation.Nullable
  private Boolean isPushed;

  public static final String JSON_PROPERTY_IS_TRIGGER = "isTrigger";
  @jakarta.annotation.Nullable
  private Boolean isTrigger;

  public static final String JSON_PROPERTY_IS_MISSED = "isMissed";
  @jakarta.annotation.Nullable
  private Boolean isMissed;

  public static final String JSON_PROPERTY_IS_MISSED_BY_VISITOR = "isMissedByVisitor";
  @jakarta.annotation.Nullable
  private Boolean isMissedByVisitor;

  public static final String JSON_PROPERTY_AGENT_USERPIC = "agentUserpic";
  @jakarta.annotation.Nullable
  private String agentUserpic;

  public static final String JSON_PROPERTY_RECEIVED_FROM = "receivedFrom";
  @jakarta.annotation.Nullable
  private String receivedFrom;

  public static final String JSON_PROPERTY_FILE = "file";
  @jakarta.annotation.Nullable
  private ConversationsMessageFile _file;

  public static final String JSON_PROPERTY_FROM = "from";
  @jakarta.annotation.Nullable
  private ConversationsMessageFrom from;

  public static final String JSON_PROPERTY_TO = "to";
  @jakarta.annotation.Nullable
  private List<ConversationsMessageToInner> to = new ArrayList<>();

  public static final String JSON_PROPERTY_REPLY_TO = "replyTo";
  @jakarta.annotation.Nullable
  private ConversationsMessageReplyTo replyTo;

  public static final String JSON_PROPERTY_CC = "cc";
  @jakarta.annotation.Nullable
  private List<ConversationsMessageToInner> cc = new ArrayList<>();

  public static final String JSON_PROPERTY_BCC = "bcc";
  @jakarta.annotation.Nullable
  private List<ConversationsMessageToInner> bcc = new ArrayList<>();

  public static final String JSON_PROPERTY_SOURCE_MESSAGE_ID = "sourceMessageId";
  @jakarta.annotation.Nullable
  private String sourceMessageId;

  public static final String JSON_PROPERTY_FORWARDED_TO_SOURCE_STATUS = "forwardedToSourceStatus";
  @jakarta.annotation.Nullable
  private ConversationsMessageForwardedToSourceStatus forwardedToSourceStatus;

  public static final String JSON_PROPERTY_INTEGRATIONS = "integrations";
  @jakarta.annotation.Nullable
  private Object integrations;

  public static final String JSON_PROPERTY_IS_BOT = "isBot";
  @jakarta.annotation.Nullable
  private Boolean isBot;

  public static final String JSON_PROPERTY_ATTACHMENTS = "attachments";
  @jakarta.annotation.Nullable
  private List<ConversationsMessageAttachmentsInner> attachments = new ArrayList<>();

  public ConversationsMessage() {
  }

  public ConversationsMessage id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Message ID. It can be used for further manipulations with the message.
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public ConversationsMessage type(@jakarta.annotation.Nullable TypeEnum type) {
    
    this.type = type;
    return this;
  }

  /**
   * &#x60;\&quot;agent\&quot;&#x60; for agents’ messages, &#x60;\&quot;visitor\&quot;&#x60; for visitors’ messages.
   * @return type
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@jakarta.annotation.Nullable TypeEnum type) {
    this.type = type;
  }

  public ConversationsMessage text(@jakarta.annotation.Nullable String text) {
    
    this.text = text;
    return this;
  }

  /**
   * Message text or name of the attached file
   * @return text
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(@jakarta.annotation.Nullable String text) {
    this.text = text;
  }

  public ConversationsMessage subject(@jakarta.annotation.Nullable String subject) {
    
    this.subject = subject;
    return this;
  }

  /**
   * The subject line of the email message (only for messages sent to email threads).
   * @return subject
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubject() {
    return subject;
  }


  @JsonProperty(JSON_PROPERTY_SUBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubject(@jakarta.annotation.Nullable String subject) {
    this.subject = subject;
  }

  public ConversationsMessage html(@jakarta.annotation.Nullable String html) {
    
    this.html = html;
    return this;
  }

  /**
   * The HTML content of the message.
   * @return html
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHtml() {
    return html;
  }


  @JsonProperty(JSON_PROPERTY_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtml(@jakarta.annotation.Nullable String html) {
    this.html = html;
  }

  public ConversationsMessage rawUnsafeHtml(@jakarta.annotation.Nullable String rawUnsafeHtml) {
    
    this.rawUnsafeHtml = rawUnsafeHtml;
    return this;
  }

  /**
   * Unescaped HTML content of the message (may include unsafe HTML).
   * @return rawUnsafeHtml
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RAW_UNSAFE_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getRawUnsafeHtml() {
    return rawUnsafeHtml;
  }


  @JsonProperty(JSON_PROPERTY_RAW_UNSAFE_HTML)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRawUnsafeHtml(@jakarta.annotation.Nullable String rawUnsafeHtml) {
    this.rawUnsafeHtml = rawUnsafeHtml;
  }

  public ConversationsMessage visitorId(@jakarta.annotation.Nullable String visitorId) {
    
    this.visitorId = visitorId;
    return this;
  }

  /**
   * visitor’s ID
   * @return visitorId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VISITOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getVisitorId() {
    return visitorId;
  }


  @JsonProperty(JSON_PROPERTY_VISITOR_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisitorId(@jakarta.annotation.Nullable String visitorId) {
    this.visitorId = visitorId;
  }

  public ConversationsMessage agentId(@jakarta.annotation.Nullable String agentId) {
    
    this.agentId = agentId;
    return this;
  }

  /**
   * ID of the agent on whose behalf the message was sent (only in messages sent by an agent).
   * @return agentId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAgentId() {
    return agentId;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentId(@jakarta.annotation.Nullable String agentId) {
    this.agentId = agentId;
  }

  public ConversationsMessage agentName(@jakarta.annotation.Nullable String agentName) {
    
    this.agentName = agentName;
    return this;
  }

  /**
   * Agent’s name as displayed to the visitor. Only in the messages sent by an agent.
   * @return agentName
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAgentName() {
    return agentName;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentName(@jakarta.annotation.Nullable String agentName) {
    this.agentName = agentName;
  }

  public ConversationsMessage createdAt(@jakarta.annotation.Nullable Long createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp in milliseconds.
   * minimum: 0
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable Long createdAt) {
    this.createdAt = createdAt;
  }

  public ConversationsMessage isPushed(@jakarta.annotation.Nullable Boolean isPushed) {
    
    this.isPushed = isPushed;
    return this;
  }

  /**
   * &#x60;true&#x60; for pushed messages
   * @return isPushed
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_PUSHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsPushed() {
    return isPushed;
  }


  @JsonProperty(JSON_PROPERTY_IS_PUSHED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsPushed(@jakarta.annotation.Nullable Boolean isPushed) {
    this.isPushed = isPushed;
  }

  public ConversationsMessage isTrigger(@jakarta.annotation.Nullable Boolean isTrigger) {
    
    this.isTrigger = isTrigger;
    return this;
  }

  /**
   * &#x60;true&#x60; for automatic messages from “Targeted chats &amp; triggers” and API (https://developers.brevo.com/docs/javascript-api-reference#sendautomessage)
   * @return isTrigger
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_TRIGGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsTrigger() {
    return isTrigger;
  }


  @JsonProperty(JSON_PROPERTY_IS_TRIGGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsTrigger(@jakarta.annotation.Nullable Boolean isTrigger) {
    this.isTrigger = isTrigger;
  }

  public ConversationsMessage isMissed(@jakarta.annotation.Nullable Boolean isMissed) {
    
    this.isMissed = isMissed;
    return this;
  }

  /**
   * &#x60;true&#x60; for missed and offline messages.
   * @return isMissed
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_MISSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsMissed() {
    return isMissed;
  }


  @JsonProperty(JSON_PROPERTY_IS_MISSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsMissed(@jakarta.annotation.Nullable Boolean isMissed) {
    this.isMissed = isMissed;
  }

  public ConversationsMessage isMissedByVisitor(@jakarta.annotation.Nullable Boolean isMissedByVisitor) {
    
    this.isMissedByVisitor = isMissedByVisitor;
    return this;
  }

  /**
   * &#x60;true&#x60; for unread agent’s messages in finished chats.
   * @return isMissedByVisitor
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_MISSED_BY_VISITOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsMissedByVisitor() {
    return isMissedByVisitor;
  }


  @JsonProperty(JSON_PROPERTY_IS_MISSED_BY_VISITOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsMissedByVisitor(@jakarta.annotation.Nullable Boolean isMissedByVisitor) {
    this.isMissedByVisitor = isMissedByVisitor;
  }

  public ConversationsMessage agentUserpic(@jakarta.annotation.Nullable String agentUserpic) {
    
    this.agentUserpic = agentUserpic;
    return this;
  }

  /**
   * Only set if the agent has uploaded a profile picture.
   * @return agentUserpic
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AGENT_USERPIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAgentUserpic() {
    return agentUserpic;
  }


  @JsonProperty(JSON_PROPERTY_AGENT_USERPIC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAgentUserpic(@jakarta.annotation.Nullable String agentUserpic) {
    this.agentUserpic = agentUserpic;
  }

  public ConversationsMessage receivedFrom(@jakarta.annotation.Nullable String receivedFrom) {
    
    this.receivedFrom = receivedFrom;
    return this;
  }

  /**
   * In two-way integrations, messages sent via REST API can be marked with receivedFrom property and then filtered out when received in a webhook to avoid infinite loop.
   * @return receivedFrom
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RECEIVED_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getReceivedFrom() {
    return receivedFrom;
  }


  @JsonProperty(JSON_PROPERTY_RECEIVED_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReceivedFrom(@jakarta.annotation.Nullable String receivedFrom) {
    this.receivedFrom = receivedFrom;
  }

  public ConversationsMessage _file(@jakarta.annotation.Nullable ConversationsMessageFile _file) {
    
    this._file = _file;
    return this;
  }

  /**
   * Get _file
   * @return _file
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ConversationsMessageFile getFile() {
    return _file;
  }


  @JsonProperty(JSON_PROPERTY_FILE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFile(@jakarta.annotation.Nullable ConversationsMessageFile _file) {
    this._file = _file;
  }

  public ConversationsMessage from(@jakarta.annotation.Nullable ConversationsMessageFrom from) {
    
    this.from = from;
    return this;
  }

  /**
   * Get from
   * @return from
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ConversationsMessageFrom getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(@jakarta.annotation.Nullable ConversationsMessageFrom from) {
    this.from = from;
  }

  public ConversationsMessage to(@jakarta.annotation.Nullable List<ConversationsMessageToInner> to) {
    
    this.to = to;
    return this;
  }

  public ConversationsMessage addToItem(ConversationsMessageToInner toItem) {
    if (this.to == null) {
      this.to = new ArrayList<>();
    }
    this.to.add(toItem);
    return this;
  }

  /**
   * An array containing details of the recipients (applicable only to messages in email threads).
   * @return to
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConversationsMessageToInner> getTo() {
    return to;
  }


  @JsonProperty(JSON_PROPERTY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTo(@jakarta.annotation.Nullable List<ConversationsMessageToInner> to) {
    this.to = to;
  }

  public ConversationsMessage replyTo(@jakarta.annotation.Nullable ConversationsMessageReplyTo replyTo) {
    
    this.replyTo = replyTo;
    return this;
  }

  /**
   * Get replyTo
   * @return replyTo
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ConversationsMessageReplyTo getReplyTo() {
    return replyTo;
  }


  @JsonProperty(JSON_PROPERTY_REPLY_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplyTo(@jakarta.annotation.Nullable ConversationsMessageReplyTo replyTo) {
    this.replyTo = replyTo;
  }

  public ConversationsMessage cc(@jakarta.annotation.Nullable List<ConversationsMessageToInner> cc) {
    
    this.cc = cc;
    return this;
  }

  public ConversationsMessage addCcItem(ConversationsMessageToInner ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<>();
    }
    this.cc.add(ccItem);
    return this;
  }

  /**
   * An array containing details of the carbon copy (CC) recipients (applicable only to messages in email threads).
   * @return cc
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConversationsMessageToInner> getCc() {
    return cc;
  }


  @JsonProperty(JSON_PROPERTY_CC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCc(@jakarta.annotation.Nullable List<ConversationsMessageToInner> cc) {
    this.cc = cc;
  }

  public ConversationsMessage bcc(@jakarta.annotation.Nullable List<ConversationsMessageToInner> bcc) {
    
    this.bcc = bcc;
    return this;
  }

  public ConversationsMessage addBccItem(ConversationsMessageToInner bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<>();
    }
    this.bcc.add(bccItem);
    return this;
  }

  /**
   * An array containing details of the blind carbon copy (BCC) recipients (applicable only to messages in email threads).
   * @return bcc
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConversationsMessageToInner> getBcc() {
    return bcc;
  }


  @JsonProperty(JSON_PROPERTY_BCC)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBcc(@jakarta.annotation.Nullable List<ConversationsMessageToInner> bcc) {
    this.bcc = bcc;
  }

  public ConversationsMessage sourceMessageId(@jakarta.annotation.Nullable String sourceMessageId) {
    
    this.sourceMessageId = sourceMessageId;
    return this;
  }

  /**
   * The ID of the message assigned by the integration source.
   * @return sourceMessageId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SOURCE_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceMessageId() {
    return sourceMessageId;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_MESSAGE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceMessageId(@jakarta.annotation.Nullable String sourceMessageId) {
    this.sourceMessageId = sourceMessageId;
  }

  public ConversationsMessage forwardedToSourceStatus(@jakarta.annotation.Nullable ConversationsMessageForwardedToSourceStatus forwardedToSourceStatus) {
    
    this.forwardedToSourceStatus = forwardedToSourceStatus;
    return this;
  }

  /**
   * Get forwardedToSourceStatus
   * @return forwardedToSourceStatus
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FORWARDED_TO_SOURCE_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ConversationsMessageForwardedToSourceStatus getForwardedToSourceStatus() {
    return forwardedToSourceStatus;
  }


  @JsonProperty(JSON_PROPERTY_FORWARDED_TO_SOURCE_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setForwardedToSourceStatus(@jakarta.annotation.Nullable ConversationsMessageForwardedToSourceStatus forwardedToSourceStatus) {
    this.forwardedToSourceStatus = forwardedToSourceStatus;
  }

  public ConversationsMessage integrations(@jakarta.annotation.Nullable Object integrations) {
    
    this.integrations = integrations;
    return this;
  }

  /**
   * Integration details.
   * @return integrations
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INTEGRATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getIntegrations() {
    return integrations;
  }


  @JsonProperty(JSON_PROPERTY_INTEGRATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIntegrations(@jakarta.annotation.Nullable Object integrations) {
    this.integrations = integrations;
  }

  public ConversationsMessage isBot(@jakarta.annotation.Nullable Boolean isBot) {
    
    this.isBot = isBot;
    return this;
  }

  /**
   * &#x60;true&#x60; for automated messages generated by an AI bot.
   * @return isBot
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsBot() {
    return isBot;
  }


  @JsonProperty(JSON_PROPERTY_IS_BOT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsBot(@jakarta.annotation.Nullable Boolean isBot) {
    this.isBot = isBot;
  }

  public ConversationsMessage attachments(@jakarta.annotation.Nullable List<ConversationsMessageAttachmentsInner> attachments) {
    
    this.attachments = attachments;
    return this;
  }

  public ConversationsMessage addAttachmentsItem(ConversationsMessageAttachmentsInner attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

  /**
   * An array of file attachments.
   * @return attachments
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConversationsMessageAttachmentsInner> getAttachments() {
    return attachments;
  }


  @JsonProperty(JSON_PROPERTY_ATTACHMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAttachments(@jakarta.annotation.Nullable List<ConversationsMessageAttachmentsInner> attachments) {
    this.attachments = attachments;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConversationsMessage conversationsMessage = (ConversationsMessage) o;
    return Objects.equals(this.id, conversationsMessage.id) &&
        Objects.equals(this.type, conversationsMessage.type) &&
        Objects.equals(this.text, conversationsMessage.text) &&
        Objects.equals(this.subject, conversationsMessage.subject) &&
        Objects.equals(this.html, conversationsMessage.html) &&
        Objects.equals(this.rawUnsafeHtml, conversationsMessage.rawUnsafeHtml) &&
        Objects.equals(this.visitorId, conversationsMessage.visitorId) &&
        Objects.equals(this.agentId, conversationsMessage.agentId) &&
        Objects.equals(this.agentName, conversationsMessage.agentName) &&
        Objects.equals(this.createdAt, conversationsMessage.createdAt) &&
        Objects.equals(this.isPushed, conversationsMessage.isPushed) &&
        Objects.equals(this.isTrigger, conversationsMessage.isTrigger) &&
        Objects.equals(this.isMissed, conversationsMessage.isMissed) &&
        Objects.equals(this.isMissedByVisitor, conversationsMessage.isMissedByVisitor) &&
        Objects.equals(this.agentUserpic, conversationsMessage.agentUserpic) &&
        Objects.equals(this.receivedFrom, conversationsMessage.receivedFrom) &&
        Objects.equals(this._file, conversationsMessage._file) &&
        Objects.equals(this.from, conversationsMessage.from) &&
        Objects.equals(this.to, conversationsMessage.to) &&
        Objects.equals(this.replyTo, conversationsMessage.replyTo) &&
        Objects.equals(this.cc, conversationsMessage.cc) &&
        Objects.equals(this.bcc, conversationsMessage.bcc) &&
        Objects.equals(this.sourceMessageId, conversationsMessage.sourceMessageId) &&
        Objects.equals(this.forwardedToSourceStatus, conversationsMessage.forwardedToSourceStatus) &&
        Objects.equals(this.integrations, conversationsMessage.integrations) &&
        Objects.equals(this.isBot, conversationsMessage.isBot) &&
        Objects.equals(this.attachments, conversationsMessage.attachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, text, subject, html, rawUnsafeHtml, visitorId, agentId, agentName, createdAt, isPushed, isTrigger, isMissed, isMissedByVisitor, agentUserpic, receivedFrom, _file, from, to, replyTo, cc, bcc, sourceMessageId, forwardedToSourceStatus, integrations, isBot, attachments);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConversationsMessage {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    html: ").append(toIndentedString(html)).append("\n");
    sb.append("    rawUnsafeHtml: ").append(toIndentedString(rawUnsafeHtml)).append("\n");
    sb.append("    visitorId: ").append(toIndentedString(visitorId)).append("\n");
    sb.append("    agentId: ").append(toIndentedString(agentId)).append("\n");
    sb.append("    agentName: ").append(toIndentedString(agentName)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    isPushed: ").append(toIndentedString(isPushed)).append("\n");
    sb.append("    isTrigger: ").append(toIndentedString(isTrigger)).append("\n");
    sb.append("    isMissed: ").append(toIndentedString(isMissed)).append("\n");
    sb.append("    isMissedByVisitor: ").append(toIndentedString(isMissedByVisitor)).append("\n");
    sb.append("    agentUserpic: ").append(toIndentedString(agentUserpic)).append("\n");
    sb.append("    receivedFrom: ").append(toIndentedString(receivedFrom)).append("\n");
    sb.append("    _file: ").append(toIndentedString(_file)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    sourceMessageId: ").append(toIndentedString(sourceMessageId)).append("\n");
    sb.append("    forwardedToSourceStatus: ").append(toIndentedString(forwardedToSourceStatus)).append("\n");
    sb.append("    integrations: ").append(toIndentedString(integrations)).append("\n");
    sb.append("    isBot: ").append(toIndentedString(isBot)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `text` to the URL query string
    if (getText() != null) {
      try {
        joiner.add(String.format("%stext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getText()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `subject` to the URL query string
    if (getSubject() != null) {
      try {
        joiner.add(String.format("%ssubject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSubject()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `html` to the URL query string
    if (getHtml() != null) {
      try {
        joiner.add(String.format("%shtml%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHtml()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `rawUnsafeHtml` to the URL query string
    if (getRawUnsafeHtml() != null) {
      try {
        joiner.add(String.format("%srawUnsafeHtml%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRawUnsafeHtml()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `visitorId` to the URL query string
    if (getVisitorId() != null) {
      try {
        joiner.add(String.format("%svisitorId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVisitorId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `agentId` to the URL query string
    if (getAgentId() != null) {
      try {
        joiner.add(String.format("%sagentId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAgentId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `agentName` to the URL query string
    if (getAgentName() != null) {
      try {
        joiner.add(String.format("%sagentName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAgentName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isPushed` to the URL query string
    if (getIsPushed() != null) {
      try {
        joiner.add(String.format("%sisPushed%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsPushed()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isTrigger` to the URL query string
    if (getIsTrigger() != null) {
      try {
        joiner.add(String.format("%sisTrigger%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsTrigger()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isMissed` to the URL query string
    if (getIsMissed() != null) {
      try {
        joiner.add(String.format("%sisMissed%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsMissed()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isMissedByVisitor` to the URL query string
    if (getIsMissedByVisitor() != null) {
      try {
        joiner.add(String.format("%sisMissedByVisitor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsMissedByVisitor()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `agentUserpic` to the URL query string
    if (getAgentUserpic() != null) {
      try {
        joiner.add(String.format("%sagentUserpic%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAgentUserpic()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `receivedFrom` to the URL query string
    if (getReceivedFrom() != null) {
      try {
        joiner.add(String.format("%sreceivedFrom%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReceivedFrom()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `file` to the URL query string
    if (getFile() != null) {
      joiner.add(getFile().toUrlQueryString(prefix + "file" + suffix));
    }

    // add `from` to the URL query string
    if (getFrom() != null) {
      joiner.add(getFrom().toUrlQueryString(prefix + "from" + suffix));
    }

    // add `to` to the URL query string
    if (getTo() != null) {
      for (int i = 0; i < getTo().size(); i++) {
        if (getTo().get(i) != null) {
          joiner.add(getTo().get(i).toUrlQueryString(String.format("%sto%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `replyTo` to the URL query string
    if (getReplyTo() != null) {
      joiner.add(getReplyTo().toUrlQueryString(prefix + "replyTo" + suffix));
    }

    // add `cc` to the URL query string
    if (getCc() != null) {
      for (int i = 0; i < getCc().size(); i++) {
        if (getCc().get(i) != null) {
          joiner.add(getCc().get(i).toUrlQueryString(String.format("%scc%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `bcc` to the URL query string
    if (getBcc() != null) {
      for (int i = 0; i < getBcc().size(); i++) {
        if (getBcc().get(i) != null) {
          joiner.add(getBcc().get(i).toUrlQueryString(String.format("%sbcc%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `sourceMessageId` to the URL query string
    if (getSourceMessageId() != null) {
      try {
        joiner.add(String.format("%ssourceMessageId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSourceMessageId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `forwardedToSourceStatus` to the URL query string
    if (getForwardedToSourceStatus() != null) {
      joiner.add(getForwardedToSourceStatus().toUrlQueryString(prefix + "forwardedToSourceStatus" + suffix));
    }

    // add `integrations` to the URL query string
    if (getIntegrations() != null) {
      try {
        joiner.add(String.format("%sintegrations%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIntegrations()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isBot` to the URL query string
    if (getIsBot() != null) {
      try {
        joiner.add(String.format("%sisBot%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsBot()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `attachments` to the URL query string
    if (getAttachments() != null) {
      for (int i = 0; i < getAttachments().size(); i++) {
        if (getAttachments().get(i) != null) {
          joiner.add(getAttachments().get(i).toUrlQueryString(String.format("%sattachments%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    return joiner.toString();
  }

}

