/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Specify the payment currency and amount. 
 */
@JsonPropertyOrder({
  Cart.JSON_PROPERTY_CURRENCY,
  Cart.JSON_PROPERTY_SPECIFIC_AMOUNT
})
@JsonTypeName("cart")
public class Cart {
  /**
   * Currency code for the payment amount. 
   */
  public enum CurrencyEnum {
    EUR(String.valueOf("EUR"));

    private String value;

    CurrencyEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CurrencyEnum fromValue(String value) {
      for (CurrencyEnum b : CurrencyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  @jakarta.annotation.Nonnull
  private CurrencyEnum currency;

  public static final String JSON_PROPERTY_SPECIFIC_AMOUNT = "specificAmount";
  @jakarta.annotation.Nonnull
  private Long specificAmount;

  public Cart() {
  }

  public Cart currency(@jakarta.annotation.Nonnull CurrencyEnum currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Currency code for the payment amount. 
   * @return currency
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CurrencyEnum getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCurrency(@jakarta.annotation.Nonnull CurrencyEnum currency) {
    this.currency = currency;
  }

  public Cart specificAmount(@jakarta.annotation.Nonnull Long specificAmount) {
    
    this.specificAmount = specificAmount;
    return this;
  }

  /**
   * Payment amount, in cents. e.g. if you want to request €12.00, then the amount in cents is 1200. 
   * @return specificAmount
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_SPECIFIC_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Long getSpecificAmount() {
    return specificAmount;
  }


  @JsonProperty(JSON_PROPERTY_SPECIFIC_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSpecificAmount(@jakarta.annotation.Nonnull Long specificAmount) {
    this.specificAmount = specificAmount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Cart cart = (Cart) o;
    return Objects.equals(this.currency, cart.currency) &&
        Objects.equals(this.specificAmount, cart.specificAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currency, specificAmount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Cart {\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    specificAmount: ").append(toIndentedString(specificAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `currency` to the URL query string
    if (getCurrency() != null) {
      try {
        joiner.add(String.format("%scurrency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCurrency()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `specificAmount` to the URL query string
    if (getSpecificAmount() != null) {
      try {
        joiner.add(String.format("%sspecificAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getSpecificAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

