/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Represents an order linked to a balance definition, including amount, due date, and transaction details.
 */
@JsonPropertyOrder({
  BalanceOrder.JSON_PROPERTY_AMOUNT,
  BalanceOrder.JSON_PROPERTY_BALANCE_DEFINITION_ID,
  BalanceOrder.JSON_PROPERTY_CONTACT_ID,
  BalanceOrder.JSON_PROPERTY_CREATED_AT,
  BalanceOrder.JSON_PROPERTY_DUE_AT,
  BalanceOrder.JSON_PROPERTY_EXPIRES_AT,
  BalanceOrder.JSON_PROPERTY_ID,
  BalanceOrder.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  BalanceOrder.JSON_PROPERTY_META,
  BalanceOrder.JSON_PROPERTY_PROCESSED_AT,
  BalanceOrder.JSON_PROPERTY_TRANSACTIONID,
  BalanceOrder.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("balanceOrder")
public class BalanceOrder {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nonnull
  private BigDecimal amount;

  public static final String JSON_PROPERTY_BALANCE_DEFINITION_ID = "balanceDefinitionId";
  @jakarta.annotation.Nullable
  private String balanceDefinitionId;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nonnull
  private Integer contactId;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nonnull
  private String createdAt;

  public static final String JSON_PROPERTY_DUE_AT = "dueAt";
  @jakarta.annotation.Nonnull
  private String dueAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  @jakarta.annotation.Nullable
  private String expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nonnull
  private String loyaltyProgramId;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_PROCESSED_AT = "processedAt";
  @jakarta.annotation.Nullable
  private String processedAt;

  public static final String JSON_PROPERTY_TRANSACTIONID = "transactionid";
  @jakarta.annotation.Nullable
  private String transactionid;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nonnull
  private String updatedAt;

  public BalanceOrder() {
  }

  public BalanceOrder amount(@jakarta.annotation.Nonnull BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * Order amount (must not be zero).
   * @return amount
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAmount(@jakarta.annotation.Nonnull BigDecimal amount) {
    this.amount = amount;
  }

  public BalanceOrder balanceDefinitionId(@jakarta.annotation.Nullable String balanceDefinitionId) {
    
    this.balanceDefinitionId = balanceDefinitionId;
    return this;
  }

  /**
   * Optional unique identifier (UUID) of the associated balance definition.
   * @return balanceDefinitionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceDefinitionId() {
    return balanceDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceDefinitionId(@jakarta.annotation.Nullable String balanceDefinitionId) {
    this.balanceDefinitionId = balanceDefinitionId;
  }

  public BalanceOrder contactId(@jakarta.annotation.Nonnull Integer contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * Unique identifier of the contact placing the order (must be ≥ 1).
   * minimum: 1
   * @return contactId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContactId(@jakarta.annotation.Nonnull Integer contactId) {
    this.contactId = contactId;
  }

  public BalanceOrder createdAt(@jakarta.annotation.Nonnull String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * RFC3339 timestamp indicating when the order was created.
   * @return createdAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCreatedAt(@jakarta.annotation.Nonnull String createdAt) {
    this.createdAt = createdAt;
  }

  public BalanceOrder dueAt(@jakarta.annotation.Nonnull String dueAt) {
    
    this.dueAt = dueAt;
    return this;
  }

  /**
   * RFC3339 timestamp specifying when the order is due in the future.
   * @return dueAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_DUE_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDueAt() {
    return dueAt;
  }


  @JsonProperty(JSON_PROPERTY_DUE_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDueAt(@jakarta.annotation.Nonnull String dueAt) {
    this.dueAt = dueAt;
  }

  public BalanceOrder expiresAt(@jakarta.annotation.Nullable String expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * Optional RFC3339 timestamp defining order expiration in the future.
   * @return expiresAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(@jakarta.annotation.Nullable String expiresAt) {
    this.expiresAt = expiresAt;
  }

  public BalanceOrder id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for the balance order.
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public BalanceOrder loyaltyProgramId(@jakarta.annotation.Nonnull String loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * Unique identifier of the loyalty program associated with the order.
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nonnull String loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public BalanceOrder meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public BalanceOrder putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Optional metadata associated with the order.
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public BalanceOrder processedAt(@jakarta.annotation.Nullable String processedAt) {
    
    this.processedAt = processedAt;
    return this;
  }

  /**
   * Optional RFC3339 timestamp indicating when the order was processed.
   * @return processedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESSED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessedAt() {
    return processedAt;
  }


  @JsonProperty(JSON_PROPERTY_PROCESSED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessedAt(@jakarta.annotation.Nullable String processedAt) {
    this.processedAt = processedAt;
  }

  public BalanceOrder transactionid(@jakarta.annotation.Nullable String transactionid) {
    
    this.transactionid = transactionid;
    return this;
  }

  /**
   * Optional reference to the associated transaction ID.
   * @return transactionid
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TRANSACTIONID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTransactionid() {
    return transactionid;
  }


  @JsonProperty(JSON_PROPERTY_TRANSACTIONID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransactionid(@jakarta.annotation.Nullable String transactionid) {
    this.transactionid = transactionid;
  }

  public BalanceOrder updatedAt(@jakarta.annotation.Nonnull String updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * RFC3339 timestamp indicating the last update to the order.
   * @return updatedAt
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUpdatedAt(@jakarta.annotation.Nonnull String updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceOrder balanceOrder = (BalanceOrder) o;
    return Objects.equals(this.amount, balanceOrder.amount) &&
        Objects.equals(this.balanceDefinitionId, balanceOrder.balanceDefinitionId) &&
        Objects.equals(this.contactId, balanceOrder.contactId) &&
        Objects.equals(this.createdAt, balanceOrder.createdAt) &&
        Objects.equals(this.dueAt, balanceOrder.dueAt) &&
        Objects.equals(this.expiresAt, balanceOrder.expiresAt) &&
        Objects.equals(this.id, balanceOrder.id) &&
        Objects.equals(this.loyaltyProgramId, balanceOrder.loyaltyProgramId) &&
        Objects.equals(this.meta, balanceOrder.meta) &&
        Objects.equals(this.processedAt, balanceOrder.processedAt) &&
        Objects.equals(this.transactionid, balanceOrder.transactionid) &&
        Objects.equals(this.updatedAt, balanceOrder.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, balanceDefinitionId, contactId, createdAt, dueAt, expiresAt, id, loyaltyProgramId, meta, processedAt, transactionid, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceOrder {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balanceDefinitionId: ").append(toIndentedString(balanceDefinitionId)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    dueAt: ").append(toIndentedString(dueAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    processedAt: ").append(toIndentedString(processedAt)).append("\n");
    sb.append("    transactionid: ").append(toIndentedString(transactionid)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `amount` to the URL query string
    if (getAmount() != null) {
      try {
        joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceDefinitionId` to the URL query string
    if (getBalanceDefinitionId() != null) {
      try {
        joiner.add(String.format("%sbalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `dueAt` to the URL query string
    if (getDueAt() != null) {
      try {
        joiner.add(String.format("%sdueAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDueAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expiresAt` to the URL query string
    if (getExpiresAt() != null) {
      try {
        joiner.add(String.format("%sexpiresAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpiresAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processedAt` to the URL query string
    if (getProcessedAt() != null) {
      try {
        joiner.add(String.format("%sprocessedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `transactionid` to the URL query string
    if (getTransactionid() != null) {
      try {
        joiner.add(String.format("%stransactionid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTransactionid()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

