/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * BalanceDefinition
 */
@JsonPropertyOrder({
  BalanceDefinition.JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER,
  BalanceDefinition.JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT,
  BalanceDefinition.JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE,
  BalanceDefinition.JSON_PROPERTY_BALANCE_EXPIRATION_DATE,
  BalanceDefinition.JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY,
  BalanceDefinition.JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING,
  BalanceDefinition.JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING,
  BalanceDefinition.JSON_PROPERTY_CREATED_AT,
  BalanceDefinition.JSON_PROPERTY_DELETED_AT,
  BalanceDefinition.JSON_PROPERTY_DESCRIPTION,
  BalanceDefinition.JSON_PROPERTY_ID,
  BalanceDefinition.JSON_PROPERTY_IMAGE_REF,
  BalanceDefinition.JSON_PROPERTY_MAX_AMOUNT,
  BalanceDefinition.JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT,
  BalanceDefinition.JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT,
  BalanceDefinition.JSON_PROPERTY_META,
  BalanceDefinition.JSON_PROPERTY_MIN_AMOUNT,
  BalanceDefinition.JSON_PROPERTY_NAME,
  BalanceDefinition.JSON_PROPERTY_UNIT,
  BalanceDefinition.JSON_PROPERTY_UPDATED_AT
})
@JsonTypeName("balanceDefinition")
public class BalanceDefinition {
  /**
   * startOfPeriod depicts the balancy expiry on start of day/week/month/year. endOfPeriod depicts the balancy expiry on end of day/week/month/year
   */
  public enum BalanceAvailabilityDurationModifierEnum {
    START_OF_PERIOD(String.valueOf("startOfPeriod")),
    
    END_OF_PERIOD(String.valueOf("endOfPeriod")),
    
    NO_MODIFICATION(String.valueOf("noModification"));

    private String value;

    BalanceAvailabilityDurationModifierEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static BalanceAvailabilityDurationModifierEnum fromValue(String value) {
      for (BalanceAvailabilityDurationModifierEnum b : BalanceAvailabilityDurationModifierEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER = "balanceAvailabilityDurationModifier";
  @jakarta.annotation.Nullable
  private BalanceAvailabilityDurationModifierEnum balanceAvailabilityDurationModifier;

  public static final String JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT = "balanceAvailabilityDurationUnit";
  @jakarta.annotation.Nullable
  private String balanceAvailabilityDurationUnit;

  public static final String JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE = "balanceAvailabilityDurationValue";
  @jakarta.annotation.Nullable
  private Integer balanceAvailabilityDurationValue;

  public static final String JSON_PROPERTY_BALANCE_EXPIRATION_DATE = "balanceExpirationDate";
  @jakarta.annotation.Nullable
  private OffsetDateTime balanceExpirationDate;

  public static final String JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY = "balanceOptionAmountOvertakingStrategy";
  @jakarta.annotation.Nullable
  private String balanceOptionAmountOvertakingStrategy;

  public static final String JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING = "balanceOptionCreditRounding";
  @jakarta.annotation.Nullable
  private String balanceOptionCreditRounding;

  public static final String JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING = "balanceOptionDebitRounding";
  @jakarta.annotation.Nullable
  private String balanceOptionDebitRounding;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private OffsetDateTime createdAt;

  public static final String JSON_PROPERTY_DELETED_AT = "deletedAt";
  @jakarta.annotation.Nullable
  private String deletedAt;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  @jakarta.annotation.Nullable
  private String description;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_IMAGE_REF = "imageRef";
  @jakarta.annotation.Nullable
  private String imageRef;

  public static final String JSON_PROPERTY_MAX_AMOUNT = "maxAmount";
  @jakarta.annotation.Nullable
  private BigDecimal maxAmount;

  public static final String JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT = "maxCreditAmountLimit";
  @jakarta.annotation.Nullable
  private BigDecimal maxCreditAmountLimit;

  public static final String JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT = "maxDebitAmountLimit";
  @jakarta.annotation.Nullable
  private BigDecimal maxDebitAmountLimit;

  public static final String JSON_PROPERTY_META = "meta";
  @jakarta.annotation.Nullable
  private Map<String, Object> meta = new HashMap<>();

  public static final String JSON_PROPERTY_MIN_AMOUNT = "minAmount";
  @jakarta.annotation.Nullable
  private BigDecimal minAmount;

  public static final String JSON_PROPERTY_NAME = "name";
  @jakarta.annotation.Nullable
  private String name;

  public static final String JSON_PROPERTY_UNIT = "unit";
  @jakarta.annotation.Nullable
  private String unit;

  public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
  @jakarta.annotation.Nullable
  private String updatedAt;

  public BalanceDefinition() {
  }

  public BalanceDefinition balanceAvailabilityDurationModifier(@jakarta.annotation.Nullable BalanceAvailabilityDurationModifierEnum balanceAvailabilityDurationModifier) {
    
    this.balanceAvailabilityDurationModifier = balanceAvailabilityDurationModifier;
    return this;
  }

  /**
   * startOfPeriod depicts the balancy expiry on start of day/week/month/year. endOfPeriod depicts the balancy expiry on end of day/week/month/year
   * @return balanceAvailabilityDurationModifier
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BalanceAvailabilityDurationModifierEnum getBalanceAvailabilityDurationModifier() {
    return balanceAvailabilityDurationModifier;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAvailabilityDurationModifier(@jakarta.annotation.Nullable BalanceAvailabilityDurationModifierEnum balanceAvailabilityDurationModifier) {
    this.balanceAvailabilityDurationModifier = balanceAvailabilityDurationModifier;
  }

  public BalanceDefinition balanceAvailabilityDurationUnit(@jakarta.annotation.Nullable String balanceAvailabilityDurationUnit) {
    
    this.balanceAvailabilityDurationUnit = balanceAvailabilityDurationUnit;
    return this;
  }

  /**
   * Unit of time for the balance&#39;s availability (e.g., day/week/month/year).
   * @return balanceAvailabilityDurationUnit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceAvailabilityDurationUnit() {
    return balanceAvailabilityDurationUnit;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAvailabilityDurationUnit(@jakarta.annotation.Nullable String balanceAvailabilityDurationUnit) {
    this.balanceAvailabilityDurationUnit = balanceAvailabilityDurationUnit;
  }

  public BalanceDefinition balanceAvailabilityDurationValue(@jakarta.annotation.Nullable Integer balanceAvailabilityDurationValue) {
    
    this.balanceAvailabilityDurationValue = balanceAvailabilityDurationValue;
    return this;
  }

  /**
   * Number of days/weeks/month/year for balance expiry
   * @return balanceAvailabilityDurationValue
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getBalanceAvailabilityDurationValue() {
    return balanceAvailabilityDurationValue;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_AVAILABILITY_DURATION_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceAvailabilityDurationValue(@jakarta.annotation.Nullable Integer balanceAvailabilityDurationValue) {
    this.balanceAvailabilityDurationValue = balanceAvailabilityDurationValue;
  }

  public BalanceDefinition balanceExpirationDate(@jakarta.annotation.Nullable OffsetDateTime balanceExpirationDate) {
    
    this.balanceExpirationDate = balanceExpirationDate;
    return this;
  }

  /**
   * Date when the balance expires and can no longer be used, in dd/mm format. The balance will be expired when this date appears next in the calendar and only one of balanceExpirationDate or balance availability fields can be used.
   * @return balanceExpirationDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getBalanceExpirationDate() {
    return balanceExpirationDate;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_EXPIRATION_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceExpirationDate(@jakarta.annotation.Nullable OffsetDateTime balanceExpirationDate) {
    this.balanceExpirationDate = balanceExpirationDate;
  }

  public BalanceDefinition balanceOptionAmountOvertakingStrategy(@jakarta.annotation.Nullable String balanceOptionAmountOvertakingStrategy) {
    
    this.balanceOptionAmountOvertakingStrategy = balanceOptionAmountOvertakingStrategy;
    return this;
  }

  /**
   * Partial enables partial credit of balance if maximum balance limit is reaching. Strict enables rejection of transaction if it will breach the max credit amount limit.
   * @return balanceOptionAmountOvertakingStrategy
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceOptionAmountOvertakingStrategy() {
    return balanceOptionAmountOvertakingStrategy;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_AMOUNT_OVERTAKING_STRATEGY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceOptionAmountOvertakingStrategy(@jakarta.annotation.Nullable String balanceOptionAmountOvertakingStrategy) {
    this.balanceOptionAmountOvertakingStrategy = balanceOptionAmountOvertakingStrategy;
  }

  public BalanceDefinition balanceOptionCreditRounding(@jakarta.annotation.Nullable String balanceOptionCreditRounding) {
    
    this.balanceOptionCreditRounding = balanceOptionCreditRounding;
    return this;
  }

  /**
   * Rounding strategy for credit transactions.
   * @return balanceOptionCreditRounding
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceOptionCreditRounding() {
    return balanceOptionCreditRounding;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_CREDIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceOptionCreditRounding(@jakarta.annotation.Nullable String balanceOptionCreditRounding) {
    this.balanceOptionCreditRounding = balanceOptionCreditRounding;
  }

  public BalanceDefinition balanceOptionDebitRounding(@jakarta.annotation.Nullable String balanceOptionDebitRounding) {
    
    this.balanceOptionDebitRounding = balanceOptionDebitRounding;
    return this;
  }

  /**
   * Rounding strategy for debit transactions.
   * @return balanceOptionDebitRounding
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceOptionDebitRounding() {
    return balanceOptionDebitRounding;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_OPTION_DEBIT_ROUNDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceOptionDebitRounding(@jakarta.annotation.Nullable String balanceOptionDebitRounding) {
    this.balanceOptionDebitRounding = balanceOptionDebitRounding;
  }

  public BalanceDefinition createdAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp of balance definition creation.
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public BalanceDefinition deletedAt(@jakarta.annotation.Nullable String deletedAt) {
    
    this.deletedAt = deletedAt;
    return this;
  }

  /**
   * Timestamp of balance definition deletion (nullable).
   * @return deletedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DELETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDeletedAt() {
    return deletedAt;
  }


  @JsonProperty(JSON_PROPERTY_DELETED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeletedAt(@jakarta.annotation.Nullable String deletedAt) {
    this.deletedAt = deletedAt;
  }

  public BalanceDefinition description(@jakarta.annotation.Nullable String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Short description of the balance definition.
   * @return description
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(@jakarta.annotation.Nullable String description) {
    this.description = description;
  }

  public BalanceDefinition id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for the balance definition.
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public BalanceDefinition imageRef(@jakarta.annotation.Nullable String imageRef) {
    
    this.imageRef = imageRef;
    return this;
  }

  /**
   * Optional image reference URL.
   * @return imageRef
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IMAGE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getImageRef() {
    return imageRef;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_REF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageRef(@jakarta.annotation.Nullable String imageRef) {
    this.imageRef = imageRef;
  }

  public BalanceDefinition maxAmount(@jakarta.annotation.Nullable BigDecimal maxAmount) {
    
    this.maxAmount = maxAmount;
    return this;
  }

  /**
   * Maximum allowable balance.
   * @return maxAmount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxAmount() {
    return maxAmount;
  }


  @JsonProperty(JSON_PROPERTY_MAX_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAmount(@jakarta.annotation.Nullable BigDecimal maxAmount) {
    this.maxAmount = maxAmount;
  }

  public BalanceDefinition maxCreditAmountLimit(@jakarta.annotation.Nullable BigDecimal maxCreditAmountLimit) {
    
    this.maxCreditAmountLimit = maxCreditAmountLimit;
    return this;
  }

  /**
   * Max credit allowed per operation.
   * @return maxCreditAmountLimit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxCreditAmountLimit() {
    return maxCreditAmountLimit;
  }


  @JsonProperty(JSON_PROPERTY_MAX_CREDIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxCreditAmountLimit(@jakarta.annotation.Nullable BigDecimal maxCreditAmountLimit) {
    this.maxCreditAmountLimit = maxCreditAmountLimit;
  }

  public BalanceDefinition maxDebitAmountLimit(@jakarta.annotation.Nullable BigDecimal maxDebitAmountLimit) {
    
    this.maxDebitAmountLimit = maxDebitAmountLimit;
    return this;
  }

  /**
   * Max debit allowed per operation.
   * @return maxDebitAmountLimit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMaxDebitAmountLimit() {
    return maxDebitAmountLimit;
  }


  @JsonProperty(JSON_PROPERTY_MAX_DEBIT_AMOUNT_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxDebitAmountLimit(@jakarta.annotation.Nullable BigDecimal maxDebitAmountLimit) {
    this.maxDebitAmountLimit = maxDebitAmountLimit;
  }

  public BalanceDefinition meta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    
    this.meta = meta;
    return this;
  }

  public BalanceDefinition putMetaItem(String key, Object metaItem) {
    if (this.meta == null) {
      this.meta = new HashMap<>();
    }
    this.meta.put(key, metaItem);
    return this;
  }

  /**
   * Additional metadata for the balance definition.
   * @return meta
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getMeta() {
    return meta;
  }


  @JsonProperty(JSON_PROPERTY_META)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setMeta(@jakarta.annotation.Nullable Map<String, Object> meta) {
    this.meta = meta;
  }

  public BalanceDefinition minAmount(@jakarta.annotation.Nullable BigDecimal minAmount) {
    
    this.minAmount = minAmount;
    return this;
  }

  /**
   * Minimum allowable balance.
   * @return minAmount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_MIN_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getMinAmount() {
    return minAmount;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAmount(@jakarta.annotation.Nullable BigDecimal minAmount) {
    this.minAmount = minAmount;
  }

  public BalanceDefinition name(@jakarta.annotation.Nullable String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Name of the balance definition.
   * @return name
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(@jakarta.annotation.Nullable String name) {
    this.name = name;
  }

  public BalanceDefinition unit(@jakarta.annotation.Nullable String unit) {
    
    this.unit = unit;
    return this;
  }

  /**
   * Unit of balance (e.g., points, currency).
   * @return unit
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUnit() {
    return unit;
  }


  @JsonProperty(JSON_PROPERTY_UNIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnit(@jakarta.annotation.Nullable String unit) {
    this.unit = unit;
  }

  public BalanceDefinition updatedAt(@jakarta.annotation.Nullable String updatedAt) {
    
    this.updatedAt = updatedAt;
    return this;
  }

  /**
   * Timestamp of the last update.
   * @return updatedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUpdatedAt() {
    return updatedAt;
  }


  @JsonProperty(JSON_PROPERTY_UPDATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpdatedAt(@jakarta.annotation.Nullable String updatedAt) {
    this.updatedAt = updatedAt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BalanceDefinition balanceDefinition = (BalanceDefinition) o;
    return Objects.equals(this.balanceAvailabilityDurationModifier, balanceDefinition.balanceAvailabilityDurationModifier) &&
        Objects.equals(this.balanceAvailabilityDurationUnit, balanceDefinition.balanceAvailabilityDurationUnit) &&
        Objects.equals(this.balanceAvailabilityDurationValue, balanceDefinition.balanceAvailabilityDurationValue) &&
        Objects.equals(this.balanceExpirationDate, balanceDefinition.balanceExpirationDate) &&
        Objects.equals(this.balanceOptionAmountOvertakingStrategy, balanceDefinition.balanceOptionAmountOvertakingStrategy) &&
        Objects.equals(this.balanceOptionCreditRounding, balanceDefinition.balanceOptionCreditRounding) &&
        Objects.equals(this.balanceOptionDebitRounding, balanceDefinition.balanceOptionDebitRounding) &&
        Objects.equals(this.createdAt, balanceDefinition.createdAt) &&
        Objects.equals(this.deletedAt, balanceDefinition.deletedAt) &&
        Objects.equals(this.description, balanceDefinition.description) &&
        Objects.equals(this.id, balanceDefinition.id) &&
        Objects.equals(this.imageRef, balanceDefinition.imageRef) &&
        Objects.equals(this.maxAmount, balanceDefinition.maxAmount) &&
        Objects.equals(this.maxCreditAmountLimit, balanceDefinition.maxCreditAmountLimit) &&
        Objects.equals(this.maxDebitAmountLimit, balanceDefinition.maxDebitAmountLimit) &&
        Objects.equals(this.meta, balanceDefinition.meta) &&
        Objects.equals(this.minAmount, balanceDefinition.minAmount) &&
        Objects.equals(this.name, balanceDefinition.name) &&
        Objects.equals(this.unit, balanceDefinition.unit) &&
        Objects.equals(this.updatedAt, balanceDefinition.updatedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(balanceAvailabilityDurationModifier, balanceAvailabilityDurationUnit, balanceAvailabilityDurationValue, balanceExpirationDate, balanceOptionAmountOvertakingStrategy, balanceOptionCreditRounding, balanceOptionDebitRounding, createdAt, deletedAt, description, id, imageRef, maxAmount, maxCreditAmountLimit, maxDebitAmountLimit, meta, minAmount, name, unit, updatedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BalanceDefinition {\n");
    sb.append("    balanceAvailabilityDurationModifier: ").append(toIndentedString(balanceAvailabilityDurationModifier)).append("\n");
    sb.append("    balanceAvailabilityDurationUnit: ").append(toIndentedString(balanceAvailabilityDurationUnit)).append("\n");
    sb.append("    balanceAvailabilityDurationValue: ").append(toIndentedString(balanceAvailabilityDurationValue)).append("\n");
    sb.append("    balanceExpirationDate: ").append(toIndentedString(balanceExpirationDate)).append("\n");
    sb.append("    balanceOptionAmountOvertakingStrategy: ").append(toIndentedString(balanceOptionAmountOvertakingStrategy)).append("\n");
    sb.append("    balanceOptionCreditRounding: ").append(toIndentedString(balanceOptionCreditRounding)).append("\n");
    sb.append("    balanceOptionDebitRounding: ").append(toIndentedString(balanceOptionDebitRounding)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    deletedAt: ").append(toIndentedString(deletedAt)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    imageRef: ").append(toIndentedString(imageRef)).append("\n");
    sb.append("    maxAmount: ").append(toIndentedString(maxAmount)).append("\n");
    sb.append("    maxCreditAmountLimit: ").append(toIndentedString(maxCreditAmountLimit)).append("\n");
    sb.append("    maxDebitAmountLimit: ").append(toIndentedString(maxDebitAmountLimit)).append("\n");
    sb.append("    meta: ").append(toIndentedString(meta)).append("\n");
    sb.append("    minAmount: ").append(toIndentedString(minAmount)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    updatedAt: ").append(toIndentedString(updatedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `balanceAvailabilityDurationModifier` to the URL query string
    if (getBalanceAvailabilityDurationModifier() != null) {
      try {
        joiner.add(String.format("%sbalanceAvailabilityDurationModifier%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceAvailabilityDurationModifier()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceAvailabilityDurationUnit` to the URL query string
    if (getBalanceAvailabilityDurationUnit() != null) {
      try {
        joiner.add(String.format("%sbalanceAvailabilityDurationUnit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceAvailabilityDurationUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceAvailabilityDurationValue` to the URL query string
    if (getBalanceAvailabilityDurationValue() != null) {
      try {
        joiner.add(String.format("%sbalanceAvailabilityDurationValue%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceAvailabilityDurationValue()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceExpirationDate` to the URL query string
    if (getBalanceExpirationDate() != null) {
      try {
        joiner.add(String.format("%sbalanceExpirationDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceExpirationDate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceOptionAmountOvertakingStrategy` to the URL query string
    if (getBalanceOptionAmountOvertakingStrategy() != null) {
      try {
        joiner.add(String.format("%sbalanceOptionAmountOvertakingStrategy%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceOptionAmountOvertakingStrategy()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceOptionCreditRounding` to the URL query string
    if (getBalanceOptionCreditRounding() != null) {
      try {
        joiner.add(String.format("%sbalanceOptionCreditRounding%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceOptionCreditRounding()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceOptionDebitRounding` to the URL query string
    if (getBalanceOptionDebitRounding() != null) {
      try {
        joiner.add(String.format("%sbalanceOptionDebitRounding%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceOptionDebitRounding()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `deletedAt` to the URL query string
    if (getDeletedAt() != null) {
      try {
        joiner.add(String.format("%sdeletedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDeletedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `description` to the URL query string
    if (getDescription() != null) {
      try {
        joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getDescription()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `imageRef` to the URL query string
    if (getImageRef() != null) {
      try {
        joiner.add(String.format("%simageRef%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getImageRef()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxAmount` to the URL query string
    if (getMaxAmount() != null) {
      try {
        joiner.add(String.format("%smaxAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxCreditAmountLimit` to the URL query string
    if (getMaxCreditAmountLimit() != null) {
      try {
        joiner.add(String.format("%smaxCreditAmountLimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxCreditAmountLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `maxDebitAmountLimit` to the URL query string
    if (getMaxDebitAmountLimit() != null) {
      try {
        joiner.add(String.format("%smaxDebitAmountLimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMaxDebitAmountLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `meta` to the URL query string
    if (getMeta() != null) {
      for (String _key : getMeta().keySet()) {
        try {
          joiner.add(String.format("%smeta%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getMeta().get(_key), URLEncoder.encode(String.valueOf(getMeta().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `minAmount` to the URL query string
    if (getMinAmount() != null) {
      try {
        joiner.add(String.format("%sminAmount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getMinAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `name` to the URL query string
    if (getName() != null) {
      try {
        joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getName()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `unit` to the URL query string
    if (getUnit() != null) {
      try {
        joiner.add(String.format("%sunit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUnit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `updatedAt` to the URL query string
    if (getUpdatedAt() != null) {
      try {
        joiner.add(String.format("%supdatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getUpdatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

