/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Balance
 */
@JsonPropertyOrder({
  Balance.JSON_PROPERTY_AMOUNT,
  Balance.JSON_PROPERTY_BALANCE_DEFINITION_ID,
  Balance.JSON_PROPERTY_CONSUMED_AT,
  Balance.JSON_PROPERTY_CONTACT_ID,
  Balance.JSON_PROPERTY_CREATED_AT,
  Balance.JSON_PROPERTY_EXPIRES_AT,
  Balance.JSON_PROPERTY_ID,
  Balance.JSON_PROPERTY_LOYALTY_PROGRAM_ID,
  Balance.JSON_PROPERTY_ORGANIZATION_ID
})
@JsonTypeName("balance")
public class Balance {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  @jakarta.annotation.Nullable
  private BigDecimal amount;

  public static final String JSON_PROPERTY_BALANCE_DEFINITION_ID = "balanceDefinitionId";
  @jakarta.annotation.Nullable
  private String balanceDefinitionId;

  public static final String JSON_PROPERTY_CONSUMED_AT = "consumedAt";
  @jakarta.annotation.Nullable
  private String consumedAt;

  public static final String JSON_PROPERTY_CONTACT_ID = "contactId";
  @jakarta.annotation.Nullable
  private Integer contactId;

  public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
  @jakarta.annotation.Nullable
  private String createdAt;

  public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
  @jakarta.annotation.Nullable
  private String expiresAt;

  public static final String JSON_PROPERTY_ID = "id";
  @jakarta.annotation.Nullable
  private String id;

  public static final String JSON_PROPERTY_LOYALTY_PROGRAM_ID = "loyaltyProgramId";
  @jakarta.annotation.Nullable
  private String loyaltyProgramId;

  public static final String JSON_PROPERTY_ORGANIZATION_ID = "organizationId";
  @jakarta.annotation.Nullable
  private Integer organizationId;

  public Balance() {
  }

  public Balance amount(@jakarta.annotation.Nullable BigDecimal amount) {
    
    this.amount = amount;
    return this;
  }

  /**
   * The current amount available in the balance
   * @return amount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(@jakarta.annotation.Nullable BigDecimal amount) {
    this.amount = amount;
  }

  public Balance balanceDefinitionId(@jakarta.annotation.Nullable String balanceDefinitionId) {
    
    this.balanceDefinitionId = balanceDefinitionId;
    return this;
  }

  /**
   * balance definition ID
   * @return balanceDefinitionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBalanceDefinitionId() {
    return balanceDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_BALANCE_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBalanceDefinitionId(@jakarta.annotation.Nullable String balanceDefinitionId) {
    this.balanceDefinitionId = balanceDefinitionId;
  }

  public Balance consumedAt(@jakarta.annotation.Nullable String consumedAt) {
    
    this.consumedAt = consumedAt;
    return this;
  }

  /**
   * Timestamp of when the balance was last consumed
   * @return consumedAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONSUMED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getConsumedAt() {
    return consumedAt;
  }


  @JsonProperty(JSON_PROPERTY_CONSUMED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConsumedAt(@jakarta.annotation.Nullable String consumedAt) {
    this.consumedAt = consumedAt;
  }

  public Balance contactId(@jakarta.annotation.Nullable Integer contactId) {
    
    this.contactId = contactId;
    return this;
  }

  /**
   * contact ID
   * @return contactId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getContactId() {
    return contactId;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactId(@jakarta.annotation.Nullable Integer contactId) {
    this.contactId = contactId;
  }

  public Balance createdAt(@jakarta.annotation.Nullable String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

  /**
   * Timestamp of when the balance was created
   * @return createdAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(@jakarta.annotation.Nullable String createdAt) {
    this.createdAt = createdAt;
  }

  public Balance expiresAt(@jakarta.annotation.Nullable String expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

  /**
   * Expiration timestamp of the balance
   * @return expiresAt
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExpiresAt() {
    return expiresAt;
  }


  @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExpiresAt(@jakarta.annotation.Nullable String expiresAt) {
    this.expiresAt = expiresAt;
  }

  public Balance id(@jakarta.annotation.Nullable String id) {
    
    this.id = id;
    return this;
  }

  /**
   * Unique identifier for the balance
   * @return id
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(@jakarta.annotation.Nullable String id) {
    this.id = id;
  }

  public Balance loyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    
    this.loyaltyProgramId = loyaltyProgramId;
    return this;
  }

  /**
   * loyalty program ID
   * @return loyaltyProgramId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLoyaltyProgramId() {
    return loyaltyProgramId;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_PROGRAM_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyProgramId(@jakarta.annotation.Nullable String loyaltyProgramId) {
    this.loyaltyProgramId = loyaltyProgramId;
  }

  public Balance organizationId(@jakarta.annotation.Nullable Integer organizationId) {
    
    this.organizationId = organizationId;
    return this;
  }

  /**
   * organization ID
   * @return organizationId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ORGANIZATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getOrganizationId() {
    return organizationId;
  }


  @JsonProperty(JSON_PROPERTY_ORGANIZATION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrganizationId(@jakarta.annotation.Nullable Integer organizationId) {
    this.organizationId = organizationId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Balance balance = (Balance) o;
    return Objects.equals(this.amount, balance.amount) &&
        Objects.equals(this.balanceDefinitionId, balance.balanceDefinitionId) &&
        Objects.equals(this.consumedAt, balance.consumedAt) &&
        Objects.equals(this.contactId, balance.contactId) &&
        Objects.equals(this.createdAt, balance.createdAt) &&
        Objects.equals(this.expiresAt, balance.expiresAt) &&
        Objects.equals(this.id, balance.id) &&
        Objects.equals(this.loyaltyProgramId, balance.loyaltyProgramId) &&
        Objects.equals(this.organizationId, balance.organizationId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, balanceDefinitionId, consumedAt, contactId, createdAt, expiresAt, id, loyaltyProgramId, organizationId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Balance {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    balanceDefinitionId: ").append(toIndentedString(balanceDefinitionId)).append("\n");
    sb.append("    consumedAt: ").append(toIndentedString(consumedAt)).append("\n");
    sb.append("    contactId: ").append(toIndentedString(contactId)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    loyaltyProgramId: ").append(toIndentedString(loyaltyProgramId)).append("\n");
    sb.append("    organizationId: ").append(toIndentedString(organizationId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `amount` to the URL query string
    if (getAmount() != null) {
      try {
        joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAmount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `balanceDefinitionId` to the URL query string
    if (getBalanceDefinitionId() != null) {
      try {
        joiner.add(String.format("%sbalanceDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBalanceDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `consumedAt` to the URL query string
    if (getConsumedAt() != null) {
      try {
        joiner.add(String.format("%sconsumedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getConsumedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `contactId` to the URL query string
    if (getContactId() != null) {
      try {
        joiner.add(String.format("%scontactId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getContactId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `createdAt` to the URL query string
    if (getCreatedAt() != null) {
      try {
        joiner.add(String.format("%screatedAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCreatedAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `expiresAt` to the URL query string
    if (getExpiresAt() != null) {
      try {
        joiner.add(String.format("%sexpiresAt%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getExpiresAt()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `id` to the URL query string
    if (getId() != null) {
      try {
        joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `loyaltyProgramId` to the URL query string
    if (getLoyaltyProgramId() != null) {
      try {
        joiner.add(String.format("%sloyaltyProgramId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLoyaltyProgramId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `organizationId` to the URL query string
    if (getOrganizationId() != null) {
      try {
        joiner.add(String.format("%sorganizationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOrganizationId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

