/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Percentage of a particular event for both versions
 */
@JsonPropertyOrder({
  AbTestVersionStats.JSON_PROPERTY_VERSION_A,
  AbTestVersionStats.JSON_PROPERTY_VERSION_B
})
@JsonTypeName("abTestVersionStats")
public class AbTestVersionStats {
  public static final String JSON_PROPERTY_VERSION_A = "Version A";
  @jakarta.annotation.Nonnull
  private String versionA;

  public static final String JSON_PROPERTY_VERSION_B = "Version B";
  @jakarta.annotation.Nonnull
  private String versionB;

  public AbTestVersionStats() {
  }

  public AbTestVersionStats versionA(@jakarta.annotation.Nonnull String versionA) {
    
    this.versionA = versionA;
    return this;
  }

  /**
   * percentage of an event for version A
   * @return versionA
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VERSION_A)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVersionA() {
    return versionA;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_A)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVersionA(@jakarta.annotation.Nonnull String versionA) {
    this.versionA = versionA;
  }

  public AbTestVersionStats versionB(@jakarta.annotation.Nonnull String versionB) {
    
    this.versionB = versionB;
    return this;
  }

  /**
   * percentage of an event for version B
   * @return versionB
   */
  @jakarta.annotation.Nonnull
  @JsonProperty(JSON_PROPERTY_VERSION_B)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVersionB() {
    return versionB;
  }


  @JsonProperty(JSON_PROPERTY_VERSION_B)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVersionB(@jakarta.annotation.Nonnull String versionB) {
    this.versionB = versionB;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbTestVersionStats abTestVersionStats = (AbTestVersionStats) o;
    return Objects.equals(this.versionA, abTestVersionStats.versionA) &&
        Objects.equals(this.versionB, abTestVersionStats.versionB);
  }

  @Override
  public int hashCode() {
    return Objects.hash(versionA, versionB);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbTestVersionStats {\n");
    sb.append("    versionA: ").append(toIndentedString(versionA)).append("\n");
    sb.append("    versionB: ").append(toIndentedString(versionB)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `Version A` to the URL query string
    if (getVersionA() != null) {
      try {
        joiner.add(String.format("%sVersion A%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersionA()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `Version B` to the URL query string
    if (getVersionB() != null) {
      try {
        joiner.add(String.format("%sVersion B%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getVersionB()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

