/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package software.xdev.brevo.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import software.xdev.brevo.model.AbTestCampaignResultClickedLinks;
import software.xdev.brevo.model.AbTestCampaignResultStatistics;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * AbTestCampaignResult
 */
@JsonPropertyOrder({
  AbTestCampaignResult.JSON_PROPERTY_WINNING_VERSION,
  AbTestCampaignResult.JSON_PROPERTY_WINNING_CRITERIA,
  AbTestCampaignResult.JSON_PROPERTY_WINNING_SUBJECT_LINE,
  AbTestCampaignResult.JSON_PROPERTY_OPEN_RATE,
  AbTestCampaignResult.JSON_PROPERTY_CLICK_RATE,
  AbTestCampaignResult.JSON_PROPERTY_WINNING_VERSION_RATE,
  AbTestCampaignResult.JSON_PROPERTY_STATISTICS,
  AbTestCampaignResult.JSON_PROPERTY_CLICKED_LINKS
})
@JsonTypeName("abTestCampaignResult")
public class AbTestCampaignResult {
  /**
   * Winning Campaign Info. pending &#x3D; Campaign has been picked for sending and winning version is yet to be decided, tie &#x3D; A tie happened between both the versions, notAvailable &#x3D; Campaign has not yet been picked for sending.
   */
  public enum WinningVersionEnum {
    NOT_AVAILABLE(String.valueOf("notAvailable")),
    
    PENDING(String.valueOf("pending")),
    
    TIE(String.valueOf("tie")),
    
    A(String.valueOf("A")),
    
    B(String.valueOf("B"));

    private String value;

    WinningVersionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WinningVersionEnum fromValue(String value) {
      for (WinningVersionEnum b : WinningVersionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WINNING_VERSION = "winningVersion";
  @jakarta.annotation.Nullable
  private WinningVersionEnum winningVersion;

  /**
   * Criteria choosen for winning version (Open/Click)
   */
  public enum WinningCriteriaEnum {
    OPEN(String.valueOf("Open")),
    
    CLICK(String.valueOf("Click"));

    private String value;

    WinningCriteriaEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WinningCriteriaEnum fromValue(String value) {
      for (WinningCriteriaEnum b : WinningCriteriaEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WINNING_CRITERIA = "winningCriteria";
  @jakarta.annotation.Nullable
  private WinningCriteriaEnum winningCriteria;

  public static final String JSON_PROPERTY_WINNING_SUBJECT_LINE = "winningSubjectLine";
  @jakarta.annotation.Nullable
  private String winningSubjectLine;

  public static final String JSON_PROPERTY_OPEN_RATE = "openRate";
  @jakarta.annotation.Nullable
  private String openRate;

  public static final String JSON_PROPERTY_CLICK_RATE = "clickRate";
  @jakarta.annotation.Nullable
  private String clickRate;

  public static final String JSON_PROPERTY_WINNING_VERSION_RATE = "winningVersionRate";
  @jakarta.annotation.Nullable
  private String winningVersionRate;

  public static final String JSON_PROPERTY_STATISTICS = "statistics";
  @jakarta.annotation.Nullable
  private AbTestCampaignResultStatistics statistics;

  public static final String JSON_PROPERTY_CLICKED_LINKS = "clickedLinks";
  @jakarta.annotation.Nullable
  private AbTestCampaignResultClickedLinks clickedLinks;

  public AbTestCampaignResult() {
  }

  public AbTestCampaignResult winningVersion(@jakarta.annotation.Nullable WinningVersionEnum winningVersion) {
    
    this.winningVersion = winningVersion;
    return this;
  }

  /**
   * Winning Campaign Info. pending &#x3D; Campaign has been picked for sending and winning version is yet to be decided, tie &#x3D; A tie happened between both the versions, notAvailable &#x3D; Campaign has not yet been picked for sending.
   * @return winningVersion
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNING_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WinningVersionEnum getWinningVersion() {
    return winningVersion;
  }


  @JsonProperty(JSON_PROPERTY_WINNING_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinningVersion(@jakarta.annotation.Nullable WinningVersionEnum winningVersion) {
    this.winningVersion = winningVersion;
  }

  public AbTestCampaignResult winningCriteria(@jakarta.annotation.Nullable WinningCriteriaEnum winningCriteria) {
    
    this.winningCriteria = winningCriteria;
    return this;
  }

  /**
   * Criteria choosen for winning version (Open/Click)
   * @return winningCriteria
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNING_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WinningCriteriaEnum getWinningCriteria() {
    return winningCriteria;
  }


  @JsonProperty(JSON_PROPERTY_WINNING_CRITERIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinningCriteria(@jakarta.annotation.Nullable WinningCriteriaEnum winningCriteria) {
    this.winningCriteria = winningCriteria;
  }

  public AbTestCampaignResult winningSubjectLine(@jakarta.annotation.Nullable String winningSubjectLine) {
    
    this.winningSubjectLine = winningSubjectLine;
    return this;
  }

  /**
   * Subject Line of current winning version
   * @return winningSubjectLine
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNING_SUBJECT_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWinningSubjectLine() {
    return winningSubjectLine;
  }


  @JsonProperty(JSON_PROPERTY_WINNING_SUBJECT_LINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinningSubjectLine(@jakarta.annotation.Nullable String winningSubjectLine) {
    this.winningSubjectLine = winningSubjectLine;
  }

  public AbTestCampaignResult openRate(@jakarta.annotation.Nullable String openRate) {
    
    this.openRate = openRate;
    return this;
  }

  /**
   * Open rate for current winning version
   * @return openRate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPEN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOpenRate() {
    return openRate;
  }


  @JsonProperty(JSON_PROPERTY_OPEN_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOpenRate(@jakarta.annotation.Nullable String openRate) {
    this.openRate = openRate;
  }

  public AbTestCampaignResult clickRate(@jakarta.annotation.Nullable String clickRate) {
    
    this.clickRate = clickRate;
    return this;
  }

  /**
   * Click rate for current winning version
   * @return clickRate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLICK_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getClickRate() {
    return clickRate;
  }


  @JsonProperty(JSON_PROPERTY_CLICK_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClickRate(@jakarta.annotation.Nullable String clickRate) {
    this.clickRate = clickRate;
  }

  public AbTestCampaignResult winningVersionRate(@jakarta.annotation.Nullable String winningVersionRate) {
    
    this.winningVersionRate = winningVersionRate;
    return this;
  }

  /**
   * Open/Click rate for the winner version
   * @return winningVersionRate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WINNING_VERSION_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWinningVersionRate() {
    return winningVersionRate;
  }


  @JsonProperty(JSON_PROPERTY_WINNING_VERSION_RATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWinningVersionRate(@jakarta.annotation.Nullable String winningVersionRate) {
    this.winningVersionRate = winningVersionRate;
  }

  public AbTestCampaignResult statistics(@jakarta.annotation.Nullable AbTestCampaignResultStatistics statistics) {
    
    this.statistics = statistics;
    return this;
  }

  /**
   * Get statistics
   * @return statistics
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATISTICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AbTestCampaignResultStatistics getStatistics() {
    return statistics;
  }


  @JsonProperty(JSON_PROPERTY_STATISTICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStatistics(@jakarta.annotation.Nullable AbTestCampaignResultStatistics statistics) {
    this.statistics = statistics;
  }

  public AbTestCampaignResult clickedLinks(@jakarta.annotation.Nullable AbTestCampaignResultClickedLinks clickedLinks) {
    
    this.clickedLinks = clickedLinks;
    return this;
  }

  /**
   * Get clickedLinks
   * @return clickedLinks
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLICKED_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AbTestCampaignResultClickedLinks getClickedLinks() {
    return clickedLinks;
  }


  @JsonProperty(JSON_PROPERTY_CLICKED_LINKS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClickedLinks(@jakarta.annotation.Nullable AbTestCampaignResultClickedLinks clickedLinks) {
    this.clickedLinks = clickedLinks;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbTestCampaignResult abTestCampaignResult = (AbTestCampaignResult) o;
    return Objects.equals(this.winningVersion, abTestCampaignResult.winningVersion) &&
        Objects.equals(this.winningCriteria, abTestCampaignResult.winningCriteria) &&
        Objects.equals(this.winningSubjectLine, abTestCampaignResult.winningSubjectLine) &&
        Objects.equals(this.openRate, abTestCampaignResult.openRate) &&
        Objects.equals(this.clickRate, abTestCampaignResult.clickRate) &&
        Objects.equals(this.winningVersionRate, abTestCampaignResult.winningVersionRate) &&
        Objects.equals(this.statistics, abTestCampaignResult.statistics) &&
        Objects.equals(this.clickedLinks, abTestCampaignResult.clickedLinks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(winningVersion, winningCriteria, winningSubjectLine, openRate, clickRate, winningVersionRate, statistics, clickedLinks);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbTestCampaignResult {\n");
    sb.append("    winningVersion: ").append(toIndentedString(winningVersion)).append("\n");
    sb.append("    winningCriteria: ").append(toIndentedString(winningCriteria)).append("\n");
    sb.append("    winningSubjectLine: ").append(toIndentedString(winningSubjectLine)).append("\n");
    sb.append("    openRate: ").append(toIndentedString(openRate)).append("\n");
    sb.append("    clickRate: ").append(toIndentedString(clickRate)).append("\n");
    sb.append("    winningVersionRate: ").append(toIndentedString(winningVersionRate)).append("\n");
    sb.append("    statistics: ").append(toIndentedString(statistics)).append("\n");
    sb.append("    clickedLinks: ").append(toIndentedString(clickedLinks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `winningVersion` to the URL query string
    if (getWinningVersion() != null) {
      try {
        joiner.add(String.format("%swinningVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinningVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winningCriteria` to the URL query string
    if (getWinningCriteria() != null) {
      try {
        joiner.add(String.format("%swinningCriteria%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinningCriteria()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winningSubjectLine` to the URL query string
    if (getWinningSubjectLine() != null) {
      try {
        joiner.add(String.format("%swinningSubjectLine%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinningSubjectLine()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `openRate` to the URL query string
    if (getOpenRate() != null) {
      try {
        joiner.add(String.format("%sopenRate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOpenRate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `clickRate` to the URL query string
    if (getClickRate() != null) {
      try {
        joiner.add(String.format("%sclickRate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getClickRate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `winningVersionRate` to the URL query string
    if (getWinningVersionRate() != null) {
      try {
        joiner.add(String.format("%swinningVersionRate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getWinningVersionRate()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `statistics` to the URL query string
    if (getStatistics() != null) {
      joiner.add(getStatistics().toUrlQueryString(prefix + "statistics" + suffix));
    }

    // add `clickedLinks` to the URL query string
    if (getClickedLinks() != null) {
      joiner.add(getClickedLinks().toUrlQueryString(prefix + "clickedLinks" + suffix));
    }

    return joiner.toString();
  }

}

