/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateWhatsAppCampaign;
import software.xdev.brevo.model.CreateWhatsAppTemplate;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetWhatsAppConfig;
import software.xdev.brevo.model.GetWhatsappCampaignOverview;
import software.xdev.brevo.model.GetWhatsappCampaigns;
import software.xdev.brevo.model.GetWhatsappTemplates;
import software.xdev.brevo.model.UpdateWhatsAppCampaign;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class WhatsAppCampaignsApi extends BaseApi {

  public WhatsAppCampaignsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public WhatsAppCampaignsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create and Send a WhatsApp campaign
   * 
   * @param createWhatsAppCampaign Values to create a WhatsApp Campaign (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createWhatsAppCampaign(@jakarta.annotation.Nonnull CreateWhatsAppCampaign createWhatsAppCampaign) throws ApiException {
    return this.createWhatsAppCampaign(createWhatsAppCampaign, Collections.emptyMap());
  }


  /**
   * Create and Send a WhatsApp campaign
   * 
   * @param createWhatsAppCampaign Values to create a WhatsApp Campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createWhatsAppCampaign(@jakarta.annotation.Nonnull CreateWhatsAppCampaign createWhatsAppCampaign, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createWhatsAppCampaign;
    
    // verify the required parameter 'createWhatsAppCampaign' is set
    if (createWhatsAppCampaign == null) {
      throw new ApiException(400, "Missing the required parameter 'createWhatsAppCampaign' when calling createWhatsAppCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a WhatsApp template
   * 
   * @param createWhatsAppTemplate Values to create a WhatsApp template (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createWhatsAppTemplate(@jakarta.annotation.Nonnull CreateWhatsAppTemplate createWhatsAppTemplate) throws ApiException {
    return this.createWhatsAppTemplate(createWhatsAppTemplate, Collections.emptyMap());
  }


  /**
   * Create a WhatsApp template
   * 
   * @param createWhatsAppTemplate Values to create a WhatsApp template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createWhatsAppTemplate(@jakarta.annotation.Nonnull CreateWhatsAppTemplate createWhatsAppTemplate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createWhatsAppTemplate;
    
    // verify the required parameter 'createWhatsAppTemplate' is set
    if (createWhatsAppTemplate == null) {
      throw new ApiException(400, "Missing the required parameter 'createWhatsAppTemplate' when calling createWhatsAppTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/template";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a WhatsApp campaign
   * 
   * @param campaignId id of the campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteWhatsAppCampaign(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    this.deleteWhatsAppCampaign(campaignId, Collections.emptyMap());
  }


  /**
   * Delete a WhatsApp campaign
   * 
   * @param campaignId id of the campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteWhatsAppCampaign(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling deleteWhatsAppCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get a WhatsApp campaign
   * 
   * @param campaignId Id of the campaign (required)
   * @return GetWhatsappCampaignOverview
   * @throws ApiException if fails to make API call
   */
  public GetWhatsappCampaignOverview getWhatsAppCampaign(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    return this.getWhatsAppCampaign(campaignId, Collections.emptyMap());
  }


  /**
   * Get a WhatsApp campaign
   * 
   * @param campaignId Id of the campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetWhatsappCampaignOverview
   * @throws ApiException if fails to make API call
   */
  public GetWhatsappCampaignOverview getWhatsAppCampaign(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getWhatsAppCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetWhatsappCampaignOverview> localVarReturnType = new TypeReference<GetWhatsappCampaignOverview>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Return all your created WhatsApp campaigns
   * 
   * @param startDate **Mandatory if endDate is used**. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the WhatsApp campaigns created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the WhatsApp campaigns created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record modification. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetWhatsappCampaigns
   * @throws ApiException if fails to make API call
   */
  public GetWhatsappCampaigns getWhatsAppCampaigns(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getWhatsAppCampaigns(startDate, endDate, limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Return all your created WhatsApp campaigns
   * 
   * @param startDate **Mandatory if endDate is used**. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the WhatsApp campaigns created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the WhatsApp campaigns created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record modification. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetWhatsappCampaigns
   * @throws ApiException if fails to make API call
   */
  public GetWhatsappCampaigns getWhatsAppCampaigns(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetWhatsappCampaigns> localVarReturnType = new TypeReference<GetWhatsappCampaigns>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get your WhatsApp API account information
   * 
   * @return GetWhatsAppConfig
   * @throws ApiException if fails to make API call
   */
  public GetWhatsAppConfig getWhatsAppConfig() throws ApiException {
    return this.getWhatsAppConfig(Collections.emptyMap());
  }


  /**
   * Get your WhatsApp API account information
   * 
   * @param additionalHeaders additionalHeaders for this call
   * @return GetWhatsAppConfig
   * @throws ApiException if fails to make API call
   */
  public GetWhatsAppConfig getWhatsAppConfig(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/config";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetWhatsAppConfig> localVarReturnType = new TypeReference<GetWhatsAppConfig>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Return all your created WhatsApp templates
   * 
   * @param startDate **Mandatory if endDate is used**. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the templates created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the templates created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record modification. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param source source of the template (optional)
   * @return GetWhatsappTemplates
   * @throws ApiException if fails to make API call
   */
  public GetWhatsappTemplates getWhatsAppTemplates(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String source) throws ApiException {
    return this.getWhatsAppTemplates(startDate, endDate, limit, offset, sort, source, Collections.emptyMap());
  }


  /**
   * Return all your created WhatsApp templates
   * 
   * @param startDate **Mandatory if endDate is used**. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the templates created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the templates created. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record modification. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param source source of the template (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetWhatsappTemplates
   * @throws ApiException if fails to make API call
   */
  public GetWhatsappTemplates getWhatsAppTemplates(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String source, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/template-list";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("source", source));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetWhatsappTemplates> localVarReturnType = new TypeReference<GetWhatsappTemplates>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send your WhatsApp template for approval
   * 
   * @param templateId id of the template (required)
   * @throws ApiException if fails to make API call
   */
  public void sendWhatsAppTemplateApproval(@jakarta.annotation.Nonnull Long templateId) throws ApiException {
    this.sendWhatsAppTemplateApproval(templateId, Collections.emptyMap());
  }


  /**
   * Send your WhatsApp template for approval
   * 
   * @param templateId id of the template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendWhatsAppTemplateApproval(@jakarta.annotation.Nonnull Long templateId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'templateId' is set
    if (templateId == null) {
      throw new ApiException(400, "Missing the required parameter 'templateId' when calling sendWhatsAppTemplateApproval");
    }
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/template/approval/{templateId}"
      .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(apiClient.parameterToString(templateId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update a WhatsApp campaign
   * 
   * @param campaignId id of the campaign (required)
   * @param updateWhatsAppCampaign Values to update a WhatsApp Campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void updateWhatsAppCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateWhatsAppCampaign updateWhatsAppCampaign) throws ApiException {
    this.updateWhatsAppCampaign(campaignId, updateWhatsAppCampaign, Collections.emptyMap());
  }


  /**
   * Update a WhatsApp campaign
   * 
   * @param campaignId id of the campaign (required)
   * @param updateWhatsAppCampaign Values to update a WhatsApp Campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateWhatsAppCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateWhatsAppCampaign updateWhatsAppCampaign, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateWhatsAppCampaign;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateWhatsAppCampaign");
    }
    
    // verify the required parameter 'updateWhatsAppCampaign' is set
    if (updateWhatsAppCampaign == null) {
      throw new ApiException(400, "Missing the required parameter 'updateWhatsAppCampaign' when calling updateWhatsAppCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/whatsappCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
