/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetSmsEventReport;
import software.xdev.brevo.model.GetTransacAggregatedSmsReport;
import software.xdev.brevo.model.GetTransacSmsReport;
import software.xdev.brevo.model.SendSms;
import software.xdev.brevo.model.SendSmsAsync;
import software.xdev.brevo.model.SendTransacSms;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class TransactionalSmsApi extends BaseApi {

  public TransactionalSmsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public TransactionalSmsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Get all your SMS activity (unaggregated events)
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the report  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the report  (optional)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param days Number of days in the past including today (positive integer). **Not compatible with &#39;startDate&#39; and &#39;endDate&#39;**  (optional)
   * @param phoneNumber Filter the report for a specific phone number (optional)
   * @param event Filter the report for specific events (optional)
   * @param tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetSmsEventReport
   * @throws ApiException if fails to make API call
   */
  public GetSmsEventReport getSmsEvents(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String phoneNumber, @jakarta.annotation.Nullable String event, @jakarta.annotation.Nullable String tags, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getSmsEvents(limit, startDate, endDate, offset, days, phoneNumber, event, tags, sort, Collections.emptyMap());
  }


  /**
   * Get all your SMS activity (unaggregated events)
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the report  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the report  (optional)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param days Number of days in the past including today (positive integer). **Not compatible with &#39;startDate&#39; and &#39;endDate&#39;**  (optional)
   * @param phoneNumber Filter the report for a specific phone number (optional)
   * @param event Filter the report for specific events (optional)
   * @param tags Filter the report for specific tags passed as a serialized urlencoded array (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSmsEventReport
   * @throws ApiException if fails to make API call
   */
  public GetSmsEventReport getSmsEvents(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String phoneNumber, @jakarta.annotation.Nullable String event, @jakarta.annotation.Nullable String tags, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/transactionalSMS/statistics/events";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
    localVarQueryParams.addAll(apiClient.parameterToPair("phoneNumber", phoneNumber));
    localVarQueryParams.addAll(apiClient.parameterToPair("event", event));
    localVarQueryParams.addAll(apiClient.parameterToPair("tags", tags));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSmsEventReport> localVarReturnType = new TypeReference<GetSmsEventReport>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get your SMS activity aggregated over a period of time
   * 
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the report  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the report  (optional)
   * @param days Number of days in the past including today (positive integer). **Not compatible with startDate and endDate**  (optional)
   * @param tag Filter on a tag (optional)
   * @return GetTransacAggregatedSmsReport
   * @throws ApiException if fails to make API call
   */
  public GetTransacAggregatedSmsReport getTransacAggregatedSmsReport(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag) throws ApiException {
    return this.getTransacAggregatedSmsReport(startDate, endDate, days, tag, Collections.emptyMap());
  }


  /**
   * Get your SMS activity aggregated over a period of time
   * 
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the report  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the report  (optional)
   * @param days Number of days in the past including today (positive integer). **Not compatible with startDate and endDate**  (optional)
   * @param tag Filter on a tag (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetTransacAggregatedSmsReport
   * @throws ApiException if fails to make API call
   */
  public GetTransacAggregatedSmsReport getTransacAggregatedSmsReport(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/transactionalSMS/statistics/aggregatedReport";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
    localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetTransacAggregatedSmsReport> localVarReturnType = new TypeReference<GetTransacAggregatedSmsReport>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get your SMS activity aggregated per day
   * 
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the report  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the report  (optional)
   * @param days Number of days in the past including today (positive integer). **Not compatible with &#39;startDate&#39; and &#39;endDate&#39;**  (optional)
   * @param tag Filter on a tag (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetTransacSmsReport
   * @throws ApiException if fails to make API call
   */
  public GetTransacSmsReport getTransacSmsReport(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getTransacSmsReport(startDate, endDate, days, tag, sort, Collections.emptyMap());
  }


  /**
   * Get your SMS activity aggregated per day
   * 
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the report  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the report  (optional)
   * @param days Number of days in the past including today (positive integer). **Not compatible with &#39;startDate&#39; and &#39;endDate&#39;**  (optional)
   * @param tag Filter on a tag (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetTransacSmsReport
   * @throws ApiException if fails to make API call
   */
  public GetTransacSmsReport getTransacSmsReport(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/transactionalSMS/statistics/reports";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
    localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetTransacSmsReport> localVarReturnType = new TypeReference<GetTransacSmsReport>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send SMS message asynchronously to a mobile number
   * 
   * @param sendTransacSms Values to send a transactional SMS (required)
   * @return SendSmsAsync
   * @throws ApiException if fails to make API call
   */
  public SendSmsAsync sendAsyncTransactionalSms(@jakarta.annotation.Nonnull SendTransacSms sendTransacSms) throws ApiException {
    return this.sendAsyncTransactionalSms(sendTransacSms, Collections.emptyMap());
  }


  /**
   * Send SMS message asynchronously to a mobile number
   * 
   * @param sendTransacSms Values to send a transactional SMS (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return SendSmsAsync
   * @throws ApiException if fails to make API call
   */
  public SendSmsAsync sendAsyncTransactionalSms(@jakarta.annotation.Nonnull SendTransacSms sendTransacSms, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendTransacSms;
    
    // verify the required parameter 'sendTransacSms' is set
    if (sendTransacSms == null) {
      throw new ApiException(400, "Missing the required parameter 'sendTransacSms' when calling sendAsyncTransactionalSms");
    }
    
    // create path and map variables
    String localVarPath = "/transactionalSMS/send";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<SendSmsAsync> localVarReturnType = new TypeReference<SendSmsAsync>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send SMS message to a mobile number
   * 
   * @param sendTransacSms Values to send a transactional SMS (required)
   * @return SendSms
   * @throws ApiException if fails to make API call
   */
  public SendSms sendTransacSms(@jakarta.annotation.Nonnull SendTransacSms sendTransacSms) throws ApiException {
    return this.sendTransacSms(sendTransacSms, Collections.emptyMap());
  }


  /**
   * Send SMS message to a mobile number
   * 
   * @param sendTransacSms Values to send a transactional SMS (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return SendSms
   * @throws ApiException if fails to make API call
   */
  public SendSms sendTransacSms(@jakarta.annotation.Nonnull SendTransacSms sendTransacSms, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendTransacSms;
    
    // verify the required parameter 'sendTransacSms' is set
    if (sendTransacSms == null) {
      throw new ApiException(400, "Missing the required parameter 'sendTransacSms' when calling sendTransacSms");
    }
    
    // create path and map variables
    String localVarPath = "/transactionalSMS/sms";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<SendSms> localVarReturnType = new TypeReference<SendSms>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
