/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.BlockDomain;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateSmtpEmail;
import software.xdev.brevo.model.CreateSmtpTemplate;
import software.xdev.brevo.model.DeleteHardbounces;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetAggregatedReport;
import software.xdev.brevo.model.GetBlockedDomains;
import software.xdev.brevo.model.GetEmailEventReport;
import software.xdev.brevo.model.GetReports;
import software.xdev.brevo.model.GetScheduledEmailById200Response;
import software.xdev.brevo.model.GetSmtpTemplateOverview;
import software.xdev.brevo.model.GetSmtpTemplates;
import software.xdev.brevo.model.GetTransacBlockedContacts;
import software.xdev.brevo.model.GetTransacEmailContent;
import software.xdev.brevo.model.GetTransacEmailsList;
import java.time.LocalDate;
import software.xdev.brevo.model.PostSendFailed;
import software.xdev.brevo.model.ScheduleSmtpEmail;
import software.xdev.brevo.model.SendSmtpEmail;
import software.xdev.brevo.model.SendTestEmail;
import software.xdev.brevo.model.TemplatePreviewModel;
import software.xdev.brevo.model.TemplatePreviewRequestBody;
import software.xdev.brevo.model.UpdateSmtpTemplate;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class TransactionalEmailsApi extends BaseApi {

  public TransactionalEmailsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public TransactionalEmailsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Add a new domain to the list of blocked domains
   * Blocks a new domain in order to avoid messages being sent to the same
   * @param blockDomain Name of the domain to be blocked (required)
   * @throws ApiException if fails to make API call
   */
  public void blockNewDomain(@jakarta.annotation.Nonnull BlockDomain blockDomain) throws ApiException {
    this.blockNewDomain(blockDomain, Collections.emptyMap());
  }


  /**
   * Add a new domain to the list of blocked domains
   * Blocks a new domain in order to avoid messages being sent to the same
   * @param blockDomain Name of the domain to be blocked (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void blockNewDomain(@jakarta.annotation.Nonnull BlockDomain blockDomain, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = blockDomain;
    
    // verify the required parameter 'blockDomain' is set
    if (blockDomain == null) {
      throw new ApiException(400, "Missing the required parameter 'blockDomain' when calling blockNewDomain");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/blockedDomains";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create an email template
   * 
   * @param createSmtpTemplate values to update in transactional email template (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createSmtpTemplate(@jakarta.annotation.Nonnull CreateSmtpTemplate createSmtpTemplate) throws ApiException {
    return this.createSmtpTemplate(createSmtpTemplate, Collections.emptyMap());
  }


  /**
   * Create an email template
   * 
   * @param createSmtpTemplate values to update in transactional email template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createSmtpTemplate(@jakarta.annotation.Nonnull CreateSmtpTemplate createSmtpTemplate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createSmtpTemplate;
    
    // verify the required parameter 'createSmtpTemplate' is set
    if (createSmtpTemplate == null) {
      throw new ApiException(400, "Missing the required parameter 'createSmtpTemplate' when calling createSmtpTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/templates";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Unblock an existing domain from the list of blocked domains
   * Unblocks an existing domain from the list of blocked domains
   * @param domain The name of the domain to be deleted (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteBlockedDomain(@jakarta.annotation.Nonnull String domain) throws ApiException {
    this.deleteBlockedDomain(domain, Collections.emptyMap());
  }


  /**
   * Unblock an existing domain from the list of blocked domains
   * Unblocks an existing domain from the list of blocked domains
   * @param domain The name of the domain to be deleted (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteBlockedDomain(@jakarta.annotation.Nonnull String domain, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'domain' is set
    if (domain == null) {
      throw new ApiException(400, "Missing the required parameter 'domain' when calling deleteBlockedDomain");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/blockedDomains/{domain}"
      .replaceAll("\\{" + "domain" + "\\}", apiClient.escapeString(apiClient.parameterToString(domain)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete hardbounces
   * Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)
   * @param deleteHardbounces values to delete hardbounces (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteHardbounces(@jakarta.annotation.Nullable DeleteHardbounces deleteHardbounces) throws ApiException {
    this.deleteHardbounces(deleteHardbounces, Collections.emptyMap());
  }


  /**
   * Delete hardbounces
   * Delete hardbounces. To use carefully (e.g. in case of temporary ISP failures)
   * @param deleteHardbounces values to delete hardbounces (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteHardbounces(@jakarta.annotation.Nullable DeleteHardbounces deleteHardbounces, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = deleteHardbounces;
    
    // create path and map variables
    String localVarPath = "/smtp/deleteHardbounces";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete scheduled emails by batchId or messageId
   * Delete scheduled batch of emails by batchId or single scheduled email by messageId
   * @param identifier The &#x60;batchId&#x60; of scheduled emails batch (Should be a valid UUIDv4) or the &#x60;messageId&#x60; of scheduled email. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteScheduledEmailById(@jakarta.annotation.Nonnull String identifier) throws ApiException {
    this.deleteScheduledEmailById(identifier, Collections.emptyMap());
  }


  /**
   * Delete scheduled emails by batchId or messageId
   * Delete scheduled batch of emails by batchId or single scheduled email by messageId
   * @param identifier The &#x60;batchId&#x60; of scheduled emails batch (Should be a valid UUIDv4) or the &#x60;messageId&#x60; of scheduled email. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteScheduledEmailById(@jakarta.annotation.Nonnull String identifier, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling deleteScheduledEmailById");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/email/{identifier}"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete an inactive email template
   * 
   * @param templateId id of the template (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteSmtpTemplate(@jakarta.annotation.Nonnull Long templateId) throws ApiException {
    this.deleteSmtpTemplate(templateId, Collections.emptyMap());
  }


  /**
   * Delete an inactive email template
   * 
   * @param templateId id of the template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteSmtpTemplate(@jakarta.annotation.Nonnull Long templateId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'templateId' is set
    if (templateId == null) {
      throw new ApiException(400, "Missing the required parameter 'templateId' when calling deleteSmtpTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/templates/{templateId}"
      .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(apiClient.parameterToString(templateId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get your transactional email activity aggregated over a period of time
   * This endpoint will show the aggregated stats for past 90 days by default if &#x60;startDate&#x60; and &#x60;endDate&#x60; OR &#x60;days&#x60; is not passed. The date range can not exceed 90 days
   * @param startDate **Mandatory if endDate is used.** Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate  (optional)
   * @param days Number of days in the past including today (positive integer). _Not compatible with &#39;startDate&#39; and &#39;endDate&#39;_  (optional)
   * @param tag Tag of the emails (optional)
   * @return GetAggregatedReport
   * @throws ApiException if fails to make API call
   */
  public GetAggregatedReport getAggregatedSmtpReport(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag) throws ApiException {
    return this.getAggregatedSmtpReport(startDate, endDate, days, tag, Collections.emptyMap());
  }


  /**
   * Get your transactional email activity aggregated over a period of time
   * This endpoint will show the aggregated stats for past 90 days by default if &#x60;startDate&#x60; and &#x60;endDate&#x60; OR &#x60;days&#x60; is not passed. The date range can not exceed 90 days
   * @param startDate **Mandatory if endDate is used.** Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate  (optional)
   * @param days Number of days in the past including today (positive integer). _Not compatible with &#39;startDate&#39; and &#39;endDate&#39;_  (optional)
   * @param tag Tag of the emails (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetAggregatedReport
   * @throws ApiException if fails to make API call
   */
  public GetAggregatedReport getAggregatedSmtpReport(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/statistics/aggregatedReport";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
    localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetAggregatedReport> localVarReturnType = new TypeReference<GetAggregatedReport>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of blocked domains
   * Get the list of blocked domains
   * @return GetBlockedDomains
   * @throws ApiException if fails to make API call
   */
  public GetBlockedDomains getBlockedDomains() throws ApiException {
    return this.getBlockedDomains(Collections.emptyMap());
  }


  /**
   * Get the list of blocked domains
   * Get the list of blocked domains
   * @param additionalHeaders additionalHeaders for this call
   * @return GetBlockedDomains
   * @throws ApiException if fails to make API call
   */
  public GetBlockedDomains getBlockedDomains(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/blockedDomains";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetBlockedDomains> localVarReturnType = new TypeReference<GetBlockedDomains>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all your transactional email activity (unaggregated events)
   * This endpoint will show the aggregated stats for past 30 days by default if &#x60;startDate&#x60; and &#x60;endDate&#x60; OR &#x60;days&#x60; is not passed. The date range can not exceed 90 days
   * @param limit Number limitation for the result returned (optional, default to 2500)
   * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
   * @param startDate **Mandatory if endDate is used.** Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate  (optional)
   * @param days Number of days in the past including today (positive integer). _Not compatible with &#39;startDate&#39; and &#39;endDate&#39;_  (optional)
   * @param email Filter the report for a specific email addresses (optional)
   * @param event Filter the report for a specific event type (optional)
   * @param tags Filter the report for tags (serialized and urlencoded array). To pass multiple tags, a format of string separated by commas is used such as **\&quot;one, two, three\&quot;** (optional)
   * @param messageId Filter on a specific message id (optional)
   * @param templateId Filter on a specific template id (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetEmailEventReport
   * @throws ApiException if fails to make API call
   */
  public GetEmailEventReport getEmailEventReport(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String email, @jakarta.annotation.Nullable String event, @jakarta.annotation.Nullable String tags, @jakarta.annotation.Nullable String messageId, @jakarta.annotation.Nullable Long templateId, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getEmailEventReport(limit, offset, startDate, endDate, days, email, event, tags, messageId, templateId, sort, Collections.emptyMap());
  }


  /**
   * Get all your transactional email activity (unaggregated events)
   * This endpoint will show the aggregated stats for past 30 days by default if &#x60;startDate&#x60; and &#x60;endDate&#x60; OR &#x60;days&#x60; is not passed. The date range can not exceed 90 days
   * @param limit Number limitation for the result returned (optional, default to 2500)
   * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
   * @param startDate **Mandatory if endDate is used.** Starting date of the report (YYYY-MM-DD). Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date of the report (YYYY-MM-DD). Must be greater than equal to startDate  (optional)
   * @param days Number of days in the past including today (positive integer). _Not compatible with &#39;startDate&#39; and &#39;endDate&#39;_  (optional)
   * @param email Filter the report for a specific email addresses (optional)
   * @param event Filter the report for a specific event type (optional)
   * @param tags Filter the report for tags (serialized and urlencoded array). To pass multiple tags, a format of string separated by commas is used such as **\&quot;one, two, three\&quot;** (optional)
   * @param messageId Filter on a specific message id (optional)
   * @param templateId Filter on a specific template id (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetEmailEventReport
   * @throws ApiException if fails to make API call
   */
  public GetEmailEventReport getEmailEventReport(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String email, @jakarta.annotation.Nullable String event, @jakarta.annotation.Nullable String tags, @jakarta.annotation.Nullable String messageId, @jakarta.annotation.Nullable Long templateId, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/statistics/events";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
    localVarQueryParams.addAll(apiClient.parameterToPair("email", email));
    localVarQueryParams.addAll(apiClient.parameterToPair("event", event));
    localVarQueryParams.addAll(apiClient.parameterToPair("tags", tags));
    localVarQueryParams.addAll(apiClient.parameterToPair("messageId", messageId));
    localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetEmailEventReport> localVarReturnType = new TypeReference<GetEmailEventReport>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Fetch scheduled emails by batchId or messageId
   * Fetch scheduled batch of emails by batchId or single scheduled email by messageId (Can retrieve data upto 30 days old)
   * @param identifier The &#x60;batchId&#x60; of scheduled emails batch (Should be a valid UUIDv4) or the &#x60;messageId&#x60; of scheduled email. (required)
   * @param startDate Mandatory if &#x60;endDate&#x60; is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older tha current date. (optional)
   * @param endDate Mandatory if &#x60;startDate&#x60; is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed. Not valid when identifier is &#x60;messageId&#x60;. (optional, default to desc)
   * @param status Filter the records by &#x60;status&#x60; of the scheduled email batch or message. Not valid when identifier is &#x60;messageId&#x60;. (optional)
   * @param limit Number of documents returned per page. Not valid when identifier is &#x60;messageId&#x60;. (optional, default to 100)
   * @param offset Index of the first document on the page.  Not valid when identifier is &#x60;messageId&#x60;. (optional, default to 0)
   * @return GetScheduledEmailById200Response
   * @throws ApiException if fails to make API call
   */
  public GetScheduledEmailById200Response getScheduledEmailById(@jakarta.annotation.Nonnull String identifier, @jakarta.annotation.Nullable LocalDate startDate, @jakarta.annotation.Nullable LocalDate endDate, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String status, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset) throws ApiException {
    return this.getScheduledEmailById(identifier, startDate, endDate, sort, status, limit, offset, Collections.emptyMap());
  }


  /**
   * Fetch scheduled emails by batchId or messageId
   * Fetch scheduled batch of emails by batchId or single scheduled email by messageId (Can retrieve data upto 30 days old)
   * @param identifier The &#x60;batchId&#x60; of scheduled emails batch (Should be a valid UUIDv4) or the &#x60;messageId&#x60; of scheduled email. (required)
   * @param startDate Mandatory if &#x60;endDate&#x60; is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older tha current date. (optional)
   * @param endDate Mandatory if &#x60;startDate&#x60; is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed. Not valid when identifier is &#x60;messageId&#x60;. (optional, default to desc)
   * @param status Filter the records by &#x60;status&#x60; of the scheduled email batch or message. Not valid when identifier is &#x60;messageId&#x60;. (optional)
   * @param limit Number of documents returned per page. Not valid when identifier is &#x60;messageId&#x60;. (optional, default to 100)
   * @param offset Index of the first document on the page.  Not valid when identifier is &#x60;messageId&#x60;. (optional, default to 0)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetScheduledEmailById200Response
   * @throws ApiException if fails to make API call
   */
  public GetScheduledEmailById200Response getScheduledEmailById(@jakarta.annotation.Nonnull String identifier, @jakarta.annotation.Nullable LocalDate startDate, @jakarta.annotation.Nullable LocalDate endDate, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String status, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling getScheduledEmailById");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/emailStatus/{identifier}"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("status", status));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetScheduledEmailById200Response> localVarReturnType = new TypeReference<GetScheduledEmailById200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get your transactional email activity aggregated per day
   * 
   * @param limit Number of documents returned per page (optional, default to 10)
   * @param offset Index of the first document on the page (optional, default to 0)
   * @param startDate **Mandatory if endDate is used.** Starting date of the report (YYYY-MM-DD)  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date of the report (YYYY-MM-DD)  (optional)
   * @param days Number of days in the past including today (positive integer). _Not compatible with &#39;startDate&#39; and &#39;endDate&#39;_  (optional)
   * @param tag Tag of the emails (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetReports
   * @throws ApiException if fails to make API call
   */
  public GetReports getSmtpReport(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getSmtpReport(limit, offset, startDate, endDate, days, tag, sort, Collections.emptyMap());
  }


  /**
   * Get your transactional email activity aggregated per day
   * 
   * @param limit Number of documents returned per page (optional, default to 10)
   * @param offset Index of the first document on the page (optional, default to 0)
   * @param startDate **Mandatory if endDate is used.** Starting date of the report (YYYY-MM-DD)  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date of the report (YYYY-MM-DD)  (optional)
   * @param days Number of days in the past including today (positive integer). _Not compatible with &#39;startDate&#39; and &#39;endDate&#39;_  (optional)
   * @param tag Tag of the emails (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetReports
   * @throws ApiException if fails to make API call
   */
  public GetReports getSmtpReport(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long days, @jakarta.annotation.Nullable String tag, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/statistics/reports";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("days", days));
    localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetReports> localVarReturnType = new TypeReference<GetReports>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Returns the template information
   * 
   * @param templateId id of the template (required)
   * @return GetSmtpTemplateOverview
   * @throws ApiException if fails to make API call
   */
  public GetSmtpTemplateOverview getSmtpTemplate(@jakarta.annotation.Nonnull Long templateId) throws ApiException {
    return this.getSmtpTemplate(templateId, Collections.emptyMap());
  }


  /**
   * Returns the template information
   * 
   * @param templateId id of the template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSmtpTemplateOverview
   * @throws ApiException if fails to make API call
   */
  public GetSmtpTemplateOverview getSmtpTemplate(@jakarta.annotation.Nonnull Long templateId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'templateId' is set
    if (templateId == null) {
      throw new ApiException(400, "Missing the required parameter 'templateId' when calling getSmtpTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/templates/{templateId}"
      .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(apiClient.parameterToString(templateId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSmtpTemplateOverview> localVarReturnType = new TypeReference<GetSmtpTemplateOverview>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of email templates
   * 
   * @param templateStatus Filter on the status of the template. Active &#x3D; true, inactive &#x3D; false (optional)
   * @param limit Number of documents returned per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetSmtpTemplates
   * @throws ApiException if fails to make API call
   */
  public GetSmtpTemplates getSmtpTemplates(@jakarta.annotation.Nullable Boolean templateStatus, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getSmtpTemplates(templateStatus, limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Get the list of email templates
   * 
   * @param templateStatus Filter on the status of the template. Active &#x3D; true, inactive &#x3D; false (optional)
   * @param limit Number of documents returned per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSmtpTemplates
   * @throws ApiException if fails to make API call
   */
  public GetSmtpTemplates getSmtpTemplates(@jakarta.annotation.Nullable Boolean templateStatus, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/templates";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("templateStatus", templateStatus));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSmtpTemplates> localVarReturnType = new TypeReference<GetSmtpTemplates>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of blocked or unsubscribed transactional contacts
   * 
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts  (optional)
   * @param limit Number of documents returned per page (optional, default to 50)
   * @param offset Index of the first document on the page (optional, default to 0)
   * @param senders Comma separated list of emails of the senders from which contacts are blocked or unsubscribed (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetTransacBlockedContacts
   * @throws ApiException if fails to make API call
   */
  public GetTransacBlockedContacts getTransacBlockedContacts(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable List<String> senders, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getTransacBlockedContacts(startDate, endDate, limit, offset, senders, sort, Collections.emptyMap());
  }


  /**
   * Get the list of blocked or unsubscribed transactional contacts
   * 
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) from which you want to fetch the blocked or unsubscribed contacts  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) till which you want to fetch the blocked or unsubscribed contacts  (optional)
   * @param limit Number of documents returned per page (optional, default to 50)
   * @param offset Index of the first document on the page (optional, default to 0)
   * @param senders Comma separated list of emails of the senders from which contacts are blocked or unsubscribed (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetTransacBlockedContacts
   * @throws ApiException if fails to make API call
   */
  public GetTransacBlockedContacts getTransacBlockedContacts(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable List<String> senders, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/blockedContacts";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("csv", "senders", senders));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetTransacBlockedContacts> localVarReturnType = new TypeReference<GetTransacBlockedContacts>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the personalized content of a sent transactional email
   * 
   * @param uuid Unique id of the transactional email that has been sent to a particular contact (required)
   * @return GetTransacEmailContent
   * @throws ApiException if fails to make API call
   */
  public GetTransacEmailContent getTransacEmailContent(@jakarta.annotation.Nonnull String uuid) throws ApiException {
    return this.getTransacEmailContent(uuid, Collections.emptyMap());
  }


  /**
   * Get the personalized content of a sent transactional email
   * 
   * @param uuid Unique id of the transactional email that has been sent to a particular contact (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetTransacEmailContent
   * @throws ApiException if fails to make API call
   */
  public GetTransacEmailContent getTransacEmailContent(@jakarta.annotation.Nonnull String uuid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uuid' is set
    if (uuid == null) {
      throw new ApiException(400, "Missing the required parameter 'uuid' when calling getTransacEmailContent");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/emails/{uuid}"
      .replaceAll("\\{" + "uuid" + "\\}", apiClient.escapeString(apiClient.parameterToString(uuid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetTransacEmailContent> localVarReturnType = new TypeReference<GetTransacEmailContent>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of transactional emails on the basis of allowed filters
   * This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.
   * @param email **Mandatory if templateId and messageId are not passed in query filters.** Email address to which transactional email has been sent.  (optional)
   * @param templateId **Mandatory if email and messageId are not passed in query filters.** Id of the template that was used to compose transactional email.  (optional)
   * @param messageId **Mandatory if templateId and email are not passed in query filters.** Message ID of the transactional email sent.  (optional)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) from which you want to fetch the list. **Maximum time period that can be selected is one month**.  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) till which you want to fetch the list. **Maximum time period that can be selected is one month.**  (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param limit Number of documents returned per page (optional, default to 500)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @return GetTransacEmailsList
   * @throws ApiException if fails to make API call
   */
  public GetTransacEmailsList getTransacEmailsList(@jakarta.annotation.Nullable String email, @jakarta.annotation.Nullable Long templateId, @jakarta.annotation.Nullable String messageId, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset) throws ApiException {
    return this.getTransacEmailsList(email, templateId, messageId, startDate, endDate, sort, limit, offset, Collections.emptyMap());
  }


  /**
   * Get the list of transactional emails on the basis of allowed filters
   * This endpoint will show the list of emails for past 30 days by default. To retrieve emails before that time, please pass startDate and endDate in query filters.
   * @param email **Mandatory if templateId and messageId are not passed in query filters.** Email address to which transactional email has been sent.  (optional)
   * @param templateId **Mandatory if email and messageId are not passed in query filters.** Id of the template that was used to compose transactional email.  (optional)
   * @param messageId **Mandatory if templateId and email are not passed in query filters.** Message ID of the transactional email sent.  (optional)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) from which you want to fetch the list. **Maximum time period that can be selected is one month**.  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) till which you want to fetch the list. **Maximum time period that can be selected is one month.**  (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param limit Number of documents returned per page (optional, default to 500)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetTransacEmailsList
   * @throws ApiException if fails to make API call
   */
  public GetTransacEmailsList getTransacEmailsList(@jakarta.annotation.Nullable String email, @jakarta.annotation.Nullable Long templateId, @jakarta.annotation.Nullable String messageId, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smtp/emails";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("email", email));
    localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
    localVarQueryParams.addAll(apiClient.parameterToPair("messageId", messageId));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetTransacEmailsList> localVarReturnType = new TypeReference<GetTransacEmailsList>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send a template to your test list
   * 
   * @param templateId Id of the template (required)
   * @param sendTestEmail  (required)
   * @throws ApiException if fails to make API call
   */
  public void sendTestTemplate(@jakarta.annotation.Nonnull Long templateId, @jakarta.annotation.Nonnull SendTestEmail sendTestEmail) throws ApiException {
    this.sendTestTemplate(templateId, sendTestEmail, Collections.emptyMap());
  }


  /**
   * Send a template to your test list
   * 
   * @param templateId Id of the template (required)
   * @param sendTestEmail  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendTestTemplate(@jakarta.annotation.Nonnull Long templateId, @jakarta.annotation.Nonnull SendTestEmail sendTestEmail, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendTestEmail;
    
    // verify the required parameter 'templateId' is set
    if (templateId == null) {
      throw new ApiException(400, "Missing the required parameter 'templateId' when calling sendTestTemplate");
    }
    
    // verify the required parameter 'sendTestEmail' is set
    if (sendTestEmail == null) {
      throw new ApiException(400, "Missing the required parameter 'sendTestEmail' when calling sendTestTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/templates/{templateId}/sendTest"
      .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(apiClient.parameterToString(templateId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Send a transactional email
   * 
   * @param sendSmtpEmail Values to send a transactional email (required)
   * @return CreateSmtpEmail
   * @throws ApiException if fails to make API call
   */
  public CreateSmtpEmail sendTransacEmail(@jakarta.annotation.Nonnull SendSmtpEmail sendSmtpEmail) throws ApiException {
    return this.sendTransacEmail(sendSmtpEmail, Collections.emptyMap());
  }


  /**
   * Send a transactional email
   * 
   * @param sendSmtpEmail Values to send a transactional email (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateSmtpEmail
   * @throws ApiException if fails to make API call
   */
  public CreateSmtpEmail sendTransacEmail(@jakarta.annotation.Nonnull SendSmtpEmail sendSmtpEmail, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendSmtpEmail;
    
    // verify the required parameter 'sendSmtpEmail' is set
    if (sendSmtpEmail == null) {
      throw new ApiException(400, "Missing the required parameter 'sendSmtpEmail' when calling sendTransacEmail");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/email";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateSmtpEmail> localVarReturnType = new TypeReference<CreateSmtpEmail>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Unblock or resubscribe a transactional contact
   * 
   * @param email contact email (urlencoded) to unblock. (required)
   * @throws ApiException if fails to make API call
   */
  public void smtpBlockedContactsEmailDelete(@jakarta.annotation.Nonnull String email) throws ApiException {
    this.smtpBlockedContactsEmailDelete(email, Collections.emptyMap());
  }


  /**
   * Unblock or resubscribe a transactional contact
   * 
   * @param email contact email (urlencoded) to unblock. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void smtpBlockedContactsEmailDelete(@jakarta.annotation.Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'email' is set
    if (email == null) {
      throw new ApiException(400, "Missing the required parameter 'email' when calling smtpBlockedContactsEmailDelete");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/blockedContacts/{email}"
      .replaceAll("\\{" + "email" + "\\}", apiClient.escapeString(apiClient.parameterToString(email)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete an SMTP transactional log
   * 
   * @param identifier MessageId of the transactional log(s) to delete (required)
   * @throws ApiException if fails to make API call
   */
  public void smtpLogIdentifierDelete(@jakarta.annotation.Nonnull String identifier) throws ApiException {
    this.smtpLogIdentifierDelete(identifier, Collections.emptyMap());
  }


  /**
   * Delete an SMTP transactional log
   * 
   * @param identifier MessageId of the transactional log(s) to delete (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void smtpLogIdentifierDelete(@jakarta.annotation.Nonnull String identifier, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling smtpLogIdentifierDelete");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/log/{identifier}"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Generate the rendered preview of transactional template
   * 
   * @param templatePreviewRequestBody Values to fetch Template preview (required)
   * @return TemplatePreviewModel
   * @throws ApiException if fails to make API call
   */
  public TemplatePreviewModel templatePreview(@jakarta.annotation.Nullable TemplatePreviewRequestBody templatePreviewRequestBody) throws ApiException {
    return this.templatePreview(templatePreviewRequestBody, Collections.emptyMap());
  }


  /**
   * Generate the rendered preview of transactional template
   * 
   * @param templatePreviewRequestBody Values to fetch Template preview (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return TemplatePreviewModel
   * @throws ApiException if fails to make API call
   */
  public TemplatePreviewModel templatePreview(@jakarta.annotation.Nullable TemplatePreviewRequestBody templatePreviewRequestBody, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = templatePreviewRequestBody;
    
    // verify the required parameter 'templatePreviewRequestBody' is set
    if (templatePreviewRequestBody == null) {
      throw new ApiException(400, "Missing the required parameter 'templatePreviewRequestBody' when calling templatePreview");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/template/preview";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TemplatePreviewModel> localVarReturnType = new TypeReference<TemplatePreviewModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update an email template
   * 
   * @param templateId id of the template (required)
   * @param updateSmtpTemplate values to update in transactional email template (required)
   * @throws ApiException if fails to make API call
   */
  public void updateSmtpTemplate(@jakarta.annotation.Nonnull Long templateId, @jakarta.annotation.Nonnull UpdateSmtpTemplate updateSmtpTemplate) throws ApiException {
    this.updateSmtpTemplate(templateId, updateSmtpTemplate, Collections.emptyMap());
  }


  /**
   * Update an email template
   * 
   * @param templateId id of the template (required)
   * @param updateSmtpTemplate values to update in transactional email template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSmtpTemplate(@jakarta.annotation.Nonnull Long templateId, @jakarta.annotation.Nonnull UpdateSmtpTemplate updateSmtpTemplate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateSmtpTemplate;
    
    // verify the required parameter 'templateId' is set
    if (templateId == null) {
      throw new ApiException(400, "Missing the required parameter 'templateId' when calling updateSmtpTemplate");
    }
    
    // verify the required parameter 'updateSmtpTemplate' is set
    if (updateSmtpTemplate == null) {
      throw new ApiException(400, "Missing the required parameter 'updateSmtpTemplate' when calling updateSmtpTemplate");
    }
    
    // create path and map variables
    String localVarPath = "/smtp/templates/{templateId}"
      .replaceAll("\\{" + "templateId" + "\\}", apiClient.escapeString(apiClient.parameterToString(templateId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
