/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CreateTierGroupRequest;
import software.xdev.brevo.model.ErrorResponse;
import software.xdev.brevo.model.LoyaltyTierPage;
import software.xdev.brevo.model.Tier;
import software.xdev.brevo.model.TierForContact;
import software.xdev.brevo.model.TierGroup;
import software.xdev.brevo.model.TierGroupPage;
import software.xdev.brevo.model.TierRequest;
import software.xdev.brevo.model.TierRequestPutPayload;
import java.util.UUID;
import software.xdev.brevo.model.UpdateTierGroupRequest;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class TierApi extends BaseApi {

  public TierApi() {
    super(Configuration.getDefaultApiClient());
  }

  public TierApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Assign a tier
   * Manually assigns a tier to a specific membership.
   * @param pid Loyalty Program ID (required)
   * @param cid Contact ID (required)
   * @param tid Tier ID (required)
   * @return TierForContact
   * @throws ApiException if fails to make API call
   */
  public TierForContact addSubscriptionToTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID cid, @jakarta.annotation.Nonnull UUID tid) throws ApiException {
    return this.addSubscriptionToTier(pid, cid, tid, Collections.emptyMap());
  }


  /**
   * Assign a tier
   * Manually assigns a tier to a specific membership.
   * @param pid Loyalty Program ID (required)
   * @param cid Contact ID (required)
   * @param tid Tier ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return TierForContact
   * @throws ApiException if fails to make API call
   */
  public TierForContact addSubscriptionToTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID cid, @jakarta.annotation.Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling addSubscriptionToTier");
    }
    
    // verify the required parameter 'cid' is set
    if (cid == null) {
      throw new ApiException(400, "Missing the required parameter 'cid' when calling addSubscriptionToTier");
    }
    
    // verify the required parameter 'tid' is set
    if (tid == null) {
      throw new ApiException(400, "Missing the required parameter 'tid' when calling addSubscriptionToTier");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/contacts/{cid}/tiers/{tid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "cid" + "\\}", apiClient.escapeString(apiClient.parameterToString(cid)))
      .replaceAll("\\{" + "tid" + "\\}", apiClient.escapeString(apiClient.parameterToString(tid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TierForContact> localVarReturnType = new TypeReference<TierForContact>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a tier
   * Creates a new tier in a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param tierRequest  (required)
   * @return Tier
   * @throws ApiException if fails to make API call
   */
  public Tier createTierForTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, @jakarta.annotation.Nonnull TierRequest tierRequest) throws ApiException {
    return this.createTierForTierGroup(pid, gid, tierRequest, Collections.emptyMap());
  }


  /**
   * Create a tier
   * Creates a new tier in a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param tierRequest  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Tier
   * @throws ApiException if fails to make API call
   */
  public Tier createTierForTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, @jakarta.annotation.Nonnull TierRequest tierRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = tierRequest;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling createTierForTierGroup");
    }
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling createTierForTierGroup");
    }
    
    // verify the required parameter 'tierRequest' is set
    if (tierRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'tierRequest' when calling createTierForTierGroup");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}/tiers"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(apiClient.parameterToString(gid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Tier> localVarReturnType = new TypeReference<Tier>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a tier group
   * Creates a new tier group in a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param createTierGroupRequest Tier group creation payload (required)
   * @return TierGroup
   * @throws ApiException if fails to make API call
   */
  public TierGroup createTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateTierGroupRequest createTierGroupRequest) throws ApiException {
    return this.createTierGroup(pid, createTierGroupRequest, Collections.emptyMap());
  }


  /**
   * Create a tier group
   * Creates a new tier group in a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param createTierGroupRequest Tier group creation payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return TierGroup
   * @throws ApiException if fails to make API call
   */
  public TierGroup createTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateTierGroupRequest createTierGroupRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createTierGroupRequest;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling createTierGroup");
    }
    
    // verify the required parameter 'createTierGroupRequest' is set
    if (createTierGroupRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createTierGroupRequest' when calling createTierGroup");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TierGroup> localVarReturnType = new TypeReference<TierGroup>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete tier
   * Deletes a tier from a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param tid Tier ID (required)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String deleteTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid) throws ApiException {
    return this.deleteTier(pid, tid, Collections.emptyMap());
  }


  /**
   * Delete tier
   * Deletes a tier from a loyalty program tier group. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param tid Tier ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String deleteTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteTier");
    }
    
    // verify the required parameter 'tid' is set
    if (tid == null) {
      throw new ApiException(400, "Missing the required parameter 'tid' when calling deleteTier");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tiers/{tid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "tid" + "\\}", apiClient.escapeString(apiClient.parameterToString(tid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<String> localVarReturnType = new TypeReference<String>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete tier group
   * Deletes a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String deleteTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid) throws ApiException {
    return this.deleteTierGroup(pid, gid, Collections.emptyMap());
  }


  /**
   * Delete tier group
   * Deletes a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return String
   * @throws ApiException if fails to make API call
   */
  public String deleteTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteTierGroup");
    }
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling deleteTierGroup");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(apiClient.parameterToString(gid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "aplication/json", "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<String> localVarReturnType = new TypeReference<String>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * List tier groups
   * Returns the list of tier groups defined within the loyalty program.
   * @param pid Loyalty Program ID (required)
   * @param version Select &#39;active&#39; to retrieve list of all tier groups which are live for clients. Select draft to retrieve list of all non deleted tier groups. (optional, default to draft)
   * @return TierGroupPage
   * @throws ApiException if fails to make API call
   */
  public TierGroupPage getListOfTierGroups(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.getListOfTierGroups(pid, version, Collections.emptyMap());
  }


  /**
   * List tier groups
   * Returns the list of tier groups defined within the loyalty program.
   * @param pid Loyalty Program ID (required)
   * @param version Select &#39;active&#39; to retrieve list of all tier groups which are live for clients. Select draft to retrieve list of all non deleted tier groups. (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return TierGroupPage
   * @throws ApiException if fails to make API call
   */
  public TierGroupPage getListOfTierGroups(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getListOfTierGroups");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TierGroupPage> localVarReturnType = new TypeReference<TierGroupPage>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * List tiers
   * Returns the list of tiers defined within the loyalty program.
   * @param pid Loyalty Program ID (required)
   * @param version Select &#39;active&#39; to retrieve list of all tiers which are live for clients. Select draft to retrieve list of all non deleted tiers. (optional, default to draft)
   * @return LoyaltyTierPage
   * @throws ApiException if fails to make API call
   */
  public LoyaltyTierPage getLoyaltyProgramTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.getLoyaltyProgramTier(pid, version, Collections.emptyMap());
  }


  /**
   * List tiers
   * Returns the list of tiers defined within the loyalty program.
   * @param pid Loyalty Program ID (required)
   * @param version Select &#39;active&#39; to retrieve list of all tiers which are live for clients. Select draft to retrieve list of all non deleted tiers. (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return LoyaltyTierPage
   * @throws ApiException if fails to make API call
   */
  public LoyaltyTierPage getLoyaltyProgramTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getLoyaltyProgramTier");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tiers"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<LoyaltyTierPage> localVarReturnType = new TypeReference<LoyaltyTierPage>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get tier group
   * Returns tier group information.
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param version Select active to retrieve active version of tier group. Select draft to retrieve latest changes in tier group. (optional, default to draft)
   * @return TierGroup
   * @throws ApiException if fails to make API call
   */
  public TierGroup getTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.getTierGroup(pid, gid, version, Collections.emptyMap());
  }


  /**
   * Get tier group
   * Returns tier group information.
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param version Select active to retrieve active version of tier group. Select draft to retrieve latest changes in tier group. (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return TierGroup
   * @throws ApiException if fails to make API call
   */
  public TierGroup getTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getTierGroup");
    }
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling getTierGroup");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(apiClient.parameterToString(gid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TierGroup> localVarReturnType = new TypeReference<TierGroup>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update tier
   * Modifies an existing tier for the specified tier group *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param tid Tier ID (required)
   * @param tierRequestPutPayload  (required)
   * @return Tier
   * @throws ApiException if fails to make API call
   */
  public Tier updateTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid, @jakarta.annotation.Nonnull TierRequestPutPayload tierRequestPutPayload) throws ApiException {
    return this.updateTier(pid, tid, tierRequestPutPayload, Collections.emptyMap());
  }


  /**
   * Update tier
   * Modifies an existing tier for the specified tier group *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param tid Tier ID (required)
   * @param tierRequestPutPayload  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Tier
   * @throws ApiException if fails to make API call
   */
  public Tier updateTier(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid, @jakarta.annotation.Nonnull TierRequestPutPayload tierRequestPutPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = tierRequestPutPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling updateTier");
    }
    
    // verify the required parameter 'tid' is set
    if (tid == null) {
      throw new ApiException(400, "Missing the required parameter 'tid' when calling updateTier");
    }
    
    // verify the required parameter 'tierRequestPutPayload' is set
    if (tierRequestPutPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'tierRequestPutPayload' when calling updateTier");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tiers/{tid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "tid" + "\\}", apiClient.escapeString(apiClient.parameterToString(tid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Tier> localVarReturnType = new TypeReference<Tier>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update tier group
   * Updates a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param updateTierGroupRequest Tier group update payload (required)
   * @return TierGroup
   * @throws ApiException if fails to make API call
   */
  public TierGroup updateTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, @jakarta.annotation.Nonnull UpdateTierGroupRequest updateTierGroupRequest) throws ApiException {
    return this.updateTierGroup(pid, gid, updateTierGroupRequest, Collections.emptyMap());
  }


  /**
   * Update tier group
   * Updates a tier group from a loyalty program. *(The changes will take effect with the next publication of the loyalty program)*
   * @param pid Loyalty Program ID (required)
   * @param gid Tier group ID (required)
   * @param updateTierGroupRequest Tier group update payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return TierGroup
   * @throws ApiException if fails to make API call
   */
  public TierGroup updateTierGroup(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID gid, @jakarta.annotation.Nonnull UpdateTierGroupRequest updateTierGroupRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateTierGroupRequest;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling updateTierGroup");
    }
    
    // verify the required parameter 'gid' is set
    if (gid == null) {
      throw new ApiException(400, "Missing the required parameter 'gid' when calling updateTierGroup");
    }
    
    // verify the required parameter 'updateTierGroupRequest' is set
    if (updateTierGroupRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'updateTierGroupRequest' when calling updateTierGroup");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/tier/programs/{pid}/tier-groups/{gid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "gid" + "\\}", apiClient.escapeString(apiClient.parameterToString(gid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TierGroup> localVarReturnType = new TypeReference<TierGroup>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
