/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CrmTasksIdPatchRequest;
import software.xdev.brevo.model.CrmTasksPost201Response;
import software.xdev.brevo.model.CrmTasksPostRequest;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.Task;
import software.xdev.brevo.model.TaskList;
import software.xdev.brevo.model.TaskTypes;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class TasksApi extends BaseApi {

  public TasksApi() {
    super(Configuration.getDefaultApiClient());
  }

  public TasksApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Get all tasks
   * 
   * @param filterType Filter by task type (ID) (optional)
   * @param filterStatus Filter by task status (optional)
   * @param filterDate Filter by date (optional)
   * @param filterAssignTo Filter by the \&quot;assignTo\&quot; ID. You can utilize account emails for the \&quot;assignTo\&quot; attribute. (optional)
   * @param filterContacts Filter by contact ids (optional)
   * @param filterDeals Filter by deals ids (optional)
   * @param filterCompanies Filter by companies ids (optional)
   * @param dateFrom dateFrom to date range filter type (timestamp in milliseconds) (optional)
   * @param dateTo dateTo to date range filter type (timestamp in milliseconds) (optional)
   * @param offset Index of the first document of the page (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param sort Sort the results in the ascending/descending order. Default order is **descending** by creation if &#x60;sort&#x60; is not passed (optional)
   * @param sortBy The field used to sort field names. (optional)
   * @return TaskList
   * @throws ApiException if fails to make API call
   */
  public TaskList crmTasksGet(@jakarta.annotation.Nullable String filterType, @jakarta.annotation.Nullable String filterStatus, @jakarta.annotation.Nullable String filterDate, @jakarta.annotation.Nullable String filterAssignTo, @jakarta.annotation.Nullable String filterContacts, @jakarta.annotation.Nullable String filterDeals, @jakarta.annotation.Nullable String filterCompanies, @jakarta.annotation.Nullable Integer dateFrom, @jakarta.annotation.Nullable Integer dateTo, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String sortBy) throws ApiException {
    return this.crmTasksGet(filterType, filterStatus, filterDate, filterAssignTo, filterContacts, filterDeals, filterCompanies, dateFrom, dateTo, offset, limit, sort, sortBy, Collections.emptyMap());
  }


  /**
   * Get all tasks
   * 
   * @param filterType Filter by task type (ID) (optional)
   * @param filterStatus Filter by task status (optional)
   * @param filterDate Filter by date (optional)
   * @param filterAssignTo Filter by the \&quot;assignTo\&quot; ID. You can utilize account emails for the \&quot;assignTo\&quot; attribute. (optional)
   * @param filterContacts Filter by contact ids (optional)
   * @param filterDeals Filter by deals ids (optional)
   * @param filterCompanies Filter by companies ids (optional)
   * @param dateFrom dateFrom to date range filter type (timestamp in milliseconds) (optional)
   * @param dateTo dateTo to date range filter type (timestamp in milliseconds) (optional)
   * @param offset Index of the first document of the page (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param sort Sort the results in the ascending/descending order. Default order is **descending** by creation if &#x60;sort&#x60; is not passed (optional)
   * @param sortBy The field used to sort field names. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return TaskList
   * @throws ApiException if fails to make API call
   */
  public TaskList crmTasksGet(@jakarta.annotation.Nullable String filterType, @jakarta.annotation.Nullable String filterStatus, @jakarta.annotation.Nullable String filterDate, @jakarta.annotation.Nullable String filterAssignTo, @jakarta.annotation.Nullable String filterContacts, @jakarta.annotation.Nullable String filterDeals, @jakarta.annotation.Nullable String filterCompanies, @jakarta.annotation.Nullable Integer dateFrom, @jakarta.annotation.Nullable Integer dateTo, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String sortBy, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/crm/tasks";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("filter[type]", filterType));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter[status]", filterStatus));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter[date]", filterDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter[assignTo]", filterAssignTo));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter[contacts]", filterContacts));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter[deals]", filterDeals));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter[companies]", filterCompanies));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateFrom", dateFrom));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateTo", dateTo));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TaskList> localVarReturnType = new TypeReference<TaskList>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a task
   * 
   * @param id  (required)
   * @throws ApiException if fails to make API call
   */
  public void crmTasksIdDelete(@jakarta.annotation.Nonnull String id) throws ApiException {
    this.crmTasksIdDelete(id, Collections.emptyMap());
  }


  /**
   * Delete a task
   * 
   * @param id  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void crmTasksIdDelete(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmTasksIdDelete");
    }
    
    // create path and map variables
    String localVarPath = "/crm/tasks/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get a task
   * 
   * @param id  (required)
   * @return Task
   * @throws ApiException if fails to make API call
   */
  public Task crmTasksIdGet(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.crmTasksIdGet(id, Collections.emptyMap());
  }


  /**
   * Get a task
   * 
   * @param id  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Task
   * @throws ApiException if fails to make API call
   */
  public Task crmTasksIdGet(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmTasksIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/crm/tasks/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Task> localVarReturnType = new TypeReference<Task>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update a task
   * 
   * @param id  (required)
   * @param crmTasksIdPatchRequest Updated task details. (required)
   * @throws ApiException if fails to make API call
   */
  public void crmTasksIdPatch(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull CrmTasksIdPatchRequest crmTasksIdPatchRequest) throws ApiException {
    this.crmTasksIdPatch(id, crmTasksIdPatchRequest, Collections.emptyMap());
  }


  /**
   * Update a task
   * 
   * @param id  (required)
   * @param crmTasksIdPatchRequest Updated task details. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void crmTasksIdPatch(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull CrmTasksIdPatchRequest crmTasksIdPatchRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = crmTasksIdPatchRequest;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmTasksIdPatch");
    }
    
    // verify the required parameter 'crmTasksIdPatchRequest' is set
    if (crmTasksIdPatchRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'crmTasksIdPatchRequest' when calling crmTasksIdPatch");
    }
    
    // create path and map variables
    String localVarPath = "/crm/tasks/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PATCH",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create a task
   * 
   * @param crmTasksPostRequest Task name. (required)
   * @return CrmTasksPost201Response
   * @throws ApiException if fails to make API call
   */
  public CrmTasksPost201Response crmTasksPost(@jakarta.annotation.Nonnull CrmTasksPostRequest crmTasksPostRequest) throws ApiException {
    return this.crmTasksPost(crmTasksPostRequest, Collections.emptyMap());
  }


  /**
   * Create a task
   * 
   * @param crmTasksPostRequest Task name. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CrmTasksPost201Response
   * @throws ApiException if fails to make API call
   */
  public CrmTasksPost201Response crmTasksPost(@jakarta.annotation.Nonnull CrmTasksPostRequest crmTasksPostRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = crmTasksPostRequest;
    
    // verify the required parameter 'crmTasksPostRequest' is set
    if (crmTasksPostRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'crmTasksPostRequest' when calling crmTasksPost");
    }
    
    // create path and map variables
    String localVarPath = "/crm/tasks";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CrmTasksPost201Response> localVarReturnType = new TypeReference<CrmTasksPost201Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all task types
   * 
   * @return TaskTypes
   * @throws ApiException if fails to make API call
   */
  public TaskTypes crmTasktypesGet() throws ApiException {
    return this.crmTasktypesGet(Collections.emptyMap());
  }


  /**
   * Get all task types
   * 
   * @param additionalHeaders additionalHeaders for this call
   * @return TaskTypes
   * @throws ApiException if fails to make API call
   */
  public TaskTypes crmTasktypesGet(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/crm/tasktypes";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TaskTypes> localVarReturnType = new TypeReference<TaskTypes>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
