/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateSmsCampaign;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetSmsCampaign;
import software.xdev.brevo.model.GetSmsCampaigns;
import software.xdev.brevo.model.PostSendSmsTestFailed;
import software.xdev.brevo.model.RequestSmsRecipientExport;
import software.xdev.brevo.model.SendReport;
import software.xdev.brevo.model.SendTestSms;
import software.xdev.brevo.model.UpdateCampaignStatus;
import software.xdev.brevo.model.UpdateSmsCampaign;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class SmsCampaignsApi extends BaseApi {

  public SmsCampaignsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public SmsCampaignsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Creates an SMS campaign
   * 
   * @param createSmsCampaign Values to create an SMS Campaign (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createSmsCampaign(@jakarta.annotation.Nonnull CreateSmsCampaign createSmsCampaign) throws ApiException {
    return this.createSmsCampaign(createSmsCampaign, Collections.emptyMap());
  }


  /**
   * Creates an SMS campaign
   * 
   * @param createSmsCampaign Values to create an SMS Campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createSmsCampaign(@jakarta.annotation.Nonnull CreateSmsCampaign createSmsCampaign, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createSmsCampaign;
    
    // verify the required parameter 'createSmsCampaign' is set
    if (createSmsCampaign == null) {
      throw new ApiException(400, "Missing the required parameter 'createSmsCampaign' when calling createSmsCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete an SMS campaign
   * 
   * @param campaignId id of the SMS campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteSmsCampaign(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    this.deleteSmsCampaign(campaignId, Collections.emptyMap());
  }


  /**
   * Delete an SMS campaign
   * 
   * @param campaignId id of the SMS campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteSmsCampaign(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling deleteSmsCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get an SMS campaign
   * 
   * @param campaignId id of the SMS campaign (required)
   * @return GetSmsCampaign
   * @throws ApiException if fails to make API call
   */
  public GetSmsCampaign getSmsCampaign(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    return this.getSmsCampaign(campaignId, Collections.emptyMap());
  }


  /**
   * Get an SMS campaign
   * 
   * @param campaignId id of the SMS campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSmsCampaign
   * @throws ApiException if fails to make API call
   */
  public GetSmsCampaign getSmsCampaign(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getSmsCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSmsCampaign> localVarReturnType = new TypeReference<GetSmsCampaign>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Returns the information for all your created SMS campaigns
   * 
   * @param status Status of campaign. (optional)
   * @param startDate **Mandatory if endDate is used.** Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param limit Number limitation for the result returned (optional, default to 500)
   * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetSmsCampaigns
   * @throws ApiException if fails to make API call
   */
  public GetSmsCampaigns getSmsCampaigns(@jakarta.annotation.Nullable String status, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getSmsCampaigns(status, startDate, endDate, limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Returns the information for all your created SMS campaigns
   * 
   * @param status Status of campaign. (optional)
   * @param startDate **Mandatory if endDate is used.** Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent sms campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param limit Number limitation for the result returned (optional, default to 500)
   * @param offset Beginning point in the list to retrieve from. (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSmsCampaigns
   * @throws ApiException if fails to make API call
   */
  public GetSmsCampaigns getSmsCampaigns(@jakarta.annotation.Nullable String status, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/smsCampaigns";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("status", status));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSmsCampaigns> localVarReturnType = new TypeReference<GetSmsCampaigns>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Export an SMS campaign&#39;s recipients
   * It returns the background process ID which on completion calls the notify URL that you have set in the input.
   * @param campaignId id of the campaign (required)
   * @param recipientExport Values to send for a recipient export request (optional)
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId requestSmsRecipientExport(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nullable RequestSmsRecipientExport recipientExport) throws ApiException {
    return this.requestSmsRecipientExport(campaignId, recipientExport, Collections.emptyMap());
  }


  /**
   * Export an SMS campaign&#39;s recipients
   * It returns the background process ID which on completion calls the notify URL that you have set in the input.
   * @param campaignId id of the campaign (required)
   * @param recipientExport Values to send for a recipient export request (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId requestSmsRecipientExport(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nullable RequestSmsRecipientExport recipientExport, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = recipientExport;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling requestSmsRecipientExport");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}/exportRecipients"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send your SMS campaign immediately
   * 
   * @param campaignId id of the campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void sendSmsCampaignNow(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    this.sendSmsCampaignNow(campaignId, Collections.emptyMap());
  }


  /**
   * Send your SMS campaign immediately
   * 
   * @param campaignId id of the campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendSmsCampaignNow(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendSmsCampaignNow");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}/sendNow"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Send an SMS campaign&#39;s report
   * Send report of Sent and Archived campaign, to the specified email addresses, with respective data and a pdf attachment in detail.
   * @param campaignId id of the campaign (required)
   * @param sendReport Values for send a report (required)
   * @throws ApiException if fails to make API call
   */
  public void sendSmsReport(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendReport sendReport) throws ApiException {
    this.sendSmsReport(campaignId, sendReport, Collections.emptyMap());
  }


  /**
   * Send an SMS campaign&#39;s report
   * Send report of Sent and Archived campaign, to the specified email addresses, with respective data and a pdf attachment in detail.
   * @param campaignId id of the campaign (required)
   * @param sendReport Values for send a report (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendSmsReport(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendReport sendReport, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendReport;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendSmsReport");
    }
    
    // verify the required parameter 'sendReport' is set
    if (sendReport == null) {
      throw new ApiException(400, "Missing the required parameter 'sendReport' when calling sendSmsReport");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}/sendReport"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Send a test SMS campaign
   * 
   * @param campaignId Id of the SMS campaign (required)
   * @param sendTestSms Mobile number of the recipient with the country code. This number **must belong to one of your contacts in Brevo account and must not be blacklisted**  (required)
   * @throws ApiException if fails to make API call
   */
  public void sendTestSms(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendTestSms sendTestSms) throws ApiException {
    this.sendTestSms(campaignId, sendTestSms, Collections.emptyMap());
  }


  /**
   * Send a test SMS campaign
   * 
   * @param campaignId Id of the SMS campaign (required)
   * @param sendTestSms Mobile number of the recipient with the country code. This number **must belong to one of your contacts in Brevo account and must not be blacklisted**  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendTestSms(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendTestSms sendTestSms, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendTestSms;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendTestSms");
    }
    
    // verify the required parameter 'sendTestSms' is set
    if (sendTestSms == null) {
      throw new ApiException(400, "Missing the required parameter 'sendTestSms' when calling sendTestSms");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}/sendTest"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update an SMS campaign
   * 
   * @param campaignId id of the SMS campaign (required)
   * @param updateSmsCampaign Values to update an SMS Campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void updateSmsCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateSmsCampaign updateSmsCampaign) throws ApiException {
    this.updateSmsCampaign(campaignId, updateSmsCampaign, Collections.emptyMap());
  }


  /**
   * Update an SMS campaign
   * 
   * @param campaignId id of the SMS campaign (required)
   * @param updateSmsCampaign Values to update an SMS Campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSmsCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateSmsCampaign updateSmsCampaign, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateSmsCampaign;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateSmsCampaign");
    }
    
    // verify the required parameter 'updateSmsCampaign' is set
    if (updateSmsCampaign == null) {
      throw new ApiException(400, "Missing the required parameter 'updateSmsCampaign' when calling updateSmsCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update a campaign&#39;s status
   * 
   * @param campaignId id of the campaign (required)
   * @param status Status of the campaign. (required)
   * @throws ApiException if fails to make API call
   */
  public void updateSmsCampaignStatus(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateCampaignStatus status) throws ApiException {
    this.updateSmsCampaignStatus(campaignId, status, Collections.emptyMap());
  }


  /**
   * Update a campaign&#39;s status
   * 
   * @param campaignId id of the campaign (required)
   * @param status Status of the campaign. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSmsCampaignStatus(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateCampaignStatus status, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = status;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateSmsCampaignStatus");
    }
    
    // verify the required parameter 'status' is set
    if (status == null) {
      throw new ApiException(400, "Missing the required parameter 'status' when calling updateSmsCampaignStatus");
    }
    
    // create path and map variables
    String localVarPath = "/smsCampaigns/{campaignId}/status"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
